// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::AppInfo;
use crate::AsyncResult;
use crate::Cancellable;
use crate::DriveStartFlags;
use crate::FileCopyFlags;
use crate::FileCreateFlags;
use crate::FileEnumerator;
use crate::FileIOStream;
use crate::FileInfo;
use crate::FileInputStream;
use crate::FileMeasureFlags;
use crate::FileMonitor;
use crate::FileMonitorFlags;
use crate::FileOutputStream;
use crate::FileQueryInfoFlags;
use crate::FileType;
use crate::Mount;
use crate::MountMountFlags;
use crate::MountOperation;
use crate::MountUnmountFlags;
use glib::object::IsA;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::pin::Pin;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "GFile")]
    pub struct File(Interface<ffi::GFile, ffi::GFileIface>);

    match fn {
        type_ => || ffi::g_file_get_type(),
    }
}

impl File {
    //#[cfg(any(feature = "v2_56", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    //#[doc(alias = "g_file_new_build_filename")]
    //pub fn new_build_filename<P: AsRef<std::path::Path>>(first_element: P, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> File {
    //    unsafe { TODO: call ffi:g_file_new_build_filename() }
    //}

    #[doc(alias = "g_file_new_for_commandline_arg")]
    #[doc(alias = "new_for_commandline_arg")]
    pub fn for_commandline_arg<P: AsRef<std::ffi::OsStr>>(arg: P) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_commandline_arg(
                arg.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_file_new_for_commandline_arg_and_cwd")]
    #[doc(alias = "new_for_commandline_arg_and_cwd")]
    pub fn for_commandline_arg_and_cwd<P: AsRef<std::ffi::OsStr>, Q: AsRef<std::path::Path>>(
        arg: P,
        cwd: Q,
    ) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_commandline_arg_and_cwd(
                arg.as_ref().to_glib_none().0,
                cwd.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_file_new_for_path")]
    #[doc(alias = "new_for_path")]
    pub fn for_path<P: AsRef<std::path::Path>>(path: P) -> File {
        unsafe { from_glib_full(ffi::g_file_new_for_path(path.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "g_file_new_for_uri")]
    #[doc(alias = "new_for_uri")]
    pub fn for_uri(uri: &str) -> File {
        unsafe { from_glib_full(ffi::g_file_new_for_uri(uri.to_glib_none().0)) }
    }

    #[doc(alias = "g_file_new_tmp")]
    pub fn new_tmp<P: AsRef<std::path::Path>>(
        tmpl: P,
    ) -> Result<(File, FileIOStream), glib::Error> {
        unsafe {
            let mut iostream = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_new_tmp(tmpl.as_ref().to_glib_none().0, &mut iostream, &mut error);
            if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(iostream)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[doc(alias = "g_file_parse_name")]
    #[doc(alias = "parse_name")]
    pub fn for_parse_name(parse_name: &str) -> File {
        unsafe { from_glib_full(ffi::g_file_parse_name(parse_name.to_glib_none().0)) }
    }
}

unsafe impl Send for File {}
unsafe impl Sync for File {}

pub const NONE_FILE: Option<&File> = None;

pub trait FileExt: 'static {
    #[doc(alias = "g_file_append_to")]
    fn append_to<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error>;

    #[doc(alias = "g_file_append_to_async")]
    fn append_to_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn append_to_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_copy")]
    fn copy<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
        progress_callback: Option<&mut dyn (FnMut(i64, i64))>,
    ) -> Result<(), glib::Error>;

    //#[doc(alias = "g_file_copy_async")]
    //fn copy_async<P: IsA<File>, Q: IsA<Cancellable>, R: FnOnce(Result<(), glib::Error>) + Send + 'static, S: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, destination: &P, flags: FileCopyFlags, io_priority: glib::Priority, cancellable: Option<&Q>, progress_callback: R, callback: S);

    //
    //fn copy_async_future<P: IsA<File> + Clone + 'static, R: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, destination: &P, flags: FileCopyFlags, io_priority: glib::Priority, progress_callback: R) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_copy_attributes")]
    fn copy_attributes<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_create")]
    fn create<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error>;

    #[doc(alias = "g_file_create_async")]
    fn create_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn create_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_create_readwrite")]
    fn create_readwrite<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error>;

    #[doc(alias = "g_file_create_readwrite_async")]
    fn create_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn create_readwrite_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_delete")]
    fn delete<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_delete_async")]
    fn delete_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn delete_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_dup")]
    fn dup(&self) -> File;

    #[doc(alias = "g_file_eject_mountable_with_operation")]
    fn eject_mountable_with_operation<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn eject_mountable_with_operation_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_enumerate_children")]
    fn enumerate_children<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<FileEnumerator, glib::Error>;

    #[doc(alias = "g_file_equal")]
    fn equal<P: IsA<File>>(&self, file2: &P) -> bool;

    #[doc(alias = "g_file_find_enclosing_mount")]
    fn find_enclosing_mount<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<Mount, glib::Error>;

    #[doc(alias = "g_file_get_basename")]
    #[doc(alias = "get_basename")]
    fn basename(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "g_file_get_child")]
    #[doc(alias = "get_child")]
    fn child<P: AsRef<std::path::Path>>(&self, name: P) -> File;

    #[doc(alias = "g_file_get_child_for_display_name")]
    #[doc(alias = "get_child_for_display_name")]
    fn child_for_display_name(&self, display_name: &str) -> Result<File, glib::Error>;

    #[doc(alias = "g_file_get_parent")]
    #[doc(alias = "get_parent")]
    fn parent(&self) -> Option<File>;

    #[doc(alias = "g_file_get_parse_name")]
    #[doc(alias = "get_parse_name")]
    fn parse_name(&self) -> glib::GString;

    #[doc(alias = "g_file_get_path")]
    #[doc(alias = "get_path")]
    fn path(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "g_file_get_relative_path")]
    #[doc(alias = "get_relative_path")]
    fn relative_path<P: IsA<File>>(&self, descendant: &P) -> Option<std::path::PathBuf>;

    #[doc(alias = "g_file_get_uri")]
    #[doc(alias = "get_uri")]
    fn uri(&self) -> glib::GString;

    #[doc(alias = "g_file_get_uri_scheme")]
    #[doc(alias = "get_uri_scheme")]
    fn uri_scheme(&self) -> Option<glib::GString>;

    #[doc(alias = "g_file_has_parent")]
    fn has_parent<P: IsA<File>>(&self, parent: Option<&P>) -> bool;

    #[doc(alias = "g_file_has_prefix")]
    fn has_prefix<P: IsA<File>>(&self, prefix: &P) -> bool;

    #[doc(alias = "g_file_has_uri_scheme")]
    fn has_uri_scheme(&self, uri_scheme: &str) -> bool;

    #[doc(alias = "g_file_is_native")]
    fn is_native(&self) -> bool;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "g_file_load_bytes")]
    fn load_bytes<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(glib::Bytes, Option<glib::GString>), glib::Error>;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "g_file_load_bytes_async")]
    fn load_bytes_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(glib::Bytes, Option<glib::GString>), glib::Error>) + Send + 'static,
    >(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    );

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn load_bytes_async_future(
        &self,
    ) -> Pin<
        Box_<
            dyn std::future::Future<
                    Output = Result<(glib::Bytes, Option<glib::GString>), glib::Error>,
                > + 'static,
        >,
    >;

    #[doc(alias = "g_file_load_contents")]
    fn load_contents<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(Vec<u8>, Option<glib::GString>), glib::Error>;

    #[doc(alias = "g_file_load_contents_async")]
    fn load_contents_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static,
    >(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn load_contents_async_future(
        &self,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<(Vec<u8>, Option<glib::GString>), glib::Error>>
                + 'static,
        >,
    >;

    //#[doc(alias = "g_file_load_partial_contents_async")]
    //fn load_partial_contents_async<P: IsA<Cancellable>, Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static, R: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static>(&self, cancellable: Option<&P>, read_more_callback: Q, callback: R);

    //
    //fn load_partial_contents_async_future<Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static>(&self, read_more_callback: Q) -> Pin<Box_<dyn std::future::Future<Output = Result<(Vec<u8>, Option<glib::GString>), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_make_directory")]
    fn make_directory<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_make_directory_async")]
    fn make_directory_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn make_directory_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_make_directory_with_parents")]
    fn make_directory_with_parents<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_make_symbolic_link")]
    fn make_symbolic_link<P: AsRef<std::path::Path>, Q: IsA<Cancellable>>(
        &self,
        symlink_value: P,
        cancellable: Option<&Q>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_measure_disk_usage")]
    fn measure_disk_usage<P: IsA<Cancellable>>(
        &self,
        flags: FileMeasureFlags,
        cancellable: Option<&P>,
        progress_callback: Option<Box_<dyn Fn(bool, u64, u64, u64) + 'static>>,
    ) -> Result<(u64, u64, u64), glib::Error>;

    //#[doc(alias = "g_file_measure_disk_usage_async")]
    //fn measure_disk_usage_async<P: IsA<Cancellable>, Q: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static, R: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static>(&self, flags: FileMeasureFlags, io_priority: glib::Priority, cancellable: Option<&P>, progress_callback: Q, callback: R);

    //
    //fn measure_disk_usage_async_future<Q: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static>(&self, flags: FileMeasureFlags, io_priority: glib::Priority, progress_callback: Q) -> Pin<Box_<dyn std::future::Future<Output = Result<(u64, u64, u64), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_monitor")]
    fn monitor<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error>;

    #[doc(alias = "g_file_monitor_directory")]
    fn monitor_directory<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error>;

    #[doc(alias = "g_file_monitor_file")]
    fn monitor_file<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error>;

    #[doc(alias = "g_file_mount_enclosing_volume")]
    fn mount_enclosing_volume<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn mount_enclosing_volume_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_mount_mountable")]
    fn mount_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<File, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn mount_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<File, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_move")]
    #[doc(alias = "move")]
    fn move_<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
        progress_callback: Option<&mut dyn (FnMut(i64, i64))>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_open_readwrite")]
    fn open_readwrite<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error>;

    #[doc(alias = "g_file_open_readwrite_async")]
    fn open_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn open_readwrite_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "g_file_peek_path")]
    fn peek_path(&self) -> Option<std::path::PathBuf>;

    #[doc(alias = "g_file_poll_mountable")]
    fn poll_mountable<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn poll_mountable_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_query_default_handler")]
    fn query_default_handler<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<AppInfo, glib::Error>;

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    #[doc(alias = "g_file_query_default_handler_async")]
    fn query_default_handler_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<AppInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    fn query_default_handler_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<AppInfo, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_query_exists")]
    fn query_exists<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> bool;

    #[doc(alias = "g_file_query_file_type")]
    fn query_file_type<P: IsA<Cancellable>>(
        &self,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> FileType;

    #[doc(alias = "g_file_query_filesystem_info")]
    fn query_filesystem_info<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        cancellable: Option<&P>,
    ) -> Result<FileInfo, glib::Error>;

    #[doc(alias = "g_file_query_filesystem_info_async")]
    fn query_filesystem_info_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        attributes: &str,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn query_filesystem_info_async_future(
        &self,
        attributes: &str,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_query_info")]
    fn query_info<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<FileInfo, glib::Error>;

    #[doc(alias = "g_file_query_info_async")]
    fn query_info_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn query_info_async_future(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>>;

    //#[doc(alias = "g_file_query_settable_attributes")]
    //fn query_settable_attributes<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result</*Ignored*/FileAttributeInfoList, glib::Error>;

    //#[doc(alias = "g_file_query_writable_namespaces")]
    //fn query_writable_namespaces<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result</*Ignored*/FileAttributeInfoList, glib::Error>;

    #[doc(alias = "g_file_read")]
    fn read<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<FileInputStream, glib::Error>;

    #[doc(alias = "g_file_read_async")]
    fn read_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn read_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInputStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_replace")]
    fn replace<P: IsA<Cancellable>>(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error>;

    #[doc(alias = "g_file_replace_async")]
    fn replace_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn replace_async_future(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_replace_contents")]
    fn replace_contents<P: IsA<Cancellable>>(
        &self,
        contents: &[u8],
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<Option<glib::GString>, glib::Error>;

    //#[doc(alias = "g_file_replace_contents_bytes_async")]
    //fn replace_contents_bytes_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + 'static>(&self, contents: &glib::Bytes, etag: Option<&str>, make_backup: bool, flags: FileCreateFlags, cancellable: Option<&P>, callback: Q);

    #[doc(alias = "g_file_replace_readwrite")]
    fn replace_readwrite<P: IsA<Cancellable>>(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error>;

    #[doc(alias = "g_file_replace_readwrite_async")]
    fn replace_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn replace_readwrite_async_future(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_resolve_relative_path")]
    fn resolve_relative_path<P: AsRef<std::path::Path>>(&self, relative_path: P) -> File;

    //#[doc(alias = "g_file_set_attribute")]
    //fn set_attribute<P: IsA<Cancellable>>(&self, attribute: &str, type_: FileAttributeType, value_p: /*Unimplemented*/Option<Fundamental: Pointer>, flags: FileQueryInfoFlags, cancellable: Option<&P>) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_byte_string")]
    fn set_attribute_byte_string<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_int32")]
    fn set_attribute_int32<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: i32,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_int64")]
    fn set_attribute_int64<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: i64,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_string")]
    fn set_attribute_string<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_uint32")]
    fn set_attribute_uint32<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: u32,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attribute_uint64")]
    fn set_attribute_uint64<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: u64,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_attributes_async")]
    fn set_attributes_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn set_attributes_async_future(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_set_attributes_from_info")]
    fn set_attributes_from_info<P: IsA<Cancellable>>(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_set_display_name")]
    fn set_display_name<P: IsA<Cancellable>>(
        &self,
        display_name: &str,
        cancellable: Option<&P>,
    ) -> Result<File, glib::Error>;

    #[doc(alias = "g_file_set_display_name_async")]
    fn set_display_name_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<File, glib::Error>) + Send + 'static,
    >(
        &self,
        display_name: &str,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn set_display_name_async_future(
        &self,
        display_name: &str,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<File, glib::Error>> + 'static>>;

    #[doc(alias = "g_file_start_mountable")]
    fn start_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: DriveStartFlags,
        start_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn start_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: DriveStartFlags,
        start_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_stop_mountable")]
    fn stop_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn stop_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_supports_thread_contexts")]
    fn supports_thread_contexts(&self) -> bool;

    #[doc(alias = "g_file_trash")]
    fn trash<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result<(), glib::Error>;

    #[doc(alias = "g_file_trash_async")]
    fn trash_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    );

    fn trash_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;

    #[doc(alias = "g_file_unmount_mountable_with_operation")]
    fn unmount_mountable_with_operation<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    );

    fn unmount_mountable_with_operation_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>>;
}

impl<O: IsA<File>> FileExt for O {
    fn append_to<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_append_to(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn append_to_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn append_to_async_trampoline<
            Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_append_to_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = append_to_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_append_to_async(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn append_to_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>
    {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.append_to_async(flags, io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn copy<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
        progress_callback: Option<&mut dyn (FnMut(i64, i64))>,
    ) -> Result<(), glib::Error> {
        let progress_callback_data: Option<&mut dyn (FnMut(i64, i64))> = progress_callback;
        unsafe extern "C" fn progress_callback_func<P: IsA<File>, Q: IsA<Cancellable>>(
            current_num_bytes: i64,
            total_num_bytes: i64,
            user_data: glib::ffi::gpointer,
        ) {
            let callback: *mut Option<&mut dyn (FnMut(i64, i64))> =
                user_data as *const _ as usize as *mut Option<&mut dyn (FnMut(i64, i64))>;
            if let Some(ref mut callback) = *callback {
                callback(current_num_bytes, total_num_bytes)
            } else {
                panic!("cannot get closure...")
            };
        }
        let progress_callback = if progress_callback_data.is_some() {
            Some(progress_callback_func::<P, Q> as _)
        } else {
            None
        };
        let super_callback0: &Option<&mut dyn (FnMut(i64, i64))> = &progress_callback_data;
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_copy(
                self.as_ref().to_glib_none().0,
                destination.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                progress_callback,
                super_callback0 as *const _ as usize as *mut _,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn copy_async<P: IsA<File>, Q: IsA<Cancellable>, R: FnOnce(Result<(), glib::Error>) + Send + 'static, S: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, destination: &P, flags: FileCopyFlags, io_priority: glib::Priority, cancellable: Option<&Q>, progress_callback: R, callback: S) {
    //    unsafe { TODO: call ffi:g_file_copy_async() }
    //}

    //
    //fn copy_async_future<P: IsA<File> + Clone + 'static, R: FnOnce(Result<(), glib::Error>) + Send + 'static>(&self, destination: &P, flags: FileCopyFlags, io_priority: glib::Priority, progress_callback: R) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {

    //let destination = destination.clone();
    //let progress_callback = progress_callback.map(ToOwned::to_owned);
    //Box_::pin(crate::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.copy_async(
    //        &destination,
    //        flags,
    //        io_priority,
    //        Some(cancellable),
    //        progress_callback.as_ref().map(::std::borrow::Borrow::borrow),
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    fn copy_attributes<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_copy_attributes(
                self.as_ref().to_glib_none().0,
                destination.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn create_async_trampoline<
            Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = create_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_create_async(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn create_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>
    {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.create_async(flags, io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn create_readwrite<P: IsA<Cancellable>>(
        &self,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create_readwrite(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn create_readwrite_async_trampoline<
            Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_create_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = create_readwrite_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_create_readwrite_async(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn create_readwrite_async_future(
        &self,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>
    {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.create_readwrite_async(flags, io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn delete<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_delete(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn delete_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn delete_async_trampoline<
            Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_delete_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = delete_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_delete_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn delete_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.delete_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn dup(&self) -> File {
        unsafe { from_glib_full(ffi::g_file_dup(self.as_ref().to_glib_none().0)) }
    }

    fn eject_mountable_with_operation<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn eject_mountable_with_operation_trampoline<
            R: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_eject_mountable_with_operation_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = eject_mountable_with_operation_trampoline::<R>;
        unsafe {
            ffi::g_file_eject_mountable_with_operation(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                mount_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn eject_mountable_with_operation_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let mount_operation = mount_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.eject_mountable_with_operation(
                    flags,
                    mount_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn enumerate_children<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<FileEnumerator, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_enumerate_children(
                self.as_ref().to_glib_none().0,
                attributes.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn equal<P: IsA<File>>(&self, file2: &P) -> bool {
        unsafe {
            from_glib(ffi::g_file_equal(
                self.as_ref().to_glib_none().0,
                file2.as_ref().to_glib_none().0,
            ))
        }
    }

    fn find_enclosing_mount<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<Mount, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_find_enclosing_mount(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn basename(&self) -> Option<std::path::PathBuf> {
        unsafe { from_glib_full(ffi::g_file_get_basename(self.as_ref().to_glib_none().0)) }
    }

    fn child<P: AsRef<std::path::Path>>(&self, name: P) -> File {
        unsafe {
            from_glib_full(ffi::g_file_get_child(
                self.as_ref().to_glib_none().0,
                name.as_ref().to_glib_none().0,
            ))
        }
    }

    fn child_for_display_name(&self, display_name: &str) -> Result<File, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_get_child_for_display_name(
                self.as_ref().to_glib_none().0,
                display_name.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn parent(&self) -> Option<File> {
        unsafe { from_glib_full(ffi::g_file_get_parent(self.as_ref().to_glib_none().0)) }
    }

    fn parse_name(&self) -> glib::GString {
        unsafe { from_glib_full(ffi::g_file_get_parse_name(self.as_ref().to_glib_none().0)) }
    }

    fn path(&self) -> Option<std::path::PathBuf> {
        unsafe { from_glib_full(ffi::g_file_get_path(self.as_ref().to_glib_none().0)) }
    }

    fn relative_path<P: IsA<File>>(&self, descendant: &P) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::g_file_get_relative_path(
                self.as_ref().to_glib_none().0,
                descendant.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uri(&self) -> glib::GString {
        unsafe { from_glib_full(ffi::g_file_get_uri(self.as_ref().to_glib_none().0)) }
    }

    fn uri_scheme(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::g_file_get_uri_scheme(self.as_ref().to_glib_none().0)) }
    }

    fn has_parent<P: IsA<File>>(&self, parent: Option<&P>) -> bool {
        unsafe {
            from_glib(ffi::g_file_has_parent(
                self.as_ref().to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    fn has_prefix<P: IsA<File>>(&self, prefix: &P) -> bool {
        unsafe {
            from_glib(ffi::g_file_has_prefix(
                self.as_ref().to_glib_none().0,
                prefix.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_uri_scheme(&self, uri_scheme: &str) -> bool {
        unsafe {
            from_glib(ffi::g_file_has_uri_scheme(
                self.as_ref().to_glib_none().0,
                uri_scheme.to_glib_none().0,
            ))
        }
    }

    fn is_native(&self) -> bool {
        unsafe { from_glib(ffi::g_file_is_native(self.as_ref().to_glib_none().0)) }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn load_bytes<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(glib::Bytes, Option<glib::GString>), glib::Error> {
        unsafe {
            let mut etag_out = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_load_bytes(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut etag_out,
                &mut error,
            );
            if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(etag_out)))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn load_bytes_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(glib::Bytes, Option<glib::GString>), glib::Error>) + Send + 'static,
    >(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn load_bytes_async_trampoline<
            Q: FnOnce(Result<(glib::Bytes, Option<glib::GString>), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut etag_out = ptr::null_mut();
            let ret = ffi::g_file_load_bytes_finish(
                _source_object as *mut _,
                res,
                &mut etag_out,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((from_glib_full(ret), from_glib_full(etag_out)))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_bytes_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_load_bytes_async(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn load_bytes_async_future(
        &self,
    ) -> Pin<
        Box_<
            dyn std::future::Future<
                    Output = Result<(glib::Bytes, Option<glib::GString>), glib::Error>,
                > + 'static,
        >,
    > {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.load_bytes_async(Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn load_contents<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(Vec<u8>, Option<glib::GString>), glib::Error> {
        unsafe {
            let mut contents = ptr::null_mut();
            let mut length = mem::MaybeUninit::uninit();
            let mut etag_out = ptr::null_mut();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_load_contents(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut contents,
                length.as_mut_ptr(),
                &mut etag_out,
                &mut error,
            );
            if error.is_null() {
                Ok((
                    FromGlibContainer::from_glib_full_num(contents, length.assume_init() as usize),
                    from_glib_full(etag_out),
                ))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn load_contents_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static,
    >(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn load_contents_async_trampoline<
            Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut contents = ptr::null_mut();
            let mut length = mem::MaybeUninit::uninit();
            let mut etag_out = ptr::null_mut();
            let _ = ffi::g_file_load_contents_finish(
                _source_object as *mut _,
                res,
                &mut contents,
                length.as_mut_ptr(),
                &mut etag_out,
                &mut error,
            );
            let result = if error.is_null() {
                Ok((
                    FromGlibContainer::from_glib_full_num(contents, length.assume_init() as usize),
                    from_glib_full(etag_out),
                ))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_contents_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_load_contents_async(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn load_contents_async_future(
        &self,
    ) -> Pin<
        Box_<
            dyn std::future::Future<Output = Result<(Vec<u8>, Option<glib::GString>), glib::Error>>
                + 'static,
        >,
    > {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.load_contents_async(Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    //fn load_partial_contents_async<P: IsA<Cancellable>, Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static, R: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static>(&self, cancellable: Option<&P>, read_more_callback: Q, callback: R) {
    //    unsafe { TODO: call ffi:g_file_load_partial_contents_async() }
    //}

    //
    //fn load_partial_contents_async_future<Q: FnOnce(Result<(Vec<u8>, Option<glib::GString>), glib::Error>) + Send + 'static>(&self, read_more_callback: Q) -> Pin<Box_<dyn std::future::Future<Output = Result<(Vec<u8>, Option<glib::GString>), glib::Error>> + 'static>> {

    //Box_::pin(crate::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.load_partial_contents_async(
    //        Some(cancellable),
    //        read_more_callback,
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    fn make_directory<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn make_directory_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn make_directory_async_trampoline<
            Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = make_directory_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_make_directory_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn make_directory_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.make_directory_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn make_directory_with_parents<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory_with_parents(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn make_symbolic_link<P: AsRef<std::path::Path>, Q: IsA<Cancellable>>(
        &self,
        symlink_value: P,
        cancellable: Option<&Q>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_symbolic_link(
                self.as_ref().to_glib_none().0,
                symlink_value.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn measure_disk_usage<P: IsA<Cancellable>>(
        &self,
        flags: FileMeasureFlags,
        cancellable: Option<&P>,
        progress_callback: Option<Box_<dyn Fn(bool, u64, u64, u64) + 'static>>,
    ) -> Result<(u64, u64, u64), glib::Error> {
        let progress_callback_data: Box_<Option<Box_<dyn Fn(bool, u64, u64, u64) + 'static>>> =
            Box_::new(progress_callback);
        unsafe extern "C" fn progress_callback_func<P: IsA<Cancellable>>(
            reporting: glib::ffi::gboolean,
            current_size: u64,
            num_dirs: u64,
            num_files: u64,
            user_data: glib::ffi::gpointer,
        ) {
            let reporting = from_glib(reporting);
            let callback: &Option<Box_<dyn Fn(bool, u64, u64, u64) + 'static>> =
                &*(user_data as *mut _);
            if let Some(ref callback) = *callback {
                callback(reporting, current_size, num_dirs, num_files)
            } else {
                panic!("cannot get closure...")
            };
        }
        let progress_callback = if progress_callback_data.is_some() {
            Some(progress_callback_func::<P> as _)
        } else {
            None
        };
        let super_callback0: Box_<Option<Box_<dyn Fn(bool, u64, u64, u64) + 'static>>> =
            progress_callback_data;
        unsafe {
            let mut disk_usage = mem::MaybeUninit::uninit();
            let mut num_dirs = mem::MaybeUninit::uninit();
            let mut num_files = mem::MaybeUninit::uninit();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_measure_disk_usage(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                progress_callback,
                Box_::into_raw(super_callback0) as *mut _,
                disk_usage.as_mut_ptr(),
                num_dirs.as_mut_ptr(),
                num_files.as_mut_ptr(),
                &mut error,
            );
            let disk_usage = disk_usage.assume_init();
            let num_dirs = num_dirs.assume_init();
            let num_files = num_files.assume_init();
            if error.is_null() {
                Ok((disk_usage, num_dirs, num_files))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn measure_disk_usage_async<P: IsA<Cancellable>, Q: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static, R: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static>(&self, flags: FileMeasureFlags, io_priority: glib::Priority, cancellable: Option<&P>, progress_callback: Q, callback: R) {
    //    unsafe { TODO: call ffi:g_file_measure_disk_usage_async() }
    //}

    //
    //fn measure_disk_usage_async_future<Q: FnOnce(Result<(u64, u64, u64), glib::Error>) + Send + 'static>(&self, flags: FileMeasureFlags, io_priority: glib::Priority, progress_callback: Q) -> Pin<Box_<dyn std::future::Future<Output = Result<(u64, u64, u64), glib::Error>> + 'static>> {

    //let progress_callback = progress_callback.map(ToOwned::to_owned);
    //Box_::pin(crate::GioFuture::new(self, move |obj, cancellable, send| {
    //    obj.measure_disk_usage_async(
    //        flags,
    //        io_priority,
    //        Some(cancellable),
    //        progress_callback.as_ref().map(::std::borrow::Borrow::borrow),
    //        move |res| {
    //            send.resolve(res);
    //        },
    //    );
    //}))
    //}

    fn monitor<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_monitor(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn monitor_directory<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_monitor_directory(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn monitor_file<P: IsA<Cancellable>>(
        &self,
        flags: FileMonitorFlags,
        cancellable: Option<&P>,
    ) -> Result<FileMonitor, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_monitor_file(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn mount_enclosing_volume<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn mount_enclosing_volume_trampoline<
            R: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_mount_enclosing_volume_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = mount_enclosing_volume_trampoline::<R>;
        unsafe {
            ffi::g_file_mount_enclosing_volume(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                mount_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn mount_enclosing_volume_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let mount_operation = mount_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.mount_enclosing_volume(
                    flags,
                    mount_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn mount_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<File, glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn mount_mountable_trampoline<
            R: FnOnce(Result<File, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_mount_mountable_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = mount_mountable_trampoline::<R>;
        unsafe {
            ffi::g_file_mount_mountable(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                mount_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn mount_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountMountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<File, glib::Error>> + 'static>> {
        let mount_operation = mount_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.mount_mountable(
                    flags,
                    mount_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn move_<P: IsA<File>, Q: IsA<Cancellable>>(
        &self,
        destination: &P,
        flags: FileCopyFlags,
        cancellable: Option<&Q>,
        progress_callback: Option<&mut dyn (FnMut(i64, i64))>,
    ) -> Result<(), glib::Error> {
        let progress_callback_data: Option<&mut dyn (FnMut(i64, i64))> = progress_callback;
        unsafe extern "C" fn progress_callback_func<P: IsA<File>, Q: IsA<Cancellable>>(
            current_num_bytes: i64,
            total_num_bytes: i64,
            user_data: glib::ffi::gpointer,
        ) {
            let callback: *mut Option<&mut dyn (FnMut(i64, i64))> =
                user_data as *const _ as usize as *mut Option<&mut dyn (FnMut(i64, i64))>;
            if let Some(ref mut callback) = *callback {
                callback(current_num_bytes, total_num_bytes)
            } else {
                panic!("cannot get closure...")
            };
        }
        let progress_callback = if progress_callback_data.is_some() {
            Some(progress_callback_func::<P, Q> as _)
        } else {
            None
        };
        let super_callback0: &Option<&mut dyn (FnMut(i64, i64))> = &progress_callback_data;
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_move(
                self.as_ref().to_glib_none().0,
                destination.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                progress_callback,
                super_callback0 as *const _ as usize as *mut _,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn open_readwrite<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_open_readwrite(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn open_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn open_readwrite_async_trampoline<
            Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_open_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = open_readwrite_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_open_readwrite_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn open_readwrite_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>
    {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.open_readwrite_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn peek_path(&self) -> Option<std::path::PathBuf> {
        unsafe { from_glib_none(ffi::g_file_peek_path(self.as_ref().to_glib_none().0)) }
    }

    fn poll_mountable<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn poll_mountable_trampoline<
            Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_poll_mountable_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = poll_mountable_trampoline::<Q>;
        unsafe {
            ffi::g_file_poll_mountable(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn poll_mountable_future(
        &self,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.poll_mountable(Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn query_default_handler<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<AppInfo, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_default_handler(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    fn query_default_handler_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<AppInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn query_default_handler_async_trampoline<
            Q: FnOnce(Result<AppInfo, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_query_default_handler_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = query_default_handler_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_query_default_handler_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    fn query_default_handler_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<AppInfo, glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.query_default_handler_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn query_exists<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> bool {
        unsafe {
            from_glib(ffi::g_file_query_exists(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    fn query_file_type<P: IsA<Cancellable>>(
        &self,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> FileType {
        unsafe {
            from_glib(ffi::g_file_query_file_type(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    fn query_filesystem_info<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        cancellable: Option<&P>,
    ) -> Result<FileInfo, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_filesystem_info(
                self.as_ref().to_glib_none().0,
                attributes.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn query_filesystem_info_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        attributes: &str,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn query_filesystem_info_async_trampoline<
            Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_query_filesystem_info_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = query_filesystem_info_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_query_filesystem_info_async(
                self.as_ref().to_glib_none().0,
                attributes.to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn query_filesystem_info_async_future(
        &self,
        attributes: &str,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>> {
        let attributes = String::from(attributes);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.query_filesystem_info_async(
                    &attributes,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn query_info<P: IsA<Cancellable>>(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<FileInfo, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_info(
                self.as_ref().to_glib_none().0,
                attributes.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn query_info_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn query_info_async_trampoline<
            Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_info_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = query_info_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_query_info_async(
                self.as_ref().to_glib_none().0,
                attributes.to_glib_none().0,
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn query_info_async_future(
        &self,
        attributes: &str,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>> {
        let attributes = String::from(attributes);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.query_info_async(
                    &attributes,
                    flags,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    //fn query_settable_attributes<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result</*Ignored*/FileAttributeInfoList, glib::Error> {
    //    unsafe { TODO: call ffi:g_file_query_settable_attributes() }
    //}

    //fn query_writable_namespaces<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result</*Ignored*/FileAttributeInfoList, glib::Error> {
    //    unsafe { TODO: call ffi:g_file_query_writable_namespaces() }
    //}

    fn read<P: IsA<Cancellable>>(
        &self,
        cancellable: Option<&P>,
    ) -> Result<FileInputStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_read(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn read_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn read_async_trampoline<
            Q: FnOnce(Result<FileInputStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_read_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = read_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_read_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn read_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInputStream, glib::Error>> + 'static>>
    {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.read_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn replace<P: IsA<Cancellable>>(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileOutputStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace(
                self.as_ref().to_glib_none().0,
                etag.to_glib_none().0,
                make_backup.into_glib(),
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn replace_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
    >(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn replace_async_trampoline<
            Q: FnOnce(Result<FileOutputStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = replace_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_replace_async(
                self.as_ref().to_glib_none().0,
                etag.to_glib_none().0,
                make_backup.into_glib(),
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn replace_async_future(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileOutputStream, glib::Error>> + 'static>>
    {
        let etag = etag.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.replace_async(
                    etag.as_ref().map(::std::borrow::Borrow::borrow),
                    make_backup,
                    flags,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn replace_contents<P: IsA<Cancellable>>(
        &self,
        contents: &[u8],
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<Option<glib::GString>, glib::Error> {
        let length = contents.len() as usize;
        unsafe {
            let mut new_etag = ptr::null_mut();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_replace_contents(
                self.as_ref().to_glib_none().0,
                contents.to_glib_none().0,
                length,
                etag.to_glib_none().0,
                make_backup.into_glib(),
                flags.into_glib(),
                &mut new_etag,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(new_etag))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //fn replace_contents_bytes_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + 'static>(&self, contents: &glib::Bytes, etag: Option<&str>, make_backup: bool, flags: FileCreateFlags, cancellable: Option<&P>, callback: Q) {
    //    unsafe { TODO: call ffi:g_file_replace_contents_bytes_async() }
    //}

    fn replace_readwrite<P: IsA<Cancellable>>(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        cancellable: Option<&P>,
    ) -> Result<FileIOStream, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace_readwrite(
                self.as_ref().to_glib_none().0,
                etag.to_glib_none().0,
                make_backup.into_glib(),
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn replace_readwrite_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
    >(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn replace_readwrite_async_trampoline<
            Q: FnOnce(Result<FileIOStream, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_replace_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = replace_readwrite_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_replace_readwrite_async(
                self.as_ref().to_glib_none().0,
                etag.to_glib_none().0,
                make_backup.into_glib(),
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn replace_readwrite_async_future(
        &self,
        etag: Option<&str>,
        make_backup: bool,
        flags: FileCreateFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileIOStream, glib::Error>> + 'static>>
    {
        let etag = etag.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.replace_readwrite_async(
                    etag.as_ref().map(::std::borrow::Borrow::borrow),
                    make_backup,
                    flags,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn resolve_relative_path<P: AsRef<std::path::Path>>(&self, relative_path: P) -> File {
        unsafe {
            from_glib_full(ffi::g_file_resolve_relative_path(
                self.as_ref().to_glib_none().0,
                relative_path.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn set_attribute<P: IsA<Cancellable>>(&self, attribute: &str, type_: FileAttributeType, value_p: /*Unimplemented*/Option<Fundamental: Pointer>, flags: FileQueryInfoFlags, cancellable: Option<&P>) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:g_file_set_attribute() }
    //}

    fn set_attribute_byte_string<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_byte_string(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attribute_int32<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: i32,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_int32(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attribute_int64<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: i64,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_int64(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attribute_string<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: &str,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_string(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attribute_uint32<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: u32,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_uint32(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attribute_uint64<P: IsA<Cancellable>>(
        &self,
        attribute: &str,
        value: u64,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_uint64(
                self.as_ref().to_glib_none().0,
                attribute.to_glib_none().0,
                value,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_attributes_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
    >(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn set_attributes_async_trampoline<
            Q: FnOnce(Result<FileInfo, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let mut info = ptr::null_mut();
            let _ = ffi::g_file_set_attributes_finish(
                _source_object as *mut _,
                res,
                &mut info,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(from_glib_full(info))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = set_attributes_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_set_attributes_async(
                self.as_ref().to_glib_none().0,
                info.to_glib_none().0,
                flags.into_glib(),
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn set_attributes_async_future(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<FileInfo, glib::Error>> + 'static>> {
        let info = info.clone();
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.set_attributes_async(
                    &info,
                    flags,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn set_attributes_from_info<P: IsA<Cancellable>>(
        &self,
        info: &FileInfo,
        flags: FileQueryInfoFlags,
        cancellable: Option<&P>,
    ) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attributes_from_info(
                self.as_ref().to_glib_none().0,
                info.to_glib_none().0,
                flags.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_display_name<P: IsA<Cancellable>>(
        &self,
        display_name: &str,
        cancellable: Option<&P>,
    ) -> Result<File, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_set_display_name(
                self.as_ref().to_glib_none().0,
                display_name.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn set_display_name_async<
        P: IsA<Cancellable>,
        Q: FnOnce(Result<File, glib::Error>) + Send + 'static,
    >(
        &self,
        display_name: &str,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn set_display_name_async_trampoline<
            Q: FnOnce(Result<File, glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let ret =
                ffi::g_file_set_display_name_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = set_display_name_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_set_display_name_async(
                self.as_ref().to_glib_none().0,
                display_name.to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn set_display_name_async_future(
        &self,
        display_name: &str,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<File, glib::Error>> + 'static>> {
        let display_name = String::from(display_name);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.set_display_name_async(
                    &display_name,
                    io_priority,
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn start_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: DriveStartFlags,
        start_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn start_mountable_trampoline<
            R: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_start_mountable_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = start_mountable_trampoline::<R>;
        unsafe {
            ffi::g_file_start_mountable(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                start_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn start_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: DriveStartFlags,
        start_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let start_operation = start_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.start_mountable(
                    flags,
                    start_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn stop_mountable<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn stop_mountable_trampoline<
            R: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_stop_mountable_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = stop_mountable_trampoline::<R>;
        unsafe {
            ffi::g_file_stop_mountable(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                mount_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn stop_mountable_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let mount_operation = mount_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.stop_mountable(
                    flags,
                    mount_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }

    fn supports_thread_contexts(&self) -> bool {
        unsafe {
            from_glib(ffi::g_file_supports_thread_contexts(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn trash<P: IsA<Cancellable>>(&self, cancellable: Option<&P>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_trash(
                self.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn trash_async<P: IsA<Cancellable>, Q: FnOnce(Result<(), glib::Error>) + Send + 'static>(
        &self,
        io_priority: glib::Priority,
        cancellable: Option<&P>,
        callback: Q,
    ) {
        let user_data: Box_<Q> = Box_::new(callback);
        unsafe extern "C" fn trash_async_trampoline<
            Q: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_trash_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<Q> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = trash_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_trash_async(
                self.as_ref().to_glib_none().0,
                io_priority.into_glib(),
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn trash_async_future(
        &self,
        io_priority: glib::Priority,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.trash_async(io_priority, Some(cancellable), move |res| {
                    send.resolve(res);
                });
            },
        ))
    }

    fn unmount_mountable_with_operation<
        P: IsA<MountOperation>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), glib::Error>) + Send + 'static,
    >(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box_<R> = Box_::new(callback);
        unsafe extern "C" fn unmount_mountable_with_operation_trampoline<
            R: FnOnce(Result<(), glib::Error>) + Send + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut crate::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_unmount_mountable_with_operation_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<R> = Box_::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = unmount_mountable_with_operation_trampoline::<R>;
        unsafe {
            ffi::g_file_unmount_mountable_with_operation(
                self.as_ref().to_glib_none().0,
                flags.into_glib(),
                mount_operation.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn unmount_mountable_with_operation_future<P: IsA<MountOperation> + Clone + 'static>(
        &self,
        flags: MountUnmountFlags,
        mount_operation: Option<&P>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let mount_operation = mount_operation.map(ToOwned::to_owned);
        Box_::pin(crate::GioFuture::new(
            self,
            move |obj, cancellable, send| {
                obj.unmount_mountable_with_operation(
                    flags,
                    mount_operation.as_ref().map(::std::borrow::Borrow::borrow),
                    Some(cancellable),
                    move |res| {
                        send.resolve(res);
                    },
                );
            },
        ))
    }
}

impl fmt::Display for File {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("File")
    }
}
