// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::GString;
use glib_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use SocketConnectable;

glib_wrapper! {
    pub struct NetworkService(Object<gio_sys::GNetworkService, gio_sys::GNetworkServiceClass, NetworkServiceClass>) @implements SocketConnectable;

    match fn {
        get_type => || gio_sys::g_network_service_get_type(),
    }
}

impl NetworkService {
    pub fn new(service: &str, protocol: &str, domain: &str) -> NetworkService {
        unsafe {
            from_glib_full(gio_sys::g_network_service_new(
                service.to_glib_none().0,
                protocol.to_glib_none().0,
                domain.to_glib_none().0,
            ))
        }
    }
}

pub const NONE_NETWORK_SERVICE: Option<&NetworkService> = None;

pub trait NetworkServiceExt: 'static {
    fn get_domain(&self) -> Option<GString>;

    fn get_protocol(&self) -> Option<GString>;

    fn get_scheme(&self) -> Option<GString>;

    fn get_service(&self) -> Option<GString>;

    fn set_scheme(&self, scheme: &str);

    fn connect_property_scheme_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<NetworkService>> NetworkServiceExt for O {
    fn get_domain(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_service_get_domain(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_protocol(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_service_get_protocol(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_scheme(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_service_get_scheme(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_service(&self) -> Option<GString> {
        unsafe {
            from_glib_none(gio_sys::g_network_service_get_service(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_scheme(&self, scheme: &str) {
        unsafe {
            gio_sys::g_network_service_set_scheme(
                self.as_ref().to_glib_none().0,
                scheme.to_glib_none().0,
            );
        }
    }

    fn connect_property_scheme_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scheme_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gio_sys::GNetworkService,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<NetworkService>,
        {
            let f: &F = &*(f as *const F);
            f(&NetworkService::from_glib_borrow(this).unsafe_cast())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scheme\0".as_ptr() as *const _,
                Some(transmute(notify_scheme_trampoline::<Self, F> as usize)),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for NetworkService {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "NetworkService")
    }
}
