use linescroll::*;

#[cfg(test)]
mod test {
    use super::*;

    #[test]
    fn test_should_clear() {
        let settings = Settings {
            combine: false,
            speedonly: false,
            print_every: 3,
            limit: 3,
            filenames: false,
            noclear: false,
            nofollow: false,
            raw: false,
            exit: false,
            axislimit: true,
        };

        assert_eq!(should_clear(&settings), true);
    }

    #[test]
    fn test_should_not_clear() {
        let settings = Settings {
            combine: false,
            speedonly: false,
            print_every: 3,
            limit: 3,
            filenames: false,
            noclear: true,
            nofollow: false,
            raw: false,
            exit: false,
            axislimit: true,
        };

        assert_eq!(should_clear(&settings), false);
    }

    #[test]
    fn test_should_print() {
        let settings = Settings {
            combine: false,
            speedonly: false,
            print_every: 3,
            limit: 3,
            filenames: false,
            noclear: true,
            nofollow: false,
            raw: false,
            exit: false,
            axislimit: true,
        };

        assert_eq!(should_print(&settings, 0), false);
        assert_eq!(should_print(&settings, 1), false);
        assert_eq!(should_print(&settings, 2), false);
        assert_eq!(should_print(&settings, 3), true);
        assert_eq!(should_print(&settings, 4), false);
    }
}
