#include "stdafx.h"
#include "Util.h"

BEGIN_TEST(LayoutAdd, Reload) {
	Package *reload = gEngine().package(S("tests.reload"));

	const char newVersion[] =
		"class ClassLayout {\n"
		"	Int a;\n"
		"   Int b;\n"
		"   Int c = 10;\n"
		"   Str d = \"A\";\n"
		"	init() {\n"
		"		init {}\n"
		"	}\n"
		"\n"
		"	void toS(StrBuf to) {\n"
		"		to << a << \", \" << b << \", \" << c << \", \" << d;\n"
		"	}\n"
		"}\n"
		"\n"
		"ClassLayout createClassLayout() {\n"
		"	ClassLayout();\n"
		"}\n";

	Object *created = runFn<Object *>(S("tests.reload.createClassLayout"));
	CHECK_EQ(toS(created), L"0");

	reloadFile(reload, S("layout.bs"), newVersion);

	CHECK_EQ(toS(created), L"0, 0, 10, A");

} END_TEST
