# This is a CamiTK python action
#
# Compute and plot image histogram using numpy and matplotlib
import camitk
import numpy as np
import matplotlib
matplotlib.use('qtagg')
import matplotlib.pyplot as plt

def process(self:camitk.Action):
    image_component = self.getTargets()[0]
    image_data = image_component.getImageDataAsNumpy()

    flattened = image_data.ravel()  # or array3d.flatten()

    # Plot histogram
    plt.hist(flattened, bins=50, color='blue', alpha=0.7)
    plt.title("Histogram '" + image_component.getName() + "' voxel values")
    plt.xlabel("Value")
    plt.ylabel("Frequency")
    plt.grid(True)
    plt.show()