#!/bin/bash
# 
# Determine the Vendor of a device
#
# csh-Example:
#
#	<1>scsi_vendor
#	Disks: SEAGATE SAMSUNG
#	Cdroms: TOSHIBA PHILIPS
#	Tapes: HP
#	<2>scsi_vendor disk
#	SEAGATE SAMSUNG
#	<383>scsi_vendor cd
#	TOSHIBA PHILIPS
#	<3>scsi_vendor tape 
#	HP
#	<4>scsi_vendor tape 1
#	HP
#	<5>scsi_vendor disk 1
#	<6>scsi_vendor disk 1
#	SEAGATE
#	<7>scsi_vendor disk 2
#	SAMSUNG
#
# Ported to bash 01.07.03 <kieren@tigs.org>

s=( )
c=( )
d=( )
o=''
v=''

SCSIINFO=`grep '^ ' /proc/scsi/scsi | cut -c3-18`

for i in $SCSIINFO
do
	if [ "$o" = "Vendor:" ]; then 
		v=$i 
	fi
	if [[ "$o" == 'Type:' && "$i" == 'Sequenti' ]]; then
		s=( $s $v )
	fi
	if [[ "$o" == 'Type:' && "$i" == 'CD-ROM' ]]; then 
		c=( $c $v )
	fi
	if [[ "$o" == 'Type:' && "$i" == 'Direct-A' ]]; then 
		d=( $d $v )
	fi
	o=$i 
done
if [ $# == 0 ]; then
	echo Disks: $d
	echo Cdroms: $c
	echo Tapes: $s
	exit 0 
fi
if [ $# == 1 ]; then
	v='' ;
	if [ "$1" == "disk" ]; then
		echo $d
	fi
	if [ "$1" == "cd" ]; then
		echo $c
	fi
	if [ "$1" == "tape" ]; then
		echo $s
	fi
	exit 0 
fi
if [ $# -eq 2 ]; then
	v='' 
	if [[ "$1" == "disk" && ${#d[@]} -ge $2 ]]; then
		v=$d[$2] 
	fi
	if [[ "$1" == "cd" && ${#c[@]} -ge $2 ]]; then 
		v=$c[$2] 
	fi
	if [[ "$1" == "tape" && ${#s[@]} -ge $2 ]]; then 
		v=${s[$2]} 
	fi
	echo $v
	exit 0 
fi
if [ "$v" == "$3" ]; then
	exit 2 
fi
exit 1 

