/*********************************************************************************
 *
 * $GAMGI/src/io/gamgi_io_font_sun.c
 *
 * $XConsortium: Roman_M.src,v 5.3 94/04/17 20:10:06 rws Exp $
 *
 * Copyright (c) 1989,1990, 1991 by Sun Microsystems, Inc. and the X Consortium.
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the names of Sun Microsystems
 * and the X Consortium not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.
 *
 * SUN MICROSYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SUN MICROSYSTEMS OR THE X CONSORTIUM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Roman Simplex font.    
 * fontname Roman        
 * top 119.0476          
 * bottom -33.3333       
 * characters 128        
 * properties 3          
 * (charset_registry ISO8859) 
 * (charset_encoding "1")     
 * (spacing p)                
 *
 * Mono-spaced version of Roman Simplex font. 
 * fontname Roman                  
 * top 119.0476                    
 * bottom -33.3333                 
 * characters 128                  
 * properties 3                    
 * (charset_registry ISO8859)            
 * (charset_encoding "1")                
 * (spacing m)                           
 */

/****************************************************************
 * Data taken from the packages GLUT 3.6 and FREEGLUT-1.3 alpha *
 *                                               Carlos Pereira *
 ****************************************************************/

#include "gamgi_engine.h"
#include "gamgi_io.h"

/*********
 * fonts *
 *********/

const float gamgi_io_font_sun_roman_points[GAMGI_IO_POINTS_ROMAN] = {

/***************
 * bottom, top *
 ***************/

-33.3333, 119.0476,

/**************
 * char 32-40 *
 **************/

104.7619, 26.6238, 51.4352, 79.4886, 76.2067, 96.5743, 101.7580, 13.6200, 47.1733, 

/**************
 * char 41-50 *
 **************/

47.5333, 59.4390, 97.2543, 26.0638, 100.7540, 26.4838, 82.1067, 77.0667, 66.5295, 77.6467, 

/**************
 * char 51-60 *
 **************/

77.0467, 80.1686, 77.6867, 73.8048, 77.2267, 77.6667, 74.0648, 26.2238, 26.3038, 81.6105, 

/**************
 * char 61-70 *
 **************/

97.2543, 81.6105, 73.9029, 74.3648, 80.4905, 83.6267, 84.4886, 85.2867, 78.1848, 78.7448, 

/**************
 * char 71-80 *
 **************/

89.7686, 89.0867, 21.3000, 59.9990, 79.3267, 71.3229, 97.2105, 88.8067, 88.8305, 85.6667, 

/**************
 * char 81-90 *
 **************/

88.0905, 82.3667, 80.8267, 71.9467, 89.4867, 81.6105, 100.5180, 72.3667, 79.6505, 73.7467, 

/***************
 * char 91-100 *
 ***************/

46.1133, 78.2067, 46.3933, 90.2305, 104.0620, 83.5714, 66.6029, 70.4629, 68.9229, 70.2629, 

/****************
 * char 101-110 *
 ****************/

68.5229, 38.6552, 70.9829, 71.0210, 28.8638, 36.2314, 62.5210, 19.3400, 123.9620, 70.8810, 

/****************
 * char 111-120 *
 ****************/

71.7448, 70.8029, 70.7429, 49.4952, 62.3210, 39.3152, 71.1610, 60.6029, 80.4905, 56.4010, 

/****************
 * char 121-126 *
 ****************/

66.0648, 61.8210, 41.6295, 23.7800, 41.4695, 91.2743, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 2 *
 *************************/

13.3819, 100.0000, 13.3819, 33.3333, GAMGI_IO_STROKE,

13.3819, 9.5238, 8.6200, 4.7619, 13.3819, 0.0000, 18.1438, 4.7619, 13.3819, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

4.0200, 100.0000, 4.0200, 66.6667, GAMGI_IO_STROKE,

42.1152, 100.0000, 42.1152, 66.6667, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

41.2952, 119.0480, 7.9619, -33.3333, GAMGI_IO_STROKE,

69.8667, 119.0480, 36.5333, -33.3333, GAMGI_IO_STROKE,

7.9619, 57.1429, 74.6286, 57.1429, GAMGI_IO_STROKE,

3.2000, 28.5714, 69.8667, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 3 *
 *************************/

28.6295, 119.0480, 28.6295, -19.0476, GAMGI_IO_STROKE,

47.6771, 119.0480, 47.6771, -19.0476, GAMGI_IO_STROKE,

71.4867, 85.7143, 61.9629, 95.2381, 47.6771, 100.0000, 28.6295, 100.0000, 14.3438, 95.2381, 4.8200, 85.7143, 4.8200, 76.1905, 9.5819, 66.6667, 14.3438, 61.9048, 23.8676, 57.1429, 52.4390, 47.6190, 61.9629, 42.8571, 66.7248, 38.0952, 71.4867, 28.5714, 71.4867, 14.2857, 61.9629, 4.7619, 47.6771, 0.0000, 28.6295, 0.0000, 14.3438, 4.7619, 4.8200, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

92.0743, 100.0000, 6.3600, 0.0000, GAMGI_IO_STROKE,

30.1695, 100.0000, 39.6933, 90.4762, 39.6933, 80.9524, 34.9314, 71.4286, 25.4076, 66.6667, 15.8838, 66.6667, 6.3600, 76.1905, 6.3600, 85.7143, 11.1219, 95.2381, 20.6457, 100.0000, 30.1695, 100.0000, 39.6933, 95.2381, 53.9790, 90.4762, 68.2648, 90.4762, 82.5505, 95.2381, 92.0743, 100.0000, GAMGI_IO_STROKE,

73.0267, 33.3333, 63.5029, 28.5714, 58.7410, 19.0476, 58.7410, 9.5238, 68.2648, 0.0000, 77.7886, 0.0000, 87.3124, 4.7619, 92.0743, 14.2857, 92.0743, 23.8095, 82.5505, 33.3333, 73.0267, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 1 *
 *************************/

101.2180, 57.1429, 101.2180, 61.9048, 96.4562, 66.6667, 91.6943, 66.6667, 86.9324, 61.9048, 82.1705, 52.3810, 72.6467, 28.5714, 63.1229, 14.2857, 53.5990, 4.7619, 44.0752, 0.0000, 25.0276, 0.0000, 15.5038, 4.7619, 10.7419, 9.5238, 5.9800, 19.0476, 5.9800, 28.5714, 10.7419, 38.0952, 15.5038, 42.8571, 48.8371, 61.9048, 53.5990, 66.6667, 58.3610, 76.1905, 58.3610, 85.7143, 53.5990, 95.2381, 44.0752, 100.0000, 34.5514, 95.2381, 29.7895, 85.7143, 29.7895, 76.1905, 34.5514, 61.9048, 44.0752, 47.6190, 67.8848, 14.2857, 77.4086, 4.7619, 86.9324, 0.0000, 96.4562, 0.0000, 101.2180, 4.7619, 101.2180, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

4.4400, 100.0000, 4.4400, 66.6667, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 1 *
 *************************/

40.9133, 119.0480, 31.3895, 109.5240, 21.8657, 95.2381, 12.3419, 76.1905, 7.5800, 52.3810, 7.5800, 33.3333, 12.3419, 9.5238, 21.8657, -9.5238, 31.3895, -23.8095, 40.9133, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 1 *
 *************************/

5.2800, 119.0480, 14.8038, 109.5240, 24.3276, 95.2381, 33.8514, 76.1905, 38.6133, 52.3810, 38.6133, 33.3333, 33.8514, 9.5238, 24.3276, -9.5238, 14.8038, -23.8095, 5.2800, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

30.7695, 71.4286, 30.7695, 14.2857, GAMGI_IO_STROKE,

6.9600, 57.1429, 54.5790, 28.5714, GAMGI_IO_STROKE,

54.5790, 57.1429, 6.9600, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

48.8371, 85.7143, 48.8371, 0.0000, GAMGI_IO_STROKE,

5.9800, 42.8571, 91.6943, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

18.2838, 4.7619, 13.5219, 0.0000, 8.7600, 4.7619, 13.5219, 9.5238, 18.2838, 4.7619, 18.2838, -4.7619, 13.5219, -14.2857, 8.7600, -19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

7.3800, 42.8571, 93.0943, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

13.1019, 9.5238, 8.3400, 4.7619, 13.1019, 0.0000, 17.8638, 4.7619, 13.1019, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

7.2400, -14.2857, 73.9067, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 1 *
 *************************/

33.5514, 100.0000, 19.2657, 95.2381, 9.7419, 80.9524, 4.9800, 57.1429, 4.9800, 42.8571, 9.7419, 19.0476, 19.2657, 4.7619, 33.5514, 0.0000, 43.0752, 0.0000, 57.3610, 4.7619, 66.8848, 19.0476, 71.6467, 42.8571, 71.6467, 57.1429, 66.8848, 80.9524, 57.3610, 95.2381, 43.0752, 100.0000, 33.5514, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 1 *
 *************************/

11.8200, 80.9524, 21.3438, 85.7143, 35.6295, 100.0000, 35.6295, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 1 *
 *************************/

10.1819, 76.1905, 10.1819, 80.9524, 14.9438, 90.4762, 19.7057, 95.2381, 29.2295, 100.0000, 48.2771, 100.0000, 57.8010, 95.2381, 62.5629, 90.4762, 67.3248, 80.9524, 67.3248, 71.4286, 62.5629, 61.9048, 53.0390, 47.6190, 5.4200, 0.0000, 72.0867, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 1 *
 *************************/

14.5238, 100.0000, 66.9048, 100.0000, 38.3333, 61.9048, 52.6190, 61.9048, 62.1429, 57.1429, 66.9048, 52.3810, 71.6667, 38.0952, 71.6667, 28.5714, 66.9048, 14.2857, 57.3810, 4.7619, 43.0952, 0.0000, 28.8095, 0.0000, 14.5238, 4.7619, 9.7619, 9.5238, 5.0000, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 2 *
 *************************/

51.4990, 100.0000, 3.8800, 33.3333, 75.3086, 33.3333, GAMGI_IO_STROKE,

51.4990, 100.0000, 51.4990, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 1 *
 *************************/

62.0029, 100.0000, 14.3838, 100.0000, 9.6219, 57.1429, 14.3838, 61.9048, 28.6695, 66.6667, 42.9552, 66.6667, 57.2410, 61.9048, 66.7648, 52.3810, 71.5267, 38.0952, 71.5267, 28.5714, 66.7648, 14.2857, 57.2410, 4.7619, 42.9552, 0.0000, 28.6695, 0.0000, 14.3838, 4.7619, 9.6219, 9.5238, 4.8600, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 1 *
 *************************/

62.7229, 85.7143, 57.9610, 95.2381, 43.6752, 100.0000, 34.1514, 100.0000, 19.8657, 95.2381, 10.3419, 80.9524, 5.5800, 57.1429, 5.5800, 33.3333, 10.3419, 14.2857, 19.8657, 4.7619, 34.1514, 0.0000, 38.9133, 0.0000, 53.1990, 4.7619, 62.7229, 14.2857, 67.4848, 28.5714, 67.4848, 33.3333, 62.7229, 47.6190, 53.1990, 57.1429, 38.9133, 61.9048, 34.1514, 61.9048, 19.8657, 57.1429, 10.3419, 47.6190, 5.5800, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 2 *
 *************************/

72.2267, 100.0000, 24.6076, 0.0000, GAMGI_IO_STROKE,

5.5600, 100.0000, 72.2267, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 1 *
 *************************/

29.4095, 100.0000, 15.1238, 95.2381, 10.3619, 85.7143, 10.3619, 76.1905, 15.1238, 66.6667, 24.6476, 61.9048, 43.6952, 57.1429, 57.9810, 52.3810, 67.5048, 42.8571, 72.2667, 33.3333, 72.2667, 19.0476, 67.5048, 9.5238, 62.7429, 4.7619, 48.4571, 0.0000, 29.4095, 0.0000, 15.1238, 4.7619, 10.3619, 9.5238, 5.6000, 19.0476, 5.6000, 33.3333, 10.3619, 42.8571, 19.8857, 52.3810, 34.1714, 57.1429, 53.2190, 61.9048, 62.7429, 66.6667, 67.5048, 76.1905, 67.5048, 85.7143, 62.7429, 95.2381, 48.4571, 100.0000, 29.4095, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 1 *
 *************************/

68.5048, 66.6667, 63.7429, 52.3810, 54.2190, 42.8571, 39.9333, 38.0952, 35.1714, 38.0952, 20.8857, 42.8571, 11.3619, 52.3810, 6.6000, 66.6667, 6.6000, 71.4286, 11.3619, 85.7143, 20.8857, 95.2381, 35.1714, 100.0000, 39.9333, 100.0000, 54.2190, 95.2381, 63.7429, 85.7143, 68.5048, 66.6667, 68.5048, 42.8571, 63.7429, 19.0476, 54.2190, 4.7619, 39.9333, 0.0000, 30.4095, 0.0000, 16.1238, 4.7619, 11.3619, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

14.0819, 66.6667, 9.3200, 61.9048, 14.0819, 57.1429, 18.8438, 61.9048, 14.0819, 66.6667, GAMGI_IO_STROKE,

14.0819, 9.5238, 9.3200, 4.7619, 14.0819, 0.0000, 18.8438, 4.7619, 14.0819, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

12.9619, 66.6667, 8.2000, 61.9048, 12.9619, 57.1429, 17.7238, 61.9048, 12.9619, 66.6667, GAMGI_IO_STROKE,

17.7238, 4.7619, 12.9619, 0.0000, 8.2000, 4.7619, 12.9619, 9.5238, 17.7238, 4.7619, 17.7238, -4.7619, 12.9619, -14.2857, 8.2000, -19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

79.2505, 85.7143, 3.0600, 42.8571, 79.2505, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

5.7000, 57.1429, 91.4143, 57.1429, GAMGI_IO_STROKE,

5.7000, 28.5714, 91.4143, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

2.7800, 85.7143, 78.9705, 42.8571, 2.7800, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 2 *
 *************************/

8.4200, 76.1905, 8.4200, 80.9524, 13.1819, 90.4762, 17.9438, 95.2381, 27.4676, 100.0000, 46.5152, 100.0000, 56.0390, 95.2381, 60.8010, 90.4762, 65.5629, 80.9524, 65.5629, 71.4286, 60.8010, 61.9048, 56.0390, 57.1429, 36.9914, 47.6190, 36.9914, 33.3333, GAMGI_IO_STROKE,

36.9914, 9.5238, 32.2295, 4.7619, 36.9914, 0.0000, 41.7533, 4.7619, 36.9914, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 2 *
 *************************/

49.2171, 52.3810, 39.6933, 57.1429, 30.1695, 57.1429, 25.4076, 47.6190, 25.4076, 42.8571, 30.1695, 33.3333, 39.6933, 33.3333, 49.2171, 38.0952, GAMGI_IO_STROKE,

49.2171, 57.1429, 49.2171, 38.0952, 53.9790, 33.3333, 63.5029, 33.3333, 68.2648, 42.8571, 68.2648, 47.6190, 63.5029, 61.9048, 53.9790, 71.4286, 39.6933, 76.1905, 34.9314, 76.1905, 20.6457, 71.4286, 11.1219, 61.9048, 6.3600, 47.6190, 6.3600, 42.8571, 11.1219, 28.5714, 20.6457, 19.0476, 34.9314, 14.2857, 39.6933, 14.2857, 53.9790, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 3 *
 *************************/

40.5952, 100.0000, 2.5000, 0.0000, GAMGI_IO_STROKE,

40.5952, 100.0000, 78.6905, 0.0000, GAMGI_IO_STROKE,

16.7857, 33.3333, 64.4048, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 3 *
 *************************/

11.4200, 100.0000, 11.4200, 0.0000, GAMGI_IO_STROKE,

11.4200, 100.0000, 54.2771, 100.0000, 68.5629, 95.2381, 73.3248, 90.4762, 78.0867, 80.9524, 78.0867, 71.4286, 73.3248, 61.9048, 68.5629, 57.1429, 54.2771, 52.3810, GAMGI_IO_STROKE,

11.4200, 52.3810, 54.2771, 52.3810, 68.5629, 47.6190, 73.3248, 42.8571, 78.0867, 33.3333, 78.0867, 19.0476, 73.3248, 9.5238, 68.5629, 4.7619, 54.2771, 0.0000, 11.4200, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 1 *
 *************************/

78.0886, 76.1905, 73.3267, 85.7143, 63.8029, 95.2381, 54.2790, 100.0000, 35.2314, 100.0000, 25.7076, 95.2381, 16.1838, 85.7143, 11.4219, 76.1905, 6.6600, 61.9048, 6.6600, 38.0952, 11.4219, 23.8095, 16.1838, 14.2857, 25.7076, 4.7619, 35.2314, 0.0000, 54.2790, 0.0000, 63.8029, 4.7619, 73.3267, 14.2857, 78.0886, 23.8095, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 2 *
 *************************/

11.9600, 100.0000, 11.9600, 0.0000, GAMGI_IO_STROKE,

11.9600, 100.0000, 45.2933, 100.0000, 59.5790, 95.2381, 69.1029, 85.7143, 73.8648, 76.1905, 78.6267, 61.9048, 78.6267, 38.0952, 73.8648, 23.8095, 69.1029, 14.2857, 59.5790, 4.7619, 45.2933, 0.0000, 11.9600, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 4 *
 *************************/

11.4200, 100.0000, 11.4200, 0.0000, GAMGI_IO_STROKE,

11.4200, 100.0000, 73.3248, 100.0000, GAMGI_IO_STROKE,

11.4200, 52.3810, 49.5152, 52.3810, GAMGI_IO_STROKE,

11.4200, 0.0000, 73.3248, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 3 *
 *************************/

11.4200, 100.0000, 11.4200, 0.0000, GAMGI_IO_STROKE,

11.4200, 100.0000, 73.3248, 100.0000, GAMGI_IO_STROKE,

11.4200, 52.3810, 49.5152, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 2 *
 *************************/

78.4886, 76.1905, 73.7267, 85.7143, 64.2029, 95.2381, 54.6790, 100.0000, 35.6314, 100.0000, 26.1076, 95.2381, 16.5838, 85.7143, 11.8219, 76.1905, 7.0600, 61.9048, 7.0600, 38.0952, 11.8219, 23.8095, 16.5838, 14.2857, 26.1076, 4.7619, 35.6314, 0.0000, 54.6790, 0.0000, 64.2029, 4.7619, 73.7267, 14.2857, 78.4886, 23.8095, 78.4886, 38.0952, GAMGI_IO_STROKE,

54.6790, 38.0952, 78.4886, 38.0952, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 3 *
 *************************/

11.4200, 100.0000, 11.4200, 0.0000, GAMGI_IO_STROKE,

78.0867, 100.0000, 78.0867, 0.0000, GAMGI_IO_STROKE,

11.4200, 52.3810, 78.0867, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 1 *
 *************************/

10.8600, 100.0000, 10.8600, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 1 *
 *************************/

50.1190, 100.0000, 50.1190, 23.8095, 45.3571, 9.5238, 40.5952, 4.7619, 31.0714, 0.0000, 21.5476, 0.0000, 12.0238, 4.7619, 7.2619, 9.5238, 2.5000, 23.8095, 2.5000, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 3 *
 *************************/

11.2800, 100.0000, 11.2800, 0.0000, GAMGI_IO_STROKE,

77.9467, 100.0000, 11.2800, 33.3333, GAMGI_IO_STROKE,

35.0895, 57.1429, 77.9467, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 2 *
 *************************/

11.6800, 100.0000, 11.6800, 0.0000, GAMGI_IO_STROKE,

11.6800, 0.0000, 68.8229, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 4 *
 *************************/

10.8600, 100.0000, 10.8600, 0.0000, GAMGI_IO_STROKE,

10.8600, 100.0000, 48.9552, 0.0000, GAMGI_IO_STROKE,

87.0505, 100.0000, 48.9552, 0.0000, GAMGI_IO_STROKE,

87.0505, 100.0000, 87.0505, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 3 *
 *************************/

11.1400, 100.0000, 11.1400, 0.0000, GAMGI_IO_STROKE,

11.1400, 100.0000, 77.8067, 0.0000, GAMGI_IO_STROKE,

77.8067, 100.0000, 77.8067, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 1 *
 *************************/

34.8114, 100.0000, 25.2876, 95.2381, 15.7638, 85.7143, 11.0019, 76.1905, 6.2400, 61.9048, 6.2400, 38.0952, 11.0019, 23.8095, 15.7638, 14.2857, 25.2876, 4.7619, 34.8114, 0.0000, 53.8590, 0.0000, 63.3829, 4.7619, 72.9067, 14.2857, 77.6686, 23.8095, 82.4305, 38.0952, 82.4305, 61.9048, 77.6686, 76.1905, 72.9067, 85.7143, 63.3829, 95.2381, 53.8590, 100.0000, 34.8114, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 2 *
 *************************/

12.1000, 100.0000, 12.1000, 0.0000, GAMGI_IO_STROKE,

12.1000, 100.0000, 54.9571, 100.0000, 69.2429, 95.2381, 74.0048, 90.4762, 78.7667, 80.9524, 78.7667, 66.6667, 74.0048, 57.1429, 69.2429, 52.3810, 54.9571, 47.6190, 12.1000, 47.6190, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 2 *
 *************************/

33.8714, 100.0000, 24.3476, 95.2381, 14.8238, 85.7143, 10.0619, 76.1905, 5.3000, 61.9048, 5.3000, 38.0952, 10.0619, 23.8095, 14.8238, 14.2857, 24.3476, 4.7619, 33.8714, 0.0000, 52.9190, 0.0000, 62.4429, 4.7619, 71.9667, 14.2857, 76.7286, 23.8095, 81.4905, 38.0952, 81.4905, 61.9048, 76.7286, 76.1905, 71.9667, 85.7143, 62.4429, 95.2381, 52.9190, 100.0000, 33.8714, 100.0000, GAMGI_IO_STROKE,

48.1571, 19.0476, 76.7286, -9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 3 *
 *************************/

11.6800, 100.0000, 11.6800, 0.0000, GAMGI_IO_STROKE,

11.6800, 100.0000, 54.5371, 100.0000, 68.8229, 95.2381, 73.5848, 90.4762, 78.3467, 80.9524, 78.3467, 71.4286, 73.5848, 61.9048, 68.8229, 57.1429, 54.5371, 52.3810, 11.6800, 52.3810, GAMGI_IO_STROKE,

45.0133, 52.3810, 78.3467, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 1 *
 *************************/

74.6667, 85.7143, 65.1429, 95.2381, 50.8571, 100.0000, 31.8095, 100.0000, 17.5238, 95.2381, 8.0000, 85.7143, 8.0000, 76.1905, 12.7619, 66.6667, 17.5238, 61.9048, 27.0476, 57.1429, 55.6190, 47.6190, 65.1429, 42.8571, 69.9048, 38.0952, 74.6667, 28.5714, 74.6667, 14.2857, 65.1429, 4.7619, 50.8571, 0.0000, 31.8095, 0.0000, 17.5238, 4.7619, 8.0000, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 2 *
 *************************/

35.6933, 100.0000, 35.6933, 0.0000, GAMGI_IO_STROKE,

2.3600, 100.0000, 69.0267, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 1 *
 *************************/

11.5400, 100.0000, 11.5400, 28.5714, 16.3019, 14.2857, 25.8257, 4.7619, 40.1114, 0.0000, 49.6352, 0.0000, 63.9210, 4.7619, 73.4448, 14.2857, 78.2067, 28.5714, 78.2067, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 2 *
 *************************/

2.3600, 100.0000, 40.4552, 0.0000, GAMGI_IO_STROKE,

78.5505, 100.0000, 40.4552, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 4 *
 *************************/

2.2200, 100.0000, 26.0295, 0.0000, GAMGI_IO_STROKE,

49.8390, 100.0000, 26.0295, 0.0000, GAMGI_IO_STROKE,

49.8390, 100.0000, 73.6486, 0.0000, GAMGI_IO_STROKE,

97.4581, 100.0000, 73.6486, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 2 *
 *************************/

2.5000, 100.0000, 69.1667, 0.0000, GAMGI_IO_STROKE,

69.1667, 100.0000, 2.5000, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 2 *
 *************************/

1.5200, 100.0000, 39.6152, 52.3810, 39.6152, 0.0000, GAMGI_IO_STROKE,

77.7105, 100.0000, 39.6152, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 3 *
 *************************/

69.1667, 100.0000, 2.5000, 0.0000, GAMGI_IO_STROKE,

2.5000, 100.0000, 69.1667, 100.0000, GAMGI_IO_STROKE,

2.5000, 0.0000, 69.1667, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

7.7800, 119.0480, 7.7800, -33.3333, GAMGI_IO_STROKE,

12.5419, 119.0480, 12.5419, -33.3333, GAMGI_IO_STROKE,

7.7800, 119.0480, 41.1133, 119.0480, GAMGI_IO_STROKE,

7.7800, -33.3333, 41.1133, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

5.8400, 100.0000, 72.5067, -14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

33.0114, 119.0480, 33.0114, -33.3333, GAMGI_IO_STROKE,

37.7733, 119.0480, 37.7733, -33.3333, GAMGI_IO_STROKE,

4.4400, 119.0480, 37.7733, 119.0480, GAMGI_IO_STROKE,

4.4400, -33.3333, 37.7733, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

44.0752, 109.5240, 5.9800, 42.8571, GAMGI_IO_STROKE,

44.0752, 109.5240, 82.1705, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

-1.1000, -33.3333, 103.6620, -33.3333, 103.6620, -28.5714, -1.1000, -28.5714, -1.1000, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 2 *
 *************************/

33.0219, 100.0000, 56.8314, 71.4286, GAMGI_IO_STROKE,

33.0219, 100.0000, 28.2600, 95.2381, 56.8314, 71.4286, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 2 *
 *************************/

63.8229, 66.6667, 63.8229, 0.0000, GAMGI_IO_STROKE,

63.8229, 52.3810, 54.2990, 61.9048, 44.7752, 66.6667, 30.4895, 66.6667, 20.9657, 61.9048, 11.4419, 52.3810, 6.6800, 38.0952, 6.6800, 28.5714, 11.4419, 14.2857, 20.9657, 4.7619, 30.4895, 0.0000, 44.7752, 0.0000, 54.2990, 4.7619, 63.8229, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 2 *
 *************************/

8.7600, 100.0000, 8.7600, 0.0000, GAMGI_IO_STROKE,

8.7600, 52.3810, 18.2838, 61.9048, 27.8076, 66.6667, 42.0933, 66.6667, 51.6171, 61.9048, 61.1410, 52.3810, 65.9029, 38.0952, 65.9029, 28.5714, 61.1410, 14.2857, 51.6171, 4.7619, 42.0933, 0.0000, 27.8076, 0.0000, 18.2838, 4.7619, 8.7600, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 1 *
 *************************/

62.6629, 52.3810, 53.1390, 61.9048, 43.6152, 66.6667, 29.3295, 66.6667, 19.8057, 61.9048, 10.2819, 52.3810, 5.5200, 38.0952, 5.5200, 28.5714, 10.2819, 14.2857, 19.8057, 4.7619, 29.3295, 0.0000, 43.6152, 0.0000, 53.1390, 4.7619, 62.6629, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 2 *
 **************************/

61.7829, 100.0000, 61.7829, 0.0000, GAMGI_IO_STROKE,

61.7829, 52.3810, 52.2590, 61.9048, 42.7352, 66.6667, 28.4495, 66.6667, 18.9257, 61.9048, 9.4019, 52.3810, 4.6400, 38.0952, 4.6400, 28.5714, 9.4019, 14.2857, 18.9257, 4.7619, 28.4495, 0.0000, 42.7352, 0.0000, 52.2590, 4.7619, 61.7829, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 1 *
 **************************/

5.7200, 38.0952, 62.8629, 38.0952, 62.8629, 47.6190, 58.1010, 57.1429, 53.3390, 61.9048, 43.8152, 66.6667, 29.5295, 66.6667, 20.0057, 61.9048, 10.4819, 52.3810, 5.7200, 38.0952, 5.7200, 28.5714, 10.4819, 14.2857, 20.0057, 4.7619, 29.5295, 0.0000, 43.8152, 0.0000, 53.3390, 4.7619, 62.8629, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 2 *
 **************************/

38.7752, 100.0000, 29.2514, 100.0000, 19.7276, 95.2381, 14.9657, 80.9524, 14.9657, 0.0000, GAMGI_IO_STROKE,

0.6800, 66.6667, 34.0133, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 2 *
 **************************/

62.5029, 66.6667, 62.5029, -9.5238, 57.7410, -23.8095, 52.9790, -28.5714, 43.4552, -33.3333, 29.1695, -33.3333, 19.6457, -28.5714, GAMGI_IO_STROKE,

62.5029, 52.3810, 52.9790, 61.9048, 43.4552, 66.6667, 29.1695, 66.6667, 19.6457, 61.9048, 10.1219, 52.3810, 5.3600, 38.0952, 5.3600, 28.5714, 10.1219, 14.2857, 19.6457, 4.7619, 29.1695, 0.0000, 43.4552, 0.0000, 52.9790, 4.7619, 62.5029, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 2 *
 **************************/

9.6000, 100.0000, 9.6000, 0.0000, GAMGI_IO_STROKE,

9.6000, 47.6190, 23.8857, 61.9048, 33.4095, 66.6667, 47.6952, 66.6667, 57.2190, 61.9048, 61.9810, 47.6190, 61.9810, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 2 *
 **************************/

10.0200, 100.0000, 14.7819, 95.2381, 19.5438, 100.0000, 14.7819, 104.7620, 10.0200, 100.0000, GAMGI_IO_STROKE,

14.7819, 66.6667, 14.7819, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 2 *
 **************************/

17.3876, 100.0000, 22.1495, 95.2381, 26.9114, 100.0000, 22.1495, 104.7620, 17.3876, 100.0000, GAMGI_IO_STROKE,

22.1495, 66.6667, 22.1495, -14.2857, 17.3876, -28.5714, 7.8638, -33.3333, -1.6600, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 3 *
 **************************/

9.6000, 100.0000, 9.6000, 0.0000, GAMGI_IO_STROKE,

57.2190, 66.6667, 9.6000, 19.0476, GAMGI_IO_STROKE,

28.6476, 38.0952, 61.9810, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 1 *
 **************************/

10.0200, 100.0000, 10.0200, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 3 *
 **************************/

9.6000, 66.6667, 9.6000, 0.0000, GAMGI_IO_STROKE,

9.6000, 47.6190, 23.8857, 61.9048, 33.4095, 66.6667, 47.6952, 66.6667, 57.2190, 61.9048, 61.9810, 47.6190, 61.9810, 0.0000, GAMGI_IO_STROKE,

61.9810, 47.6190, 76.2667, 61.9048, 85.7905, 66.6667, 100.0760, 66.6667, 109.6000, 61.9048, 114.3620, 47.6190, 114.3620, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 2 *
 **************************/

9.1800, 66.6667, 9.1800, 0.0000, GAMGI_IO_STROKE,

9.1800, 47.6190, 23.4657, 61.9048, 32.9895, 66.6667, 47.2752, 66.6667, 56.7990, 61.9048, 61.5610, 47.6190, 61.5610, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 1 *
 **************************/

28.7895, 66.6667, 19.2657, 61.9048, 9.7419, 52.3810, 4.9800, 38.0952, 4.9800, 28.5714, 9.7419, 14.2857, 19.2657, 4.7619, 28.7895, 0.0000, 43.0752, 0.0000, 52.5990, 4.7619, 62.1229, 14.2857, 66.8848, 28.5714, 66.8848, 38.0952, 62.1229, 52.3810, 52.5990, 61.9048, 43.0752, 66.6667, 28.7895, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 2 *
 **************************/

9.4600, 66.6667, 9.4600, -33.3333, GAMGI_IO_STROKE,

9.4600, 52.3810, 18.9838, 61.9048, 28.5076, 66.6667, 42.7933, 66.6667, 52.3171, 61.9048, 61.8410, 52.3810, 66.6029, 38.0952, 66.6029, 28.5714, 61.8410, 14.2857, 52.3171, 4.7619, 42.7933, 0.0000, 28.5076, 0.0000, 18.9838, 4.7619, 9.4600, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 2 *
 **************************/

61.9829, 66.6667, 61.9829, -33.3333, GAMGI_IO_STROKE,

61.9829, 52.3810, 52.4590, 61.9048, 42.9352, 66.6667, 28.6495, 66.6667, 19.1257, 61.9048, 9.6019, 52.3810, 4.8400, 38.0952, 4.8400, 28.5714, 9.6019, 14.2857, 19.1257, 4.7619, 28.6495, 0.0000, 42.9352, 0.0000, 52.4590, 4.7619, 61.9829, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 2 *
 **************************/

9.4600, 66.6667, 9.4600, 0.0000, GAMGI_IO_STROKE,

9.4600, 38.0952, 14.2219, 52.3810, 23.7457, 61.9048, 33.2695, 66.6667, 47.5552, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 1 *
 **************************/

57.0810, 52.3810, 52.3190, 61.9048, 38.0333, 66.6667, 23.7476, 66.6667, 9.4619, 61.9048, 4.7000, 52.3810, 9.4619, 42.8571, 18.9857, 38.0952, 42.7952, 33.3333, 52.3190, 28.5714, 57.0810, 19.0476, 57.0810, 14.2857, 52.3190, 4.7619, 38.0333, 0.0000, 23.7476, 0.0000, 9.4619, 4.7619, 4.7000, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 2 *
 **************************/

14.8257, 100.0000, 14.8257, 19.0476, 19.5876, 4.7619, 29.1114, 0.0000, 38.6352, 0.0000, GAMGI_IO_STROKE,

0.5400, 66.6667, 33.8733, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 2 *
 **************************/

9.4600, 66.6667, 9.4600, 19.0476, 14.2219, 4.7619, 23.7457, 0.0000, 38.0314, 0.0000, 47.5552, 4.7619, 61.8410, 19.0476, GAMGI_IO_STROKE,

61.8410, 66.6667, 61.8410, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 2 *
 **************************/

1.8000, 66.6667, 30.3714, 0.0000, GAMGI_IO_STROKE,

58.9429, 66.6667, 30.3714, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 4 *
 **************************/

2.5000, 66.6667, 21.5476, 0.0000, GAMGI_IO_STROKE,

40.5952, 66.6667, 21.5476, 0.0000, GAMGI_IO_STROKE,

40.5952, 66.6667, 59.6429, 0.0000, GAMGI_IO_STROKE,

78.6905, 66.6667, 59.6429, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 2 *
 **************************/

1.6600, 66.6667, 54.0410, 0.0000, GAMGI_IO_STROKE,

54.0410, 66.6667, 1.6600, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 2 *
 **************************/

6.5619, 66.6667, 35.1333, 0.0000, GAMGI_IO_STROKE,

63.7048, 66.6667, 35.1333, 0.0000, 25.6095, -19.0476, 16.0857, -28.5714, 6.5619, -33.3333, 1.8000, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 3 *
 **************************/

56.8210, 66.6667, 4.4400, 0.0000, GAMGI_IO_STROKE,

4.4400, 66.6667, 56.8210, 66.6667, GAMGI_IO_STROKE,

4.4400, 0.0000, 56.8210, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

31.1895, 119.0480, 21.6657, 114.2860, 16.9038, 109.5240, 12.1419, 100.0000, 12.1419, 90.4762, 16.9038, 80.9524, 21.6657, 76.1905, 26.4276, 66.6667, 26.4276, 57.1429, 16.9038, 47.6190, GAMGI_IO_STROKE,

21.6657, 114.2860, 16.9038, 104.7620, 16.9038, 95.2381, 21.6657, 85.7143, 26.4276, 80.9524, 31.1895, 71.4286, 31.1895, 61.9048, 26.4276, 52.3810, 7.3800, 42.8571, 26.4276, 33.3333, 31.1895, 23.8095, 31.1895, 14.2857, 26.4276, 4.7619, 21.6657, 0.0000, 16.9038, -9.5238, 16.9038, -19.0476, 21.6657, -28.5714, GAMGI_IO_STROKE,

16.9038, 38.0952, 26.4276, 28.5714, 26.4276, 19.0476, 21.6657, 9.5238, 16.9038, 4.7619, 12.1419, -4.7619, 12.1419, -14.2857, 16.9038, -23.8095, 21.6657, -28.5714, 31.1895, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

11.5400, 119.0480, 11.5400, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

9.1800, 119.0480, 18.7038, 114.2860, 23.4657, 109.5240, 28.2276, 100.0000, 28.2276, 90.4762, 23.4657, 80.9524, 18.7038, 76.1905, 13.9419, 66.6667, 13.9419, 57.1429, 23.4657, 47.6190, GAMGI_IO_STROKE,

18.7038, 114.2860, 23.4657, 104.7620, 23.4657, 95.2381, 18.7038, 85.7143, 13.9419, 80.9524, 9.1800, 71.4286, 9.1800, 61.9048, 13.9419, 52.3810, 32.9895, 42.8571, 13.9419, 33.3333, 9.1800, 23.8095, 9.1800, 14.2857, 13.9419, 4.7619, 18.7038, 0.0000, 23.4657, -9.5238, 23.4657, -19.0476, 18.7038, -28.5714, GAMGI_IO_STROKE,

23.4657, 38.0952, 13.9419, 28.5714, 13.9419, 19.0476, 18.7038, 9.5238, 23.4657, 4.7619, 28.2276, -4.7619, 28.2276, -14.2857, 23.4657, -23.8095, 18.7038, -28.5714, 9.1800, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

2.9200, 28.5714, 2.9200, 38.0952, 7.6819, 52.3810, 17.2057, 57.1429, 26.7295, 57.1429, 36.2533, 52.3810, 55.3010, 38.0952, 64.8248, 33.3333, 74.3486, 33.3333, 83.8724, 38.0952, 88.6343, 47.6190, GAMGI_IO_STROKE,

2.9200, 38.0952, 7.6819, 47.6190, 17.2057, 52.3810, 26.7295, 52.3810, 36.2533, 47.6190, 55.3010, 33.3333, 64.8248, 28.5714, 74.3486, 28.5714, 83.8724, 33.3333, 88.6343, 47.6190, 88.6343, 57.1429, GAMGI_IO_CHAR,

};

const float gamgi_io_font_sun_roman_mono_points[GAMGI_IO_POINTS_ROMAN_MONO] = {

/***************
 * bottom, top *
 ***************/

-33.3333, 119.0476,

/**************
 * char 32-40 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/**************
 * char 41-50 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/**************
 * char 51-60 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/**************
 * char 61-70 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/**************
 * char 71-80 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/**************
 * char 81-90 *
 **************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/***************
 * char 91-100 *
 ***************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/****************
 * char 101-110 *
 ****************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/****************
 * char 111-120 *
 ****************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/****************
 * char 121-126 *
 ****************/

104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 104.7619, 

/*************************
 * char: 32   strokes: 0 *
 *************************/

GAMGI_IO_CHAR,

/*************************
 * char: 33 ! strokes: 2 *
 *************************/

52.3810, 100.0000, 52.3810, 33.3333, GAMGI_IO_STROKE,

52.3810, 9.5238, 47.6191, 4.7619, 52.3810, 0.0000, 57.1429, 4.7619, 52.3810, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 34 " strokes: 2 *
 *************************/

33.3334, 100.0000, 33.3334, 66.6667, GAMGI_IO_STROKE,

71.4286, 100.0000, 71.4286, 66.6667, GAMGI_IO_CHAR,

/*************************
 * char: 35 # strokes: 4 *
 *************************/

54.7619, 119.0476, 21.4286, -33.3333, GAMGI_IO_STROKE,

83.3334, 119.0476, 50.0000, -33.3333, GAMGI_IO_STROKE,

21.4286, 57.1429, 88.0952, 57.1429, GAMGI_IO_STROKE,

16.6667, 28.5714, 83.3334, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 36 $ strokes: 3 *
 *************************/

42.8571, 119.0476, 42.8571, -19.0476, GAMGI_IO_STROKE,

61.9047, 119.0476, 61.9047, -19.0476, GAMGI_IO_STROKE,

85.7143, 85.7143, 76.1905, 95.2381, 61.9047, 100.0000, 42.8571, 100.0000, 28.5714, 95.2381, 19.0476, 85.7143, 19.0476, 76.1905, 23.8095, 66.6667, 28.5714, 61.9048, 38.0952, 57.1429, 66.6666, 47.6190, 76.1905, 42.8571, 80.9524, 38.0952, 85.7143, 28.5714, 85.7143, 14.2857, 76.1905, 4.7619, 61.9047, 0.0000, 42.8571, 0.0000, 28.5714, 4.7619, 19.0476, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 37 % strokes: 3 *
 *************************/

95.2381, 100.0000, 9.5238, 0.0000, GAMGI_IO_STROKE,

33.3333, 100.0000, 42.8571, 90.4762, 42.8571, 80.9524, 38.0952, 71.4286, 28.5714, 66.6667, 19.0476, 66.6667, 9.5238, 76.1905, 9.5238, 85.7143, 14.2857, 95.2381, 23.8095, 100.0000, 33.3333, 100.0000, 42.8571, 95.2381, 57.1428, 90.4762, 71.4286, 90.4762, 85.7143, 95.2381, 95.2381, 100.0000, GAMGI_IO_STROKE,

76.1905, 33.3333, 66.6667, 28.5714, 61.9048, 19.0476, 61.9048, 9.5238, 71.4286, 0.0000, 80.9524, 0.0000, 90.4762, 4.7619, 95.2381, 14.2857, 95.2381, 23.8095, 85.7143, 33.3333, 76.1905, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 38 & strokes: 1 *
 *************************/

100.0000, 57.1429, 100.0000, 61.9048, 95.2381, 66.6667, 90.4762, 66.6667, 85.7143, 61.9048, 80.9524, 52.3810, 71.4286, 28.5714, 61.9048, 14.2857, 52.3809, 4.7619, 42.8571, 0.0000, 23.8095, 0.0000, 14.2857, 4.7619, 9.5238, 9.5238, 4.7619, 19.0476, 4.7619, 28.5714, 9.5238, 38.0952, 14.2857, 42.8571, 47.6190, 61.9048, 52.3809, 66.6667, 57.1429, 76.1905, 57.1429, 85.7143, 52.3809, 95.2381, 42.8571, 100.0000, 33.3333, 95.2381, 28.5714, 85.7143, 28.5714, 76.1905, 33.3333, 61.9048, 42.8571, 47.6190, 66.6667, 14.2857, 76.1905, 4.7619, 85.7143, 0.0000, 95.2381, 0.0000, 100.0000, 4.7619, 100.0000, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 39 ' strokes: 1 *
 *************************/

52.3810, 100.0000, 52.3810, 66.6667, GAMGI_IO_CHAR,

/*************************
 * char: 40 ( strokes: 1 *
 *************************/

69.0476, 119.0476, 59.5238, 109.5238, 50.0000, 95.2381, 40.4762, 76.1905, 35.7143, 52.3810, 35.7143, 33.3333, 40.4762, 9.5238, 50.0000, -9.5238, 59.5238, -23.8095, 69.0476, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 41 ) strokes: 1 *
 *************************/

35.7143, 119.0476, 45.2381, 109.5238, 54.7619, 95.2381, 64.2857, 76.1905, 69.0476, 52.3810, 69.0476, 33.3333, 64.2857, 9.5238, 54.7619, -9.5238, 45.2381, -23.8095, 35.7143, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 42 * strokes: 3 *
 *************************/

52.3810, 71.4286, 52.3810, 14.2857, GAMGI_IO_STROKE,

28.5715, 57.1429, 76.1905, 28.5714, GAMGI_IO_STROKE,

76.1905, 57.1429, 28.5715, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 43 + strokes: 2 *
 *************************/

52.3809, 85.7143, 52.3809, 0.0000, GAMGI_IO_STROKE,

9.5238, 42.8571, 95.2381, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 44 , strokes: 1 *
 *************************/

57.1429, 4.7619, 52.3810, 0.0000, 47.6191, 4.7619, 52.3810, 9.5238, 57.1429, 4.7619, 57.1429, -4.7619, 52.3810, -14.2857, 47.6191, -19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 45 - strokes: 1 *
 *************************/

9.5238, 42.8571, 95.2381, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 46 . strokes: 1 *
 *************************/

52.3810, 9.5238, 47.6191, 4.7619, 52.3810, 0.0000, 57.1429, 4.7619, 52.3810, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 47 / strokes: 1 *
 *************************/

19.0476, -14.2857, 85.7143, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 48 0 strokes: 1 *
 *************************/

47.6190, 100.0000, 33.3333, 95.2381, 23.8095, 80.9524, 19.0476, 57.1429, 19.0476, 42.8571, 23.8095, 19.0476, 33.3333, 4.7619, 47.6190, 0.0000, 57.1428, 0.0000, 71.4286, 4.7619, 80.9524, 19.0476, 85.7143, 42.8571, 85.7143, 57.1429, 80.9524, 80.9524, 71.4286, 95.2381, 57.1428, 100.0000, 47.6190, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 49 1 strokes: 1 *
 *************************/

40.4762, 80.9524, 50.0000, 85.7143, 64.2857, 100.0000, 64.2857, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 50 2 strokes: 1 *
 *************************/

23.8095, 76.1905, 23.8095, 80.9524, 28.5714, 90.4762, 33.3333, 95.2381, 42.8571, 100.0000, 61.9047, 100.0000, 71.4286, 95.2381, 76.1905, 90.4762, 80.9524, 80.9524, 80.9524, 71.4286, 76.1905, 61.9048, 66.6666, 47.6190, 19.0476, 0.0000, 85.7143, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 51 3 strokes: 1 *
 *************************/

28.5714, 100.0000, 80.9524, 100.0000, 52.3809, 61.9048, 66.6666, 61.9048, 76.1905, 57.1429, 80.9524, 52.3810, 85.7143, 38.0952, 85.7143, 28.5714, 80.9524, 14.2857, 71.4286, 4.7619, 57.1428, 0.0000, 42.8571, 0.0000, 28.5714, 4.7619, 23.8095, 9.5238, 19.0476, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 52 4 strokes: 2 *
 *************************/

64.2857, 100.0000, 16.6667, 33.3333, 88.0952, 33.3333, GAMGI_IO_STROKE,

64.2857, 100.0000, 64.2857, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 53 5 strokes: 1 *
 *************************/

76.1905, 100.0000, 28.5714, 100.0000, 23.8095, 57.1429, 28.5714, 61.9048, 42.8571, 66.6667, 57.1428, 66.6667, 71.4286, 61.9048, 80.9524, 52.3810, 85.7143, 38.0952, 85.7143, 28.5714, 80.9524, 14.2857, 71.4286, 4.7619, 57.1428, 0.0000, 42.8571, 0.0000, 28.5714, 4.7619, 23.8095, 9.5238, 19.0476, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 54 6 strokes: 1 *
 *************************/

78.5714, 85.7143, 73.8096, 95.2381, 59.5238, 100.0000, 50.0000, 100.0000, 35.7143, 95.2381, 26.1905, 80.9524, 21.4286, 57.1429, 21.4286, 33.3333, 26.1905, 14.2857, 35.7143, 4.7619, 50.0000, 0.0000, 54.7619, 0.0000, 69.0476, 4.7619, 78.5714, 14.2857, 83.3334, 28.5714, 83.3334, 33.3333, 78.5714, 47.6190, 69.0476, 57.1429, 54.7619, 61.9048, 50.0000, 61.9048, 35.7143, 57.1429, 26.1905, 47.6190, 21.4286, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 55 7 strokes: 2 *
 *************************/

85.7143, 100.0000, 38.0952, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 85.7143, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 56 8 strokes: 1 *
 *************************/

42.8571, 100.0000, 28.5714, 95.2381, 23.8095, 85.7143, 23.8095, 76.1905, 28.5714, 66.6667, 38.0952, 61.9048, 57.1428, 57.1429, 71.4286, 52.3810, 80.9524, 42.8571, 85.7143, 33.3333, 85.7143, 19.0476, 80.9524, 9.5238, 76.1905, 4.7619, 61.9047, 0.0000, 42.8571, 0.0000, 28.5714, 4.7619, 23.8095, 9.5238, 19.0476, 19.0476, 19.0476, 33.3333, 23.8095, 42.8571, 33.3333, 52.3810, 47.6190, 57.1429, 66.6666, 61.9048, 76.1905, 66.6667, 80.9524, 76.1905, 80.9524, 85.7143, 76.1905, 95.2381, 61.9047, 100.0000, 42.8571, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 57 9 strokes: 1 *
 *************************/

83.3334, 66.6667, 78.5714, 52.3810, 69.0476, 42.8571, 54.7619, 38.0952, 50.0000, 38.0952, 35.7143, 42.8571, 26.1905, 52.3810, 21.4286, 66.6667, 21.4286, 71.4286, 26.1905, 85.7143, 35.7143, 95.2381, 50.0000, 100.0000, 54.7619, 100.0000, 69.0476, 95.2381, 78.5714, 85.7143, 83.3334, 66.6667, 83.3334, 42.8571, 78.5714, 19.0476, 69.0476, 4.7619, 54.7619, 0.0000, 45.2381, 0.0000, 30.9524, 4.7619, 26.1905, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 58 : strokes: 2 *
 *************************/

52.3810, 66.6667, 47.6191, 61.9048, 52.3810, 57.1429, 57.1429, 61.9048, 52.3810, 66.6667, GAMGI_IO_STROKE,

52.3810, 9.5238, 47.6191, 4.7619, 52.3810, 0.0000, 57.1429, 4.7619, 52.3810, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 59 ; strokes: 2 *
 *************************/

52.3810, 66.6667, 47.6191, 61.9048, 52.3810, 57.1429, 57.1429, 61.9048, 52.3810, 66.6667, GAMGI_IO_STROKE,

57.1429, 4.7619, 52.3810, 0.0000, 47.6191, 4.7619, 52.3810, 9.5238, 57.1429, 4.7619, 57.1429, -4.7619, 52.3810, -14.2857, 47.6191, -19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 60 < strokes: 1 *
 *************************/

90.4762, 85.7143, 14.2857, 42.8571, 90.4762, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 61 = strokes: 2 *
 *************************/

9.5238, 57.1429, 95.2381, 57.1429, GAMGI_IO_STROKE,

9.5238, 28.5714, 95.2381, 28.5714, GAMGI_IO_CHAR,

/*************************
 * char: 62 > strokes: 1 *
 *************************/

14.2857, 85.7143, 90.4762, 42.8571, 14.2857, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 63 ? strokes: 2 *
 *************************/

23.8095, 76.1905, 23.8095, 80.9524, 28.5714, 90.4762, 33.3333, 95.2381, 42.8571, 100.0000, 61.9047, 100.0000, 71.4285, 95.2381, 76.1905, 90.4762, 80.9524, 80.9524, 80.9524, 71.4286, 76.1905, 61.9048, 71.4285, 57.1429, 52.3809, 47.6190, 52.3809, 33.3333, GAMGI_IO_STROKE,

52.3809, 9.5238, 47.6190, 4.7619, 52.3809, 0.0000, 57.1428, 4.7619, 52.3809, 9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 64 @ strokes: 2 *
 *************************/

64.2857, 52.3810, 54.7619, 57.1429, 45.2381, 57.1429, 40.4762, 47.6190, 40.4762, 42.8571, 45.2381, 33.3333, 54.7619, 33.3333, 64.2857, 38.0952, GAMGI_IO_STROKE,

64.2857, 57.1429, 64.2857, 38.0952, 69.0476, 33.3333, 78.5714, 33.3333, 83.3334, 42.8571, 83.3334, 47.6190, 78.5714, 61.9048, 69.0476, 71.4286, 54.7619, 76.1905, 50.0000, 76.1905, 35.7143, 71.4286, 26.1905, 61.9048, 21.4286, 47.6190, 21.4286, 42.8571, 26.1905, 28.5714, 35.7143, 19.0476, 50.0000, 14.2857, 54.7619, 14.2857, 69.0476, 19.0476, GAMGI_IO_CHAR,

/*************************
 * char: 65 A strokes: 3 *
 *************************/

52.3809, 100.0000, 14.2857, 0.0000, GAMGI_IO_STROKE,

52.3809, 100.0000, 90.4762, 0.0000, GAMGI_IO_STROKE,

28.5714, 33.3333, 76.1905, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 66 B strokes: 3 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 61.9047, 100.0000, 76.1905, 95.2381, 80.9524, 90.4762, 85.7143, 80.9524, 85.7143, 71.4286, 80.9524, 61.9048, 76.1905, 57.1429, 61.9047, 52.3810, GAMGI_IO_STROKE,

19.0476, 52.3810, 61.9047, 52.3810, 76.1905, 47.6190, 80.9524, 42.8571, 85.7143, 33.3333, 85.7143, 19.0476, 80.9524, 9.5238, 76.1905, 4.7619, 61.9047, 0.0000, 19.0476, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 67 C strokes: 1 *
 *************************/

88.0952, 76.1905, 83.3334, 85.7143, 73.8096, 95.2381, 64.2857, 100.0000, 45.2381, 100.0000, 35.7143, 95.2381, 26.1905, 85.7143, 21.4286, 76.1905, 16.6667, 61.9048, 16.6667, 38.0952, 21.4286, 23.8095, 26.1905, 14.2857, 35.7143, 4.7619, 45.2381, 0.0000, 64.2857, 0.0000, 73.8096, 4.7619, 83.3334, 14.2857, 88.0952, 23.8095, GAMGI_IO_CHAR,

/*************************
 * char: 68 D strokes: 2 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 52.3809, 100.0000, 66.6666, 95.2381, 76.1905, 85.7143, 80.9524, 76.1905, 85.7143, 61.9048, 85.7143, 38.0952, 80.9524, 23.8095, 76.1905, 14.2857, 66.6666, 4.7619, 52.3809, 0.0000, 19.0476, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 69 E strokes: 4 *
 *************************/

21.4286, 100.0000, 21.4286, 0.0000, GAMGI_IO_STROKE,

21.4286, 100.0000, 83.3334, 100.0000, GAMGI_IO_STROKE,

21.4286, 52.3810, 59.5238, 52.3810, GAMGI_IO_STROKE,

21.4286, 0.0000, 83.3334, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 70 F strokes: 3 *
 *************************/

21.4286, 100.0000, 21.4286, 0.0000, GAMGI_IO_STROKE,

21.4286, 100.0000, 83.3334, 100.0000, GAMGI_IO_STROKE,

21.4286, 52.3810, 59.5238, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 71 G strokes: 2 *
 *************************/

88.0952, 76.1905, 83.3334, 85.7143, 73.8096, 95.2381, 64.2857, 100.0000, 45.2381, 100.0000, 35.7143, 95.2381, 26.1905, 85.7143, 21.4286, 76.1905, 16.6667, 61.9048, 16.6667, 38.0952, 21.4286, 23.8095, 26.1905, 14.2857, 35.7143, 4.7619, 45.2381, 0.0000, 64.2857, 0.0000, 73.8096, 4.7619, 83.3334, 14.2857, 88.0952, 23.8095, 88.0952, 38.0952, GAMGI_IO_STROKE,

64.2857, 38.0952, 88.0952, 38.0952, GAMGI_IO_CHAR,

/*************************
 * char: 72 H strokes: 3 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

85.7143, 100.0000, 85.7143, 0.0000, GAMGI_IO_STROKE,

19.0476, 52.3810, 85.7143, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 73 I strokes: 1 *
 *************************/

52.3810, 100.0000, 52.3810, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 74 J strokes: 1 *
 *************************/

76.1905, 100.0000, 76.1905, 23.8095, 71.4286, 9.5238, 66.6667, 4.7619, 57.1429, 0.0000, 47.6191, 0.0000, 38.0953, 4.7619, 33.3334, 9.5238, 28.5715, 23.8095, 28.5715, 33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 75 K strokes: 3 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

85.7143, 100.0000, 19.0476, 33.3333, GAMGI_IO_STROKE,

42.8571, 57.1429, 85.7143, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 76 L strokes: 2 *
 *************************/

23.8095, 100.0000, 23.8095, 0.0000, GAMGI_IO_STROKE,

23.8095, 0.0000, 80.9524, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 77 M strokes: 4 *
 *************************/

14.2857, 100.0000, 14.2857, 0.0000, GAMGI_IO_STROKE,

14.2857, 100.0000, 52.3809, 0.0000, GAMGI_IO_STROKE,

90.4762, 100.0000, 52.3809, 0.0000, GAMGI_IO_STROKE,

90.4762, 100.0000, 90.4762, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 78 N strokes: 3 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 85.7143, 0.0000, GAMGI_IO_STROKE,

85.7143, 100.0000, 85.7143, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 79 O strokes: 1 *
 *************************/

42.8571, 100.0000, 33.3333, 95.2381, 23.8095, 85.7143, 19.0476, 76.1905, 14.2857, 61.9048, 14.2857, 38.0952, 19.0476, 23.8095, 23.8095, 14.2857, 33.3333, 4.7619, 42.8571, 0.0000, 61.9047, 0.0000, 71.4286, 4.7619, 80.9524, 14.2857, 85.7143, 23.8095, 90.4762, 38.0952, 90.4762, 61.9048, 85.7143, 76.1905, 80.9524, 85.7143, 71.4286, 95.2381, 61.9047, 100.0000, 42.8571, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 80 P strokes: 2 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 61.9047, 100.0000, 76.1905, 95.2381, 80.9524, 90.4762, 85.7143, 80.9524, 85.7143, 66.6667, 80.9524, 57.1429, 76.1905, 52.3810, 61.9047, 47.6190, 19.0476, 47.6190, GAMGI_IO_CHAR,

/*************************
 * char: 81 Q strokes: 2 *
 *************************/

42.8571, 100.0000, 33.3333, 95.2381, 23.8095, 85.7143, 19.0476, 76.1905, 14.2857, 61.9048, 14.2857, 38.0952, 19.0476, 23.8095, 23.8095, 14.2857, 33.3333, 4.7619, 42.8571, 0.0000, 61.9047, 0.0000, 71.4286, 4.7619, 80.9524, 14.2857, 85.7143, 23.8095, 90.4762, 38.0952, 90.4762, 61.9048, 85.7143, 76.1905, 80.9524, 85.7143, 71.4286, 95.2381, 61.9047, 100.0000, 42.8571, 100.0000, GAMGI_IO_STROKE,

57.1428, 19.0476, 85.7143, -9.5238, GAMGI_IO_CHAR,

/*************************
 * char: 82 R strokes: 3 *
 *************************/

19.0476, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 61.9047, 100.0000, 76.1905, 95.2381, 80.9524, 90.4762, 85.7143, 80.9524, 85.7143, 71.4286, 80.9524, 61.9048, 76.1905, 57.1429, 61.9047, 52.3810, 19.0476, 52.3810, GAMGI_IO_STROKE,

52.3809, 52.3810, 85.7143, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 83 S strokes: 1 *
 *************************/

85.7143, 85.7143, 76.1905, 95.2381, 61.9047, 100.0000, 42.8571, 100.0000, 28.5714, 95.2381, 19.0476, 85.7143, 19.0476, 76.1905, 23.8095, 66.6667, 28.5714, 61.9048, 38.0952, 57.1429, 66.6666, 47.6190, 76.1905, 42.8571, 80.9524, 38.0952, 85.7143, 28.5714, 85.7143, 14.2857, 76.1905, 4.7619, 61.9047, 0.0000, 42.8571, 0.0000, 28.5714, 4.7619, 19.0476, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 84 T strokes: 2 *
 *************************/

52.3809, 100.0000, 52.3809, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 85.7143, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 85 U strokes: 1 *
 *************************/

19.0476, 100.0000, 19.0476, 28.5714, 23.8095, 14.2857, 33.3333, 4.7619, 47.6190, 0.0000, 57.1428, 0.0000, 71.4286, 4.7619, 80.9524, 14.2857, 85.7143, 28.5714, 85.7143, 100.0000, GAMGI_IO_CHAR,

/*************************
 * char: 86 V strokes: 2 *
 *************************/

14.2857, 100.0000, 52.3809, 0.0000, GAMGI_IO_STROKE,

90.4762, 100.0000, 52.3809, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 87 W strokes: 4 *
 *************************/

4.7619, 100.0000, 28.5714, 0.0000, GAMGI_IO_STROKE,

52.3809, 100.0000, 28.5714, 0.0000, GAMGI_IO_STROKE,

52.3809, 100.0000, 76.1905, 0.0000, GAMGI_IO_STROKE,

100.0000, 100.0000, 76.1905, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 88 X strokes: 2 *
 *************************/

19.0476, 100.0000, 85.7143, 0.0000, GAMGI_IO_STROKE,

85.7143, 100.0000, 19.0476, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 89 Y strokes: 2 *
 *************************/

14.2857, 100.0000, 52.3809, 52.3810, 52.3809, 0.0000, GAMGI_IO_STROKE,

90.4762, 100.0000, 52.3809, 52.3810, GAMGI_IO_CHAR,

/*************************
 * char: 90 Z strokes: 3 *
 *************************/

85.7143, 100.0000, 19.0476, 0.0000, GAMGI_IO_STROKE,

19.0476, 100.0000, 85.7143, 100.0000, GAMGI_IO_STROKE,

19.0476, 0.0000, 85.7143, 0.0000, GAMGI_IO_CHAR,

/*************************
 * char: 91 [ strokes: 4 *
 *************************/

35.7143, 119.0476, 35.7143, -33.3333, GAMGI_IO_STROKE,

40.4762, 119.0476, 40.4762, -33.3333, GAMGI_IO_STROKE,

35.7143, 119.0476, 69.0476, 119.0476, GAMGI_IO_STROKE,

35.7143, -33.3333, 69.0476, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 92 \ strokes: 1 *
 *************************/

19.0476, 100.0000, 85.7143, -14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 93 ] strokes: 4 *
 *************************/

64.2857, 119.0476, 64.2857, -33.3333, GAMGI_IO_STROKE,

69.0476, 119.0476, 69.0476, -33.3333, GAMGI_IO_STROKE,

35.7143, 119.0476, 69.0476, 119.0476, GAMGI_IO_STROKE,

35.7143, -33.3333, 69.0476, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 94 ^ strokes: 2 *
 *************************/

52.3809, 109.5238, 14.2857, 42.8571, GAMGI_IO_STROKE,

52.3809, 109.5238, 90.4762, 42.8571, GAMGI_IO_CHAR,

/*************************
 * char: 95 _ strokes: 1 *
 *************************/

0.0000, -33.3333, 104.7620, -33.3333, 104.7620, -28.5714, 0.0000, -28.5714, 0.0000, -33.3333, GAMGI_IO_CHAR,

/*************************
 * char: 96 ` strokes: 2 *
 *************************/

42.8572, 100.0000, 66.6667, 71.4286, GAMGI_IO_STROKE,

42.8572, 100.0000, 38.0953, 95.2381, 66.6667, 71.4286, GAMGI_IO_CHAR,

/*************************
 * char: 97 a strokes: 2 *
 *************************/

80.9524, 66.6667, 80.9524, 0.0000, GAMGI_IO_STROKE,

80.9524, 52.3810, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 98 b strokes: 2 *
 *************************/

23.8095, 100.0000, 23.8095, 0.0000, GAMGI_IO_STROKE,

23.8095, 52.3810, 33.3333, 61.9048, 42.8571, 66.6667, 57.1428, 66.6667, 66.6666, 61.9048, 76.1905, 52.3810, 80.9524, 38.0952, 80.9524, 28.5714, 76.1905, 14.2857, 66.6666, 4.7619, 57.1428, 0.0000, 42.8571, 0.0000, 33.3333, 4.7619, 23.8095, 14.2857, GAMGI_IO_CHAR,

/*************************
 * char: 99 c strokes: 1 *
 *************************/

80.9524, 52.3810, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 100 d strokes: 2 *
 **************************/

80.9524, 100.0000, 80.9524, 0.0000, GAMGI_IO_STROKE,

80.9524, 52.3810, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 101 e strokes: 1 *
 **************************/

23.8095, 38.0952, 80.9524, 38.0952, 80.9524, 47.6190, 76.1905, 57.1429, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 102 f strokes: 2 *
 **************************/

71.4286, 100.0000, 61.9048, 100.0000, 52.3810, 95.2381, 47.6191, 80.9524, 47.6191, 0.0000, GAMGI_IO_STROKE,

33.3334, 66.6667, 66.6667, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 103 g strokes: 2 *
 **************************/

80.9524, 66.6667, 80.9524, -9.5238, 76.1905, -23.8095, 71.4285, -28.5714, 61.9047, -33.3333, 47.6190, -33.3333, 38.0952, -28.5714, GAMGI_IO_STROKE,

80.9524, 52.3810, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 104 h strokes: 2 *
 **************************/

26.1905, 100.0000, 26.1905, 0.0000, GAMGI_IO_STROKE,

26.1905, 47.6190, 40.4762, 61.9048, 50.0000, 66.6667, 64.2857, 66.6667, 73.8095, 61.9048, 78.5715, 47.6190, 78.5715, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 105 i strokes: 2 *
 **************************/

47.6191, 100.0000, 52.3810, 95.2381, 57.1429, 100.0000, 52.3810, 104.7620, 47.6191, 100.0000, GAMGI_IO_STROKE,

52.3810, 66.6667, 52.3810, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 106 j strokes: 2 *
 **************************/

57.1429, 100.0000, 61.9048, 95.2381, 66.6667, 100.0000, 61.9048, 104.7619, 57.1429, 100.0000, GAMGI_IO_STROKE,

61.9048, 66.6667, 61.9048, -14.2857, 57.1429, -28.5714, 47.6191, -33.3333, 38.0953, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 107 k strokes: 3 *
 **************************/

26.1905, 100.0000, 26.1905, 0.0000, GAMGI_IO_STROKE,

73.8095, 66.6667, 26.1905, 19.0476, GAMGI_IO_STROKE,

45.2381, 38.0952, 78.5715, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 108 l strokes: 1 *
 **************************/

52.3810, 100.0000, 52.3810, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 109 m strokes: 3 *
 **************************/

0.0000, 66.6667, 0.0000, 0.0000, GAMGI_IO_STROKE,

0.0000, 47.6190, 14.2857, 61.9048, 23.8095, 66.6667, 38.0952, 66.6667, 47.6190, 61.9048, 52.3810, 47.6190, 52.3810, 0.0000, GAMGI_IO_STROKE,

52.3810, 47.6190, 66.6667, 61.9048, 76.1905, 66.6667, 90.4762, 66.6667, 100.0000, 61.9048, 104.7620, 47.6190, 104.7620, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 110 n strokes: 2 *
 **************************/

26.1905, 66.6667, 26.1905, 0.0000, GAMGI_IO_STROKE,

26.1905, 47.6190, 40.4762, 61.9048, 50.0000, 66.6667, 64.2857, 66.6667, 73.8095, 61.9048, 78.5715, 47.6190, 78.5715, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 111 o strokes: 1 *
 **************************/

45.2381, 66.6667, 35.7143, 61.9048, 26.1905, 52.3810, 21.4286, 38.0952, 21.4286, 28.5714, 26.1905, 14.2857, 35.7143, 4.7619, 45.2381, 0.0000, 59.5238, 0.0000, 69.0476, 4.7619, 78.5714, 14.2857, 83.3334, 28.5714, 83.3334, 38.0952, 78.5714, 52.3810, 69.0476, 61.9048, 59.5238, 66.6667, 45.2381, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 112 p strokes: 2 *
 **************************/

23.8095, 66.6667, 23.8095, -33.3333, GAMGI_IO_STROKE,

23.8095, 52.3810, 33.3333, 61.9048, 42.8571, 66.6667, 57.1428, 66.6667, 66.6666, 61.9048, 76.1905, 52.3810, 80.9524, 38.0952, 80.9524, 28.5714, 76.1905, 14.2857, 66.6666, 4.7619, 57.1428, 0.0000, 42.8571, 0.0000, 33.3333, 4.7619, 23.8095, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 113 q strokes: 2 *
 **************************/

80.9524, 66.6667, 80.9524, -33.3333, GAMGI_IO_STROKE,

80.9524, 52.3810, 71.4285, 61.9048, 61.9047, 66.6667, 47.6190, 66.6667, 38.0952, 61.9048, 28.5714, 52.3810, 23.8095, 38.0952, 23.8095, 28.5714, 28.5714, 14.2857, 38.0952, 4.7619, 47.6190, 0.0000, 61.9047, 0.0000, 71.4285, 4.7619, 80.9524, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 114 r strokes: 2 *
 **************************/

33.3334, 66.6667, 33.3334, 0.0000, GAMGI_IO_STROKE,

33.3334, 38.0952, 38.0953, 52.3810, 47.6191, 61.9048, 57.1429, 66.6667, 71.4286, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 115 s strokes: 1 *
 **************************/

78.5715, 52.3810, 73.8095, 61.9048, 59.5238, 66.6667, 45.2381, 66.6667, 30.9524, 61.9048, 26.1905, 52.3810, 30.9524, 42.8571, 40.4762, 38.0952, 64.2857, 33.3333, 73.8095, 28.5714, 78.5715, 19.0476, 78.5715, 14.2857, 73.8095, 4.7619, 59.5238, 0.0000, 45.2381, 0.0000, 30.9524, 4.7619, 26.1905, 14.2857, GAMGI_IO_CHAR,

/**************************
 * char: 116 t strokes: 2 *
 **************************/

47.6191, 100.0000, 47.6191, 19.0476, 52.3810, 4.7619, 61.9048, 0.0000, 71.4286, 0.0000, GAMGI_IO_STROKE,

33.3334, 66.6667, 66.6667, 66.6667, GAMGI_IO_CHAR,

/**************************
 * char: 117 u strokes: 2 *
 **************************/

26.1905, 66.6667, 26.1905, 19.0476, 30.9524, 4.7619, 40.4762, 0.0000, 54.7619, 0.0000, 64.2857, 4.7619, 78.5715, 19.0476, GAMGI_IO_STROKE,

78.5715, 66.6667, 78.5715, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 118 v strokes: 2 *
 **************************/

23.8095, 66.6667, 52.3809, 0.0000, GAMGI_IO_STROKE,

80.9524, 66.6667, 52.3809, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 119 w strokes: 4 *
 **************************/

14.2857, 66.6667, 33.3333, 0.0000, GAMGI_IO_STROKE,

52.3809, 66.6667, 33.3333, 0.0000, GAMGI_IO_STROKE,

52.3809, 66.6667, 71.4286, 0.0000, GAMGI_IO_STROKE,

90.4762, 66.6667, 71.4286, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 120 x strokes: 2 *
 **************************/

26.1905, 66.6667, 78.5715, 0.0000, GAMGI_IO_STROKE,

78.5715, 66.6667, 26.1905, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 121 y strokes: 2 *
 **************************/

26.1905, 66.6667, 54.7619, 0.0000, GAMGI_IO_STROKE,

83.3334, 66.6667, 54.7619, 0.0000, 45.2381, -19.0476, 35.7143, -28.5714, 26.1905, -33.3333, 21.4286, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 122 z strokes: 3 *
 **************************/

78.5715, 66.6667, 26.1905, 0.0000, GAMGI_IO_STROKE,

26.1905, 66.6667, 78.5715, 66.6667, GAMGI_IO_STROKE,

26.1905, 0.0000, 78.5715, 0.0000, GAMGI_IO_CHAR,

/**************************
 * char: 123 { strokes: 3 *
 **************************/

64.2857, 119.0476, 54.7619, 114.2857, 50.0000, 109.5238, 45.2381, 100.0000, 45.2381, 90.4762, 50.0000, 80.9524, 54.7619, 76.1905, 59.5238, 66.6667, 59.5238, 57.1429, 50.0000, 47.6190, GAMGI_IO_STROKE,

54.7619, 114.2857, 50.0000, 104.7619, 50.0000, 95.2381, 54.7619, 85.7143, 59.5238, 80.9524, 64.2857, 71.4286, 64.2857, 61.9048, 59.5238, 52.3810, 40.4762, 42.8571, 59.5238, 33.3333, 64.2857, 23.8095, 64.2857, 14.2857, 59.5238, 4.7619, 54.7619, 0.0000, 50.0000, -9.5238, 50.0000, -19.0476, 54.7619, -28.5714, GAMGI_IO_STROKE,

50.0000, 38.0952, 59.5238, 28.5714, 59.5238, 19.0476, 54.7619, 9.5238, 50.0000, 4.7619, 45.2381, -4.7619, 45.2381, -14.2857, 50.0000, -23.8095, 54.7619, -28.5714, 64.2857, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 124 | strokes: 1 *
 **************************/

52.3810, 119.0476, 52.3810, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 125 } strokes: 3 *
 **************************/

40.4762, 119.0476, 50.0000, 114.2857, 54.7619, 109.5238, 59.5238, 100.0000, 59.5238, 90.4762, 54.7619, 80.9524, 50.0000, 76.1905, 45.2381, 66.6667, 45.2381, 57.1429, 54.7619, 47.6190, GAMGI_IO_STROKE,

50.0000, 114.2857, 54.7619, 104.7619, 54.7619, 95.2381, 50.0000, 85.7143, 45.2381, 80.9524, 40.4762, 71.4286, 40.4762, 61.9048, 45.2381, 52.3810, 64.2857, 42.8571, 45.2381, 33.3333, 40.4762, 23.8095, 40.4762, 14.2857, 45.2381, 4.7619, 50.0000, 0.0000, 54.7619, -9.5238, 54.7619, -19.0476, 50.0000, -28.5714, GAMGI_IO_STROKE,

54.7619, 38.0952, 45.2381, 28.5714, 45.2381, 19.0476, 50.0000, 9.5238, 54.7619, 4.7619, 59.5238, -4.7619, 59.5238, -14.2857, 54.7619, -23.8095, 50.0000, -28.5714, 40.4762, -33.3333, GAMGI_IO_CHAR,

/**************************
 * char: 126 ~ strokes: 2 *
 **************************/

9.5238, 28.5714, 9.5238, 38.0952, 14.2857, 52.3810, 23.8095, 57.1429, 33.3333, 57.1429, 42.8571, 52.3810, 61.9048, 38.0952, 71.4286, 33.3333, 80.9524, 33.3333, 90.4762, 38.0952, 95.2381, 47.6190, GAMGI_IO_STROKE,

9.5238, 38.0952, 14.2857, 47.6190, 23.8095, 52.3810, 33.3333, 52.3810, 42.8571, 47.6190, 61.9048, 33.3333, 71.4286, 28.5714, 80.9524, 28.5714, 90.4762, 33.3333, 95.2381, 47.6190, 95.2381, 57.1429, GAMGI_IO_CHAR,

};

/***********
 * drivers *
 ***********/

const int gamgi_io_font_sun_roman_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 114, 124, 144, 195, 256, 325, 330, 
351, 372, 387, 397, 414, 419, 430, 435, 470, 479, 
508, 539, 551, 586, 633, 643, 702, 749, 771, 799, 
806, 816, 823, 863, 919, 934, 979, 1016, 1046, 1066, 
1081, 1125, 1140, 1145, 1166, 1181, 1191, 1211, 1226, 1269, 
1295, 1343, 1374, 1415, 1425, 1446, 1456, 1476, 1486, 1498, 
1513, 1533, 1538, 1558, 1568, 1579, 1591, 1625, 1659, 1688, 
1722, 1757, 1773, 1817, 1837, 1853, 1875, 1890, 1895, 1930, 
1950, 1985, 2019, 2053, 2069, 2104, 2120, 2140, 2150, 2170, 
2180, 2198, 2213, 2290, 2295, 2372,
};

const int gamgi_io_font_sun_roman_mono_driver[GAMGI_IO_ASCII_RANGE] = {
97, 98, 114, 124, 144, 195, 256, 325, 330, 
351, 372, 387, 397, 414, 419, 430, 435, 470, 479, 
508, 539, 551, 586, 633, 643, 702, 749, 771, 799, 
806, 816, 823, 863, 919, 934, 979, 1016, 1046, 1066, 
1081, 1125, 1140, 1145, 1166, 1181, 1191, 1211, 1226, 1269, 
1295, 1343, 1374, 1415, 1425, 1446, 1456, 1476, 1486, 1498, 
1513, 1533, 1538, 1558, 1568, 1579, 1591, 1625, 1659, 1688, 
1722, 1757, 1773, 1817, 1837, 1853, 1875, 1890, 1895, 1930, 
1950, 1985, 2019, 2053, 2069, 2104, 2120, 2140, 2150, 2170, 
2180, 2198, 2213, 2290, 2295, 2372, 
};
