#A  BOUNDS FOR q = 3
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the
##  second upperbounds) for a code with wordlength n and
##  dimension k. Each entry contains one of the following
##  items:
##
##  FOR LOWER- AND UPPERBOUNDSTABLE
##  [ 0, <d>, <ref> ]  from Brouwers table
##
##  FOR LOWERBOUNDSTABLE
##  empty           k= 0, 1, n or d= 2 or (k= 2 and q= 2)
##  1               shortening a [ n + 1, k + 1 ] code
##  2               puncturing a [ n + 1, k ] code
##  3               extending a [ n - 1, k ] code
##  [ 4, <dd> ]     constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]     an UUV-construction with a [ n / 2, k1 ]
##                  and a [ n / 2, k - k1 ] code
##  [ 6, <n1> ]     concatenation of a [ n1, k ] and a
##                  [ n - n1, k ] code
##  [ 7, <n1> ]     taking the residue of a [ n1, k + 1 ] code
##  20              taking the subcode of a [ n, k + 1 ] code
##  [21,<s>,<j>]    constr. B2 of a [ n+s, k+s-2j-1, d+2j] code
##  [22,<k1>,<k2>]  an UUAVUVW-construction with a [ n/3, k1 ],
##                  a [ n/3, k2 ] and a [ n/3, k-(k1+k2) ] code
##
##  FOR UPPERBOUNDSTABLE
##  empty        trivial and Singleton bound
##  11           shortening a [ n + 1, k + 1 ] code
##  12           puncturing a [ n + 1, k ] code
##  13           extending a [ n - 1, k ] code
##  [ 14, <dd> ] constr. B, with dd = dual distance
##  [ 15, <d> ]  Griesmer bound
##  [ 16, <d> ]  One-step Griesmer bound


GUAVA_BOUNDS_TABLE[1][3] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ , [7, 11]],
#V   n = 5
[ , 1, 20],
#V   n = 6
[ , 1, 1, 20],
#V   n = 7
[ , 1, 1, 1, 20],
#V   n = 8
[ , 1, 1, 1, 1, 20],
#V   n = 9
[ , 20, 1, 1, 1, 1, 20],
#V   n = 10
[ , 1, 20, 1, 1, 2, 1, 20],
#V   n = 11
[ , 1, 2, 20, 1, 2, 20, 1, 20],
#V   n = 12
[ , 1, 2, 20, 20, [0, 6, "QR"], 1, 20, 1, 20],
#V   n = 13
[ , 20, [7, 38], 1, 20, 1, 1, 1, 20, [4, 24], 20],
#V   n = 14
[ , 2, 1, 1, 1, 20, [0, 6, "QR"], [0, 5, "NBC"], 1, 1, 20, 20],
#V   n = 15
[ , 2, 20, 1, 2, [0, 7, "Li1"], 1, 1, 20, 1, 1, 20, 20],
#V   n = 16
[ , [6, 4], 1, 20, [0, 9, "HN"], 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 17
[ , 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 18
[ , 2, 1, 1, 2, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 19
[ , 2, 20, 1, 2, 20, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20],
#V   n = 20
[ , [6, 4], 2, 20, [7, 54], 1, 20, 1, 1, 1, 20, 1, 1, 20, [5, 9], 1, 20, 20],
#V   n = 21
[ , 1, 2, 20, 1, 1, 2, 20, 1, 1, 1, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 22
[ , 2, [6, 9], 1, 20, 1, 2, 20, 20, 1, 1, 2, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 23
[ , 2, 1, 1, 1, 20, [0, 12, "Bou"], 1, 20, 20, 1, 2, 20, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 24
[ , [6, 4], 1, 1, 1, 1, 1, 2, 1, 20, 20, [0, 9, "QR"], 1, 20, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 25
[ , 1, 1, 2, 1, 1, 1, 2, 20, [0, 10, "BE3"], 20, 3, 20, 1, 20, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 26
[ , 2, 1, 2, 20, 1, 1, 2, 1, 1, 20, 1, 1, 20, 1, 20, 20, 1, 1, 1, 20, 1, 20, 20],
#V   n = 27
[ , 2, 20, [22, 3, 1], 2, 20, 1, 2, 1, 1, 1, 20, 1, 1, 20, [0, 7, "EB3"], 20, 20, 1, 2, 1, 20, 1, 20, 20],
#V   n = 28
[ , [6, 4], 20, 1, 2, 20, 20, [0, 15, "NBC"], 20, 1, 1, 1, 20, [0, 9, "KP"], 1, 1, 20, 20, 20, [0, 6, "KP"], 20, 1, 20, 1, 20, 20],
#V   n = 29
[ , 2, 1, 20, [0, 18, "vE0"], 1, 20, 3, 1, 20, 1, 1, 1, 1, 20, [0, 8, "EB3"], 1, 20, 20, 3, 1, 20, 1, 20, 1, 20, 20],
#V   n = 30
[ , 2, 1, 2, 1, 1, 2, 1, 2, [0, 13, "GuB"], 20, 1, 1, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 31
[ , 2, 1, 2, 20, [7, 83], [0, 17, "XX"], 20, [0, 15, "DaH"], 2, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 32
[ , [6, 4], 20, [0, 21, "Bel"], 2, 1, 1, 2, 1, 2, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 33
[ , 2, 1, 1, 2, 20, 1, 2, 20, [0, 15, "GB4"], 1, 20, 20, 20, 1, 1, 1, 2, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 34
[ , 2, 1, 2, [0, 21, "vE0"], 1, 20, [0, 18, "DaH"], 2, 1, 1, 1, 20, 20, 20, 1, 1, 2, 20, 1, 20, [0, 7, "EB3"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 35
[ , 2, 1, 2, 1, 2, [0, 19, "KP"], 1, 2, 20, 1, 1, 1, 20, 20, 20, 1, 2, 1, 20, [0, 8, "EB3"], 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 36
[ , [6, 4], 20, [22, 3, 1], 2, [0, 21, "BZ"], 2, 20, [0, 18, "KP"], 1, 20, 1, 1, 1, 20, 20, 20, [0, 12, "Ple"], 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 37
[ , 2, 1, 1, 2, 2, [0, 20, "Bo1"], 20, 1, 1, 1, 20, 1, 1, 1, 20, 20, 3, 1, 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 38
[ , 2, 1, 2, [0, 24, "BB"], 2, 1, 1, 20, 1, 1, 2, 20, 1, 1, 1, 20, 1, 1, 2, 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 39
[ , 2, 1, 2, 1, 2, 1, 1, 1, 20, 1, 2, 20, 20, 1, 1, 1, 20, 1, 2, 20, 20, 1, 1, 20, 1, 20, 20, [0, 6, "B"], 20, 1, 20, 1, 20, 1, 20, 20],
#V   n = 40
[ , [6, 4], 20, [7, 119], 20, [7, 110], 1, 1, 2, [0, 19, "DaH"], 20, [0, 18, "KP"], 2, 20, 20, 1, 1, 1, 20, [0, 12, "Be"], 1, 20, 20, [0, 9, "KP"], 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, [4, 78], 20, 20],
#V   n = 41
[ , 2, 20, 3, 1, 1, 2, [0, 22, "KP"], [0, 21, "DaH"], 1, 20, 1, 2, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 3, 20, 1, 20, 1, 20, 1, 20, 20, [0, 5, "BCH"], 20, 1, 1, 20, 20, 20],
#V   n = 42
[ , 2, 2, 1, 1, 2, [0, 24, "X"], 1, 1, 1, 2, 20, [0, 18, "B"], 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 20, 20, 1, 20, [0, 7, "EB3"], 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 43
[ , 2, 2, 20, 1, 2, 1, 1, 2, 1, 2, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 2, [0, 9, "Vx"], 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 44
[ , [6, 4], [6, 9], 1, 20, [0, 27, "Bo1"], 20, 1, 2, 20, [0, 21, "DaH"], 2, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 2, 1, 20, 20, 20, [0, 8, "BE3"], 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 45
[ , 2, 1, 1, 2, 3, 2, 20, [0, 24, "KP"], 20, 1, 2, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 2, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 46
[ , 2, 2, 1, 2, 2, [0, 26, "BKW"], 20, 3, 2, 20, [0, 21, "DaH"], 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 2, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 47
[ , 2, 2, 20, [0, 30, "vE1"], 2, 1, 2, 1, 2, 20, 3, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 2, 1, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 48
[ , [6, 4], [6, 9], 1, 1, 2, 1, 2, 20, [0, 24, "DaH"], [0, 22, "GB4"], 1, 1, 2, 20, 20, 20, 1, 1, 1, 20, 20, 20, [0, 15, "QR"], 1, 2, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 49
[ , 2, 1, 2, [0, 31, "BB"], [0, 30, "Gu1"], [0, 28, "GuB"], [0, 27, "DaH"], 1, 2, 1, 20, [0, 21, "DaH"], [0, 20, "DaH"], 20, 20, 20, 20, 1, 1, 1, 20, 20, 3, 1, 2, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 50
[ , 2, 2, [6, 10], 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 1, 2, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 51
[ , 2, 2, 1, 1, 2, 2, 20, 1, 2, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 2, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 52
[ , [6, 4], [4, 2], 1, 1, 2, [0, 30, "CG"], 2, 20, [0, 27, "DaH"], 20, 1, 1, 2, 1, 1, 2, 20, 20, 20, 20, 1, 1, 1, 20, [0, 15, "GaO"], 1, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 53
[ , 2, 1, 1, 1, 2, 1, 2, 20, 3, 1, 20, 1, 2, 20, [0, 21, "DaH"], [0, 20, "DaH"], 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, [0, 7, "EB3"], 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 54
[ , 2, 20, 1, 1, 2, 2, [0, 30, "GB4"], [0, 28, "GB1"], 1, 1, 2, 20, [0, 24, "DaH"], 20, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 55
[ , 2, 2, 20, 1, 2, 2, 2, 1, 20, 1, 2, 20, 3, 1, 20, 1, 1, 1, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20],
#V   n = 56
[ , [6, 4], 2, 20, 20, [0, 36, "Gu"], [0, 33, "GB4"], [0, 31, "Gu2"], 1, 2, 20, [0, 27, "ARS"], 20, 1, 1, 2, 20, [0, 21, "DaH"], 1, 2, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 20, [0, 4, "Hi1"], 1, 20, 20, 20],
#V   n = 57
[ , 2, [6, 9], 2, 20, 3, 2, 3, 1, 2, 20, 3, 1, 20, [0, 24, "DaH"], [0, 23, "DaH"], 20, 3, 20, [0, 20, "DaH"], 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 58
[ , 2, 1, 2, 20, 3, 2, 1, 20, [0, 30, "XX"], 2, 1, 1, 2, 1, 2, 20, 1, 20, 3, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 1, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 59
[ , 2, 2, [6, 19], 2, 1, 2, 1, 1, 1, 2, 20, 1, 2, 20, [0, 24, "GW2"], 2, 20, 1, 1, 2, 20, 20, 20, 20, 20, 20, 20, 1, 2, 1, 2, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 60
[ , [6, 4], 2, 1, 2, 20, [0, 36, "BKW"], 2, 1, 1, 2, 2, 20, [0, 27, "GW2"], 2, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, [0, 18, "QR"], 1, 2, 20, 1, 20, 20, 1, 20, 20, 1, 2, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 61
[ , 2, [4, 2], 2, [0, 39, "vE0"], 2, 3, 2, 20, 1, 2, 2, 20, 3, [0, 26, "DaH"], 20, [0, 24, "DaH"], 1, 20, 20, [0, 21, "DaH"], 20, 20, 20, 20, 20, 20, 20, 20, 3, 1, 2, 20, 20, 1, 20, 20, 1, 20, 20, [0, 10, "Glo"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 62
[ , 2, 1, 2, 1, 2, 1, 2, 2, 20, [0, 32, "DaH"], [0, 30, "DaH"], 20, 1, 1, 1, 1, 1, 1, 20, 3, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, [0, 13, "Vx"], 20, 20, 1, 20, 20, 1, 20, 3, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 63
[ , 2, 2, [22, 3, 1], 2, [0, 39, "Gu1"], 1, 2, 2, 20, 3, 2, 1, 20, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 2, 1, 20, 20, 20, 1, 20, 20, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 64
[ , [6, 4], 2, 1, 2, 1, 2, [0, 37, "BKW"], 2, 1, 1, 2, 1, 1, 20, 1, 2, 20, 1, 1, 2, 1, 1, 1, 20, 20, 20, 20, 20, 20, 20, [0, 18, "Be"], 1, 1, 20, 20, 20, [0, 12, "D1"], 20, 20, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 65
[ , 2, [6, 13], 2, [0, 42, "HN"], 2, [0, 39, "GO"], 3, [0, 36, "Gu"], 20, 1, 2, 1, 1, 1, 20, [0, 27, "DaH"], 20, 20, 1, 2, 20, 1, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 66
[ , 2, 1, 2, 1, 2, 3, 3, 3, 1, 20, [0, 33, "DaH"], 20, 1, 1, 2, 3, 2, 20, 20, [0, 24, "DaH"], 1, 20, 1, 1, 1, 20, 20, 20, 20, 20, 3, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 67
[ , 2, 20, [6, 27], 2, [0, 42, "Ha"], 2, 1, 1, 1, 2, 3, 20, 20, 1, 2, 1, 2, 20, 20, 3, 1, 2, 20, 1, 1, 1, 20, 20, 20, 20, 3, 1, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 1, 2, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 68
[ , [6, 4], 2, 1, 2, 3, 2, 1, 2, 1, 2, 2, 1, 20, 20, [0, 30, "ARS"], 20, [0, 27, "DaH"], 20, 20, 1, 20, [0, 23, "DaH"], 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, [0, 11, "Glo"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 69
[ , 2, 2, 20, [0, 45, "vEH"], 1, 2, 1, 2, 20, [0, 36, "Bou"], 2, 1, 1, 20, 3, 2, 3, 20, 20, 20, 1, 2, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 2, 20, 1, 1, 20, 20, 1, 20, 20, 3, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 70
[ , 2, [4, 2], 2, 3, 2, [0, 42, "Gu2"], 2, [0, 39, "GB4"], 20, 1, 2, 1, 1, 1, 1, 2, 3, 1, 20, 20, 20, [0, 24, "DaH"], 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 2, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 71
[ , 2, 1, 2, 1, 2, 1, 2, 2, 1, 20, [0, 36, "GW2"], 1, 1, 1, 2, [0, 30, "ASR"], 1, 1, 1, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 2, 2, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 72
[ , [6, 4], 2, [22, 3, 1], 2, [0, 45, "Gu1"], [0, 43, "GO"], [0, 42, "Gu2"], 2, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, [0, 18, "QR"], 2, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 73
[ , 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 2, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 74
[ , 2, [6, 9], 2, [0, 48, "BB"], 2, 2, 20, [0, 42, "B"], 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, [0, 18, "QR"], 2, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 75
[ , 2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, 1, 2, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 76
[ , [6, 4], 2, [6, 36], 2, [0, 48, "Bo3"], 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 20, 1, 1, 1, 1, 2, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 20, [0, 18, "GaO"], 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 77
[ , 2, 2, 1, 2, 1, 2, 1, 2, 20, 1, 1, 1, 1, 1, 2, 1, 2, 20, 20, 1, 1, 1, 2, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 78
[ , 2, [6, 13], 1, 2, 1, 2, 1, 2, 1, 20, 1, 1, 1, 1, 2, 1, 2, 20, 20, 20, 1, 1, 2, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 79
[ , 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 20, 1, 1, 1, 2, 1, 2, 1, 20, 20, 20, 1, 2, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 1, 2, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 80
[ , [6, 4], 20, 1, 2, 1, 2, 1, 2, 1, 2, 20, 20, 1, 1, 2, 20, [0, 36, "DaH"], 1, 2, 20, 20, 20, [0, 30, "DaH"], 2, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 1, 2, 20, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 1, 2, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 81
[ , 2, 2, 20, [22, 4, 1], 20, [0, 51, "XBC"], 20, [0, 48, "BE"], 20, [0, 45, "XBC"], 20, 20, 20, 1, 2, 20, 3, 2, [0, 32, "DaH"], 20, 20, 20, 3, [0, 26, "BZ"], 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 1, 2, 20, 20, 20, 1, 20, 20, 20, [0, 14, "XBC"], 20, 20, 20, 1, 20, [0, 11, "XBC"], 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 82
[ , 2, 2, 20, 3, 1, 2, 20, 3, 20, 3, 1, 20, 20, 20, [0, 42, "NBC"], 20, 3, 2, 2, 20, 20, 20, 3, 1, 1, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 2, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, [0, 8, "BE"], 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 83
[ , 2, [6, 9], 20, 1, 1, 2, 20, 3, 20, 1, 1, 1, 20, 20, 3, 20, 1, 2, 2, 1, 20, 20, 3, 2, 1, 2, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 2, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, [0, 12, "XX"], 1, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 84
[ , [6, 4], 2, 1, 20, 1, 2, 1, 2, 1, 20, 1, 1, 1, 20, 3, 20, 20, [0, 36, "DaH"], [0, 34, "DaH"], 1, 1, 20, 3, [0, 28, "BZ"], 20, [0, 26, "BZ"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 20, [0, 21, "GaO"], 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 20, 3, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 85
[ , 2, 2, 1, 2, 20, [0, 54, "XX"], 1, 2, 1, 2, 20, [0, 45, "BEx"], 1, 2, 3, 1, 20, 3, 2, 20, [0, 32, "DaH"], [0, 31, "DaH"], 3, 3, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 3, 1, 2, 1, 1, 20, 20, 20, [0, 15, "XX"], 20, 20, 1, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, [0, 9, "XX"], 20, 20, 20, 1, 20, [0, 7, "BE"], 20, 20, 20, [0, 6, "BE"], 20, 1, 20, 1, 20, 1, 20, 20, 20],
#V   n = 86
[ , 2, 2, 1, 2, 20, 3, 20, [0, 50, "BE"], 20, [0, 47, "XX"], 20, 1, 20, [0, 44, "XX"], 2, 1, 2, 1, 2, 1, 1, 2, 3, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 1, 1, 2, 20, [0, 17, "XX"], 1, 20, 20, 1, 20, 20, 20, [0, 14, "XX"], [0, 13, "XX"], 20, 1, 20, 20, [0, 11, "XX"], 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, [0, 5, "BE"], 20, 1, 20, 1, 20, 20, 20],
#V   n = 87
[ , 2, [6, 9], 20, [0, 57, "HHY"], 20, 3, 1, 2, 1, 2, 20, 20, 1, 1, 2, 20, [0, 38, "DaH"], 20, [0, 36, "DaH"], 1, 2, [0, 32, "DaH"], 3, 20, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 1, 2, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, [0, 12, "X6"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, [0, 8, "BE"], 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 88
[ , [6, 4], 2, 1, 2, 2, 3, 1, 2, 1, 2, 1, 20, 20, [0, 45, "XX"], [0, 44, "X6a"], 1, 2, 20, 1, 1, 2, 2, 2, 20, 20, [0, 28, "BZ"], 20, 20, [0, 26, "BZ"], [0, 25, "XX"], 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, [0, 21, "GaO"], 1, 1, 1, 20, [0, 16, "XX"], 20, 20, 1, 20, 20, 1, 2, 20, 1, 20, 20, 1, 20, [0, 10, "XX"], 20, 20, 1, 20, 20, 20, 3, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 89
[ , 2, 2, 1, 2, 2, 1, 1, 2, 1, 2, [0, 47, "BE3"], 1, 20, 1, 2, 1, 2, 1, 20, 1, 2, [0, 33, "DaH"], 2, 1, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 20, 20, [0, 15, "XX"], 20, 20, [0, 14, "X6u"], 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, [0, 9, "XX"], 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 90
[ , 2, 2, 1, 2, [0, 57, "X"], 2, 1, 2, 1, 2, 1, 20, [0, 46, "XX"], 20, [0, 45, "X6a"], 1, 2, 20, [0, 37, "DaH"], 20, [0, 36, "DaH"], 1, 2, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, [0, 17, "XX"], [0, 16, "X6"], 20, 20, 1, 20, 20, 1, 1, 20, 20, [0, 12, "X6"], 20, 20, [0, 11, "XX"], 1, 20, 20, 1, 20, 20, 20, [0, 8, "XX"], 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 91
[ , 2, [6, 13], 20, [0, 60, "XX"], 1, 2, 20, [0, 54, "dB"], 20, [0, 51, "XX"], [0, 48, "BE3"], 1, 1, 20, 3, 1, 2, [0, 38, "DaH"], 3, 20, 3, 20, [0, 33, "DaH"], 1, 1, 1, 20, 1, 2, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 92
[ , [6, 4], 3, 2, 3, 2, [0, 57, "X3a"], 20, 3, 20, 3, 1, 20, [0, 47, "XX"], [0, 46, "X6a"], 3, 20, [0, 42, "DaH"], 1, 2, 20, 3, 1, 1, 1, 1, 1, 1, 20, [0, 28, "BZ"], 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 20, 1, 1, 20, 20, 20, [0, 15, "X6u"], 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, [0, 10, "Ed2"], 20, 20, [0, 9, "X6u"], 20, 20, 1, 20, 20, 20, [0, 7, "EB3"], 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 93
[ , 2, 1, 2, 1, 2, 2, 20, 3, 20, 3, 2, 1, 1, 2, 3, 20, 3, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 20, 20, [0, 17, "X6u"], 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, [0, 12, "X6"], 20, 20, [0, 11, "X6u"], 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 94
[ , 2, 2, [6, 27], 2, [0, 60, "XX"], 2, 2, 3, 2, 1, 2, 20, [0, 48, "X"], [0, 47, "X6a"], 2, 20, 3, 1, 2, 20, 20, [0, 36, "DaH"], 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 20, 1, 20, [0, 16, "X6"], 20, 20, [0, 15, "X6u"], 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 95
[ , 2, 2, 1, 2, 1, 2, 2, 3, [7, 252], 20, [0, 51, "X6a"], 2, 1, 1, 2, 20, 3, 20, [0, 40, "DaH"], 1, 20, 3, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 20, 1, 2, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 1, 2, 1, 20, 20, 1, 1, 20, 20, 3, 20, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 20, [0, 6, "EB3"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 96
[ , [6, 4], [6, 9], 20, [22, 4, 1], 2, [0, 60, "X6a"], [0, 57, "GB1"], 1, 1, 2, 1, 2, 20, [0, 48, "X"], [0, 47, "X"], 2, 3, [0, 41, "DaH"], 3, 1, 2, 3, 20, 20, 20, 1, 1, 1, 1, 1, 1, 1, 2, 20, [0, 26, "BZ"], 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, [0, 24, "ACG"], 20, 1, 20, 20, [0, 17, "X6u"], 1, 20, 1, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 97
[ , 2, 2, 1, 1, 2, 2, 2, 2, [7, 257], [0, 53, "X6a"], 20, [0, 51, "X6a"], 20, 1, 2, 2, 1, 2, 3, [0, 39, "DaH"], [0, 38, "GW2"], 2, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 20, 1, 1, 1, 20, 20, [0, 11, "Ed2"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 98
[ , 2, 2, 1, 2, [0, 63, "Gu1"], 2, 2, 2, 1, 2, 20, 3, 1, 20, [0, 48, "X"], [0, 45, "DaH"], 2, [0, 42, "DaH"], 3, 3, 3, [0, 37, "GW2"], 20, 20, 20, 20, 20, 1, 1, 1, 1, 1, 2, 1, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 20, 3, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 99
[ , 2, 2, 1, 2, 1, 2, 2, [0, 57, "GB1"], 20, [0, 54, "X6a"], 20, 1, 1, 2, 3, 1, 2, 3, 3, 3, 3, 3, 2, 20, 20, 20, 20, 20, 1, 1, 1, 1, 2, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 20, 3, 20, [0, 19, "VE"], 20, 20, 1, 20, [0, 17, "X6u"], 20, 1, 20, [0, 15, "X6u"], 20, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 1, 20, 20, [0, 9, "XB"], 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 100
[ , [6, 4], [6, 9], 20, [0, 66, "Bel"], 20, [0, 63, "EB1"], [0, 60, "GO2"], 3, [0, 55, "Gu"], 3, 2, 20, 1, 2, 2, 20, [0, 45, "DaH"], 2, 3, 3, 3, 3, [0, 36, "BZ"], 20, 20, 20, 20, 20, 20, 1, 1, 1, 2, 2, [0, 28, "BZ"], 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 20, 3, 1, 1, 20, 20, 20, [0, 18, "D1"], 1, 20, 20, [0, 16, "BZ"], 1, 20, 20, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 101
[ , 2, 2, 1, 2, 1, 2, 3, 2, 2, 3, [0, 53, "X6a"], 20, 20, [0, 51, "XX"], 2, 1, 2, [0, 43, "GW2"], 1, 1, 1, 2, 1, 1, 20, 20, 20, 20, 20, 20, 1, 1, 2, 2, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 20, 3, 20, [0, 20, "VE"], 1, 20, 20, 1, 20, [0, 17, "Vx"], 20, 1, 20, 1, 20, 20, 20, 20, 20, 20, 1, 1, 2, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 102
[ , 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 2, 20, 1, 2, 1, 2, 3, 1, 1, 1, 2, 20, 1, 1, 20, 20, 20, 20, 20, 20, 1, 2, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 20, 20, 3, [0, 21, "VE"], 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 103
[ , 2, 2, 1, 2, 1, 2, 2, 2, [0, 57, "MTS"], 2, 1, 2, 20, 20, [0, 51, "X6a"], 1, 2, 1, 1, 1, 1, 2, 2, 20, 1, 2, 20, 20, 20, 20, 20, 20, [0, 34, "Glo"], 2, 2, 20, 1, 2, 20, 20, 1, 2, 20, 20, 20, 20, 3, 1, 20, 1, 20, [0, 19, "VE"], 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 20, 20, [0, 14, "Glo"], 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 20, [0, 6, "EB3"], 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 104
[ , [6, 4], [6, 13], 20, [0, 69, "Bel"], 20, [0, 66, "GO"], 2, [0, 60, "DGM"], 2, [0, 56, "BET"], 20, [0, 54, "ARS"], 2, 20, 3, 20, [0, 48, "DaH"], 2, [0, 43, "DaH"], 1, 1, 2, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], 20, 20, 20, 20, 20, 20, 3, [0, 33, "Glo"], [0, 30, "BZ"], 20, 20, [0, 28, "BZ"], 20, 20, 20, [0, 26, "BZ"], 20, 20, 20, 20, 3, [0, 22, "BZ"], 1, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 20, 3, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 105
[ , 2, 3, 1, 2, 1, 2, [0, 63, "Gu"], 2, 2, 3, 20, 3, [0, 53, "XX"], 20, 3, 20, 3, [0, 45, "DaH"], 3, 20, [0, 42, "DaH"], [0, 41, "DaH"], 1, 1, 20, 1, 1, 20, 20, 20, 20, 20, 3, 3, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 3, 1, 20, [0, 21, "VE"], 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 3, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 106
[ , 2, 1, 1, 2, 1, 2, 3, 2, [0, 59, "MTS"], 1, 2, 1, 1, 2, 3, 20, 3, 3, 2, 20, 3, 3, 20, 1, 1, 20, 1, 1, 20, 20, 20, 20, 3, 3, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 3, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 107
[ , 2, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 20, [0, 54, "XX"], [0, 53, "X6a"], 2, [0, 49, "GW2"], 3, 1, 2, 20, 3, 3, 2, 20, 1, 2, 20, 1, 2, 20, 20, 20, 3, 3, 2, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 2, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 108
[ , [6, 4], 2, 20, [22, 4, 1], 20, [0, 69, "EB1"], 2, [0, 63, "GB1"], 2, [0, 58, "GB4"], [0, 57, "BZ"], 20, 1, 2, [0, 52, "X6a"], 1, 2, 2, [0, 45, "BZ"], 2, 3, 1, 2, 20, 20, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], 20, 20, 20, 3, 3, [0, 32, "BZ"], 20, 20, [0, 30, "BZ"], 20, 20, 1, 1, 20, 20, [0, 26, "BZ"], 20, 20, [0, 24, "BZ"], 20, 20, [0, 22, "BZ"], 1, 20, 20, [0, 20, "BZ"], [0, 19, "VE"], 20, 20, 20, [0, 18, "BZ"], 1, 20, 20, [0, 16, "BZ"], 20, 1, 20, 20, 20, [0, 14, "BZ"], 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 20, 20, [0, 7, "EB3"], 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 109
[ , 2, [6, 9], 20, 3, 1, 2, 2, 3, 2, 1, 2, 1, 20, [0, 54, "X6a"], 2, 1, 2, 2, 1, 2, 1, 20, [0, 41, "XX"], 1, 20, 1, 1, 20, 1, 1, 20, 20, 3, 3, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, [0, 10, "LX"], 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 110
[ , 2, 2, 1, 1, 1, 2, [0, 66, "GO2"], 3, [0, 62, "MTS"], 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, [0, 45, "DaH"], 2, [0, 42, "BZ"], 3, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 20, [0, 7, "Vx"], 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 111
[ , 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 20, [0, 54, "X6a"], 20, [0, 51, "DaH"], 2, 2, 1, 2, 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 20, 1, 20, 1, 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20],
#V   n = 112
[ , [6, 4], 2, 1, 2, 20, [0, 72, "EB1"], 2, 1, 2, 20, [0, 60, "BZ"], [0, 58, "ARS"], [0, 57, "BZ"], 20, 3, 20, 3, [0, 50, "DaH"], 2, 2, [0, 45, "BZ"], 20, [0, 42, "BZ"], [0, 41, "Vx"], 20, [0, 40, "BZ"], 20, 20, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], 20, 20, [0, 30, "BZ"], 20, 20, 20, [0, 28, "BZ"], 20, 20, [0, 26, "BZ"], 20, 20, [0, 24, "BZ"], 20, 20, [0, 22, "BZ"], 20, 1, 20, [0, 20, "BZ"], 1, 20, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 15, "BZ"], 20, 20, [0, 14, "BZ"], 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, [5, 55], 20, 1, 20, 20, 20],
#V   n = 113
[ , 2, [6, 9], 20, [0, 75, "Bel"], 20, 3, [0, 68, "GW2"], 1, 2, 2, 3, 3, 3, 2, 3, 1, 1, 1, 2, 2, 3, [0, 43, "Vx"], 3, 3, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 3, 20, 20, 1, 2, 20, 20, 3, 20, 20, 3, 20, 20, 3, 1, 20, 1, 20, 20, 1, 1, 20, [0, 19, "VE"], 20, 20, 20, [0, 18, "BZ"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 20, [0, 12, "BZ"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 114
[ , 2, 2, 1, 2, [0, 73, "Gu1"], 3, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 3, 1, 1, 1, 20, 1, 2, 20, 1, 2, 20, 3, [0, 35, "Vx"], 20, 3, [0, 33, "Vx"], 20, 1, 2, 20, 20, [0, 30, "XBZ"], 20, 20, 3, [0, 27, "Vx"], 20, 1, 1, 20, 1, 20, 1, 20, [0, 22, "XBZ"], 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, [0, 15, "Vx"], 20, 20, [0, 14, "Vx"], 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 115
[ , 2, 2, 1, 2, 2, 3, [0, 69, "GW2"], 1, 2, [0, 63, "Bou"], 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 1, 2, [0, 43, "Ed"], [0, 42, "Vx"], [0, 41, "Vx"], 20, [0, 40, "Vx"], 20, 20, [0, 38, "Vx"], 20, 1, 1, 20, 1, 1, 20, 20, [0, 32, "Vx"], 20, 20, 3, [0, 29, "Vx"], 20, 1, 1, 20, 20, [0, 26, "Vx"], [0, 25, "Ed"], 20, [0, 24, "Vx"], 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 1, 20, 20, 1, 20, 1, 20, 20, 20, [0, 12, "Vx"], 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 116
[ , [6, 4], 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, [0, 45, "Vx"], 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 28, "Vx"], 1, 20, 1, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 20, [5, 42], 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 117
[ , 2, [6, 13], 20, [22, 4, 1], 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 1, 2, [0, 43, "Ed"], 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, [0, 30, "Vx"], 1, 20, 1, 20, [0, 27, "XB"], 20, 1, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 118
[ , 2, 3, 1, 2, 2, [7, 338], 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, [0, 48, "XB"], 20, [0, 45, "XB"], 1, 20, [0, 42, "XB"], 1, 20, [0, 40, "XB"], 20, 20, [0, 38, "XB"], 20, 20, [0, 36, "XB"], 20, 20, [0, 34, "XB"], 20, 20, [0, 32, "XB"], 20, 1, 20, [0, 29, "XB"], 20, [0, 28, "Vx"], 1, 20, 20, [0, 26, "XB"], [0, 25, "Ed"], 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 20, 1, 20, 20, 1, 1, 20, [0, 15, "Ed"], 20, 20, 1, 20, [0, 13, "Ed"], 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 119
[ , 2, 1, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 2, 20, 1, 1, 2, 2, 2, 2, 3, [0, 44, "Vx"], [0, 43, "Ed"], 1, 20, 1, 1, 1, 20, 3, [0, 37, "Vx"], 20, 1, 2, 20, 3, [0, 33, "Vx"], 20, 3, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 2, 20, 20, 20, 1, 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 120
[ , [6, 4], 2, 1, 2, [0, 78, "Gu1"], [0, 75, "GO"], 20, 1, 2, 20, [0, 66, "ARS"], 20, 1, 2, 2, 20, 20, 1, 2, 2, 2, 2, 1, 1, 1, 20, [0, 42, "Vx"], 20, 1, 1, 2, 1, 1, 20, 20, [5, 30], 20, 1, 1, 20, 1, 20, [0, 31, "Ed"], 20, [0, 30, "BZ"], 1, 20, 1, 20, [0, 27, "Ed"], 20, [0, 26, "Vx"], 1, 20, 20, [0, 24, "BZ"], 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 20, [5, 41], 20, 20, 1, 1, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20],
#V   n = 121
[ , 2, 2, 20, [0, 81, "sim"], 2, 2, 20, 20, [0, 72, "dB"], 2, 3, 20, 20, [0, 63, "BCH"], 2, 20, 20, 20, [0, 57, "DaH"], 2, 2, [0, 48, "BZ"], [0, 46, "Vx"], [0, 45, "Vx"], [0, 44, "Vx"], [0, 43, "Var"], 1, 20, 20, 1, 2, 20, [0, 38, "Vx"], 1, 20, 3, 1, 20, [0, 34, "Vx"], 1, 20, [0, 32, "XB"], 1, 20, 1, 20, [0, 29, "Ed"], 20, [0, 28, "Ed"], 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, [0, 23, "BCH"], 20, 20, 20, 20, [0, 21, "BCH"], 1, 20, 20, 20, 3, 20, 20, 20, 1, 2, 1, 20, 20, 20, [0, 14, "BCH"], 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, [0, 3, "Ham"], 20, 20, 20],
#V   n = 122
[ , 2, [6, 9], 20, 3, 2, 2, 2, 20, 3, 2, 3, 20, 20, 1, 2, 20, 20, 20, 1, 2, [0, 51, "DaH"], 3, 1, 1, 1, 1, 20, [0, 42, "Vx"], 20, 20, [0, 41, "NBC"], [0, 39, "Vx"], 1, 20, [0, 37, "Ed"], 1, 20, [0, 35, "Ed"], 1, 20, [0, 33, "Ed"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 25, "Ed"], 20, 1, 20, 20, 1, 1, 20, 20, 20, 3, [0, 20, "Vx"], 1, 20, 20, 1, 20, 20, 20, 20, [0, 17, "XBC"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 20, [0, 11, "NBC"], 20, 1, 20, 20, 1, 20, 20, 20, 20, [0, 8, "DaH"], 20, 20, 20, 20, 20, 1, 20, 20, 20, [0, 5, "NBC"], 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 123
[ , 2, 2, 20, 1, 2, 2, 2, 20, 3, 2, 2, 20, 20, 20, [0, 63, "X"], 1, 20, 20, 20, [0, 57, "DaH"], 3, 1, 2, [0, 46, "Vx"], [0, 45, "Vx"], [0, 44, "Var"], 1, 1, 20, 20, 3, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 31, "Ed"], 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 20, 3, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 124
[ , [6, 4], 2, 2, 20, [0, 81, "Bo1"], 2, [0, 75, "BZ"], 20, 3, 2, 2, 1, 20, 20, 3, 1, 1, 20, 20, 3, 3, 2, [0, 48, "Vx"], 1, 1, 1, 20, [0, 43, "Ed"], 1, 20, 1, 2, 1, 20, [0, 38, "BZ"], 1, 20, [0, 36, "BZ"], 1, 20, [0, 34, "BZ"], 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, [0, 27, "Ed"], 20, [0, 26, "Ed"], 1, 20, 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 125
[ , 2, 2, 2, 20, 3, 2, 2, 20, 1, 2, [0, 68, "GW2"], 1, 1, 20, 3, 1, 1, 1, 20, 3, 1, 2, 1, 2, [0, 46, "Vx"], [0, 45, "Var"], 1, 1, 20, [0, 42, "Ed"], 20, [0, 41, "Vx"], 20, [0, 39, "Ed"], 1, 20, [0, 37, "Ed"], 1, 20, [0, 35, "Ed"], 1, 20, [0, 33, "Var"], 20, 1, 1, 20, 20, [0, 30, "BZ"], [0, 29, "Ed"], 20, [0, 28, "BZ"], 1, 20, 1, 20, 1, 20, 20, [0, 24, "BZ"], 20, 20, 1, 1, 20, 20, [0, 21, "X"], 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, [0, 16, "Ed"], 20, [0, 15, "Ed"], 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, [0, 10, "BZ"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 126
[ , 2, [6, 9], [22, 3, 1], 2, 1, 2, 2, [0, 73, "GB1"], 20, [0, 72, "Br2"], 2, [0, 66, "BZ"], 1, 2, 3, 1, 1, 1, 2, 3, 1, 2, 20, [0, 48, "BZ"], 1, 1, 20, [0, 44, "Ed"], 1, 1, 20, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 2, 20, 1, 20, 1, 20, [0, 19, "Var"], 20, 20, 1, 20, 20, [0, 17, "BE3"], 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 20, [0, 12, "X"], 20, 20, 20, 1, 20, 1, 20, 20, 20, [0, 9, "X"], 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 127
[ , 2, 2, 1, 2, 20, [0, 81, "GW2"], 2, 2, 20, 3, [0, 69, "GW2"], 1, 20, [0, 65, "X"], 1, 1, 1, 1, 2, 3, 1, 2, 2, 3, [0, 47, "Vx"], [0, 46, "Var"], 1, 1, 20, [0, 43, "Ed"], 1, 20, [0, 41, "Vx"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, [0, 23, "X"], 20, 20, 1, 20, [0, 20, "X"], 1, 20, 20, 20, [0, 18, "X"], 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 13, "Ed"], 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 128
[ , [6, 4], 2, 2, [6, 11], 2, 3, [0, 78, "GO2"], 2, 20, 3, 3, 1, 1, 1, 2, 1, 1, 1, 2, 3, 1, 2, [0, 50, "VE"], 1, 1, 1, 20, [0, 45, "Ed"], 1, 1, 20, [0, 42, "BZ"], 1, 20, [0, 40, "BZ"], [0, 39, "Var"], 20, [0, 38, "BZ"], [0, 37, "Ed"], 20, [0, 36, "BZ"], [0, 35, "Var"], 20, [0, 34, "BZ"], 1, 20, 20, [0, 32, "BZ"], 20, 20, 1, 1, 20, 1, 20, [0, 27, "Ed"], 20, 1, 20, [0, 25, "XB"], 20, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 129
[ , 2, 2, 2, 1, 2, 3, 3, 2, 2, 3, 1, 1, 1, 2, [0, 65, "XX"], 20, 1, 1, 2, 2, 1, 2, 1, 2, [0, 48, "Vx"], [0, 47, "Var"], 1, 1, 20, [0, 44, "Ed"], 1, 1, 20, [0, 41, "Vx"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 33, "Var"], 20, 1, 1, 20, 20, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, 20, [0, 23, "Vx"], 1, 20, 20, [0, 21, "X"], 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 130
[ , 2, [6, 13], [6, 10], 2, [0, 84, "Bo1"], 2, 2, [0, 76, "DGM"], [0, 74, "DG4"], 3, 20, 1, 1, 2, 2, 20, 20, 1, 2, 2, 1, 2, [0, 51, "VE"], [0, 50, "VE"], 1, 1, 20, [0, 46, "Ed"], 1, 1, 20, [0, 43, "Ed"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, [0, 30, "BZ"], 20, 20, [0, 28, "BZ"], 1, 20, 20, [0, 26, "BZ"], 1, 20, 20, [0, 24, "BZ"], 20, 1, 20, [0, 22, "Ed"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, [0, 17, "XX"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 131
[ , 2, 3, 1, 2, 2, 2, 2, 3, 2, 2, 20, 20, 1, 2, 2, 20, 20, 20, [0, 63, "DaH"], 2, 1, 2, 1, 1, 2, [0, 48, "Var"], 1, 1, 20, [0, 45, "VE"], 1, 1, 20, 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 1, 1, 20, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 16, "Ed"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 132
[ , [6, 4], 2, 2, [6, 11], 2, 2, 2, 3, [0, 75, "X"], 2, 1, 20, 20, [0, 69, "X"], 2, 20, 20, 20, 3, [0, 60, "DaH"], 20, [0, 57, "DaH"], [0, 52, "Vx"], [0, 51, "VE"], [0, 50, "VE"], 1, 20, [0, 47, "Var"], 1, 1, 20, [0, 44, "BZ"], 1, 20, [0, 42, "BZ"], [0, 41, "VE"], 20, [0, 40, "BZ"], 20, 20, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], [0, 35, "Var"], 20, 1, 1, 20, 20, [0, 32, "BZ"], 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 18, "Ed"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 133
[ , 2, 2, 2, 1, 2, [0, 84, "GO"], [0, 81, "GW2"], 2, 1, 2, 1, 2, 20, 1, 2, 20, 20, 20, 3, 3, 2, 3, 1, 1, 1, 2, 1, 1, 20, [0, 46, "VE"], 1, 1, 20, [0, 43, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, [0, 27, "Var"], 20, 1, 20, [0, 25, "XB"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, [0, 20, "XX"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 134
[ , 2, 2, [6, 27], 2, [0, 87, "Bo3"], 2, 2, 2, 20, [0, 75, "XX"], 1, 2, 20, 20, [0, 69, "XX"], 20, 20, 20, 3, 1, 2, 3, 2, [0, 52, "VE"], [0, 51, "VE"], [0, 50, "VE"], 20, 1, 1, 1, 20, [0, 45, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 2, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 19, "Var"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 135
[ , 2, [6, 9], 1, 2, 2, 2, 2, [0, 78, "BZ"], 1, 2, 20, [0, 72, "BZ"], 20, 20, 3, 1, 20, 20, 3, [0, 61, "DaH"], [0, 60, "DaH"], 3, [0, 54, "BZ"], 1, 1, 2, 1, 20, [0, 48, "BZ"], [0, 47, "VE"], 1, 1, 20, 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 20, 1, 2, 20, 20, [0, 30, "BZ"], 20, 20, 1, 1, 20, 20, [0, 26, "BZ"], 1, 20, 20, [0, 24, "BZ"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 136
[ , [6, 4], 2, 20, [6, 55], 2, [0, 86, "GO"], 2, 1, 1, 2, 20, 3, 1, 20, 3, 1, 2, 20, 3, 3, 3, 3, 3, [0, 53, "VE"], [0, 52, "VE"], [0, 51, "VE"], 20, [0, 49, "Var"], 1, 1, 20, [0, 46, "BZ"], [0, 45, "Var"], 20, [0, 44, "BZ"], [0, 43, "VE"], 20, [0, 42, "BZ"], 20, 20, [0, 40, "BZ"], 20, 20, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], [0, 35, "VE"], 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, [0, 22, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, [0, 17, "VE"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 137
[ , 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 3, 1, 2, 3, 1, 2, 20, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 20, [0, 48, "Vx"], [0, 47, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 138
[ , 2, 2, 2, 20, [0, 90, "Bo3"], 2, 2, 2, 20, [0, 78, "Bou"], 2, 1, 20, [0, 71, "XX"], 3, 20, [0, 66, "DaH"], 20, 3, 1, 2, 2, [0, 55, "Vx"], [0, 54, "Vx"], [0, 53, "VE"], [0, 52, "VE"], [0, 51, "VE"], [0, 50, "Var"], 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 139
[ , 2, [6, 9], [6, 19], 2, 3, 2, 2, 2, 2, 3, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 20, [0, 49, "VE"], 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 20, 20, 1, 2, 20, 1, 20, [0, 25, "VE"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 18, "VE"], 20, 1, 20, 20, [0, 16, "VE"], 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 140
[ , [6, 4], 2, 1, 2, 1, 2, [0, 87, "Koh"], [0, 82, "GB4"], 2, 3, 2, 2, 20, [0, 72, "XX"], 2, 1, 2, 1, 2, 1, 2, 2, 2, [0, 55, "Vx"], [0, 54, "BZ"], [0, 53, "VE"], [0, 52, "VE"], [0, 51, "Var"], 1, 1, 20, [0, 48, "BZ"], [0, 47, "Var"], 20, [0, 46, "BZ"], 20, 20, [0, 44, "BZ"], 20, 20, [0, 42, "BZ"], 20, 20, [0, 40, "BZ"], 20, 20, [0, 38, "BZ"], 20, 20, 1, 1, 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], [0, 31, "Var"], 20, 20, [0, 30, "BZ"], 20, 20, 20, [0, 28, "BZ"], 20, 20, [0, 26, "BZ"], 1, 20, 20, [0, 24, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 20, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, [0, 15, "BZ"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, [0, 10, "BZ"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 141
[ , 2, 2, 2, [6, 20], 20, [0, 90, "GW2"], 2, 2, [0, 81, "X"], 1, 2, 2, 20, 3, [0, 71, "X6a"], 1, 2, [0, 66, "DaH"], [0, 65, "DaH"], 20, [0, 63, "DaH"], [0, 60, "DaH"], 2, 1, 1, 1, 1, 1, 20, [0, 50, "VE"], [0, 49, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 142
[ , 2, 2, 2, 3, 2, 3, 2, 2, 3, 1, 2, 2, [0, 73, "MTS"], 1, 2, 20, [0, 69, "DaH"], 3, 3, 20, 3, 3, 2, [0, 56, "Vx"], [0, 55, "Vx"], 1, 2, [0, 52, "Var"], 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 30, "XBZ"], 1, 20, 20, [0, 28, "Vx"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 20, [0, 19, "Var"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 143
[ , 2, [6, 13], [6, 27], 1, 2, 1, 2, [0, 84, "DGM"], 1, 1, 2, 2, 1, 20, [0, 72, "X6a"], 20, 3, 1, 2, 20, 3, 1, 2, 1, 1, 20, [0, 54, "BZ"], 1, 20, [0, 51, "VE"], 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 144
[ , [6, 4], 3, 2, 2, [0, 93, "Gu1"], 20, [0, 90, "GO2"], 3, 1, 1, 2, [0, 78, "BZ"], 2, [0, 73, "XX"], 3, 20, 3, 1, 2, 20, 3, 20, [0, 60, "BZ"], 2, [0, 56, "Vx"], [0, 55, "Vx"], 1, 2, 1, 1, 20, [0, 50, "BZ"], [0, 49, "Var"], 20, [0, 48, "BZ"], 20, 20, [0, 46, "BZ"], 20, 20, [0, 44, "BZ"], 20, 20, [0, 42, "BZ"], 20, 20, [0, 40, "BZ"], 20, 20, [0, 38, "BZ"], 20, 20, 20, [0, 36, "BZ"], 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], 1, 20, 1, 20, [0, 29, "Var"], 20, 1, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 20, [0, 6, "BZ"], 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 145
[ , 2, 2, 2, 2, 2, 2, 3, 2, 20, 1, 2, 3, [0, 75, "MTS"], 2, 3, 1, 1, 1, 2, 20, 3, 20, 3, [0, 58, "Vx"], 1, 1, 20, [0, 54, "Vx"], 20, [0, 52, "VE"], [0, 51, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 31, "Var"], 20, 1, 1, 20, 20, 1, 1, 20, 20, [0, 26, "VE"], 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 146
[ , 2, 2, 2, [6, 25], 2, 2, 3, [0, 85, "Zwa"], 2, 20, [0, 82, "ARS"], 3, 2, [0, 74, "XX"], 1, 1, 1, 1, 2, [0, 64, "DaH"], 3, 20, 3, 2, [0, 57, "Vx"], [0, 56, "Vx"], [0, 55, "Var"], 1, 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 30, "VE"], 1, 20, 20, [0, 28, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 147
[ , 2, 2, [6, 27], 1, 2, [0, 93, "GO"], 2, 1, 2, 20, 3, 2, 2, 2, [0, 73, "X6a"], 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 20, [0, 54, "Vx"], [0, 53, "VE"], 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 18, "VE"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 148
[ , [6, 4], [6, 9], 3, 2, [0, 96, "Bo3"], 2, 2, 1, 2, 20, 3, 2, [0, 77, "MTS"], [0, 75, "XX"], 2, 20, [0, 72, "DaH"], 1, 2, 1, 2, 1, 1, 2, 2, [0, 57, "Vx"], [0, 56, "Var"], [0, 55, "Vx"], 1, 1, 20, [0, 52, "BZ"], [0, 51, "Var"], 20, [0, 50, "BZ"], 20, 20, [0, 48, "BZ"], 20, 20, [0, 46, "BZ"], 20, 20, [0, 44, "BZ"], 20, 20, [0, 42, "BZ"], 20, 20, [0, 40, "BZ"], 20, 20, 1, 1, 20, 20, [0, 36, "BZ"], 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, 1, 20, 1, 20, 20, [0, 20, "VE"], 20, 1, 20, 1, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 149
[ , 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 3, 2, 2, 1, 2, 20, 3, 20, [0, 71, "DaH"], 1, 2, 1, 1, 2, 2, 1, 1, 1, 20, [0, 54, "Var"], [0, 53, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 16, "VE"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 150
[ , 2, 2, 2, [22, 4, 1], 2, 2, [0, 93, "GO2"], [0, 88, "GB4"], [0, 87, "Gu"], [0, 84, "MTS"], 1, 2, [0, 78, "MTS"], 1, 2, 20, 3, 20, 3, 20, [0, 66, "GW2"], 1, 1, 2, [0, 60, "BZ"], 1, 2, [0, 56, "Vx"], 1, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 31, "Var"], 20, [0, 30, "VE"], 1, 20, 20, [0, 28, "VE"], 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 151
[ , 2, 2, 2, 1, 2, 2, 3, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 20, 3, 1, 1, 1, 1, 2, 1, 1, 2, 1, 20, [0, 55, "Var"], 1, 1, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 20, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "VE"], 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 19, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 152
[ , [6, 4], [6, 9], [6, 32], 2, [0, 99, "Bo3"], 2, 3, 1, 2, 2, 1, 2, 2, 1, 2, 2, [0, 73, "Da0"], [0, 72, "Da0"], 3, 1, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 20, [0, 54, "BZ"], [0, 53, "Var"], 20, [0, 52, "BZ"], 20, 20, [0, 50, "BZ"], 20, 20, [0, 48, "BZ"], 20, 20, [0, 46, "BZ"], 20, 20, [0, 44, "BZ"], 20, 20, [0, 42, "BZ"], 20, 20, [0, 40, "BZ"], 20, 20, 20, [0, 38, "BZ"], 20, 20, [0, 36, "BZ"], 20, 20, [0, 34, "BZ"], 20, 20, [0, 32, "BZ"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 153
[ , 2, 2, 1, 2, 1, 2, 2, 1, 2, [0, 86, "MTS"], 20, [0, 84, "BZ"], 2, 20, [0, 78, "BZ"], 2, 2, 3, 3, 1, 1, 1, 1, 2, 2, 20, [0, 60, "BZ"], 1, 1, 2, 1, 1, 1, 20, 1, 1, 20, 3, [0, 49, "Vx"], 20, 3, [0, 47, "Vx"], 20, 3, [0, 45, "Vx"], 20, 3, [0, 43, "Vx"], 20, 3, [0, 41, "Vx"], 20, 1, 1, 20, 20, 3, [0, 37, "Vx"], 20, 3, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 154
[ , 2, 2, 2, [0, 102, "Bel"], 2, [0, 99, "GO"], 2, 1, 2, 1, 2, 3, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 20, [0, 55, "VE"], [0, 54, "Var"], 1, 20, [0, 52, "Vx"], [0, 51, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 20, [0, 40, "XBZ"], [0, 39, "VE"], 20, 1, 1, 20, 1, 20, [0, 35, "VE"], 20, [0, 34, "Vx"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 155
[ , 2, 2, 2, 1, 2, 3, 2, 1, 2, 1, 2, 3, 2, 1, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 20, [0, 53, "Var"], 1, 1, 20, [0, 50, "Vx"], 1, 20, [0, 48, "Vx"], 1, 20, [0, 46, "Vx"], 1, 20, [0, 44, "Vx"], 1, 20, [0, 42, "Vx"], 1, 20, 1, 1, 20, 20, [0, 38, "Vx"], 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 20, [0, 30, "Var"], 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 156
[ , [6, 4], [6, 13], [6, 36], 2, [0, 102, "Bo3"], 3, [0, 96, "GO2"], 1, 2, 20, [0, 87, "DaH"], 1, 2, 1, 2, [0, 78, "DaH"], 2, 2, 20, 1, 2, 20, 1, 2, 2, 20, 1, 1, 1, 2, 20, [0, 56, "VE"], [0, 55, "Var"], 1, 1, 20, [0, 52, "Vx"], 1, 1, 20, [0, 49, "VE"], 1, 20, [0, 47, "VE"], 1, 20, [0, 45, "VE"], 1, 20, [0, 43, "VE"], 1, 20, [0, 41, "Var"], 20, [0, 40, "Vx"], 1, 20, 1, 20, [0, 37, "VE"], 20, [0, 36, "VE"], 1, 20, 1, 20, [0, 33, "Var"], 20, [0, 32, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 28, "VE"], 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 20, "Var"], 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 157
[ , 2, 3, 1, 2, 2, 3, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 20, [0, 72, "GW2"], 1, 20, [0, 69, "GW2"], 2, 20, 20, 1, 1, 2, 1, 1, 1, 20, [0, 54, "Var"], 1, 1, 20, [0, 51, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, [0, 18, "VE"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 158
[ , 2, 2, 2, [0, 105, "Bel"], 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 1, 20, 20, 1, 2, 20, [0, 57, "VE"], [0, 56, "Var"], 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "XB"], 1, 20, [0, 48, "XB"], 1, 20, [0, 46, "XB"], 1, 20, [0, 44, "XB"], 1, 20, [0, 42, "XB"], 1, 20, 1, 20, [0, 39, "VE"], 20, [0, 38, "VE"], 1, 20, 1, 20, [0, 35, "VE"], 20, [0, 34, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 159
[ , 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 20, 1, 1, 2, 2, 1, 2, 20, 20, [0, 62, "GW2"], 1, 1, 1, 20, [0, 55, "Var"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, [0, 49, "Var"], 1, 20, [0, 47, "VE"], 1, 20, [0, 45, "VE"], 1, 20, [0, 43, "Var"], 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 160
[ , [6, 4], 2, [4, 2], 2, [0, 105, "Gu"], 2, [0, 99, "GO2"], 2, [0, 96, "DaH"], 2, [0, 90, "ARS"], 2, [0, 87, "DaH"], 20, [0, 84, "DaH"], 1, 2, [0, 78, "DaH"], 2, [0, 75, "DaH"], 1, 20, 1, 2, 2, 1, 2, 20, 20, 3, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 41, "VE"], 1, 20, 1, 20, 1, 20, [0, 37, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 161
[ , 2, [6, 9], 1, 2, 2, [0, 102, "GO"], 1, 2, 3, 2, 1, 2, 3, 20, 3, 1, 2, 3, [0, 77, "DaH"], 3, 20, [0, 73, "GW2"], 20, [0, 72, "GW2"], 2, 1, 2, 2, 20, 3, 1, 1, 1, 20, [0, 56, "Var"], 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "VE"], 1, 20, [0, 48, "VE"], 1, 20, [0, 46, "VE"], 1, 20, [0, 44, "VE"], 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 33, "Var"], 20, [0, 32, "VE"], 1, 20, 20, [0, 30, "VE"], 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 1, 20, 20, [0, 19, "VE"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 162
[ , 2, 2, 20, [22, 4, 1], 2, 2, 2, [0, 99, "DaH"], 3, [0, 93, "DaH"], 20, [0, 90, "BZ"], 3, 20, 1, 1, 2, 2, 3, 3, 20, 1, 20, 3, [0, 71, "GW2"], 1, 2, 2, 20, 3, [0, 60, "Vx"], [0, 59, "VE"], [0, 58, "Var"], 1, 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, [0, 49, "Var"], 1, 20, [0, 47, "Var"], 1, 20, [0, 45, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 20, [0, 34, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "VE"], 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 163
[ , 2, 2, 20, 1, 2, 2, 2, 3, 3, 3, 20, 3, 2, 1, 20, 1, 2, 2, 2, 3, 20, 20, [0, 73, "GW2"], 3, 3, 1, 2, 2, 20, 3, 1, 1, 1, 20, [0, 57, "Var"], 1, 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 164
[ , [6, 4], 2, 2, 20, [0, 108, "Bo3"], 2, [0, 102, "ARS"], 3, 3, 3, [0, 91, "MTS"], 3, 2, 1, 2, 20, [0, 84, "DaH"], 2, [0, 78, "GW2"], 1, 2, 20, 3, 3, 3, 1, 2, 2, 2, 3, 20, [0, 60, "Var"], [0, 59, "Var"], 1, 1, 20, [0, 56, "VE"], 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "Var"], 1, 20, [0, 48, "VE"], 1, 20, [0, 46, "VE"], 1, 20, [0, 44, "Var"], 1, 20, 1, 20, [0, 41, "VE"], 1, 20, 1, 20, 1, 20, [0, 37, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 165
[ , 2, [6, 9], 2, 20, 3, 2, 3, 3, 3, 2, 2, 3, [0, 89, "GW2"], 20, [0, 86, "DaH"], 20, 3, [0, 81, "DaH"], 3, 20, [0, 75, "GW2"], 20, 3, 3, 3, 20, [0, 69, "GW2"], [0, 67, "GW2"], 2, 1, 1, 1, 1, 20, [0, 58, "Var"], 1, 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, [0, 49, "Var"], 1, 20, [0, 47, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 166
[ , 2, 2, [6, 10], 2, 3, 2, 3, 2, 3, 2, 2, 1, 2, 20, 3, 20, 3, 3, 2, 1, 2, 20, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 20, [0, 57, "VE"], 1, 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 33, "Var"], 20, [0, 32, "Var"], 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 22, "VE"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 167
[ , 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, [0, 93, "MTS"], 2, [0, 90, "GW2"], 1, 2, 20, 3, 3, 2, 1, 2, 20, 20, 1, 2, 20, [0, 70, "GW2"], 2, 2, 1, 1, 1, 2, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "VE"], 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "Var"], 1, 20, [0, 48, "Var"], 1, 20, [0, 46, "Var"], 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 20, [0, 34, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 30, "VE"], 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, 1, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 168
[ , [6, 4], 2, 2, [6, 47], 2, [22, 6, 1], 2, 2, 2, [0, 96, "GW2"], 1, 2, 3, 1, 2, 2, 3, 1, 2, 1, 2, [0, 74, "GW2"], 20, 20, [0, 73, "GW2"], 1, 1, 2, [0, 67, "GW2"], 1, 1, 1, 2, 1, 1, 20, [0, 58, "VE"], 1, 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 24, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 20, [0, 6, "BZ"], 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 169
[ , 2, [6, 13], 2, 1, 2, 3, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2, 1, 2, 20, [0, 78, "GW2"], 2, 20, 20, 3, 1, 1, 2, 1, 2, 1, 1, 2, [0, 61, "VE"], [0, 60, "Var"], 1, 1, 20, [0, 57, "VE"], [0, 56, "Var"], 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "VE"], 1, 20, [0, 47, "VE"], 1, 20, [0, 45, "Var"], 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, [0, 38, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 170
[ , 2, 3, [6, 10], 2, [0, 111, "Bo3"], 3, 2, [0, 103, "GW2"], [0, 99, "Gu"], [0, 97, "MTS"], 1, 2, 2, 1, 2, [0, 87, "DaH"], 2, 1, 2, [0, 79, "GW2"], 3, 2, 20, 20, 1, 20, [0, 72, "GW2"], [0, 71, "GW2"], 20, [0, 67, "GW2"], 20, 1, 2, 1, 1, 20, [0, 59, "VE"], 1, 1, 1, 20, 1, 1, 20, [0, 53, "VE"], 1, 1, 20, [0, 50, "Var"], 1, 20, [0, 48, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 21, "VE"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 171
[ , 2, 2, 1, 2, 2, 3, 2, 3, 2, 2, 1, 2, 2, 20, [0, 90, "BZ"], 1, 2, [0, 84, "BZ"], [0, 83, "DaH"], 3, 3, 2, 20, 20, 20, 1, 2, 3, 2, 3, 20, 20, [0, 65, "GW2"], [0, 62, "VE"], [0, 61, "Var"], 1, 1, 20, [0, 58, "VE"], [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 20, [0, 23, "VE"], 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 19, "Var"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 172
[ , [6, 4], 2, 2, [6, 55], 2, 1, 2, 2, 2, 2, 20, [0, 96, "XBZ"], [0, 93, "GW2"], 20, 3, 20, [0, 87, "DaH"], 3, 3, 1, 1, 2, 20, 20, 20, 20, [0, 73, "GW2"], 3, [0, 69, "GW2"], 3, 20, 20, 3, 1, 1, 20, [0, 60, "VE"], 1, 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "Var"], 1, 20, [0, 47, "Var"], 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 20, [0, 34, "VE"], 20, [0, 33, "VE"], 20, [0, 32, "VE"], 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 173
[ , 2, 2, 2, 1, 2, 2, [0, 108, "Koh"], 2, 2, 2, 20, 3, 3, [0, 91, "GW2"], 3, 20, 3, 2, 3, 1, 1, 2, 2, 20, 20, 20, 3, 2, 3, 3, [0, 66, "Vx"], 20, 3, [0, 63, "VE"], [0, 62, "Var"], 1, 1, 20, [0, 59, "VE"], [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "VE"], 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 174
[ , 2, [6, 9], [6, 27], 2, [0, 114, "Gu1"], 2, 3, 2, 2, [0, 100, "MTS"], 2, 3, 3, 1, 2, 2, 3, 2, 2, 1, 1, 2, 2, 20, 20, 20, 3, [0, 72, "GW2"], 3, 1, 1, 20, 3, 1, 1, 20, [0, 61, "VE"], 1, 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "Var"], 1, 20, [0, 50, "VE"], 1, 20, [0, 48, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 175
[ , 2, 2, 1, 2, 3, 2, 3, [0, 106, "GW2"], [0, 103, "GW2"], 2, 2, 3, 1, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 20, 20, 3, 3, 3, 1, 1, 1, 1, 2, [0, 63, "Var"], 1, 1, 20, [0, 60, "VE"], [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "VE"], 1, 1, 20, [0, 51, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 20, [0, 40, "Var"], 20, [0, 39, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 22, "VE"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 176
[ , [6, 4], 2, 20, [6, 55], 2, [0, 112, "GO"], 2, 3, 2, [0, 101, "MTS"], 2, 2, 1, 1, 2, [0, 90, "DaH"], 20, [0, 87, "DaH"], 2, 2, 20, [0, 81, "DaH"], 2, 1, 2, 20, 3, 3, 1, 20, 1, 1, 1, 2, 1, 20, [0, 62, "VE"], 1, 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "VE"], 1, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, [0, 47, "Var"], 1, 20, 1, 20, [0, 44, "BZ"], 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 177
[ , 2, 2, 2, 3, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 3, 1, 1, 2, [0, 84, "DaH"], 2, 3, 2, 1, 2, 20, 3, 3, 1, 2, 20, 1, 1, 2, [0, 64, "Var"], 1, 1, 20, [0, 61, "VE"], [0, 60, "Var"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "Var"], 1, 20, [0, 50, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 35, "Var"], 20, [0, 34, "Var"], 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 178
[ , 2, [6, 9], 2, 1, 2, 2, [0, 110, "Koh"], 2, [0, 105, "GW2"], 1, 2, 2, 1, 1, 2, 1, 1, 1, 2, 1, 2, 3, 2, 1, 2, 20, 3, 1, 1, 2, 20, 20, 1, 2, 1, 20, [0, 63, "VE"], 1, 1, 1, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 32, "VE"], 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 179
[ , 2, 2, [6, 19], 2, [0, 117, "Bo3"], 2, 2, [0, 108, "GW2"], 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 2, 20, [0, 84, "GW2"], 1, 2, 1, 2, 2, 3, 20, 1, 2, [0, 69, "Vx"], 20, 20, [0, 68, "GW2"], [0, 65, "Var"], 1, 1, 20, [0, 62, "VE"], [0, 61, "Var"], 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 20, [0, 51, "Var"], 1, 20, [0, 49, "Var"], 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, [0, 43, "VE"], 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 30, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 23, "Var"], 20, 1, 20, 20, [0, 21, "Var"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 180
[ , [6, 4], 2, 1, 2, 3, 2, [0, 111, "GO2"], 3, 2, 1, 2, 2, 1, 2, [0, 96, "BZ"], 1, 1, 1, 2, 2, 3, 20, [0, 81, "GW2"], 20, [0, 78, "BZ"], [0, 75, "BZ"], 2, 20, 20, [0, 72, "BZ"], 1, 20, 20, 3, 1, 20, [0, 64, "Var"], 1, 1, 1, 20, [0, 60, "Var"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, [0, 52, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, [0, 40, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 181
[ , 2, 2, 2, [6, 81], 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 20, 3, 20, 3, 2, [0, 74, "VE"], 20, 20, 3, 2, 1, 20, 3, [0, 66, "Vx"], 1, 1, 20, [0, 63, "VE"], [0, 62, "Var"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "VE"], 1, 1, 20, 1, 20, [0, 50, "VE"], 1, 20, [0, 48, "Var"], 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 182
[ , 2, [6, 13], 2, 2, 2, [0, 117, "GO"], 2, 20, [0, 108, "DaH"], 20, [0, 105, "ARS"], [0, 102, "XBZ"], 20, [0, 99, "DaH"], 3, 20, 1, 1, 2, 2, 3, 2, 3, 20, 3, [0, 76, "Vx"], 1, 1, 20, 3, [0, 71, "Vx"], 20, [0, 69, "GW2"], 3, 1, 20, [0, 65, "Var"], 1, 1, 1, 20, [0, 61, "Var"], 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, [0, 53, "Var"], 1, 20, [0, 51, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 28, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 183
[ , 2, 3, [6, 27], 2, 2, 3, 2, 2, 3, 20, 3, 3, 20, 3, 2, 20, 20, 1, 2, 2, 1, 2, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 67, "Vx"], 1, 1, 20, [0, 64, "VE"], [0, 63, "Var"], 1, 1, 20, [0, 60, "VE"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, [0, 35, "VE"], 20, [0, 34, "Var"], 20, [0, 33, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 184
[ , [6, 4], 2, 1, 2, [0, 120, "Gu"], 3, [0, 114, "GO2"], [0, 110, "XB"], 3, 2, 3, 3, 20, 3, 2, 20, 20, 20, [0, 93, "XX"], [0, 89, "DaH"], 2, [0, 84, "XBZ"], 1, 1, 2, 2, 1, 1, 1, 2, [0, 72, "Vx"], 1, 1, 2, 1, 20, [0, 66, "Var"], 1, 1, 1, 20, [0, 62, "Var"], 1, 1, 20, [0, 59, "VE"], 1, 1, 20, [0, 56, "Var"], 1, 20, [0, 54, "Var"], 1, 20, [0, 52, "Var"], 1, 20, [0, 50, "Var"], 1, 20, 1, 20, [0, 47, "VE"], 20, [0, 46, "BZ"], 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, [0, 31, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 1, 20, 20, [0, 22, "Var"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 185
[ , 2, 2, 2, [6, 81], 2, 2, 3, 2, 2, [0, 107, "MTS"], 3, 3, 1, 1, 2, 1, 20, 20, 3, 3, 2, 3, 1, 1, 2, [0, 78, "Vx"], 20, 1, 1, 2, 1, 20, 1, 2, 1, 1, 1, 20, [0, 65, "VE"], [0, 64, "Var"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, [0, 58, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 186
[ , 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 20, 3, 3, 2, 1, 1, 1, 2, 3, 1, 20, 1, 2, 20, [0, 72, "Vx"], 20, [0, 71, "GW2"], 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 1, 20, [0, 63, "Var"], 1, 1, 20, [0, 60, "VE"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "VE"], 1, 20, [0, 53, "VE"], 1, 20, [0, 51, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 20, [0, 41, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, [0, 30, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 187
[ , 2, [6, 9], [4, 2], 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 3, 1, 2, 20, 1, 1, 2, 1, 20, 1, 20, [0, 76, "GW2"], 2, 1, 20, 3, 1, 1, 1, 20, [0, 66, "VE"], [0, 65, "Var"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 188
[ , [6, 4], 2, 1, 2, 2, [0, 120, "Koh"], 2, 2, [0, 111, "BZ"], [0, 109, "MTS"], 2, 2, 20, 1, 2, 20, 1, 2, 3, 1, 2, 20, 20, 1, 2, 1, 1, 20, 1, 2, 2, 20, [0, 72, "Vx"], 3, 20, [0, 69, "VE"], [0, 68, "Var"], 1, 1, 1, 20, [0, 64, "Var"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, [0, 58, "Var"], 1, 20, [0, 56, "BZ"], 1, 20, [0, 54, "BZ"], 1, 20, [0, 52, "BZ"], 1, 20, [0, 50, "Var"], 1, 20, 1, 20, [0, 47, "VE"], 20, [0, 46, "BZ"], 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 189
[ , 2, 2, 20, [22, 4, 1], 2, 2, 2, [0, 114, "BZ"], 2, 2, [0, 108, "BZ"], 2, 20, 20, [0, 102, "BZ"], 20, 20, [0, 96, "BZ"], 3, 20, [0, 90, "BZ"], 20, 20, 20, [0, 84, "BZ"], [0, 80, "Vx"], 1, 1, 20, [0, 77, "GW2"], 2, [0, 73, "Var"], 1, 2, 1, 1, 1, 20, [0, 67, "VE"], [0, 66, "Var"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "VE"], 1, 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "Var"], 1, 20, [0, 53, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "VE"], 1, 20, 1, 20, 1, 20, 20, [0, 34, "VE"], 20, [0, 33, "Var"], 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 190
[ , 2, 2, 2, 1, 2, 2, 2, 3, 2, 2, 3, 2, 20, 20, 3, 20, 20, 3, 2, 20, 3, 1, 20, 20, 3, 1, 20, 1, 1, 1, 2, 1, 20, [0, 72, "Vx"], 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 1, 20, [0, 65, "Var"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 51, "VE"], 1, 20, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 191
[ , 2, [6, 9], 2, 20, [0, 126, "BKW"], 2, 2, 1, 2, [0, 111, "MTS"], 1, 2, 1, 20, 3, 1, 20, 3, 2, 20, 3, [0, 86, "Vx"], 1, 20, 3, 1, 1, 20, 1, 1, 2, [0, 74, "Var"], [0, 73, "Vx"], 1, 1, 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 49, "VE"], 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 42, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 192
[ , [6, 4], 2, [6, 32], 2, 3, [0, 123, "GO"], [0, 120, "GO2"], 2, [0, 114, "BZ"], 2, 2, [0, 108, "XBZ"], 1, 1, 2, 1, 1, 2, [0, 95, "X6a"], 1, 2, 1, 20, [0, 85, "BZ"], 3, 1, 1, 1, 20, 1, 2, 1, 1, 20, [0, 72, "Vx"], [0, 71, "Var"], [0, 70, "Var"], 1, 1, 1, 20, [0, 66, "Var"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "BZ"], 1, 20, [0, 58, "BZ"], [0, 57, "Var"], 20, [0, 56, "BZ"], [0, 55, "Var"], 20, [0, 54, "BZ"], 1, 20, [0, 52, "BZ"], 1, 20, [0, 50, "Var"], 1, 20, 20, [0, 48, "BZ"], [0, 47, "VE"], 20, [0, 46, "BZ"], 1, 20, 1, 20, [0, 43, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 193
[ , 2, 2, 1, 2, 3, 2, 3, [0, 116, "XB"], 3, 2, [0, 110, "XB"], 3, 1, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 2, 3, 20, 1, 1, 1, 20, [0, 79, "GW2"], [0, 75, "Var"], [0, 74, "Vx"], 1, 1, 1, 1, 20, [0, 69, "VE"], [0, 68, "Var"], 1, 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, [0, 30, "VE"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 194
[ , 2, 2, 2, [6, 81], 3, 2, 2, 2, 1, 2, 2, 3, 1, 1, 2, 1, 1, 2, [0, 96, "X6a"], 1, 2, 1, 1, 2, 1, 2, 20, 1, 1, 2, 3, 1, 1, 20, [0, 73, "VE"], [0, 72, "Var"], [0, 71, "Vx"], 1, 1, 1, 20, [0, 67, "Var"], 1, 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "Vx"], 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "Var"], 20, [0, 37, "Var"], 20, [0, 36, "Var"], 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 1, 1, 20, 20, [0, 29, "Var"], 20, 1, 20, 1, 20, 20, [0, 26, "Var"], 20, 1, 20, 1, 20, 20, 20, 1, 20, [0, 22, "VE"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 195
[ , 2, [6, 13], 2, 2, 1, 2, 2, 2, 2, [0, 114, "Ma"], 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 2, 2, [0, 84, "Vx"], 20, 20, 1, 2, 2, [0, 76, "Vx"], [0, 75, "Vx"], 1, 1, 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 20, [0, 66, "VE"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "VE"], 1, 20, [0, 58, "VE"], 1, 20, [0, 56, "VE"], 1, 20, [0, 54, "VE"], 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 34, "VE"], 20, [0, 33, "Var"], 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 196
[ , [6, 4], 3, [6, 36], 2, 2, [0, 126, "GO"], 2, 2, [0, 116, "MTS"], 2, 2, 20, 1, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 2, 2, 1, 1, 20, 20, [0, 82, "GW2"], [0, 80, "GW2"], 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], [0, 72, "Vx"], 1, 1, 1, 20, [0, 68, "Var"], 1, 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "Var"], 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 42, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 197
[ , 2, 2, 1, 2, 2, 3, 2, 2, 1, 2, 2, 2, 20, 1, 2, 20, 1, 2, 2, 1, 2, 20, 1, 2, 2, 20, 1, 2, 20, 3, 3, 2, [0, 76, "Vx"], 1, 1, 1, 1, 20, [0, 71, "Var"], [0, 70, "Var"], 1, 1, 20, [0, 67, "VE"], 1, 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 20, [0, 43, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 198
[ , 2, 2, 2, [22, 4, 1], [0, 129, "Gu1"], 2, 2, [0, 120, "BZ"], 1, 2, [0, 114, "BZ"], 2, 20, 20, [0, 108, "BZ"], 20, 20, [0, 102, "BZ"], [0, 99, "X6a"], 20, [0, 96, "BZ"], 20, 20, [0, 90, "BZ"], 2, 1, 20, [0, 84, "BZ"], 20, 3, 2, [0, 78, "BZ"], 1, 20, [0, 75, "VE"], [0, 74, "Var"], [0, 73, "Vx"], 1, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "VE"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "VE"], 1, 20, [0, 56, "VE"], 1, 20, [0, 54, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 20, [0, 45, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 199
[ , 2, 2, 2, 2, 2, 2, 2, 3, 2, [0, 117, "Ma"], 3, 2, 20, 20, 3, 20, 20, 3, 3, 20, 3, 20, 20, 1, 2, 20, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 20, [0, 72, "Var"], [0, 71, "Vx"], 1, 1, 20, [0, 68, "VE"], 1, 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "Var"], 1, 20, [0, 55, "Var"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 39, "Var"], 20, [0, 38, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 20, [0, 27, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 200
[ , [6, 4], [6, 9], [6, 40], 2, 2, 2, [0, 126, "BKW"], 2, [0, 119, "MTS"], 2, 2, 2, 1, 20, 3, 1, 20, 3, 3, 20, 3, 1, 20, 20, [0, 90, "XBZ"], [0, 86, "Vx"], 20, 1, 1, 1, 2, 20, [0, 78, "BZ"], [0, 77, "VE"], [0, 76, "Var"], [0, 75, "Var"], 1, 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "VE"], 1, 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "VE"], 1, 20, 1, 20, 20, [0, 37, "VE"], 20, [0, 36, "VE"], 20, [0, 35, "Var"], 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 201
[ , 2, 2, 1, 2, 2, [0, 129, "GW2"], 3, 2, 2, [0, 118, "MTS"], 2, 2, 1, 1, 2, 1, 1, 2, 3, 1, 2, 1, 1, 20, 3, 1, 20, 20, 1, 1, 2, 2, 1, 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 1, 20, [0, 69, "VE"], 1, 1, 20, [0, 66, "VE"], 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, [0, 56, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 34, "Var"], 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 202
[ , 2, 2, 20, [6, 81], [0, 132, "BKW"], 2, 3, [0, 122, "XB"], 2, 2, [0, 116, "XB"], [0, 114, "XBZ"], 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 3, 1, 1, 20, 20, 1, 2, [0, 80, "Vx"], 20, [0, 78, "Vx"], [0, 77, "Var"], [0, 76, "Vx"], 1, 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 20, [0, 68, "VE"], [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 54, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, [0, 44, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 20, [0, 29, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 24, "Var"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 203
[ , 2, 2, 20, 3, 2, 2, 2, 1, 2, 2, 2, 3, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 3, 1, 1, 2, 20, 20, [0, 85, "GW2"], 1, 1, 1, 1, 1, 20, [0, 75, "VE"], [0, 74, "Var"], 1, 1, 1, 20, [0, 70, "VE"], 1, 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "VE"], 1, 20, [0, 57, "VE"], 1, 20, [0, 55, "Var"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, [0, 45, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, 1, 20, 1, 20, 20, [0, 26, "VE"], 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 204
[ , [6, 4], [6, 9], 2, 3, 2, [0, 131, "GW2"], 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 20, 20, 3, 2, [0, 80, "Vx"], [0, 79, "Var"], [0, 78, "Var"], [0, 77, "Vx"], 1, 1, 1, 20, [0, 73, "VE"], [0, 72, "Var"], 1, 1, 20, [0, 69, "VE"], [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "VE"], 1, 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, [0, 50, "VE"], 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 20, [0, 28, "Var"], 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 205
[ , 2, 2, 2, 1, 2, 2, [0, 128, "BKW"], 1, 2, [0, 121, "MTS"], 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 2, 20, 1, 1, 2, 1, 20, 3, 2, 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 1, 20, [0, 71, "VE"], 1, 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 56, "VE"], 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, [0, 39, "Var"], 20, [0, 38, "Var"], 20, [0, 37, "Var"], 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 206
[ , 2, 2, [6, 10], 2, [0, 135, "Bo3"], 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 20, 1, 2, 1, 1, 2, 2, 2, [0, 80, "Var"], [0, 79, "Vx"], [0, 78, "Vx"], 1, 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 20, [0, 70, "VE"], [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 36, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 207
[ , 2, 2, 1, 2, 3, 2, 2, 1, 2, 2, [0, 120, "BZ"], 1, 2, 20, [0, 114, "BZ"], 20, 20, [0, 108, "BZ"], 2, 20, [0, 102, "BZ"], 20, 20, [0, 96, "BZ"], 1, 1, 20, [0, 90, "BZ"], 1, 1, 2, [0, 84, "BZ"], [0, 82, "Vx"], 1, 1, 1, 20, [0, 77, "Var"], [0, 76, "Var"], 1, 1, 1, 20, [0, 72, "VE"], 1, 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, [0, 34, "Var"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, [0, 25, "Var"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 208
[ , [6, 4], [6, 13], 2, [6, 87], 1, 2, 2, 20, [0, 126, "DaH"], 2, 3, 20, [0, 117, "DaH"], 20, 3, 20, 20, 3, 2, 20, 3, 20, 20, 3, 1, 1, 1, 1, 1, 1, 2, 3, 1, 2, [0, 80, "Vx"], 1, 1, 1, 1, 20, [0, 75, "VE"], [0, 74, "Var"], 1, 1, 20, [0, 71, "VE"], [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "VE"], 1, 20, [0, 58, "Var"], 1, 20, [0, 56, "Var"], 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 20, [0, 45, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 20, [0, 27, "VE"], 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 209
[ , 2, 3, 2, 2, 2, [0, 135, "GW2"], 2, 20, 3, [0, 124, "MTS"], 2, 20, 3, 20, 3, 1, 20, 3, [0, 105, "DaH"], 20, 3, 1, 20, 3, 1, 1, 1, 1, 1, 1, 2, 1, 2, [0, 82, "Vx"], 1, 20, [0, 79, "VE"], [0, 78, "Var"], [0, 77, "Vx"], 1, 1, 1, 20, [0, 73, "VE"], 1, 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 210
[ , 2, 2, [6, 10], 2, 2, 3, [0, 132, "Koh"], 2, 3, 2, 2, 1, 2, 1, 2, 1, 1, 2, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 84, "BZ"], 1, 2, 1, 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 20, [0, 72, "VE"], [0, 71, "Var"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 211
[ , 2, 2, 1, 2, [0, 138, "Bo3"], 3, 3, [0, 128, "XB"], 1, 2, [0, 122, "XB"], 1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 86, "Vx"], 2, [0, 83, "Vx"], [0, 82, "Vx"], 20, [0, 80, "VE"], [0, 79, "Var"], [0, 78, "Vx"], 1, 1, 1, 20, [0, 74, "Var"], 1, 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "Var"], 1, 20, [0, 58, "Var"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "VE"], 1, 20, 1, 20, 20, [0, 39, "VE"], 20, [0, 38, "VE"], 20, [0, 37, "Var"], 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, 1, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 212
[ , [6, 4], 2, 2, [6, 91], 3, 2, 3, 1, 1, 2, 2, [0, 120, "XBZ"], [0, 119, "GW2"], 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 85, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 77, "Var"], [0, 76, "Var"], 1, 1, 20, [0, 73, "VE"], [0, 72, "Var"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 36, "Var"], 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 20, [0, 28, "Var"], 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 213
[ , 2, [6, 9], 2, 2, 2, 2, 2, 1, 2, [0, 127, "MTS"], 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 84, "Vx"], [0, 83, "Vx"], [0, 82, "Vx"], [0, 81, "Var"], [0, 80, "Var"], [0, 79, "Vx"], 1, 1, 1, 20, [0, 75, "Var"], 1, 1, 1, 20, [0, 71, "Var"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, [0, 59, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 46, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 214
[ , 2, 2, [4, 2], 2, 2, 2, 2, 2, [0, 129, "MTS"], 2, 2, 20, 1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 86, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 78, "Var"], [0, 77, "Vx"], 1, 1, 20, [0, 74, "VE"], [0, 73, "Var"], 1, 1, 20, [0, 70, "Var"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 57, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 215
[ , 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 20, 20, 1, 2, 20, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, [0, 82, "Var"], [0, 81, "Vx"], 1, 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 1, 20, [0, 72, "Var"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 1, 20, 1, 20, [0, 60, "VE"], 1, 20, [0, 58, "Var"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, [0, 49, "Var"], 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 216
[ , [6, 4], 2, 20, [22, 4, 1], 2, [0, 139, "GO"], [0, 135, "BZ"], [0, 132, "BZ"], 1, 2, [0, 126, "BZ"], 20, 20, 20, [0, 120, "BZ"], 20, 20, [0, 114, "BZ"], 20, 20, [0, 108, "BZ"], 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 90, "BZ"], 2, [0, 86, "VE"], 20, [0, 84, "BZ"], 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], [0, 78, "Vx"], 1, 1, 20, [0, 75, "VE"], [0, 74, "Var"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 56, "VE"], 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, [0, 41, "Var"], 20, [0, 40, "Var"], 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 217
[ , 2, [6, 9], 2, 3, 2, 2, 2, 1, 1, 2, 3, 1, 20, 20, 3, 20, 20, 3, 20, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, [0, 88, "VE"], 1, 2, 1, 2, [0, 82, "Vx"], 1, 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 1, 20, [0, 73, "Var"], 1, 1, 20, [0, 70, "VE"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "VE"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 59, "VE"], 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 20, [0, 44, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, [0, 38, "VE"], 20, [0, 37, "Var"], 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 20, [0, 27, "VE"], 20, 20, 1, 20, [0, 25, "VE"], 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 218
[ , 2, 2, 2, 1, 2, 2, 2, 20, [0, 132, "MTS"], [0, 131, "Ma"], 2, 1, 1, 20, 3, 1, 20, 3, 1, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 87, "VE"], [0, 86, "VE"], 20, [0, 84, "Vx"], 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "VE"], [0, 75, "Var"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "VE"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, [0, 60, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 20, [0, 36, "Var"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 219
[ , 2, 2, [6, 19], 2, [0, 144, "BKW"], 2, 2, 1, 1, 2, 2, 2, 1, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 89, "Vx"], 1, 1, 2, 1, 2, 1, 1, 1, 20, [0, 79, "VE"], [0, 78, "Var"], 1, 1, 1, 20, [0, 74, "Var"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 58, "VE"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 220
[ , [6, 4], 2, 1, 2, 3, 2, [0, 138, "BZ"], 1, 1, 2, [0, 128, "XB"], 2, 20, [0, 122, "XB"], 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 92, "Vx"], 2, [0, 88, "Vx"], [0, 87, "VE"], [0, 86, "VE"], 20, [0, 84, "Vx"], 20, [0, 82, "VE"], [0, 81, "Var"], 1, 1, 1, 20, [0, 77, "VE"], [0, 76, "Var"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "VE"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "VE"], 1, 20, [0, 61, "VE"], 1, 20, [0, 59, "Var"], 1, 20, 1, 20, [0, 56, "VE"], 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 221
[ , 2, [6, 13], 2, [6, 100], 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], 1, 1, 1, 20, [0, 75, "Var"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, 1, 20, 1, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 222
[ , 2, 3, 2, 2, 2, [0, 144, "BKW"], 2, 20, [0, 135, "MTS"], [0, 134, "Ma"], 2, [0, 126, "BY"], 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 91, "Vx"], 2, [0, 88, "Vx"], [0, 87, "VE"], [0, 86, "VE"], 20, [0, 84, "Vx"], [0, 83, "Var"], [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "VE"], [0, 77, "Var"], 1, 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 60, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 20, [0, 44, "Var"], 1, 20, 1, 20, 20, 1, 20, [0, 40, "Var"], 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 223
[ , 2, 2, [6, 27], 2, 2, 3, 2, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 94, "Vx"], 2, [0, 90, "Vx"], 1, 1, 1, 1, 1, 1, 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 1, 20, [0, 76, "Var"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "VE"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "Var"], 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "VE"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, 1, 20, 1, 20, 20, 20, 20],
#V   n = 224
[ , [6, 4], 2, 1, 2, [0, 147, "Bo3"], 3, [0, 141, "BKW"], 1, 1, 2, 2, 20, 1, 1, 2, 20, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 92, "Vx"], 1, 2, [0, 88, "Vx"], [0, 87, "VE"], [0, 86, "VE"], [0, 85, "VE"], 1, 2, 1, 1, 1, 20, [0, 79, "VE"], [0, 78, "Var"], 1, 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 59, "Var"], 1, 20, 1, 20, [0, 56, "VE"], 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 48, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 20, [0, 37, "VE"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 20, [5, 111], 20, 1, 20, 20, 20, 20],
#V   n = 225
[ , 2, 2, 2, [22, 4, 1], 2, 3, 2, 1, 1, 2, [0, 132, "BZ"], 20, 20, 1, 2, 20, 20, [0, 120, "BZ"], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 91, "Vx"], [0, 90, "BZ"], 1, 1, 1, 1, 20, [0, 84, "BZ"], 20, [0, 82, "VE"], [0, 81, "Var"], 1, 1, 1, 20, [0, 77, "Var"], 1, 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "VE"], 1, 20, [0, 62, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 20, [0, 49, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 226
[ , 2, [6, 9], 2, 2, 2, 2, 2, 1, 2, [0, 137, "MTS"], 3, 1, 20, 20, [0, 126, "XBZ"], 1, 20, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 96, "Vx"], 2, 2, 3, [0, 89, "Vx"], [0, 88, "Vx"], [0, 87, "Vx"], [0, 86, "Var"], [0, 85, "Var"], 1, 1, 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], 1, 1, 20, [0, 76, "VE"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "VE"], 1, 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 60, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 20, [0, 27, "VE"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 227
[ , 2, 2, [6, 27], 2, 2, 2, 2, 20, [0, 139, "MTS"], 2, 2, 1, 1, 20, 3, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 94, "VE"], [0, 92, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 84, "Vx"], [0, 83, "Var"], [0, 82, "Var"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 63, "VE"], 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "VE"], 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 45, "Var"], 20, [0, 44, "Var"], 20, [0, 43, "Var"], 20, [0, 42, "Var"], 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 228
[ , [6, 4], 2, 1, 2, [0, 150, "Bo3"], [0, 146, "GO"], [0, 144, "BKW"], 1, 1, 2, 2, 2, 1, 2, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 2, [0, 90, "Vx"], [0, 89, "Vx"], [0, 88, "Vx"], [0, 87, "Var"], [0, 86, "Vx"], [0, 85, "Vx"], 1, 1, 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 20, [0, 77, "VE"], 1, 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 59, "VE"], 1, 20, 1, 20, [0, 56, "VE"], 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 229
[ , 2, 2, 20, [6, 108], 2, 2, 3, 1, 1, 2, [0, 134, "XB"], 2, 20, [0, 128, "XB"], 3, 20, [4, 14], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 98, "Vx"], [0, 95, "Vx"], 2, [0, 92, "Vx"], 1, 1, 1, 1, 1, 1, 20, [0, 84, "Var"], [0, 83, "Vx"], 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 20, [0, 76, "VE"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 62, "VE"], 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 230
[ , 2, [6, 9], 2, 3, 2, 2, 3, 1, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 94, "Vx"], 1, 2, [0, 90, "Vx"], [0, 89, "Vx"], [0, 88, "Vx"], [0, 87, "Vx"], 1, 1, 1, 1, 20, [0, 82, "Var"], [0, 81, "Var"], 1, 1, 20, [0, 78, "VE"], 1, 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 231
[ , 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, [0, 132, "BY"], 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, [0, 93, "Vx"], [0, 92, "VE"], 1, 1, 1, 1, 20, [0, 86, "VE"], [0, 85, "Var"], [0, 84, "Vx"], 1, 1, 1, 20, [0, 80, "Var"], 1, 1, 20, [0, 77, "VE"], 1, 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "VE"], 1, 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 61, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 232
[ , [6, 4], 2, [6, 32], 2, [0, 153, "BvE"], 2, 1, 1, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, [0, 90, "Vx"], [0, 89, "Vx"], [0, 88, "Vx"], 1, 1, 1, 1, 20, [0, 83, "Var"], [0, 82, "Vx"], 1, 1, 20, [0, 79, "VE"], 1, 1, 20, [0, 76, "VE"], 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "Var"], 1, 1, 20, 1, 1, 20, 1, 20, [0, 64, "VE"], 1, 20, [0, 62, "Var"], 1, 20, 1, 20, [0, 59, "VE"], 1, 20, 1, 20, [0, 56, "VE"], 1, 20, 1, 20, 1, 20, [0, 52, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 233
[ , 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 2, 20, 1, 2, 2, 20, 1, 2, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 101, "Vx"], [0, 98, "Vx"], 2, 2, [0, 93, "VE"], [0, 92, "VE"], 1, 1, 1, 20, [0, 87, "VE"], [0, 86, "Var"], [0, 85, "Vx"], 1, 1, 1, 20, [0, 81, "Var"], 1, 1, 20, [0, 78, "VE"], 1, 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, [0, 65, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "Var"], 20, [0, 45, "VE"], 20, [0, 44, "VE"], 20, [0, 43, "VE"], 20, [0, 42, "Var"], 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 234
[ , 2, [6, 13], 2, [22, 4, 1], 2, 2, 1, 1, 1, 2, [0, 138, "BZ"], 20, 20, [0, 132, "BZ"], 2, 1, 20, [0, 126, "BZ"], 1, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 97, "Vx"], [0, 95, "BZ"], 1, 1, 2, [0, 90, "Vx"], [0, 89, "Vx"], 1, 1, 1, 1, 20, [0, 84, "Var"], 1, 1, 1, 20, [0, 80, "VE"], 1, 1, 20, [0, 77, "VE"], [0, 76, "Var"], 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "Var"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 63, "VE"], 1, 20, 1, 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 20, [0, 54, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 235
[ , 2, 3, 2, 1, 2, 2, 1, 1, 1, 2, 3, 1, 20, 1, 2, 1, 1, 1, 1, 2, 20, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 99, "Vx"], 2, 2, [0, 94, "Vx"], [0, 93, "VE"], [0, 92, "Vx"], 1, 1, 20, [0, 88, "Var"], [0, 87, "Var"], 1, 1, 1, 20, [0, 83, "VE"], [0, 82, "Var"], 1, 1, 20, [0, 79, "VE"], [0, 78, "Var"], 1, 1, 20, 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, [0, 64, "Var"], 1, 20, 1, 20, [0, 61, "VE"], 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 55, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 50, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 236
[ , [6, 4], 2, [6, 36], 2, [0, 156, "Bo3"], [0, 153, "GW2"], 1, 1, 1, 2, 2, 1, 1, 20, [0, 132, "XBZ"], 1, 1, 1, 1, 2, 20, 20, 1, 1, 1, 1, 1, 1, 1, 1, 2, [0, 103, "Vx"], 2, [0, 98, "Vx"], [0, 96, "Vx"], 1, 1, 1, 2, 1, 1, 1, 1, 20, [0, 86, "VE"], [0, 85, "Var"], 1, 1, 1, 20, [0, 81, "VE"], 1, 1, 1, 20, [0, 77, "Var"], 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 62, "Var"], 1, 20, 1, 20, [0, 59, "VE"], 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 20, [0, 52, "Var"], 20, [0, 51, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 237
[ , 2, 2, 1, 2, 2, 3, 1, 1, 1, 2, 2, 1, 1, 2, 3, 1, 1, 1, 1, 2, 1, 20, 20, 1, 1, 1, 1, 1, 1, 1, 2, 2, [0, 100, "Vx"], 2, 2, [0, 95, "Vx"], [0, 94, "Vx"], [0, 93, "Vx"], [0, 92, "Vx"], 20, [0, 90, "VE"], [0, 89, "Var"], [0, 88, "Vx"], 1, 1, 1, 20, [0, 84, "VE"], [0, 83, "Var"], 1, 1, 20, [0, 80, "VE"], [0, 79, "Var"], 1, 1, 20, [0, 76, "Var"], 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "Var"], 1, 20, [0, 69, "VE"], 1, 20, [0, 67, "VE"], 1, 20, [0, 65, "Var"], 1, 20, [0, 63, "Var"], 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, 1, 20, [0, 53, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 238
[ , 2, 2, 2, [6, 117], 2, 3, 1, 1, 1, 2, [0, 140, "XB"], 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 20, 20, 1, 1, 1, 1, 1, 1, 2, 2, 2, [0, 99, "Vx"], [0, 97, "Vx"], 1, 1, 1, 1, 1, 1, 1, 1, 20, [0, 87, "VE"], [0, 86, "Var"], 1, 1, 1, 20, [0, 82, "VE"], 1, 1, 1, 20, [0, 78, "Var"], 1, 1, 20, 1, 1, 20, [0, 73, "VE"], 1, 1, 20, [0, 70, "Var"], 1, 20, [0, 68, "Var"], 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 20, [0, 54, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 47, "Var"], 20, [0, 46, "Var"], 20, [0, 45, "Var"], 20, [0, 44, "Var"], 20, 1, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 1, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 239
[ , 2, [6, 9], 2, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 20, 1, 1, 1, 1, 2, 1, 1, 1, 20, 20, 1, 1, 1, 1, 1, 2, [0, 105, "Vx"], 2, 2, 1, 1, 2, [0, 94, "Vx"], [0, 93, "Vx"], [0, 92, "Vx"], [0, 91, "VE"], [0, 90, "Var"], [0, 89, "Vx"], 1, 1, 1, 20, [0, 85, "VE"], [0, 84, "Var"], 1, 1, 20, [0, 81, "VE"], [0, 80, "Var"], 1, 1, 20, [0, 77, "Var"], 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 64, "Var"], 1, 20, 1, 1, 20, 1, 20, 1, 1, 20, 1, 20, 1, 20, [0, 55, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, [0, 49, "Var"], 20, [0, 48, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 20, [0, 43, "VE"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 1, 2, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 240
[ , [6, 4], 2, [6, 40], 1, 2, [0, 154, "GO"], 1, 1, 1, 2, 2, 1, 1, 2, 2, 20, 1, 1, 1, 2, 20, 1, 1, 1, 20, 20, 1, 1, 1, 1, 2, 2, [0, 102, "Vx"], [0, 100, "Vx"], [0, 98, "Vx"], [0, 97, "Vx"], [0, 96, "BZ"], 1, 1, 1, 1, 1, 1, 20, [0, 88, "VE"], [0, 87, "Var"], 1, 1, 1, 20, [0, 83, "VE"], 1, 1, 1, 20, [0, 79, "Var"], 1, 1, 20, [0, 76, "Var"], 1, 20, [0, 74, "VE"], 1, 1, 20, [0, 71, "Var"], 1, 20, [0, 69, "Var"], 1, 20, [0, 67, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 62, "VE"], 1, 20, 1, 20, [0, 59, "VE"], 1, 20, 1, 20, [0, 56, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 51, "Var"], 20, [0, 50, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 1, 2, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 241
[ , 2, 2, 1, 1, 2, 2, 20, 1, 1, 2, 2, 20, 1, 2, 2, 20, 20, 1, 1, 2, 20, 20, 1, 1, 2, 20, 20, 1, 1, 1, 2, 2, 2, 2, 1, 2, 1, 1, 2, [0, 93, "VE"], [0, 92, "Var"], [0, 91, "Var"], [0, 90, "Vx"], 1, 1, 1, 20, [0, 86, "VE"], [0, 85, "Var"], 1, 1, 20, [0, 82, "VE"], [0, 81, "Var"], 1, 1, 20, [0, 78, "Var"], 1, 1, 20, 1, 1, 20, [0, 73, "VE"], 1, 1, 20, 1, 1, 20, 1, 1, 20, 1, 20, [0, 65, "VE"], 1, 20, [0, 63, "Var"], 1, 20, 1, 20, [0, 60, "Var"], 1, 20, 1, 20, [0, 57, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 52, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 1, 2, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 2, [0, 28, "Vx"], 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 242
[ , 2, 2, 20, 1, 2, 2, 20, 20, 1, 2, 2, 20, 20, [0, 138, "MTS"], [0, 135, "Ma"], 20, 20, 20, 1, 2, 2, 20, 20, 1, 2, 20, 20, 20, 1, 1, 2, [0, 107, "Vx"], 2, 2, 2, [0, 98, "Vx"], 20, 1, 2, 1, 1, 1, 1, 20, [0, 89, "Var"], [0, 88, "Var"], 1, 1, 1, 20, [0, 84, "VE"], 1, 1, 1, 20, [0, 80, "Var"], 1, 1, 20, [0, 77, "Var"], 1, 20, [0, 75, "VE"], 1, 1, 20, [0, 72, "Var"], 1, 20, [0, 70, "VE"], 1, 20, [0, 68, "VE"], 1, 20, [0, 66, "Var"], 1, 20, 1, 1, 20, 1, 20, [0, 61, "Var"], 1, 20, 1, 20, [0, 58, "Var"], 1, 20, 1, 20, 1, 20, 1, 20, [0, 53, "VE"], 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 20, 20, 1, 2, 1, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 2, 20, 20, 20, 1, 20, 20, 20, 20, 1, 1, 20, 20, 20, 1, 20, 20, 20, 20, 1, 20, 1, 20, 20, 1, 20, 20, 20, 20],
#V   n = 243
[ , [6, 3], [6, 9], 20, 20, [22, 5, 1], [0, 156, "Koh"], 20, 20, 20, [0, 153, "XBC"], [0, 144, "BZ"], 20, 20, 3, 3, 20, 20, 20, 20, [0, 132, "XBC"], [0, 128, "NBC"], 20, 20, 20, [0, 126, "XBC"], 20, 20, 20, 20, [0, 123, "XBC"], [0, 122, "XBC"], 3, [0, 104, "Vx"], [0, 102, "BZ"], [0, 100, "BZ"], 3, [0, 97, "Vx"], 20, [0, 96, "BZ"], [0, 94, "Vx"], [0, 93, "Var"], [0, 92, "Vx"], [0, 91, "Vx"], [0, 90, "Vx"], 3, 3, 20, [0, 87, "VE"], [0, 86, "Var"], [0, 85, "Vx"], 3, 20, [0, 83, "VE"], [0, 82, "Var"], [0, 81, "Vx"], 3, 20, [0, 79, "Var"], [0, 78, "Vx"], 3, 20, [0, 76, "Var"], 3, 20, [0, 74, "VE"], [0, 73, "Var"], 3, 20, [0, 71, "Var"], 3, 20, [0, 69, "Var"], 3, 20, [0, 67, "Var"], 3, 20, [0, 65, "Var"], 20, [0, 64, "VE"], [0, 63, "Vx"], 20, [0, 62, "Var"], 3, 20, [0, 60, "Vx"], 20, [0, 59, "Var"], 3, 20, [0, 57, "Vx"], 20, [0, 56, "Var"], 20, [0, 55, "Var"], 20, [0, 54, "VE"], 3, 20, [0, 52, "Vx"], 20, [0, 51, "Var"], 20, [0, 50, "Var"], 20, [0, 49, "Var"], 20, [0, 48, "Var"], 20, [0, 47, "Var"], 20, [0, 46, "Var"], 20, [0, 45, "Var"], 20, [0, 44, "XBC"], 20, [0, 43, "Var"], 20, 20, [0, 42, "XBC"], 20, 20, 20, 20, [0, 41, "XBC"], 20, 20, 20, 20, [0, 39, "XBC"], [0, 37, "Vx"], 20, 20, 20, [0, 36, "XBC"], 20, 20, 20, 20, [0, 35, "XBC"], 20, 20, 20, 20, [0, 33, "XBC"], 20, 20, 20, 20, [0, 32, "XBC"], [0, 29, "Vx"], [0, 28, "Vx"], 20, 20, [0, 27, "XBC"], 20, 20, 20, 20, [0, 26, "XBC"], [0, 25, "BCH"], 20, 20, 20, [0, 24, "XBC"], 20, 20, 20, 20, [0, 23, "XBC"], 20, 20, 20, 20, [0, 21, "XBC"], 20, 20, 20, 20, [0, 20, "XBC"], [0, 19, "BCH"], 20, 20, 20, [0, 18, "XBC"], 20, 20, 20, 20, [0, 17, "XBC"], 20, 20, 20, 20, [0, 15, "XBC"], 20, 20, 20, 20, [0, 14, "XBC"], [0, 13, "BCH"], 20, 20, 20, [0, 12, "XBC"], 20, 20, 20, 20, [0, 11, "XBC"], 20, 20, 20, 20, [0, 9, "XBC"], 20, 20, 20, 20, [0, 8, "XBC"], [0, 7, "BCH"], 20, 20, 20, [0, 6, "XBC"], 20, 20, 20, 20, [0, 5, "XBC"], 20, 1, 20, 20, [0, 3, "Ham"], 20, 20, 20, 20],
#V   n = 244
[ , 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, [5, 121], 3, 3, 3, 3, 3, 3, 3, 3]];


GUAVA_BOUNDS_TABLE[2][3] := [
#V   n = 1
[ ],
#V   n = 2
[ ],
#V   n = 3
[ ],
#V   n = 4
[ ,],
#V   n = 5
[ , [15, 3], [14, 3]],
#V   n = 6
[ , [15, 4], [15, 3], 11],
#V   n = 7
[ , [15, 5], [15, 4], [15, 3], 11],
#V   n = 8
[ , [15, 6], [15, 5], [15, 4], [15, 3], 11],
#V   n = 9
[ , [15, 6], [15, 6], [15, 5], [15, 4], [15, 3], 11],
#V   n = 10
[ , [15, 7], [15, 6], [15, 6], [15, 5], [15, 4], [15, 3], 11],
#V   n = 11
[ , [15, 8], [15, 7], [15, 6], [15, 6], [15, 5], [14, 6], [15, 3], 11],
#V   n = 12
[ , [15, 9], [15, 8], [16, 6], [15, 6], [15, 6], 12, 11, [15, 3], 11],
#V   n = 13
[ , [15, 9], [15, 9], [16, 7], [16, 6], [15, 6], 12, 11, 11, [15, 3], 11],
#V   n = 14
[ , [15, 10], [15, 9], [16, 8], [16, 7], [16, 6], [15, 6], 11, 11, 11, [14, 9], 11],
#V   n = 15
[ , [15, 11], [15, 9], [15, 9], [16, 8], [16, 7], [16, 6], [0, 5, "vE2"], [0, 4, "vE2"], 11, 11, 11, 11],
#V   n = 16
[ , [15, 12], [15, 10], [15, 9], [15, 9], [0, 7, "vE2"], [0, 6, "vE2"], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 17
[ , [15, 12], [15, 11], [15, 10], [15, 9], 12, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 18
[ , [15, 13], [15, 12], [15, 11], [15, 10], [15, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 19
[ , [15, 14], [15, 12], [15, 12], [15, 11], [14, 4], [15, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 20
[ , [15, 15], [15, 13], [15, 12], [15, 12], 12, 11, [15, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 21
[ , [15, 15], [15, 14], [0, 12, "HN"], [15, 12], 12, 11, [16, 9], [15, 9], 11, 11, [16, 6], [16, 6], 11, 11, [0, 3, "Pel"], 11, 11, 11],
#V   n = 22
[ , [15, 16], [15, 15], 12, 11, [15, 12], 11, [16, 10], [16, 9], [15, 9], 11, [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 23
[ , [15, 17], [15, 15], 12, 11, 11, [15, 12], [16, 11], [16, 10], [16, 9], [15, 9], [16, 8], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 24
[ , [15, 18], [15, 16], [15, 15], 11, 11, 11, [0, 11, "BS"], [16, 11], [16, 10], [16, 9], [15, 9], [16, 8], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 25
[ , [15, 18], [15, 17], [15, 16], [15, 15], 11, 11, [16, 12], 11, [16, 11], [16, 10], [16, 9], [0, 8, "LP"], [16, 8], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 26
[ , [15, 19], [15, 18], [15, 17], [14, 3], [15, 15], 11, [16, 13], [16, 12], 11, [16, 11], [16, 10], [16, 9], 11, [16, 8], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 27
[ , [15, 20], [15, 18], [15, 18], 12, 11, [15, 15], [16, 14], [14, 6], [16, 12], 11, [16, 11], [16, 10], [16, 9], 11, [14, 11], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 28
[ , [15, 21], [15, 18], [15, 18], 12, [0, 15, "HHM"], 11, [15, 15], 12, [16, 12], [16, 12], 11, [16, 11], [16, 10], [16, 9], 11, 11, [14, 12], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 29
[ , [15, 21], [15, 19], [15, 18], [15, 18], 12, 11, [16, 15], 12, [16, 13], [16, 12], [16, 12], 11, [16, 11], [16, 10], [16, 9], 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11],
#V   n = 30
[ , [15, 22], [15, 20], [15, 19], [15, 18], 12, 11, 11, [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 11, [16, 11], [14, 11], [16, 9], 11, 11, 11, [16, 6], [14, 15], 11, 11, 11, 11, 11, 11],
#V   n = 31
[ , [15, 23], [15, 21], [15, 20], [16, 18], [15, 18], 11, 11, [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 11, 12, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 32
[ , [15, 24], [15, 21], [15, 21], [16, 19], [16, 18], [15, 18], 11, [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 11, [16, 10], [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 33
[ , [15, 24], [15, 22], [15, 21], [16, 20], [16, 19], [16, 18], [15, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], [16, 11], [0, 9, "LP"], [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, [14, 18], 11, 11, 11, 11, 11],
#V   n = 34
[ , [15, 25], [15, 23], [15, 22], [15, 21], [16, 20], [16, 19], [16, 18], [15, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 12, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 35
[ , [15, 26], [15, 24], [15, 23], [16, 21], [0, 20, "Bou"], [16, 20], [16, 18], [16, 18], [15, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 12, 11, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 36
[ , [15, 27], [15, 24], [15, 24], [16, 22], [16, 21], 11, [16, 19], [16, 18], [16, 18], [15, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 37
[ , [15, 27], [15, 25], [15, 24], [16, 23], [0, 21, "Bou"], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [0, 17, "LP"], [16, 17], [14, 9], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 38
[ , [15, 28], [15, 26], [15, 25], [15, 24], 12, [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 12, 11, [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 39
[ , [15, 29], [15, 27], [15, 26], [16, 24], 12, [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], [16, 9], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 40
[ , [15, 30], [15, 27], [15, 27], [0, 24, "vE1"], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], [0, 8, "LP"], 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 41
[ , [15, 30], [15, 27], [15, 27], 12, 11, [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, [14, 27], 11, 11],
#V   n = 42
[ , [15, 31], [15, 28], [15, 27], 12, 11, [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], [0, 14, "BKn"], [16, 14], [14, 15], [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 43
[ , [15, 32], [15, 29], [15, 27], [15, 27], 11, [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [14, 8], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], 11, 12, 11, [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 44
[ , [15, 33], [15, 30], [15, 28], [15, 27], [15, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 45
[ , [15, 33], [15, 30], [15, 29], [15, 28], [15, 27], [15, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [14, 8], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 46
[ , [15, 34], [15, 31], [15, 30], [15, 29], [15, 28], [15, 27], [0, 26, "Gur"], [16, 26], [14, 6], [16, 24], [16, 24], 12, 11, [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 15], [16, 15], 11, 11, [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 47
[ , [15, 35], [15, 32], [15, 30], [15, 30], [0, 28, "HJ"], [16, 27], [15, 27], 11, 12, 11, [16, 24], 12, 11, 11, [16, 21], 11, [16, 20], [16, 18], [16, 18], [16, 18], 11, [16, 16], [16, 15], [16, 15], 11, [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 48
[ , [15, 36], [15, 33], [15, 31], [15, 30], 12, [16, 28], [16, 27], [15, 27], 11, 11, 11, [16, 24], 11, 11, 11, [16, 21], 11, [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 49
[ , [15, 36], [15, 33], [15, 32], [15, 31], [15, 30], [16, 29], [16, 28], [16, 27], [15, 27], 11, 11, 11, [16, 24], 11, 11, [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], [16, 15], [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, 11, [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 50
[ , [15, 37], [15, 34], [15, 33], [0, 31, "EHW"], [0, 30, "HJL"], [15, 30], [16, 29], [16, 28], [16, 27], [15, 27], 11, 11, [16, 24], [16, 24], 11, [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], [0, 14, "BKn"], [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, [16, 8], [16, 7], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 51
[ , [15, 38], [15, 35], [15, 33], 12, 11, [16, 30], [15, 30], [16, 29], [16, 28], [16, 27], [15, 27], 11, [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, [16, 8], [0, 6, "BKn"], [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 52
[ , [15, 39], [15, 36], [15, 34], [15, 33], 11, [16, 31], [16, 30], [15, 30], [16, 29], [16, 28], [16, 27], [15, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [16, 9], 11, 12, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 53
[ , [15, 39], [15, 36], [15, 35], [15, 34], [15, 33], [16, 32], [16, 31], [16, 30], [15, 30], [14, 6], [16, 28], [16, 27], [15, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [16, 18], [16, 17], [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, [0, 8, "sp"], 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 54
[ , [15, 40], [15, 36], [15, 36], [15, 35], [15, 34], [15, 33], [16, 32], [16, 31], [16, 30], 12, 11, [16, 28], [16, 27], [15, 27], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], [0, 17, "LP"], [16, 17], [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 55
[ , [15, 41], [15, 37], [15, 36], [15, 36], [15, 35], [16, 33], [0, 32, "Gur"], [0, 31, "Gur"], [16, 31], [16, 30], 11, 11, [14, 8], [16, 27], [0, 26, "BKn"], [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, [0, 16, "BKn"], [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], 11, 11, 11, 11, 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 56
[ , [15, 42], [15, 38], [15, 36], [15, 36], [15, 36], [16, 34], [16, 33], 11, 11, [14, 6], [16, 30], 11, 11, 11, [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], [16, 12], [0, 10, "LP"], 11, 11, 11, 11, 11, 11, [16, 6], [16, 6], 11, 11, 11, 11, 11, 11, 11],
#V   n = 57
[ , [15, 42], [15, 39], [15, 37], [15, 36], [15, 36], [16, 35], [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 11, [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], 12, 11, 11, 11, 11, 11, 11, 11, [16, 6], [16, 6], [0, 4, "Jo"], 11, [14, 36], 11, 11, 11, 11],
#V   n = 58
[ , [15, 43], [15, 39], [15, 38], [16, 36], [15, 36], [0, 35, "BKn"], [16, 35], [16, 33], [16, 33], 11, 11, 11, [16, 30], 11, 11, [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 12, 11, 11, 11, 11, 11, 11, 11],
#V   n = 59
[ , [15, 44], [15, 40], [15, 39], [16, 37], [16, 36], [15, 36], 11, [16, 34], [16, 33], [16, 33], 11, 11, 11, [16, 30], 11, [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [0, 23, "BKn"], [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, [16, 14], [16, 13], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 60
[ , [15, 45], [15, 41], [15, 39], [16, 38], [16, 37], [16, 36], [15, 36], [16, 35], [16, 34], [16, 33], [16, 33], 11, 11, 11, [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [0, 25, "BKn"], [16, 25], [16, 24], 11, [16, 23], [16, 22], [16, 21], [16, 21], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, [16, 14], [0, 12, "BKn"], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 61
[ , [15, 45], [15, 42], [15, 40], [15, 39], [16, 38], [16, 37], [16, 36], [15, 36], [16, 35], [16, 34], [16, 33], [16, 33], 11, 11, 11, [0, 29, "BKn"], [16, 29], [16, 27], [16, 27], [16, 27], 11, 11, [16, 25], [16, 24], 11, [16, 23], [16, 22], [16, 21], [0, 20, "LP"], [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [16, 15], 11, 12, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 62
[ , [15, 46], [15, 42], [15, 41], [16, 39], [15, 39], [16, 38], [14, 4], [16, 36], [0, 35, "Gur"], [16, 35], [16, 34], [16, 33], [0, 32, "BKn"], 11, 11, [16, 30], 11, [16, 28], [16, 27], [16, 27], [16, 27], 11, 11, [14, 16], [16, 24], 11, [16, 23], [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [14, 25], [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 63
[ , [15, 47], [15, 43], [15, 42], [16, 40], [16, 39], [15, 39], 12, 11, [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, 11, [16, 31], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], [16, 27], 11, 11, 11, [16, 24], 11, [16, 23], [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 64
[ , [15, 48], [15, 44], [15, 42], [16, 41], [16, 40], [16, 39], 12, 11, [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [0, 31, "BKn"], [16, 31], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], [16, 27], 11, 11, 11, [16, 24], 11, [0, 22, "BKn"], [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], [0, 16, "BKn"], 11, 11, [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 65
[ , [15, 48], [15, 45], [15, 43], [15, 42], [16, 41], [16, 40], [16, 39], 11, [16, 37], [16, 36], [16, 36], 11, [0, 34, "BKn"], [16, 34], [16, 33], 11, 11, [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], [16, 27], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], 12, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 66
[ , [15, 49], [15, 45], [15, 44], [16, 42], [15, 42], [16, 41], [14, 4], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], [0, 26, "BKn"], 11, [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 67
[ , [15, 50], [15, 45], [15, 45], [16, 43], [16, 42], [0, 41, "BKn"], 12, 11, [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [0, 33, "BKn"], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [14, 22], [16, 21], 11, [16, 20], [0, 18, "BKn"], [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, [14, 34], [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 68
[ , [15, 51], [15, 46], [15, 45], [16, 44], [16, 43], [16, 42], 11, 11, [16, 39], [0, 38, "Gur"], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 21], 11, 12, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, [16, 9], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 69
[ , [15, 51], [15, 47], [15, 45], [15, 45], [0, 43, "Ma"], [0, 42, "Gur"], [16, 42], 11, [16, 40], [16, 39], 11, [16, 38], [16, 37], [16, 36], [0, 35, "LP"], 11, 11, [16, 33], [0, 32, "BKn"], [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 21], 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], [0, 10, "BKn"], 11, 11, [0, 8, "BKn"], 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 70
[ , [15, 52], [15, 48], [15, 46], [15, 45], 12, 11, 11, [16, 42], [16, 41], [16, 40], [16, 39], 11, [0, 37, "BKn"], [14, 8], [16, 36], 11, 11, [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 21], 11, 11, [16, 18], [16, 18], 11, 11, 11, 11, 11, 11, 11, [16, 12], 12, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 71
[ , [15, 53], [15, 48], [15, 47], [0, 45, "HW1"], [15, 45], 11, 11, 11, [16, 42], [0, 40, "Gur"], [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [16, 26], [16, 25], [16, 24], [0, 23, "LP"], 11, 11, 11, [0, 20, "BKn"], 11, [16, 19], [16, 18], [16, 18], 11, 11, 11, 11, 11, 11, [0, 12, "BKn"], [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 72
[ , [15, 54], [15, 49], [15, 48], 12, [16, 45], [15, 45], 11, 11, [16, 42], 12, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, [0, 34, "BKn"], [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], [16, 29], [16, 28], [16, 27], [16, 27], 11, [0, 25, "LP"], [16, 25], [16, 24], 11, 11, 11, 11, 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, 11, 11, 12, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 73
[ , [15, 54], [15, 50], [15, 48], 12, [16, 46], [16, 45], [0, 44, "LP"], 11, [16, 43], [16, 42], 11, 11, [0, 39, "BKn"], [16, 39], 11, 11, 11, [16, 36], 11, 11, [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], [0, 29, "BKn"], [16, 29], [16, 28], [16, 27], [16, 27], 11, 11, [16, 25], [16, 24], 11, [0, 22, "LP"], 11, 11, 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 74
[ , [15, 55], [15, 51], [15, 49], [15, 48], [16, 47], [16, 45], [16, 45], 11, [16, 44], [0, 42, "Da"], [16, 42], 11, 11, 11, [16, 39], 11, 11, 11, [16, 36], 11, 11, [0, 33, "BKn"], [16, 33], 11, [0, 31, "BKn"], [16, 31], [16, 30], 11, [16, 29], [16, 28], [16, 27], [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, 11, [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, [16, 15], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, [0, 6, "Jo"], 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 75
[ , [15, 56], [15, 51], [15, 50], [0, 48, "HN"], [15, 48], [16, 46], [16, 45], [16, 45], 11, 12, 11, [16, 42], 11, 11, 11, [0, 38, "Da"], 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], 11, 11, [16, 31], [16, 30], 11, [16, 29], [16, 28], [16, 27], [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, [16, 16], [0, 14, "BKn"], 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 12, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 76
[ , [15, 57], [15, 52], [15, 51], 12, [16, 48], [16, 47], [16, 46], [16, 45], [16, 45], 11, 11, 11, [0, 41, "BKn"], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], 11, 11, [16, 31], [16, 30], 11, [16, 29], [16, 28], [16, 27], [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 12, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 77
[ , [15, 57], [15, 53], [15, 51], 12, [16, 49], [16, 48], [16, 47], [16, 46], [16, 45], [0, 44, "BKn"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 35, "Da"], 11, 11, 11, [16, 33], 11, 11, [16, 31], [16, 30], 11, [16, 29], [16, 28], [16, 27], [16, 27], 11, 11, [0, 24, "LP"], [16, 24], 11, 11, [16, 22], [16, 21], 11, [16, 20], [16, 19], [16, 18], [16, 18], 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 78
[ , [15, 58], [15, 54], [15, 52], [15, 51], [16, 50], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], 11, 11, 11, 11, 11, [0, 40, "Da"], 11, 11, 11, [0, 37, "LP"], 11, 11, 11, 11, 11, 11, [16, 33], 11, 11, [0, 30, "LP"], [16, 30], 11, [16, 29], [16, 28], [16, 27], [0, 26, "LP"], 11, 11, [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], 11, [0, 19, "LP"], [0, 18, "LP"], [16, 18], [16, 18], [0, 16, "LP"], 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 79
[ , [15, 59], [15, 54], [15, 53], [15, 52], [15, 51], [16, 49], [16, 48], [16, 48], [16, 47], [16, 46], [16, 45], 11, [0, 43, "BKn"], [0, 42, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, 11, 11, [16, 30], 11, [0, 28, "LP"], [16, 28], [16, 27], 11, 11, [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], 11, 11, 11, [16, 18], 12, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 80
[ , [15, 60], [15, 54], [15, 54], [15, 53], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [0, 46, "BKn"], [14, 6], [16, 45], 11, 11, 11, 11, 11, 11, [0, 39, "Da"], 11, 11, 11, [16, 37], [16, 36], 11, 11, 11, 11, [0, 32, "LP"], 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [0, 20, "LP"], 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 81
[ , [15, 60], [15, 55], [15, 54], [15, 54], [0, 51, "Ma"], [16, 51], [16, 50], [16, 49], [16, 48], 12, 11, 11, [16, 45], 11, 11, 11, [0, 41, "Da"], 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 12, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 82
[ , [15, 61], [15, 56], [15, 54], [15, 54], 12, [16, 51], [0, 50, "BKn"], [16, 50], [16, 49], [16, 48], 11, 11, 11, [0, 44, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "Da"], [16, 36], 11, [0, 34, "LP"], 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 83
[ , [15, 62], [15, 57], [15, 54], [15, 54], 12, [16, 52], [16, 51], 11, [16, 50], [0, 48, "BKn"], [16, 48], 11, 11, [16, 45], 11, 11, 11, 11, 11, [0, 40, "Da"], 11, 11, [0, 38, "Da"], 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [0, 23, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 84
[ , [15, 63], [15, 57], [15, 55], [15, 54], [15, 54], [16, 53], [16, 52], [16, 51], 11, 12, 11, [0, 47, "LP"], 11, [16, 46], [16, 45], 11, [0, 43, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [0, 25, "LP"], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 85
[ , [15, 63], [15, 58], [15, 56], [15, 55], [15, 54], [15, 54], [0, 52, "BKn"], [16, 52], [16, 51], 11, 11, 11, 11, 13, [16, 46], [16, 45], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, [0, 33, "LP"], 11, 11, [0, 31, "LP"], 11, 11, [0, 29, "LP"], 11, 11, [0, 27, "LP"], [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 86
[ , [15, 64], [15, 59], [15, 57], [15, 56], [16, 54], [15, 54], 12, 11, [16, 52], [0, 50, "BKn"], [0, 49, "Da"], 11, 11, [0, 46, "Da"], 11, [16, 46], [16, 45], 11, 11, [0, 42, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, [16, 12], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 87
[ , [15, 65], [15, 60], [15, 57], [15, 57], [16, 55], [16, 54], [15, 54], 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 45, "Da"], [16, 45], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 35, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, 11, 11, [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 12, 11, 11, [16, 12], [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 88
[ , [15, 66], [15, 60], [15, 58], [15, 57], [16, 56], [16, 55], [16, 54], [15, 54], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, [16, 45], 11, 11, 11, 11, 11, 11, [0, 39, "Da"], 11, 11, [0, 37, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 31], [16, 30], 11, 11, 11, 11, [16, 27], 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 89
[ , [15, 66], [15, 61], [15, 59], [15, 58], [15, 57], [16, 56], [16, 55], [16, 54], [15, 54], [0, 52, "BKn"], [0, 51, "BKn"], [16, 51], 11, 11, 11, 11, 11, 11, 11, [0, 44, "Da"], 11, 11, 11, [0, 41, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 31], [16, 30], 11, 11, 11, 11, [0, 26, "LP"], 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 90
[ , [15, 67], [15, 62], [15, 60], [15, 59], [16, 57], [15, 57], [16, 56], [16, 54], [16, 54], 12, 11, 11, [16, 51], [0, 49, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 91
[ , [15, 68], [15, 63], [15, 60], [15, 60], [16, 58], [16, 57], [0, 56, "BKn"], [16, 55], [16, 54], [16, 54], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 43, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "LP"], 11, 11, [0, 32, "LP"], 11, 11, [16, 31], [16, 30], 11, [0, 28, "LP"], 11, 11, 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, [16, 18], [0, 16, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "sp"], 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 92
[ , [15, 69], [15, 63], [15, 61], [15, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 55], [16, 54], [0, 53, "Da"], 11, 11, 11, 11, 11, [0, 48, "Da"], 11, 11, 11, [0, 45, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 93
[ , [15, 69], [15, 63], [15, 62], [0, 60, "HH"], [15, 60], [16, 59], [16, 58], [16, 57], [16, 56], [16, 55], [16, 54], 11, 11, [0, 51, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "LP"], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 94
[ , [15, 70], [15, 64], [15, 63], 12, [16, 60], [15, 60], [0, 58, "BKn"], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "Da"], 11, 11, 11, 11, 11, [0, 38, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 24], [16, 24], 11, [0, 22, "sp"], 11, 11, 11, 11, [16, 19], [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 95
[ , [15, 71], [15, 65], [15, 63], 12, [16, 61], [16, 60], 12, [16, 58], [16, 57], [0, 56, "BKn"], [0, 55, "BKn"], [16, 55], [16, 54], 11, 11, 11, [0, 50, "Da"], 11, 11, 11, [0, 47, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, 11, [16, 27], 11, 11, [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, [16, 20], [0, 18, "sp"], [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 96
[ , [15, 72], [15, 66], [15, 63], [15, 63], [0, 61, "Gur"], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, 11, [16, 55], [0, 53, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, 12, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 97
[ , [15, 72], [15, 66], [15, 64], [15, 63], 12, [16, 61], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, 11, 12, 11, 11, 11, 11, 11, [0, 49, "Da"], 11, 11, 11, [0, 46, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, [16, 21], 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 98
[ , [15, 73], [15, 67], [15, 65], [15, 64], [15, 63], [16, 62], [16, 61], [16, 60], [0, 59, "LP"], [0, 58, "BKn"], [0, 57, "BKn"], [16, 57], 11, 11, 11, 11, [0, 52, "Da"], [0, 51, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 37, "LP"], 11, 11, [0, 35, "LP"], 11, 11, [0, 33, "LP"], 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [16, 21], 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 99
[ , [15, 74], [15, 68], [15, 66], [15, 65], [16, 63], [15, 63], [16, 62], [16, 61], [16, 60], 11, 11, 11, [16, 57], [0, 55, "Da"], [0, 54, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 43, "LP"], 11, 11, [0, 41, "LP"], 11, 11, [0, 39, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, [16, 22], [0, 20, "sp"], 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], [0, 4, "Jo"], 11, 11, 11, 11, 11, 11, 11],
#V   n = 100
[ , [15, 75], [15, 69], [15, 66], [15, 66], [16, 64], [16, 63], [0, 62, "BKn"], [14, 4], [16, 61], [16, 60], [0, 58, "BKn"], 11, 11, 12, 11, 11, 11, 11, 11, 11, [0, 50, "Da"], 11, 11, [0, 48, "Da"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 12, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 101
[ , [15, 75], [15, 69], [15, 67], [15, 66], [16, 65], [16, 63], [16, 63], 11, 11, [0, 60, "BKn"], 12, 11, 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 45, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 102
[ , [15, 76], [15, 70], [15, 68], [15, 67], [15, 66], [16, 64], [16, 63], [16, 63], 11, 11, 11, 11, 11, [0, 57, "LP"], [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 47, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 103
[ , [15, 77], [15, 71], [15, 69], [15, 68], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], 11, [0, 60, "BKn"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, 11, [0, 49, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], 11, 11, 11, 11, 11, 11, 11, [16, 18], 11, 11, 11, [0, 14, "sp"], 11, 11, [0, 12, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 104
[ , [15, 78], [15, 72], [15, 69], [15, 69], [16, 67], [16, 66], [16, 65], [16, 64], [16, 63], [0, 62, "BKn"], 12, 11, [16, 60], 11, 11, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "LP"], 11, 11, [0, 40, "LP"], 11, 11, [0, 38, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], [16, 24], [0, 22, "sp"], 11, 11, 11, 11, 11, 11, [16, 18], [0, 16, "sp"], 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 105
[ , [15, 78], [15, 72], [15, 70], [15, 69], [0, 67, "DM5"], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], 11, 11, 11, [0, 59, "BKn"], [0, 58, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 51, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "LP"], 11, 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 106
[ , [15, 79], [15, 72], [15, 71], [15, 70], 12, [16, 67], [16, 66], [16, 66], [16, 65], [16, 64], [0, 62, "BKn"], 11, 11, 11, 11, 11, 11, [0, 56, "LP"], 11, 11, [0, 54, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 107
[ , [15, 80], [15, 73], [15, 72], [15, 71], [16, 69], [16, 68], [16, 67], [16, 66], [0, 65, "LP"], [0, 64, "BKn"], 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 48, "LP"], 11, 11, [0, 46, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "Jo"], 11, 11, 11, 11, 11, 11, [0, 6, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 108
[ , [15, 81], [15, 74], [15, 72], [15, 72], [0, 69, "Ma"], [16, 69], [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, [0, 61, "LP"], [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, 11, [0, 50, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, [16, 26], [0, 24, "sp"], [16, 24], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 109
[ , [15, 81], [15, 75], [15, 72], [15, 72], 12, [16, 69], [0, 68, "BKn"], [0, 67, "BKn"], [16, 67], [16, 66], [0, 64, "BKn"], 11, [16, 63], 11, 11, 11, 11, [0, 58, "LP"], 11, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, 12, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 110
[ , [15, 82], [15, 75], [15, 73], [15, 72], 12, [16, 70], [16, 69], 11, 11, [0, 66, "BKn"], 12, 11, [16, 64], [16, 63], [0, 61, "LP"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 45, "LP"], 11, 11, [0, 43, "LP"], 11, 11, 11, 11, 11, [0, 39, "LP"], 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, 11, 11, [16, 24], 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 111
[ , [15, 83], [15, 76], [15, 74], [15, 73], [15, 72], [16, 71], [16, 70], [16, 69], 11, 11, 11, 11, 11, [0, 63, "LP"], 12, 11, 11, 11, 11, 11, [0, 57, "LP"], 11, 11, 11, [0, 54, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, 11, 11, [16, 24], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 112
[ , [15, 84], [15, 77], [15, 75], [15, 74], [16, 72], [15, 72], [0, 70, "LP"], [0, 69, "LP"], [16, 69], 11, [0, 66, "LP"], 11, 11, 11, 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 49, "LP"], 11, 11, [0, 47, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 41, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 113
[ , [15, 84], [15, 78], [15, 75], [15, 75], [16, 72], [16, 72], 12, 11, 11, [0, 68, "LP"], 12, 11, [0, 65, "LP"], [0, 64, "LP"], [0, 63, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, [0, 51, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [0, 26, "sp"], 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 114
[ , [15, 85], [15, 78], [15, 76], [15, 75], [16, 73], [16, 72], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 59, "LP"], [0, 58, "LP"], 11, 11, [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 12, 11, 11, 11, 11, [16, 24], [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 115
[ , [15, 86], [15, 79], [15, 77], [15, 76], [16, 74], [16, 73], [16, 72], [0, 71, "LP"], 11, 11, [0, 68, "LP"], [0, 67, "LP"], 11, 11, 11, 11, 11, [0, 62, "LP"], [0, 61, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 46, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 116
[ , [15, 87], [15, 80], [15, 78], [15, 77], [16, 75], [16, 74], [16, 73], [16, 72], 11, [0, 70, "LP"], 12, 11, 11, [0, 66, "LP"], [0, 65, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 57, "LP"], 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "LP"], 11, 11, 11, 11, 11, [0, 40, "LP"], 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 117
[ , [15, 87], [15, 81], [15, 78], [15, 78], [16, 75], [16, 75], [16, 74], [14, 4], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 50, "LP"], 11, 11, [0, 48, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, [16, 25], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 118
[ , [15, 88], [15, 81], [15, 79], [15, 78], [16, 76], [16, 75], [0, 74, "LP"], 12, 11, [16, 72], [0, 70, "LP"], [0, 69, "LP"], 11, 11, 11, 11, 11, [0, 64, "LP"], [0, 63, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 54, "LP"], 11, 11, [0, 52, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 32], [16, 30], [16, 30], [16, 30], [0, 28, "sp"], 11, 11, 11, [16, 26], [0, 24, "sp"], [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 119
[ , [15, 89], [15, 81], [15, 80], [15, 79], [16, 77], [16, 76], [16, 75], 11, 11, [16, 72], 12, 11, 11, [0, 68, "LP"], [0, 67, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 59, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], 11, [16, 31], [16, 30], [16, 30], 12, 11, 11, 11, 11, 12, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 120
[ , [15, 90], [15, 82], [15, 81], [15, 80], [16, 78], [16, 77], [16, 76], [0, 74, "Gur"], 11, [16, 73], [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 62, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, [16, 27], 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 12, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 121
[ , [15, 90], [15, 83], [15, 81], [15, 81], [16, 78], [16, 78], [0, 76, "LP"], 12, 11, [16, 74], [0, 72, "LP"], [0, 71, "LP"], 11, 11, 11, 11, 11, [0, 66, "LP"], [0, 65, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 58, "LP"], 11, 11, [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 47, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, 11, [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [16, 27], 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 122
[ , [15, 91], [15, 84], [15, 81], [15, 81], [16, 79], [16, 78], 12, 11, 11, 11, 12, 11, 11, [0, 70, "LP"], [0, 69, "LP"], [0, 68, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 61, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 51, "LP"], 11, 11, [0, 49, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], 11, 11, 11, [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, [16, 28], [0, 26, "Jo"], 11, 11, 11, [16, 24], 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 81], 11, 11, 11],
#V   n = 123
[ , [15, 92], [15, 84], [15, 81], [15, 81], [16, 80], [16, 79], [16, 78], 11, 11, [16, 75], 11, 11, 11, 11, 11, 11, 11, [0, 67, "LP"], 11, 11, 11, [0, 64, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 53, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 12, 11, 11, 11, 11, [16, 24], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 124
[ , [15, 93], [15, 85], [15, 82], [15, 81], [15, 81], [16, 80], [0, 78, "LP"], [0, 77, "LP"], [0, 76, "LP"], [16, 76], [0, 74, "LP"], [0, 73, "LP"], 11, 11, [0, 70, "LP"], 11, 11, 11, 11, [0, 66, "LP"], 11, 11, 11, 11, 11, 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, [0, 55, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 125
[ , [15, 93], [15, 86], [15, 83], [15, 81], [15, 81], [15, 81], 12, [16, 78], 11, 11, 12, 11, 11, [0, 72, "LP"], 12, 11, 11, 11, 11, 11, 11, [0, 65, "LP"], 11, 11, [0, 63, "LP"], [0, 62, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 126
[ , [15, 94], [15, 87], [15, 84], [15, 82], [15, 81], [15, 81], 12, [16, 79], [16, 78], 11, [0, 75, "LP"], 11, 11, 11, 11, 11, 11, [0, 69, "LP"], [0, 68, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 59, "LP"], 11, 11, [0, 57, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], 11, 11, 11, 11, 11, 11, 11, [16, 24], [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 127
[ , [15, 95], [15, 87], [15, 84], [15, 83], [15, 82], [15, 81], [0, 80, "LP"], [0, 79, "LP"], [0, 78, "LP"], [16, 78], 12, 11, 11, 11, [0, 72, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 64, "LP"], 11, 11, 11, [0, 61, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 52, "LP"], 11, 11, [0, 50, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], [16, 33], [16, 32], [16, 31], [16, 30], [16, 30], [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 128
[ , [15, 96], [15, 88], [15, 85], [15, 84], [15, 83], [15, 82], [15, 81], 11, 11, 11, 12, 11, 11, [0, 74, "LP"], 12, 11, 11, 11, 11, 11, 11, [0, 67, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 54, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, [0, 48, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], [0, 32, "sp"], [16, 32], [16, 31], [16, 30], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 129
[ , [15, 96], [15, 89], [15, 86], [15, 84], [15, 84], [15, 83], [16, 81], [15, 81], 11, 11, [0, 77, "LP"], [0, 76, "LP"], 11, 11, 11, 11, 11, [0, 71, "LP"], [0, 70, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 58, "LP"], 11, 11, [0, 56, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 130
[ , [15, 97], [15, 90], [15, 87], [15, 85], [15, 84], [15, 84], [16, 82], [16, 81], [0, 80, "LP"], 11, 12, 11, 11, 11, [0, 74, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 66, "LP"], [0, 65, "LP"], 11, 11, [0, 63, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 131
[ , [15, 98], [15, 90], [15, 87], [15, 86], [15, 85], [15, 84], [16, 83], [16, 82], [16, 81], 11, 12, 11, 11, 11, 12, 11, [0, 73, "Gur"], 11, 11, 11, 11, [0, 69, "LP"], [0, 68, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [16, 32], [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 132
[ , [15, 99], [15, 90], [15, 88], [15, 87], [15, 86], [16, 84], [15, 84], [16, 83], [16, 82], [16, 81], [0, 79, "LP"], [0, 78, "LP"], 11, 11, 11, 11, 11, 11, [0, 72, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 62, "LP"], 11, 11, [0, 60, "LP"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [16, 35], [16, 34], [16, 33], 11, [16, 32], [0, 30, "sp"], [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 133
[ , [15, 99], [15, 91], [15, 89], [15, 87], [15, 87], [16, 85], [16, 84], [0, 83, "Da2"], [16, 83], [16, 82], 12, 11, 11, 11, [0, 76, "Gur"], [0, 75, "Gur"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, [0, 34, "Jo"], [16, 34], [16, 33], 11, 12, 11, [16, 30], 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 134
[ , [15, 100], [15, 92], [15, 90], [15, 88], [15, 87], [16, 86], [16, 85], [16, 84], 11, [0, 82, "Da2"], 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, [0, 71, "Da2"], [0, 70, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 135
[ , [15, 101], [15, 93], [15, 90], [15, 89], [15, 88], [15, 87], [16, 86], [0, 84, "Gur"], [16, 84], 11, [0, 81, "Gur"], [0, 80, "Gur"], 11, 11, 11, 11, 11, 11, [0, 74, "Da2"], [0, 73, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 136
[ , [15, 102], [15, 93], [15, 90], [15, 90], [0, 88, "Ha"], [16, 87], [0, 86, "Gur"], 12, 11, [16, 84], 12, 11, 11, 11, [0, 78, "Gur"], [0, 77, "Gur"], 11, 11, 11, 11, 11, [0, 72, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 12, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 137
[ , [15, 102], [15, 94], [15, 91], [15, 90], 12, [16, 88], [16, 87], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 75, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [0, 32, "sp"], 11, 11, 11, [16, 30], [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, [0, 3, "BEH"], 11, 11, 11, 11, 11],
#V   n = 138
[ , [15, 103], [15, 95], [15, 92], [15, 90], [15, 90], [16, 89], [16, 88], [0, 86, "Gur"], 11, 11, [0, 83, "Da2"], [0, 82, "Gur"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 12, 11, 11, 11, [16, 30], 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 139
[ , [15, 104], [15, 96], [15, 93], [15, 91], [15, 90], [15, 90], [0, 88, "Da2"], 12, 11, 11, 12, 11, 11, 11, [0, 80, "Gur"], [0, 79, "Gur"], 11, 11, 11, 11, 11, [0, 74, "Da2"], [0, 73, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, 11, 11, [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 140
[ , [15, 105], [15, 96], [15, 93], [15, 92], [15, 91], [15, 90], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 77, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 38], [16, 36], [16, 36], [16, 36], 11, 11, 11, 11, [16, 32], [16, 31], [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 141
[ , [15, 105], [15, 97], [15, 94], [15, 93], [15, 92], [16, 90], [15, 90], [0, 88, "Gur"], 11, 11, [0, 85, "Gur"], [0, 84, "Gur"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], 11, [16, 37], [16, 36], [16, 36], [16, 36], 11, 11, 11, 11, [16, 32], [0, 30, "Jo"], [16, 30], 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 142
[ , [15, 106], [15, 98], [15, 95], [15, 93], [15, 93], [16, 91], [16, 90], 12, 11, 11, 12, 11, 11, 11, [0, 82, "Gur"], [0, 81, "Gur"], 11, 11, 11, 11, 11, [0, 76, "Da2"], [0, 75, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], [16, 36], [0, 34, "sp"], 11, [16, 33], 11, 12, 11, [16, 30], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 143
[ , [15, 107], [15, 99], [15, 96], [0, 93, "Lan"], [15, 93], [16, 92], [16, 91], [16, 90], 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 80, "Da2"], 11, [0, 78, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, 11, [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 12, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 144
[ , [15, 108], [15, 99], [15, 96], 12, [16, 93], [15, 93], [16, 92], [0, 90, "Gur"], [16, 90], 11, [0, 87, "Gur"], [0, 86, "Da2"], 11, 11, 11, [0, 82, "Gur"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, 11, [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 145
[ , [15, 108], [15, 99], [15, 97], 12, [16, 94], [16, 93], [0, 92, "Gur"], 12, 11, [16, 90], 12, 11, 11, [0, 85, "Da9"], [0, 84, "Gur"], 12, 11, 11, 11, 11, 11, 11, [0, 77, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [16, 33], 11, 11, 11, [16, 30], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 146
[ , [15, 109], [15, 100], [15, 98], [15, 96], [16, 95], [14, 3], [16, 93], 11, 11, 11, 12, [0, 87, "Gur"], 11, 11, 11, 11, 11, 11, [0, 81, "Da2"], [0, 80, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, [16, 34], [0, 32, "sp"], 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 147
[ , [15, 110], [15, 101], [15, 99], [0, 96, "Lg"], [15, 96], 12, 11, [0, 92, "Gur"], 11, 11, [0, 89, "Gur"], 12, 11, 11, [0, 85, "Gur"], [0, 84, "Gur"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 12, 11, 11, 11, 11, [16, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 148
[ , [15, 111], [15, 102], [15, 99], 12, [16, 96], 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 78, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, 11, 11, 11, 11, [16, 30], [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 149
[ , [15, 111], [15, 102], [15, 99], 12, [16, 97], [16, 96], 11, 11, [16, 93], 11, 12, [0, 89, "Gur"], 11, 11, 11, 11, 11, 11, [0, 83, "Da2"], [0, 82, "Da2"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 150
[ , [15, 112], [15, 103], [15, 100], [15, 99], [16, 98], [14, 3], [16, 96], [0, 94, "Da2"], [16, 94], [16, 93], [0, 91, "Gur"], 12, 11, 11, [0, 87, "Gur"], [0, 86, "Gur"], 11, 11, 11, 11, 11, [0, 81, "Da2"], [0, 80, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 151
[ , [15, 113], [15, 104], [15, 101], [15, 99], [15, 99], 12, 11, 12, 11, [16, 94], 12, 11, 11, 11, 12, 11, 11, 11, [0, 84, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [16, 39], [16, 38], [16, 37], [16, 36], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 152
[ , [15, 114], [15, 105], [15, 102], [15, 100], [15, 99], 12, 11, [16, 96], 11, 11, 12, [0, 91, "Gur"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], [0, 38, "sp"], [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 12, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 153
[ , [15, 114], [15, 105], [15, 102], [15, 101], [15, 100], [15, 99], 11, [0, 96, "Gur"], [16, 96], 11, [0, 93, "Gur"], 12, 11, 11, [0, 89, "Gur"], [0, 88, "Gur"], 11, 11, 11, 11, 11, [0, 83, "Da2"], [0, 82, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 154
[ , [15, 115], [15, 106], [15, 103], [15, 102], [0, 100, "Ha"], [14, 3], [0, 98, "Gur"], 12, 11, [16, 96], 12, 11, 11, 11, 12, 11, 11, 11, [0, 86, "Da2"], [0, 85, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 6, "sp"], 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 155
[ , [15, 116], [15, 107], [15, 104], [15, 102], 12, 11, [16, 99], 11, 11, 11, 12, [0, 93, "Gur"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, [16, 38], [0, 36, "Jo"], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 156
[ , [15, 117], [15, 108], [15, 105], [15, 103], [15, 102], 11, [16, 100], [0, 98, "Gur"], 11, 11, [0, 95, "Gur"], 12, 11, 11, [0, 91, "Gur"], [0, 90, "Gur"], 11, 11, 11, 11, 11, 11, [0, 84, "Da9"], [0, 83, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 12, 11, [16, 36], 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 8, "Jo"], 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 157
[ , [15, 117], [15, 108], [15, 105], [15, 104], [0, 102, "Ma"], [15, 102], [0, 100, "Da2"], 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 88, "Da2"], [0, 87, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 158
[ , [15, 118], [15, 108], [15, 106], [15, 105], 12, 11, 12, 11, [16, 99], 11, 12, [0, 95, "Gur"], 11, 11, 11, [0, 91, "Gur"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 159
[ , [15, 119], [15, 109], [15, 107], [15, 105], 12, 11, [16, 102], [0, 100, "Da2"], [16, 100], [16, 99], [0, 97, "Gur"], 12, 11, [0, 94, "Gur"], [0, 93, "Gur"], 12, 11, 11, 11, 11, 11, 11, [0, 86, "Da9"], [0, 85, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 160
[ , [15, 120], [15, 110], [15, 108], [15, 106], [15, 105], 11, [0, 102, "Gur"], 12, 11, [16, 100], 12, 11, 11, 11, 11, 11, 11, 11, [0, 90, "Da2"], [0, 89, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [0, 38, "sp"], 11, 11, [16, 36], [16, 36], [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 161
[ , [15, 120], [15, 111], [15, 108], [15, 107], [0, 105, "Gur"], [15, 105], 12, 11, 11, 11, 12, [0, 97, "Gur"], [0, 96, "Da2"], 11, 11, [0, 93, "Gur"], 11, 11, 11, 11, 11, 11, [0, 87, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 12, 11, 11, [16, 37], [16, 36], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 162
[ , [15, 121], [15, 111], [15, 108], [15, 108], 12, 11, 12, [0, 102, "Gur"], [16, 102], 11, [0, 99, "Gur"], 12, 11, 11, [0, 95, "Gur"], 12, 11, 11, 11, [0, 90, "Da2"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 11, 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 163
[ , [15, 122], [15, 112], [15, 108], [15, 108], 12, 11, [0, 104, "Gur"], 12, 11, [0, 101, "Gur"], 12, 11, 11, 11, 11, 11, 11, 11, [0, 92, "Da2"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 32], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 44], [16, 42], [16, 42], [16, 42], 11, 11, 11, 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 164
[ , [15, 123], [15, 113], [15, 109], [15, 108], [15, 108], 11, [16, 105], 11, 11, 11, 11, [0, 99, "Gur"], [0, 98, "Gur"], 11, 11, [0, 95, "Gur"], 11, 11, 11, 11, 11, 11, [0, 89, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], 11, [16, 43], [16, 42], [16, 42], [16, 42], 11, 11, [16, 39], 11, [16, 38], [16, 37], [16, 36], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 165
[ , [15, 123], [15, 114], [15, 110], [15, 108], [15, 108], [0, 107, "Da6"], [16, 106], [0, 104, "Gur"], 11, 11, [0, 101, "Gur"], 12, 11, 11, [0, 97, "Gur"], 12, 11, 11, 11, [0, 92, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 38], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], [16, 42], [0, 40, "sp"], [16, 40], [16, 39], 11, [16, 38], [0, 36, "sp"], [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 166
[ , [15, 124], [15, 114], [15, 111], [15, 109], [15, 108], [15, 108], [0, 106, "Da2"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 94, "Da2"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 46], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 12, 11, [16, 40], [16, 39], 11, 12, 11, [16, 36], 11, 11, 11, [0, 32, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 167
[ , [15, 125], [15, 115], [15, 111], [15, 110], [16, 108], [15, 108], 12, 11, 11, 11, 12, [0, 101, "Da2"], [0, 100, "Da2"], 11, 11, [0, 97, "Gur"], [0, 96, "Da2"], 11, 11, 11, 11, 11, [0, 91, "Da9"], [0, 90, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, [16, 48], 11, 11, 11, [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 168
[ , [15, 126], [15, 116], [15, 112], [15, 111], [16, 109], [16, 108], [15, 108], [0, 106, "Da2"], 11, [16, 105], [0, 103, "Gur"], 12, 11, 11, [0, 99, "Gur"], 12, 11, 11, 11, [0, 94, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [16, 39], 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, [0, 22, "sp"], 11, 11, [0, 20, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 169
[ , [15, 126], [15, 117], [15, 113], [15, 111], [16, 110], [16, 109], [16, 108], 12, 11, [16, 106], 12, [0, 102, "Gur"], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, [16, 40], [0, 38, "sp"], 11, 11, 11, [16, 36], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 170
[ , [15, 127], [15, 117], [15, 114], [15, 112], [15, 111], [16, 110], [16, 109], [0, 107, "Gur"], 11, 11, 12, 12, 11, 11, 11, [0, 99, "Gur"], [0, 98, "Da2"], 11, 11, 11, 11, 11, [0, 93, "Da9"], [0, 92, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 40], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 12, 11, 11, 11, 11, [16, 36], [0, 34, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 171
[ , [15, 128], [15, 117], [15, 114], [15, 113], [16, 111], [15, 111], [16, 110], [16, 108], 11, 11, [0, 105, "Gur"], 12, 11, 11, [0, 101, "Gur"], 12, 11, 11, [0, 97, "Da2"], [0, 96, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "Jo"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 172
[ , [15, 129], [15, 118], [15, 115], [15, 114], [16, 112], [16, 111], [0, 110, "Gur"], [16, 109], [16, 108], 11, 12, [0, 104, "Gur"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 93, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, 11, [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 6], [0, 4, "sp"], 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 173
[ , [15, 129], [15, 119], [15, 116], [15, 114], [16, 113], [16, 112], [16, 111], [0, 109, "Gur"], [16, 109], [16, 108], 11, 12, 11, [0, 103, "Gur"], 11, [0, 101, "Gur"], [0, 100, "Da2"], 11, 11, 11, 11, 11, [0, 95, "Da9"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 174
[ , [15, 130], [15, 120], [15, 117], [15, 115], [15, 114], [16, 113], [16, 112], 12, 11, [16, 109], [0, 107, "Gur"], 12, 11, 11, 11, 12, 11, 11, [0, 99, "Da2"], [0, 98, "Da2"], [0, 97, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 47], 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [16, 45], [16, 44], [16, 43], [16, 42], [16, 42], [0, 40, "sp"], 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, [0, 30, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 175
[ , [15, 131], [15, 120], [15, 117], [15, 116], [16, 114], [15, 114], [0, 112, "Da2"], [16, 111], 11, 11, 12, [0, 106, "Gur"], 11, 11, 11, [0, 102, "Da2"], 11, 11, 11, 11, 11, 11, [0, 96, "Da2"], [0, 95, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, 11, 11, [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], [0, 44, "Jo"], [16, 44], [16, 43], [16, 42], 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 176
[ , [15, 132], [15, 121], [15, 117], [15, 117], [16, 115], [16, 114], 12, [0, 111, "Gur"], [16, 111], 11, 11, 12, 11, [0, 105, "Gur"], 11, 12, 11, 11, 11, [0, 99, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 50], 11, 11, 11, 11, 11, 11, [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 177
[ , [15, 132], [15, 122], [15, 118], [15, 117], [16, 116], [16, 115], [16, 114], 12, 11, [16, 111], [0, 109, "Gur"], 12, 11, 11, 11, 12, 11, 11, [0, 101, "Da2"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 47], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 178
[ , [15, 133], [15, 123], [15, 119], [15, 117], [15, 117], [16, 116], [0, 114, "Gur"], 12, 11, 11, 12, [0, 108, "Gur"], [0, 107, "Gur"], 11, 11, [0, 104, "Da2"], [0, 103, "Da2"], 11, 11, 11, 11, 11, [0, 98, "Da9"], [0, 97, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 179
[ , [15, 134], [15, 123], [15, 120], [15, 118], [15, 117], [15, 117], 12, [0, 113, "Gur"], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 101, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], 11, [16, 44], [0, 42, "sp"], [16, 42], 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 180
[ , [15, 135], [15, 124], [15, 120], [15, 119], [16, 117], [15, 117], 12, 12, 11, 11, [0, 111, "Gur"], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [16, 47], [16, 46], [16, 45], 11, 12, 11, [16, 42], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 181
[ , [15, 135], [15, 125], [15, 121], [15, 120], [16, 118], [16, 117], [0, 116, "Da9"], 12, 11, 11, 12, [0, 110, "Gur"], [0, 109, "Gur"], 11, 11, [0, 106, "Da2"], [0, 105, "Da2"], 11, 11, 11, 11, 11, [0, 100, "Da9"], [0, 99, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, [0, 46, "sp"], [16, 46], [16, 45], 11, 11, 11, [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 182
[ , [15, 136], [15, 126], [15, 122], [15, 120], [16, 119], [16, 118], [16, 117], 13, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 103, "Da2"], [0, 102, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 56], [16, 57], 11, [14, 58], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], 11, 11, 11, [16, 42], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 183
[ , [15, 137], [15, 126], [15, 123], [15, 121], [15, 120], [16, 119], [16, 118], [0, 115, "Gur"], 11, [0, 114, "Gur"], [0, 113, "Gur"], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 100, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], 11, 11, [16, 42], [16, 42], [0, 40, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 184
[ , [15, 138], [15, 126], [15, 123], [15, 122], [16, 120], [15, 120], [0, 118, "Da2"], 12, 11, 11, 11, [0, 112, "Gur"], [0, 111, "Gur"], 11, 11, [0, 108, "Da2"], [0, 107, "Da2"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 52], 11, 11, [16, 61], [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], [14, 61], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [0, 44, "sp"], 11, [16, 43], [16, 42], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, [0, 24, "sp"], 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 185
[ , [15, 138], [15, 127], [15, 124], [15, 123], [16, 121], [16, 120], 12, 12, 11, 11, 11, 12, 11, 11, [0, 110, "Gur"], 12, 11, 11, 11, [0, 105, "Da2"], [0, 104, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 61], [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], 11, 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 48], [16, 48], [16, 48], 11, 11, 12, 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 186
[ , [15, 139], [15, 128], [15, 125], [15, 123], [16, 122], [16, 121], [16, 120], 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [0, 102, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 30], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 61], [16, 60], 11, [14, 57], 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], 11, 11, 11, [16, 52], [16, 51], 11, [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, 11, 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 187
[ , [15, 140], [15, 129], [15, 126], [15, 124], [15, 123], [16, 122], [0, 120, "Gur"], 12, 11, 11, 11, [0, 114, "Gur"], [0, 113, "Gur"], 11, 11, [0, 110, "Gur"], [0, 109, "Da2"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 61], [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], 11, 11, 11, [14, 65], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, 11, [16, 45], 11, [16, 44], [16, 43], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 188
[ , [15, 141], [15, 129], [15, 126], [15, 125], [16, 123], [15, 123], 12, [0, 119, "Gur"], 11, 11, 11, 12, 11, 11, [0, 112, "Da2"], 12, 11, 11, 11, [0, 107, "Da2"], [0, 106, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 61], [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], 11, 11, 11, 11, [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], 11, [16, 46], [16, 45], 11, [16, 44], [0, 42, "sp"], [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 189
[ , [15, 141], [15, 130], [15, 126], [15, 126], [16, 124], [16, 123], 12, 12, 11, 11, [0, 117, "Gur"], 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, [0, 104, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 57], [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 55], [16, 54], 11, 11, 11, [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [16, 48], [0, 46, "sp"], [16, 46], [16, 45], 11, 12, 11, [16, 42], 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 190
[ , [15, 142], [15, 131], [15, 127], [15, 126], [16, 125], [16, 124], [16, 123], 12, 11, 11, 12, [0, 116, "Gur"], [0, 115, "Gur"], [0, 114, "Gur"], 11, [0, 112, "Gur"], [0, 111, "Da2"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, [16, 57], 11, 11, [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 12, 11, [16, 46], [16, 45], 11, 11, 11, [16, 42], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 191
[ , [15, 143], [15, 132], [15, 128], [15, 126], [15, 126], [0, 124, "Da6"], [16, 123], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, [0, 110, "Da2"], [0, 109, "Da2"], [0, 108, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, [14, 62], 11, [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [16, 45], 11, 11, 11, [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 192
[ , [15, 144], [15, 132], [15, 129], [15, 127], [15, 126], 12, [16, 124], [0, 122, "Da2"], [0, 121, "Da2"], 11, [0, 119, "Gur"], 12, [0, 116, "Gur"], 11, 11, 11, [0, 112, "Da2"], 11, 11, 11, 11, 11, [0, 107, "Da9"], [0, 106, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, [16, 46], [0, 44, "Jo"], 11, 11, 11, [16, 42], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 193
[ , [15, 144], [15, 133], [15, 129], [15, 128], [16, 126], [15, 126], [16, 125], 12, 11, 11, 12, [0, 118, "Gur"], 12, 11, 11, [0, 114, "Gur"], 12, 11, 11, 11, [0, 109, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, 11, [16, 66], 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, 11, 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 12, 11, 11, 11, 11, [16, 42], [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 194
[ , [15, 145], [15, 134], [15, 130], [15, 129], [16, 127], [16, 126], [0, 125, "Gur"], [0, 123, "Gur"], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 111, "Da2"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, 11, [16, 67], [16, 66], 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, 11, [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 195
[ , [15, 146], [15, 135], [15, 131], [15, 129], [16, 128], [16, 127], [16, 126], 12, 11, [0, 122, "Gur"], [0, 121, "Gur"], 12, [0, 118, "Gur"], 11, 11, 11, [0, 114, "Da2"], 11, 11, 11, 11, 11, 11, [0, 108, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 196
[ , [15, 147], [15, 135], [15, 132], [15, 130], [15, 129], [16, 128], [16, 126], 12, 11, 11, 11, [0, 120, "Gur"], 12, 11, 11, [0, 116, "Gur"], 12, 11, 11, [0, 112, "Da2"], [0, 111, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, 11, 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, 11, 11, 11, [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 197
[ , [15, 147], [15, 135], [15, 132], [15, 131], [16, 129], [15, 129], [16, 127], [0, 125, "Gur"], [0, 124, "Da2"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 109, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, 11, [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, 11, 11, [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], [16, 48], [0, 46, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 198
[ , [15, 148], [15, 136], [15, 133], [15, 132], [16, 130], [16, 129], [16, 128], 12, 11, 11, [0, 123, "Gur"], 12, [0, 120, "Gur"], 11, 11, 11, [0, 116, "Da2"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, 11, [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [16, 53], [16, 52], [16, 51], [16, 51], [16, 50], [16, 49], [16, 48], 12, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 199
[ , [15, 149], [15, 137], [15, 134], [15, 132], [16, 131], [16, 129], [16, 129], 12, 11, 11, 11, [0, 122, "Gur"], 12, 11, 11, [0, 118, "Gur"], 12, 11, 11, [0, 114, "Da2"], [0, 113, "Da2"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, [14, 72], [16, 52], [16, 51], [0, 50, "sp"], [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 200
[ , [15, 150], [15, 138], [15, 135], [15, 133], [15, 132], [16, 130], [16, 129], 12, [0, 126, "Da2"], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 111, "Da9"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 28], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, 11, 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "sp"], 11, 11, [0, 26, "sp"], 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 201
[ , [15, 150], [15, 138], [15, 135], [15, 134], [16, 132], [16, 131], [16, 130], [16, 129], 12, 11, [0, 125, "Gur"], 12, [0, 122, "Gur"], 11, 11, [0, 119, "Gur"], [0, 118, "DM4"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], [14, 26], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, 11, [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 202
[ , [15, 151], [15, 139], [15, 135], [15, 135], [16, 133], [16, 132], [16, 131], 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, 11, [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 50], [0, 48, "sp"], [16, 48], 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "Jo"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 203
[ , [15, 152], [15, 140], [15, 135], [15, 135], [0, 133, "Da5"], [16, 132], [0, 131, "Gur"], [0, 129, "Gur"], [0, 128, "Gur"], 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, 12, 11, [16, 48], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 204
[ , [15, 153], [15, 141], [15, 136], [15, 135], 12, [16, 133], [16, 132], 12, 11, 11, [0, 127, "Gur"], 11, [0, 124, "Gur"], 11, 11, [0, 121, "Gur"], 11, 11, 11, [0, 117, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 67], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 205
[ , [15, 153], [15, 141], [15, 137], [15, 135], [15, 135], [16, 134], [16, 133], 12, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 68], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, 11, [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 206
[ , [15, 154], [15, 142], [15, 138], [15, 136], [15, 135], [15, 135], [16, 134], [0, 131, "Gur"], 11, 11, 11, 13, 12, 11, 11, 12, [0, 121, "DM4"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], 11, [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, [16, 49], [16, 48], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 10, "sp"], 11, 11, 11, [0, 8, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 207
[ , [15, 155], [15, 143], [15, 138], [15, 137], [16, 135], [15, 135], [15, 135], 12, 11, 11, [0, 129, "Gur"], [0, 127, "Gur"], [0, 126, "Gur"], 11, 11, [0, 123, "Gur"], 12, 11, 11, 12, [0, 118, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 56], [16, 54], [16, 54], [16, 54], 11, 11, [16, 52], [0, 50, "sp"], [16, 50], [16, 49], [16, 48], [16, 48], [0, 46, "sp"], 11, 11, 11, 11, [0, 42, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 208
[ , [15, 156], [15, 144], [15, 139], [15, 138], [16, 136], [16, 135], [15, 135], 12, 11, 11, 12, 12, 11, 11, 11, 12, 11, 11, 11, [0, 120, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, [16, 55], [16, 54], [16, 54], [16, 54], 11, 11, 12, 11, [16, 50], [16, 49], [16, 48], 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 209
[ , [15, 156], [15, 144], [15, 140], [15, 138], [16, 137], [16, 136], [16, 135], 12, 11, 11, 11, 12, 11, 11, 11, 12, [0, 123, "DM4"], 11, 11, 11, 11, [0, 118, "DM4"], 11, [0, 117, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], 11, 11, [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], [16, 54], 11, 11, [16, 51], 11, [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 210
[ , [15, 157], [15, 144], [15, 141], [15, 139], [15, 138], [16, 137], [16, 135], [16, 135], 11, 11, [16, 132], [0, 129, "Gur"], 11, 11, 11, [0, 125, "Gur"], 12, 11, 11, 11, [0, 120, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], 11, [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], [16, 54], 11, [16, 52], [16, 51], 11, [16, 50], [16, 49], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 211
[ , [15, 158], [15, 145], [15, 141], [15, 140], [16, 138], [15, 138], [16, 136], [16, 135], 13, 13, [16, 133], 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], [16, 54], [16, 53], [16, 52], [16, 51], 11, [16, 50], [0, 48, "sp"], [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 212
[ , [15, 159], [15, 146], [15, 142], [15, 141], [16, 139], [16, 138], [16, 137], [0, 135, "Gur"], [0, 134, "Gur"], [0, 133, "Gur"], 11, 12, [0, 129, "Gur"], 11, 11, 12, [0, 125, "DM4"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 62], [16, 60], [16, 60], [16, 60], 11, [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], [16, 54], [0, 52, "sp"], [16, 52], [16, 51], 11, 12, 11, [16, 48], 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 12, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 213
[ , [15, 159], [15, 147], [15, 143], [15, 141], [16, 140], [16, 139], [16, 138], 12, 11, 11, 11, [0, 131, "Gur"], 12, 11, 11, [0, 127, "Gur"], 12, 11, 11, 11, [0, 122, "DM4"], [0, 121, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], 11, 11, [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], 11, [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 12, 11, [16, 52], [16, 51], 11, 11, 11, [16, 48], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 214
[ , [15, 160], [15, 147], [15, 144], [15, 142], [15, 141], [16, 140], [16, 138], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 124, "DM4"], 12, 11, 11, [0, 120, "DM4"], 11, 11, 11, 11, 11, 11, 11, [14, 16], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], 11, 11, [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 215
[ , [15, 161], [15, 148], [15, 144], [15, 143], [16, 141], [15, 141], [16, 139], [0, 137, "Gur"], 11, 11, 11, 12, [0, 131, "Gur"], 11, 11, 11, [0, 127, "DM4"], 11, 11, 11, [0, 123, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], 11, [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 64], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [16, 51], 11, 11, 11, [16, 48], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 28, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 216
[ , [15, 162], [15, 149], [15, 144], [15, 144], [16, 142], [16, 141], [16, 140], 12, 11, 11, 11, [0, 133, "Gur"], 12, 11, 11, [0, 129, "Gur"], 12, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 65], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, [16, 52], [0, 50, "sp"], 11, 11, 11, [16, 48], [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 30, "sp"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 217
[ , [15, 162], [15, 150], [15, 145], [15, 144], [16, 143], [16, 142], [16, 141], 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 11, 11, 11, [0, 122, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, 11, [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], 11, [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 32, "sp"], 11, 12, 11, 11, 11, 11, 11, 11, [0, 26, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 218
[ , [15, 163], [15, 150], [15, 146], [15, 144], [15, 144], [16, 143], [16, 141], 12, 11, [0, 137, "Gur"], 11, 12, [0, 133, "Gur"], 11, 11, 11, [0, 129, "DM4"], [0, 128, "DM4"], 11, [0, 125, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 26], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, 11, [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 18, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 219
[ , [15, 164], [15, 151], [15, 147], [15, 145], [15, 144], [15, 144], [16, 142], [16, 141], 11, 12, 11, [0, 135, "Gur"], 12, 11, 11, [0, 131, "Gur"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], [14, 20], 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, 11, [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 220
[ , [15, 165], [15, 152], [15, 147], [15, 146], [16, 144], [15, 144], [16, 143], 13, 13, 12, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [0, 124, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, 11, 11, 11, [0, 48, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 221
[ , [15, 165], [15, 153], [15, 148], [15, 147], [16, 145], [16, 144], [0, 143, "Gur"], [0, 141, "Gur"], [0, 140, "Gur"], 11, 11, 12, [0, 135, "Gur"], 11, 11, 11, [0, 131, "DM4"], [0, 130, "DM4"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], [0, 52, "sp"], 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 222
[ , [15, 166], [15, 153], [15, 149], [15, 147], [16, 146], [16, 145], [16, 144], 12, 11, 11, 11, [0, 137, "Gur"], 12, 11, [0, 134, "Gur"], [0, 133, "Gur"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], [0, 56, "sp"], [16, 56], [16, 55], [16, 54], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 14, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 6, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 223
[ , [15, 167], [15, 153], [15, 150], [15, 148], [15, 147], [16, 146], [16, 144], 12, 11, 11, 11, 12, 11, 11, 11, 11, [0, 132, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 224
[ , [15, 168], [15, 154], [15, 150], [15, 149], [16, 147], [15, 147], [16, 145], [0, 143, "Gur"], 11, 11, 11, 12, [0, 137, "Gur"], 11, 11, 11, 12, 11, 11, 11, [0, 129, "DM4"], [0, 128, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 22, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 225
[ , [15, 168], [15, 155], [15, 151], [15, 150], [16, 148], [16, 147], [16, 146], 12, 11, 11, 11, [0, 139, "Gur"], 12, 11, [0, 136, "Gur"], [0, 135, "Gur"], 12, 11, 11, [0, 131, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], 11, 11, 11, [0, 50, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 226
[ , [15, 169], [15, 156], [15, 152], [15, 150], [16, 149], [16, 148], [16, 147], 12, [0, 143, "Gur"], 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [0, 54, "sp"], [16, 54], 11, 11, 12, 11, 11, 11, 11, 11, [0, 46, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 40, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 227
[ , [15, 170], [15, 156], [15, 153], [15, 151], [15, 150], [16, 149], [16, 147], 12, 12, 11, 11, 12, [0, 139, "Gur"], 11, 11, 11, 11, 11, 11, 11, [0, 131, "DM4"], [0, 130, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [0, 58, "sp"], [16, 58], [16, 57], 11, 12, [16, 54], [16, 54], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 228
[ , [15, 171], [15, 157], [15, 153], [15, 152], [16, 150], [15, 150], [16, 148], [16, 147], 12, 11, 11, [0, 141, "Gur"], 12, 11, 11, [0, 137, "Gur"], 13, 13, 11, [0, 133, "DM4"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 75], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 12, 11, [16, 58], [16, 57], 11, [16, 55], [16, 54], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 229
[ , [15, 171], [15, 158], [15, 153], [15, 153], [16, 151], [16, 150], [16, 149], 13, [0, 145, "Gur"], 11, 11, 12, 11, 11, 11, 12, [0, 136, "DM4"], [0, 135, "DM4"], 11, 12, [0, 132, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 60], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], [16, 56], [16, 55], [16, 54], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 42, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 230
[ , [15, 172], [15, 159], [15, 154], [15, 153], [0, 151, "DM5"], [16, 151], [16, 150], [0, 147, "Gur"], 12, 11, 11, 12, [0, 141, "Gur"], [0, 140, "Gur"], 11, 11, 12, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 61], [16, 60], [16, 60], [16, 60], 11, 11, [16, 58], [0, 56, "Jo"], [16, 56], [16, 55], [16, 54], [16, 54], [0, 52, "sp"], 11, 11, 11, 11, [0, 48, "Jo"], 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 231
[ , [15, 173], [15, 159], [15, 155], [15, 153], 12, 11, [16, 150], 12, 11, 11, 11, [0, 143, "Gur"], 12, 11, 11, [0, 139, "Gur"], 12, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 22], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 77], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], 11, 11, [16, 57], 11, [16, 56], [16, 55], [16, 54], 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 232
[ , [15, 174], [15, 160], [15, 156], [15, 154], [15, 153], 11, [16, 151], 12, [0, 147, "Gur"], 11, 11, 12, [0, 142, "Gur"], 11, 11, 11, [0, 138, "DM4"], [0, 137, "DM4"], 11, [0, 134, "DM4"], 11, [0, 133, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], 11, [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], 11, [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 34, "sp"], 11, 11, [0, 32, "sp"], 11, 11, [0, 30, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 233
[ , [15, 174], [15, 161], [15, 156], [15, 155], [15, 154], [15, 153], [16, 152], [0, 149, "Gur"], 12, 11, 11, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 84], 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [16, 55], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 44, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [0, 28, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 20, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 234
[ , [15, 175], [15, 162], [15, 157], [15, 156], [15, 155], [16, 153], [15, 153], 12, 11, 11, 11, [0, 145, "Gur"], 12, 11, 11, [0, 141, "Gur"], 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 79], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [16, 59], [16, 58], [16, 57], 11, [16, 56], [0, 54, "Jo"], [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 36, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, [0, 16, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 235
[ , [15, 176], [15, 162], [15, 158], [15, 156], [0, 155, "Gur"], [16, 153], [16, 153], 12, [0, 149, "Gur"], 11, 11, 12, [0, 144, "Gur"], 11, 11, 11, [0, 140, "DM4"], [0, 139, "DM4"], 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 20], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 82], [16, 81], 11, [16, 80], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], [16, 60], [0, 58, "Jo"], [16, 58], [16, 57], 11, 12, 11, [16, 54], 11, 11, 11, [0, 50, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 26, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 236
[ , [15, 177], [15, 162], [15, 159], [15, 157], [15, 156], [16, 154], [16, 153], 12, 12, 11, 11, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 18], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 82], [16, 81], 11, [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 12, 11, [16, 58], [16, 57], 11, 11, 11, [16, 54], 11, 11, 12, 11, 11, 11, 11, 11, [0, 46, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 38, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 237
[ , [15, 177], [15, 163], [15, 159], [15, 158], [0, 156, "Gur"], [16, 155], [16, 154], [16, 153], 12, 11, 11, [0, 147, "Gur"], 12, 11, 11, [0, 143, "Gur"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 82], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 238
[ , [15, 178], [15, 164], [15, 160], [15, 159], 12, [16, 156], [16, 155], 13, [0, 151, "Gur"], 11, 11, 12, [0, 146, "Gur"], 11, 11, 11, [0, 142, "DM4"], [0, 141, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 82], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [16, 57], 11, 11, 11, [16, 54], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 40, "Jo"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 239
[ , [15, 179], [15, 165], [15, 161], [15, 159], 12, [16, 156], [16, 156], [0, 153, "Gur"], 12, 11, 11, 12, 12, 11, [0, 145, "Gur"], [0, 144, "Gur"], 12, 11, 11, [0, 140, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, 11, 11, [16, 81], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, [16, 58], [0, 56, "sp"], 11, 11, 11, [16, 54], [0, 52, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 240
[ , [15, 180], [15, 165], [15, 162], [15, 160], [15, 159], [16, 157], [16, 156], 12, 11, 11, 11, [0, 149, "Gur"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, 11, [16, 82], [16, 81], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 24, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 241
[ , [15, 180], [15, 166], [15, 162], [15, 161], [15, 160], [16, 158], [16, 157], 12, [0, 153, "Gur"], 11, 11, 12, [0, 148, "Gur"], 11, 11, 11, [0, 144, "DM4"], [0, 143, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [14, 24], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, [16, 83], [16, 82], [16, 81], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 74], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [0, 48, "sp"], 11, 11, 11, 11, 11, 11, 11, [0, 42, "sp"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 242
[ , [15, 181], [15, 167], [15, 162], [15, 162], [15, 161], [16, 159], [16, 158], [16, 156], 12, 11, 11, 12, 12, 11, [0, 147, "Gur"], [0, 146, "Gur"], 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, [16, 83], [16, 82], [16, 81], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 75], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11],
#V   n = 243
[ , [15, 182], [15, 168], [15, 162], [15, 162], [15, 162], [16, 159], [0, 158, "Gur"], [16, 157], 12, 11, 11, [0, 151, "Gur"], 12, 11, 11, 11, 11, [0, 144, "DM4"], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [16, 90], 11, 11, 11, 11, [16, 87], 11, 11, [16, 85], [16, 84], 11, [16, 83], [16, 82], [16, 81], [16, 81], [16, 80], [16, 79], [16, 78], [16, 78], [16, 78], [16, 77], [16, 76], [16, 75], [16, 74], [16, 73], [16, 72], [16, 72], [16, 72], [16, 71], [16, 70], [16, 69], [16, 69], [16, 68], [16, 67], [16, 66], [16, 66], [16, 66], [16, 65], [16, 64], [16, 63], [16, 63], [16, 62], [16, 61], [16, 60], [16, 60], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11]];
