/**************************************************************************\
 Closed Captionning decoding         Initial version
 by Chrisitan Lupien
    (lupien@physics.utoronto.ca)

 This is part of the Gatos project:
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila,
        Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include "cc.h"

#include <curses.h>

/*  Display area is 15 row by 32 columns
    starts on line 43 and ends on line 237 on interlaced display (195 lines
    long. Note full height is 21 to 262, first line is 1 and the frame is 525
    including blanking (fields are 262.5).
    E.I. A full screen has 3 more lines(18 of 13 rows each), about 1.5 above
    and below the 15.
    Overall the text should be inside 80% vertically and horiszontally of the
    displayable area (considering 15x34).
    Should erase the screen when shitching channels or fields.
*/

/* Currently the display of caption is done on the tty where xatitv
   is started so the program cannot be run in backgound mode (it blocks if you
   try. Also since I am using ncurses you need to have a correctly set
   TERM variable. You can try a couple of different ones (linux, VT100, xterm).
   For modes CC1 and CC2 the program puts a blue screen (if ncurses thinks your
   terminal handles colors). The blue screen corresponds to the addresable size
   of the TV screen.
*/


static int curmode=-1;
static int clrflag=1;
WINDOW *mainw,*mwin,*twin;
static int navail=0,nedsd=0;
static int preveds=-1;
static int ccerror=0;

int cursattr(int);

static char *short_title[]={"NONE","CC1","CC2","TEXT1","TEXT2"};

void cc_show(void) {
  struct ccdata *csd;
  int dnum_row,*drow,(*dattrib)[CC_COLUMNS];
  unsigned char (*dtext)[CC_COLUMNS];
  int row,col,crow;
  char avail[40],edsd[40];
  int sum,i;
  struct ccdata *ccdat;
  struct edsdata *edsdat;
#ifdef CCTEST
  return;
#endif
  if(ccerror) return;
  if(curmode==-1) return; /* show nothing, the mode is off */
  ccdat=cc_get_data();
  edsdat=eds_get_data();
  csd=&(ccdat[curmode]);
  if(*csd->clrflag) clrflag=1;
  if(curmode<=CC_MODE_CC2) wbkgdset(mwin,COLOR_PAIR(7));
  else wbkgdset(mwin,0);
  if(clrflag) wclear(mwin);
  wbkgdset(mwin,0);
  dnum_row=csd->num_row;
  drow=csd->row;
  dtext=csd->text;
  dattrib=csd->attrib;
/* Start of diagnostic section ---------------------------------*/
  sprintf(avail,"Avail. CC:%c%c Text:%c%c doing %5s",
               (ccdat[0].num_row!=0)?'1':' ',
               (ccdat[1].num_row!=0)?'2':' ',
               (ccdat[2].num_row!=0)?'1':' ',
               (ccdat[3].num_row!=0)?'2':' ',
               short_title[curmode+1]);
  sum=i=0; while(avail[i]!=0) sum+=avail[i++];
  if(sum!=navail) mvwaddstr(twin,0,1,avail);
  navail=sum;
  sprintf(edsd,"Num of EDS %6i",edsdat->num);
  sum=i=0; while(edsd[i]!=0) sum+=edsd[i++];
  if(sum!=nedsd) mvwaddstr(twin,1,1,edsd);
  nedsd=sum;
/*  if(preveds!=edsdat->num) {
    preveds=edsdat->num;
    wmove(twin,2,1);
    for(i=0,j=edsdat->cur;i<EDS_BUFMAX;i++,j++) {
      if(j>=EDS_BUFMAX) j=0;
      waddch(twin,edsdat->buf[j]);
      if(((i+1)%(EDS_BUFMAX/2))==0) wmove(twin,3,1);
      }
    }
*/
  wnoutrefresh(twin);
/* End of diagnostic section ----------------------------------*/
  for(row=0;row<dnum_row;row++) {
    crow=drow[row]-1;
    if(crow<0) continue;
    for(col=0; col<(CC_COLUMNS+2);col++) {
      /* Some logic here is to add a space before and after blanks
         this is optional but is intended to make text easier to read */
      if(col==0) {
        if((!clrflag)&&(!(dattrib[row][0]&CC_ATTR_NEWCHAR))) continue;
        if(dtext[row][0]!=CC_INVSPACE) mvwaddch(mwin,crow,0,' ');
        continue;
        }
      if(col==(CC_COLUMNS+1)) {
        if((!clrflag)&&(!(dattrib[row][CC_COLUMNS-1]&CC_ATTR_NEWCHAR))) 
          continue;
        if(dtext[row][CC_COLUMNS-1]!=CC_INVSPACE) 
          mvwaddch(mwin,crow,CC_COLUMNS+1,' ');
        continue;
        }
      if(dtext[row][col-1]==CC_INVSPACE) {
        if(col>1) 
          if(clrflag||(dattrib[row][col-2]&CC_ATTR_NEWCHAR))
            if(dtext[row][col-2]!=CC_INVSPACE)
              mvwaddch(mwin,crow,col,' ');
        if(col<(CC_COLUMNS-2)) 
          if(clrflag||(dattrib[row][col]&CC_ATTR_NEWCHAR))
            if(dtext[row][col]!=CC_INVSPACE) mvwaddch(mwin,crow,col,' ');
        continue;
        }
      if((!clrflag)&&(!(dattrib[row][col-1]&CC_ATTR_NEWCHAR))) continue;
      mvwaddch(mwin,crow,col,dtext[row][col-1]|
                            cursattr(dattrib[row][col-1]));
      }
    for(col=0; col<CC_COLUMNS;col++) 
      dattrib[row][col]&= ~CC_ATTR_NEWCHAR;
    }
  wnoutrefresh(mwin);
  doupdate();
  clrflag=0; *csd->clrflag=0;
  }

void cc_mode(int mode) {
  if(ccerror) return;
  if((mode==-1)&&(curmode==-1)) return;
  if((mode==-1)&&(curmode>=0)) {
    curmode=-1; 
#ifndef CCTEST
    wbkgdset(mwin,COLOR_PAIR(0));
    wclear(mwin);
    wclear(twin);
    wrefresh(mwin);
    wrefresh(twin);
    endwin();
    return;
#endif
    }
  else if((mode!=-1)&&(curmode==-1)) {
    curmode=mode;
    navail=nedsd=0;
    preveds=-1;
#ifndef CCTEST
    mainw=initscr();
    start_color();
    if(COLOR_PAIRS>7) {
      /* 0 is white on black */
      init_pair(1,COLOR_GREEN,COLOR_BLACK);
      init_pair(2,COLOR_BLUE,COLOR_BLACK);
      init_pair(3,COLOR_CYAN,COLOR_BLACK);
      init_pair(4,COLOR_RED,COLOR_BLACK);
      init_pair(5,COLOR_YELLOW,COLOR_BLACK);
      init_pair(6,COLOR_MAGENTA,COLOR_BLACK);
      init_pair(7,COLOR_WHITE,COLOR_BLUE); /* To be use for the rest of the
                                            screen */
      }
    mwin=newwin(15,34+1,7,0); /* 34+1: +1 is to prevent line wrap */
    twin=newwin(5,78,2,0); 
    if((mwin==NULL)||(twin==NULL)) {endwin(); ccerror=1; 
                   printf("Problems creating windows. tty too small ?\n");
                   return;}
    scrollok(mwin,0);
    clrflag=1;
    cc_show(); 
    return;
#endif
    }
  curmode=mode;
  clrflag=1;
  cc_show(); 
  }

/* input CC attr, returns attr to use with wattrset */
int cursattr(int attr){
  int ret=0;
  if(attr&CC_ATTR_UNDERLINE) ret|=A_UNDERLINE;
  if(attr&CC_ATTR_FLASH) ret|=A_BLINK;
  if(attr&CC_ATTR_ITALICS) ret|=A_REVERSE;
  ret|=COLOR_PAIR((attr&0xff)>>4);
  return ret;
  }
