/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/global.h,v 1.5 1999/02/28 20:10:29 ghn Exp $
 * PURPOSE:     Declare global types, constants, and variables
 * AUTHOR:      Greg Nelson
 * DATE:        98-04-12
 *
 * REVISED:
 * $Log: global.h,v $
 * Revision 1.5  1999/02/28 20:10:29  ghn
 * Version 5.1: Added netmask field for egg.
 *
 * Revision 1.4  1998/12/31 22:11:05  ghn
 *  Rev 5 code: includes multi-reg support, HTML, etc.
 *
 * Revision 1.3  1998/08/01 18:51:25  ghn
 * Added John's byte-order-independence changes.
 *
 * Revision 1.2  1998/08/01 17:08:20  ghn
 * Added upcmd and dncmd for DND.
 *
 * Revision 1.1  1998/07/21 11:37:56  ghn
 * Initial revision
 *
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#ifndef _GLOBAL_H

#include <netinet/in.h>

#include "byteorder.h"		/* Build byte-order independent version */

/* Good for i386, but be careful... */
typedef unsigned char byte;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
typedef char int8;
typedef short int16;
typedef long int32;

/* Some fixed assumptions:
   Trial type is always bitsum.
   Bit spacing method does not need to be communicated, since we'll
     choose something at compile time. 
   Record size ranges from one to MAXSAMP_REC trials, which are assumed to
     be evenly spaced starting at timestamp.
   Records always begin on round seconds divisible by sec_rec, which
     can range from one to MAXSEC_REC.
*/

/* Some adjustable assumptions: */

#define MINBITS		32	/* Minimum bits per trial */
#define MAXBITS		253	/* Maximum bits per trial */
#define MAXSAMP_REC	10	/* Maximum samples/record */
#define MAXSEC_REC	3000	/* Maximum seconds/record */	

#define SEC_PKT		60	/* Desired number of seconds per packet */
#define MAXREC_PKT	60	/* Maximum number of records per packet
				   For 1-second records (typ) this is 1 min */

#define EGG_MISSING_DATA 254    /* Value used to represent missing data in trials array. */

#if MAXBITS < 256
typedef uint8 trial;
#else
#error "Can't represent MAXBITS in a byte value."
#endif

#if MAXBITS >= EGG_MISSING_DATA
#error "MAXBITS is >= EGG_MISSING_DATA: ambiguous trial data possible."
#endif

typedef struct eggrec {
  uint32 timestamp;	/* Seconds since the epoch (19700101000000Z) */
  trial trials[MAXSAMP_REC]; /* Trial values */
} EggRec;		/* Normally 16 bytes total */

/* Make sure type field of packet is non-zero so that CRC works. */

typedef struct genpacket {
  uint16 type;
  uint16 pktsize;
} GenPacket;

#define DATA_PACKET	0x0101
typedef struct eggheader {
  uint16 type;		/* type */
  uint16 pktsize;	/* Number of bytes in packet */
  uint16 eggid;		/* Identifying number for device */
  uint16 samp_rec;	/* Number of samples per record */
  uint16 sec_rec;	/* Number of seconds per record */
  uint16 rec_pkt;	/* Number of records per packet */
  trial trialsz;	/* Number of bits per trial */
  uint16 numrec;	/* Number of valid records */
} EggHeader;

#define REQ_PACKET	0x0202
typedef struct reqpacket {
  uint16 type;		/* type */
  uint16 pktsize;	/* Number of bytes in packet */
  uint16 eggid;		/* Identifying number for device */
  uint32 starttm;	/* Time for first record to send */
  uint16 cksum;		/* No data, checksum goes inside */
} ReqPacket;

#define AWAKE_PACKET	0x0303
typedef struct awakepacket {
  uint16 type;		/* type */
  uint16 pktsize;	/* Number of bytes in packet */
  uint16 eggid;		/* Identifying number for device */
  uint32 nowtm;		/* Egg's identification of "now" (zulu) */
  uint16 cksum;		/* No data, checksum goes inside */
} AwakePacket;

#define SETTINGS_PACKET	0x0404
typedef struct setpacket {
  uint16 type;		/* type */
  uint16 pktsize;	/* Number of bytes in packet */
  uint16 eggid;		/* Identifying number for device */
  uint32 nowtm;		/* Egg's identification of "now" (zulu) */
  uint16 samp_rec;	/* Number of samples per record */
  uint16 sec_rec;	/* Number of seconds per record */
  uint16 rec_pkt;	/* Number of records per packet */
  trial trialsz;	/* Number of bits per trial */
  uint16 cksum;		/* No data, checksum goes inside */
} SettingsPacket;

/*  An EggCarton is the in-memory representation of a data
    packet.  Fields in it are thus in host byte order,
    being translated, as appropriate, when transferred
    to and from a DATA_PACKET by Packetize() and
    Unpacketize().  */

typedef struct eggpkt {
  EggHeader hdr;	/* Header (type = DATA_PACKET) */
  EggRec records[MAXREC_PKT];
} EggCarton;

typedef struct collect {
  EggHeader opts;
  EggRec data;
  uint16 sampct;		/* Count of completed samples in rec */
  int32 dd;			/* Device handle */
} CollectRecord;

#define CONN_PERM	0
#define CONN_DND	1

typedef struct eggentry {
  char *name;
  int16 id;
  struct sockaddr_in ipaddr;
  int16 netmask;	/* Number of significant bits, default 32. */
  char *primbasket;
  int16 conntype;
  int16 connival;	/* Connect interval in minutes */
  int32 lastupd;	/* Zulutime of last update received */
  int16 setup;		/* Does setup match config file? */
  char *upcmd;		/* Command to bring net up (req if conntype == DND) */
  char *dncmd;		/* Command to bring net down */
  char *url;		/* URL describing basket or NULL */
} EggEntry;

typedef struct basketentry {
  char *name;
  struct sockaddr_in ipaddr;
} BasketEntry;

#define MAX_EGGS	100
#define MAX_BASKETS	5

extern EggEntry eggtable[MAX_EGGS];
extern BasketEntry baskettable[MAX_BASKETS];
extern short numeggs, numbaskets;
extern EggHeader protocol;

extern char *pgmname;	/* For error messages to announce program name */

#define TRUE	-1
#define FALSE	0

#define _GLOBAL_H
#endif /* _GLOBAL_H */
