static const char* noise_hurl_cl_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2013 Carlos Zubieta <czubieta.dev@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"__kernel void cl_noise_hurl(__global       float4    *src,                    \n"
"                            __global const int       *random_data,            \n"
"                                           int        x_offset,               \n"
"                                           int        y_offset,               \n"
"                                           int        roi_width,              \n"
"                                           int        whole_region_width,     \n"
"                                           GeglRandom rand,                   \n"
"                                           float      pct_random,             \n"
"                                           int        gray,                   \n"
"                                           int        offset)                 \n"
"{                                                                             \n"
"  int gid  = get_global_id(0);                                                \n"
"  int gidy = gid / roi_width;                                                 \n"
"  int gidx = gid - gidy*roi_width;                                            \n"
"                                                                              \n"
"  int x = gidx + x_offset;                                                    \n"
"  int y = gidy + y_offset;                                                    \n"
"  int n = 4 * (x + whole_region_width * y + offset);                          \n"
"                                                                              \n"
"  float4 src_v = src[gid];                                                    \n"
"                                                                              \n"
"  float pc          = gegl_cl_random_float_range (random_data,                \n"
"                                                  rand, x, y, 0, n, 0, 100);  \n"
"                                                                              \n"
"  if(pc <= pct_random)                                                        \n"
"    {                                                                         \n"
"      float red_noise   = gegl_cl_random_float (random_data,                  \n"
"                                                rand, x, y, 0, n+1);          \n"
"                                                                              \n"
"      src_v.x = red_noise;                                                    \n"
"      if (gray == 0)                                                          \n"
"      {                                                                       \n"
"        float green_noise = gegl_cl_random_float (random_data,                \n"
"                                                  rand, x, y, 0, n+2);        \n"
"        float blue_noise  = gegl_cl_random_float (random_data,                \n"
"                                                  rand, x, y, 0, n+3);        \n"
"        src_v.y = green_noise;                                                \n"
"        src_v.z = blue_noise;                                                 \n"
"      }                                                                       \n"
"      else                                                                    \n"
"      {                                                                       \n"
"        src_v.y = red_noise;                                                  \n"
"        src_v.z = red_noise;                                                  \n"
"      }                                                                       \n"
"    }                                                                         \n"
"  src[gid] = src_v;                                                           \n"
"}                                                                             \n"
;
