/* Copyright (C) 1992-1998 The Geometry Center
 * Copyright (C) 1998-2000 Stuart Levy, Tamara Munzner, Mark Phillips
 *
 * This file is part of Geomview.
 * 
 * Geomview is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * Geomview is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with Geomview; see the file COPYING.  If not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA, or visit http://www.gnu.org.
 */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#if 0
static char copyright[] = "Copyright (C) 1992-1998 The Geometry Center\n\
Copyright (C) 1998-2000 Stuart Levy, Tamara Munzner, Mark Phillips";
#endif

#line 2 "lex.fparse_yy.c"
/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /cvsroot/geomview/geomview/src/lib/fexpr/lex.yy.c,v 1.5 2006/07/15 19:05:57 rotdrop Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define fparse_yyconst const
#else
#define fparse_yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN fparse_yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((fparse_yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE fparse_yyrestart( fparse_yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct fparse_yy_buffer_state *YY_BUFFER_STATE;

extern int fparse_yyleng;
extern FILE *fparse_yyin, *fparse_yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		fparse_yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the fparse_yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define fparse_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up fparse_yytext. */ \
		*fparse_yy_cp = fparse_yy_hold_char; \
		fparse_yy_c_buf_p = fparse_yy_cp = fparse_yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up fparse_yytext again */ \
		} \
	while ( 0 )

#define unput(c) fparse_yyunput( c, fparse_yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int fparse_yy_size_t;


struct fparse_yy_buffer_state
	{
	FILE *fparse_yy_input_file;

	char *fparse_yy_ch_buf;		/* input buffer */
	char *fparse_yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	fparse_yy_size_t fparse_yy_buf_size;

	/* Number of characters read into fparse_yy_ch_buf, not including EOB
	 * characters.
	 */
	int fparse_yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int fparse_yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int fparse_yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int fparse_yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int fparse_yy_fill_buffer;

	int fparse_yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via fparse_yyrestart()), so that the user can continue scanning by
	 * just pointing fparse_yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE fparse_yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER fparse_yy_current_buffer


/* fparse_yy_hold_char holds the character lost when fparse_yytext is formed. */
static char fparse_yy_hold_char;

static int fparse_yy_n_chars;		/* number of characters read into fparse_yy_ch_buf */


int fparse_yyleng;

/* Points to current character in buffer. */
static char *fparse_yy_c_buf_p = (char *) 0;
static int fparse_yy_init = 1;		/* whether we need to initialize */
static int fparse_yy_start = 0;	/* start state number */

/* Flag which is used to allow fparse_yywrap()'s to do buffer switches
 * instead of setting up a fresh fparse_yyin.  A bit of a hack ...
 */
static int fparse_yy_did_buffer_switch_on_eof;

void fparse_yyrestart YY_PROTO(( FILE *input_file ));

void fparse_yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void fparse_yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE fparse_yy_create_buffer YY_PROTO(( FILE *file, int size ));
void fparse_yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void fparse_yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void fparse_yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER fparse_yy_flush_buffer( fparse_yy_current_buffer )

YY_BUFFER_STATE fparse_yy_scan_buffer YY_PROTO(( char *base, fparse_yy_size_t size ));
YY_BUFFER_STATE fparse_yy_scan_string YY_PROTO(( fparse_yyconst char *str ));
YY_BUFFER_STATE fparse_yy_scan_bytes YY_PROTO(( fparse_yyconst char *bytes, int len ));

static void *fparse_yy_flex_alloc YY_PROTO(( fparse_yy_size_t ));
static void *fparse_yy_flex_realloc YY_PROTO(( void *, fparse_yy_size_t ));
static void fparse_yy_flex_free YY_PROTO(( void * ));

#define fparse_yy_new_buffer fparse_yy_create_buffer

#define fparse_yy_set_interactive(is_interactive) \
	{ \
	if ( ! fparse_yy_current_buffer ) \
		fparse_yy_current_buffer = fparse_yy_create_buffer( fparse_yyin, YY_BUF_SIZE ); \
	fparse_yy_current_buffer->fparse_yy_is_interactive = is_interactive; \
	}

#define fparse_yy_set_bol(at_bol) \
	{ \
	if ( ! fparse_yy_current_buffer ) \
		fparse_yy_current_buffer = fparse_yy_create_buffer( fparse_yyin, YY_BUF_SIZE ); \
	fparse_yy_current_buffer->fparse_yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (fparse_yy_current_buffer->fparse_yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *fparse_yyin = (FILE *) 0, *fparse_yyout = (FILE *) 0;
typedef int fparse_yy_state_type;
extern char *fparse_yytext;
#define fparse_yytext_ptr fparse_yytext

static fparse_yy_state_type fparse_yy_get_previous_state YY_PROTO(( void ));
static fparse_yy_state_type fparse_yy_try_NUL_trans YY_PROTO(( fparse_yy_state_type current_state ));
static int fparse_yy_get_next_buffer YY_PROTO(( void ));
static void fparse_yy_fatal_error YY_PROTO(( fparse_yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up fparse_yytext.
 */
#define YY_DO_BEFORE_ACTION \
	fparse_yytext_ptr = fparse_yy_bp; \
	fparse_yyleng = (int) (fparse_yy_cp - fparse_yy_bp); \
	fparse_yy_hold_char = *fparse_yy_cp; \
	*fparse_yy_cp = '\0'; \
	fparse_yy_c_buf_p = fparse_yy_cp;

#define YY_NUM_RULES 4
#define YY_END_OF_BUFFER 5
static fparse_yyconst short int fparse_yy_accept[19] =
    {   0,
        0,    0,    5,    3,    4,    3,    1,    2,    1,    1,
        1,    0,    2,    1,    0,    1,    1,    0
    } ;

static fparse_yyconst int fparse_yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    2,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    1,    3,    4,    1,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    1,    1,    1,
        1,    1,    1,    1,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        1,    1,    1,    1,    7,    1,    6,    6,    6,    6,

        8,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static fparse_yyconst int fparse_yy_meta[9] =
    {   0,
        1,    1,    1,    1,    2,    2,    2,    2
    } ;

static fparse_yyconst short int fparse_yy_base[20] =
    {   0,
        0,    0,   21,   22,   22,   14,    5,    0,    9,   11,
        0,   15,    0,    0,   10,    7,   22,   22,    9
    } ;

static fparse_yyconst short int fparse_yy_def[20] =
    {   0,
       18,    1,   18,   18,   18,   18,   18,   19,   18,    9,
        7,   18,   19,   10,   18,   18,   18,    0,   18
    } ;

static fparse_yyconst short int fparse_yy_nxt[31] =
    {   0,
        4,    5,    4,    6,    7,    8,    4,    8,   10,   11,
       13,   17,   12,    9,   16,   14,   12,   15,    9,   16,
       18,    3,   18,   18,   18,   18,   18,   18,   18,   18
    } ;

static fparse_yyconst short int fparse_yy_chk[31] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    7,    7,
       19,   16,    7,    9,   15,   10,    9,   12,    6,   12,
        3,   18,   18,   18,   18,   18,   18,   18,   18,   18
    } ;

static fparse_yy_state_type fparse_yy_last_accepting_state;
static char *fparse_yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define fparse_yymore() fparse_yymore_used_but_not_detected
#define YY_MORE_ADJ 0
char *fparse_yytext;
#line 1 "../lexical.l"
#define INITIAL 0
#line 2 "../lexical.l"

#include <stdlib.h>
#include <string.h>
#include "parse.tab.h"

#define	fparse_yywrap()	1

static int inputpos=0;
static char *bufptr;
static int buflen;

void expr_lex_reset_input(char *buf)
{
  bufptr = buf;
  inputpos = 0;
  buflen = strlen(buf);
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) do_fparse_yy_input((buf),&(result),(max_size))

void do_fparse_yy_input(char *buf, int *result, int max_size)
{
  if (inputpos == buflen) {
    (*result) = 0;
  } else {
    int size = max_size < buflen-inputpos ? max_size : buflen-inputpos;
    memcpy (buf, bufptr+inputpos, size);
    (*result) = size;
    inputpos += size;
  }
}

#line 403 "lex.fparse_yy.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int fparse_yywrap YY_PROTO(( void ));
#else
extern int fparse_yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void fparse_yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef fparse_yytext_ptr
static void fparse_yy_flex_strncpy YY_PROTO(( char *, fparse_yyconst char *, int ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int fparse_yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int fparse_yy_start_stack_ptr = 0;
static int fparse_yy_start_stack_depth = 0;
static int *fparse_yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void fparse_yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void fparse_yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int fparse_yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( fparse_yytext, fparse_yyleng, 1, fparse_yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( fparse_yy_current_buffer->fparse_yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( fparse_yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( fparse_yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, fparse_yyin )) == 0) \
		  && ferror( fparse_yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "fparse_yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef fparse_yyterminate
#define fparse_yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) fparse_yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int fparse_yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after fparse_yytext and fparse_yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	fparse_yy_state_type fparse_yy_current_state;
	char *fparse_yy_cp, *fparse_yy_bp;
	int fparse_yy_act;

#line 41 "../lexical.l"



#line 554 "lex.fparse_yy.c"

	if ( fparse_yy_init )
		{
		fparse_yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! fparse_yy_start )
			fparse_yy_start = 1;	/* first start state */

		if ( ! fparse_yyin )
			fparse_yyin = stdin;

		if ( ! fparse_yyout )
			fparse_yyout = stdout;

		if ( ! fparse_yy_current_buffer )
			fparse_yy_current_buffer =
				fparse_yy_create_buffer( fparse_yyin, YY_BUF_SIZE );

		fparse_yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		fparse_yy_cp = fparse_yy_c_buf_p;

		/* Support of fparse_yytext. */
		*fparse_yy_cp = fparse_yy_hold_char;

		/* fparse_yy_bp points to the position in fparse_yy_ch_buf of the start of
		 * the current run.
		 */
		fparse_yy_bp = fparse_yy_cp;

		fparse_yy_current_state = fparse_yy_start;
fparse_yy_match:
		do
			{
			YY_CHAR fparse_yy_c = fparse_yy_ec[YY_SC_TO_UI(*fparse_yy_cp)];
			if ( fparse_yy_accept[fparse_yy_current_state] )
				{
				fparse_yy_last_accepting_state = fparse_yy_current_state;
				fparse_yy_last_accepting_cpos = fparse_yy_cp;
				}
			while ( fparse_yy_chk[fparse_yy_base[fparse_yy_current_state] + fparse_yy_c] != fparse_yy_current_state )
				{
				fparse_yy_current_state = (int) fparse_yy_def[fparse_yy_current_state];
				if ( fparse_yy_current_state >= 19 )
					fparse_yy_c = fparse_yy_meta[(unsigned int) fparse_yy_c];
				}
			fparse_yy_current_state = fparse_yy_nxt[fparse_yy_base[fparse_yy_current_state] + (unsigned int) fparse_yy_c];
			++fparse_yy_cp;
			}
		while ( fparse_yy_base[fparse_yy_current_state] != 22 );

fparse_yy_find_action:
		fparse_yy_act = fparse_yy_accept[fparse_yy_current_state];
		if ( fparse_yy_act == 0 )
			{ /* have to back up */
			fparse_yy_cp = fparse_yy_last_accepting_cpos;
			fparse_yy_current_state = fparse_yy_last_accepting_state;
			fparse_yy_act = fparse_yy_accept[fparse_yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( fparse_yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*fparse_yy_cp = fparse_yy_hold_char;
			fparse_yy_cp = fparse_yy_last_accepting_cpos;
			fparse_yy_current_state = fparse_yy_last_accepting_state;
			goto fparse_yy_find_action;

case 1:
YY_RULE_SETUP
#line 44 "../lexical.l"
{ fparse_yylval.number = atof(fparse_yytext); return NUMBER; }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 45 "../lexical.l"
{ fparse_yylval.string = malloc(strlen(fparse_yytext)+1); strcpy (fparse_yylval.string, fparse_yytext); return IDENT; }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 46 "../lexical.l"
{ if (*fparse_yytext != ' ' && *fparse_yytext != '\n' && *fparse_yytext != '\t') return *fparse_yytext; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 47 "../lexical.l"
ECHO;
	YY_BREAK
#line 657 "lex.fparse_yy.c"
case YY_STATE_EOF(INITIAL):
	fparse_yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int fparse_yy_amount_of_matched_text = (int) (fparse_yy_cp - fparse_yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*fparse_yy_cp = fparse_yy_hold_char;

		if ( fparse_yy_current_buffer->fparse_yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed fparse_yyin at a new source and called
			 * fparse_yylex().  If so, then we have to assure
			 * consistency between fparse_yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			fparse_yy_n_chars = fparse_yy_current_buffer->fparse_yy_n_chars;
			fparse_yy_current_buffer->fparse_yy_input_file = fparse_yyin;
			fparse_yy_current_buffer->fparse_yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for fparse_yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since fparse_yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( fparse_yy_c_buf_p <= &fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars] )
			{ /* This was really a NUL. */
			fparse_yy_state_type fparse_yy_next_state;

			fparse_yy_c_buf_p = fparse_yytext_ptr + fparse_yy_amount_of_matched_text;

			fparse_yy_current_state = fparse_yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * fparse_yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			fparse_yy_next_state = fparse_yy_try_NUL_trans( fparse_yy_current_state );

			fparse_yy_bp = fparse_yytext_ptr + YY_MORE_ADJ;

			if ( fparse_yy_next_state )
				{
				/* Consume the NUL. */
				fparse_yy_cp = ++fparse_yy_c_buf_p;
				fparse_yy_current_state = fparse_yy_next_state;
				goto fparse_yy_match;
				}

			else
				{
				fparse_yy_cp = fparse_yy_c_buf_p;
				goto fparse_yy_find_action;
				}
			}

		else switch ( fparse_yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				fparse_yy_did_buffer_switch_on_eof = 0;

				if ( fparse_yywrap() )
					{
					/* Note: because we've taken care in
					 * fparse_yy_get_next_buffer() to have set up
					 * fparse_yytext, we can now set up
					 * fparse_yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					fparse_yy_c_buf_p = fparse_yytext_ptr + YY_MORE_ADJ;

					fparse_yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! fparse_yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				fparse_yy_c_buf_p =
					fparse_yytext_ptr + fparse_yy_amount_of_matched_text;

				fparse_yy_current_state = fparse_yy_get_previous_state();

				fparse_yy_cp = fparse_yy_c_buf_p;
				fparse_yy_bp = fparse_yytext_ptr + YY_MORE_ADJ;
				goto fparse_yy_match;

			case EOB_ACT_LAST_MATCH:
				fparse_yy_c_buf_p =
				&fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars];

				fparse_yy_current_state = fparse_yy_get_previous_state();

				fparse_yy_cp = fparse_yy_c_buf_p;
				fparse_yy_bp = fparse_yytext_ptr + YY_MORE_ADJ;
				goto fparse_yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of fparse_yylex */


/* fparse_yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int fparse_yy_get_next_buffer()
	{
	char *dest = fparse_yy_current_buffer->fparse_yy_ch_buf;
	char *source = fparse_yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( fparse_yy_c_buf_p > &fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( fparse_yy_current_buffer->fparse_yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( fparse_yy_c_buf_p - fparse_yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a singled characater, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (fparse_yy_c_buf_p - fparse_yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( fparse_yy_current_buffer->fparse_yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		fparse_yy_n_chars = 0;

	else
		{
		int num_to_read =
			fparse_yy_current_buffer->fparse_yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = fparse_yy_current_buffer;

			int fparse_yy_c_buf_p_offset =
				(int) (fparse_yy_c_buf_p - b->fparse_yy_ch_buf);

			if ( b->fparse_yy_is_our_buffer )
				{
				int new_size = b->fparse_yy_buf_size * 2;

				if ( new_size <= 0 )
					b->fparse_yy_buf_size += b->fparse_yy_buf_size / 8;
				else
					b->fparse_yy_buf_size *= 2;

				b->fparse_yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					fparse_yy_flex_realloc( (void *) b->fparse_yy_ch_buf,
							 b->fparse_yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->fparse_yy_ch_buf = 0;

			if ( ! b->fparse_yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			fparse_yy_c_buf_p = &b->fparse_yy_ch_buf[fparse_yy_c_buf_p_offset];

			num_to_read = fparse_yy_current_buffer->fparse_yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&fparse_yy_current_buffer->fparse_yy_ch_buf[number_to_move]),
			fparse_yy_n_chars, num_to_read );
		}

	if ( fparse_yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			fparse_yyrestart( fparse_yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			fparse_yy_current_buffer->fparse_yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	fparse_yy_n_chars += number_to_move;
	fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	fparse_yytext_ptr = &fparse_yy_current_buffer->fparse_yy_ch_buf[0];

	return ret_val;
	}


/* fparse_yy_get_previous_state - get the state just before the EOB char was reached */

static fparse_yy_state_type fparse_yy_get_previous_state()
	{
	fparse_yy_state_type fparse_yy_current_state;
	char *fparse_yy_cp;

	fparse_yy_current_state = fparse_yy_start;

	for ( fparse_yy_cp = fparse_yytext_ptr + YY_MORE_ADJ; fparse_yy_cp < fparse_yy_c_buf_p; ++fparse_yy_cp )
		{
		YY_CHAR fparse_yy_c = (*fparse_yy_cp ? fparse_yy_ec[YY_SC_TO_UI(*fparse_yy_cp)] : 1);
		if ( fparse_yy_accept[fparse_yy_current_state] )
			{
			fparse_yy_last_accepting_state = fparse_yy_current_state;
			fparse_yy_last_accepting_cpos = fparse_yy_cp;
			}
		while ( fparse_yy_chk[fparse_yy_base[fparse_yy_current_state] + fparse_yy_c] != fparse_yy_current_state )
			{
			fparse_yy_current_state = (int) fparse_yy_def[fparse_yy_current_state];
			if ( fparse_yy_current_state >= 19 )
				fparse_yy_c = fparse_yy_meta[(unsigned int) fparse_yy_c];
			}
		fparse_yy_current_state = fparse_yy_nxt[fparse_yy_base[fparse_yy_current_state] + (unsigned int) fparse_yy_c];
		}

	return fparse_yy_current_state;
	}


/* fparse_yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = fparse_yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static fparse_yy_state_type fparse_yy_try_NUL_trans( fparse_yy_state_type fparse_yy_current_state )
#else
static fparse_yy_state_type fparse_yy_try_NUL_trans( fparse_yy_current_state )
fparse_yy_state_type fparse_yy_current_state;
#endif
	{
	int fparse_yy_is_jam;
	char *fparse_yy_cp = fparse_yy_c_buf_p;

	YY_CHAR fparse_yy_c = 1;
	if ( fparse_yy_accept[fparse_yy_current_state] )
		{
		fparse_yy_last_accepting_state = fparse_yy_current_state;
		fparse_yy_last_accepting_cpos = fparse_yy_cp;
		}
	while ( fparse_yy_chk[fparse_yy_base[fparse_yy_current_state] + fparse_yy_c] != fparse_yy_current_state )
		{
		fparse_yy_current_state = (int) fparse_yy_def[fparse_yy_current_state];
		if ( fparse_yy_current_state >= 19 )
			fparse_yy_c = fparse_yy_meta[(unsigned int) fparse_yy_c];
		}
	fparse_yy_current_state = fparse_yy_nxt[fparse_yy_base[fparse_yy_current_state] + (unsigned int) fparse_yy_c];
	fparse_yy_is_jam = (fparse_yy_current_state == 18);

	return fparse_yy_is_jam ? 0 : fparse_yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void fparse_yyunput( int c, char *fparse_yy_bp )
#else
static void fparse_yyunput( c, fparse_yy_bp )
int c;
char *fparse_yy_bp;
#endif
	{
	char *fparse_yy_cp = fparse_yy_c_buf_p;

	/* undo effects of setting up fparse_yytext */
	*fparse_yy_cp = fparse_yy_hold_char;

	if ( fparse_yy_cp < fparse_yy_current_buffer->fparse_yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = fparse_yy_n_chars + 2;
		char *dest = &fparse_yy_current_buffer->fparse_yy_ch_buf[
					fparse_yy_current_buffer->fparse_yy_buf_size + 2];
		char *source =
				&fparse_yy_current_buffer->fparse_yy_ch_buf[number_to_move];

		while ( source > fparse_yy_current_buffer->fparse_yy_ch_buf )
			*--dest = *--source;

		fparse_yy_cp += (int) (dest - source);
		fparse_yy_bp += (int) (dest - source);
		fparse_yy_n_chars = fparse_yy_current_buffer->fparse_yy_buf_size;

		if ( fparse_yy_cp < fparse_yy_current_buffer->fparse_yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--fparse_yy_cp = (char) c;


	fparse_yytext_ptr = fparse_yy_bp;
	fparse_yy_hold_char = *fparse_yy_cp;
	fparse_yy_c_buf_p = fparse_yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int fparse_yyinput()
#else
static int input()
#endif
	{
	int c;

	*fparse_yy_c_buf_p = fparse_yy_hold_char;

	if ( *fparse_yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* fparse_yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( fparse_yy_c_buf_p < &fparse_yy_current_buffer->fparse_yy_ch_buf[fparse_yy_n_chars] )
			/* This was really a NUL. */
			*fparse_yy_c_buf_p = '\0';

		else
			{ /* need more input */
			fparse_yytext_ptr = fparse_yy_c_buf_p;
			++fparse_yy_c_buf_p;

			switch ( fparse_yy_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( fparse_yywrap() )
						{
						fparse_yy_c_buf_p =
						fparse_yytext_ptr + YY_MORE_ADJ;
						return EOF;
						}

					if ( ! fparse_yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return fparse_yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					fparse_yy_c_buf_p = fparse_yytext_ptr + YY_MORE_ADJ;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					YY_FATAL_ERROR(
					"unexpected last match in fparse_yyinput()" );
#else
					YY_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) fparse_yy_c_buf_p;	/* cast for 8-bit char's */
	*fparse_yy_c_buf_p = '\0';	/* preserve fparse_yytext */
	fparse_yy_hold_char = *++fparse_yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void fparse_yyrestart( FILE *input_file )
#else
void fparse_yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! fparse_yy_current_buffer )
		fparse_yy_current_buffer = fparse_yy_create_buffer( fparse_yyin, YY_BUF_SIZE );

	fparse_yy_init_buffer( fparse_yy_current_buffer, input_file );
	fparse_yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void fparse_yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void fparse_yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( fparse_yy_current_buffer == new_buffer )
		return;

	if ( fparse_yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*fparse_yy_c_buf_p = fparse_yy_hold_char;
		fparse_yy_current_buffer->fparse_yy_buf_pos = fparse_yy_c_buf_p;
		fparse_yy_current_buffer->fparse_yy_n_chars = fparse_yy_n_chars;
		}

	fparse_yy_current_buffer = new_buffer;
	fparse_yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (fparse_yywrap()) processing, but the only time this flag
	 * is looked at is after fparse_yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	fparse_yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void fparse_yy_load_buffer_state( void )
#else
void fparse_yy_load_buffer_state()
#endif
	{
	fparse_yy_n_chars = fparse_yy_current_buffer->fparse_yy_n_chars;
	fparse_yytext_ptr = fparse_yy_c_buf_p = fparse_yy_current_buffer->fparse_yy_buf_pos;
	fparse_yyin = fparse_yy_current_buffer->fparse_yy_input_file;
	fparse_yy_hold_char = *fparse_yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE fparse_yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE fparse_yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) fparse_yy_flex_alloc( sizeof( struct fparse_yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in fparse_yy_create_buffer()" );

	b->fparse_yy_buf_size = size;

	/* fparse_yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->fparse_yy_ch_buf = (char *) fparse_yy_flex_alloc( b->fparse_yy_buf_size + 2 );
	if ( ! b->fparse_yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in fparse_yy_create_buffer()" );

	b->fparse_yy_is_our_buffer = 1;

	fparse_yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void fparse_yy_delete_buffer( YY_BUFFER_STATE b )
#else
void fparse_yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == fparse_yy_current_buffer )
		fparse_yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->fparse_yy_is_our_buffer )
		fparse_yy_flex_free( (void *) b->fparse_yy_ch_buf );

	fparse_yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void fparse_yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void fparse_yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	fparse_yy_flush_buffer( b );

	b->fparse_yy_input_file = file;
	b->fparse_yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->fparse_yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->fparse_yy_is_interactive = 0;
#else
	b->fparse_yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void fparse_yy_flush_buffer( YY_BUFFER_STATE b )
#else
void fparse_yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	b->fparse_yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->fparse_yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->fparse_yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->fparse_yy_buf_pos = &b->fparse_yy_ch_buf[0];

	b->fparse_yy_at_bol = 1;
	b->fparse_yy_buffer_status = YY_BUFFER_NEW;

	if ( b == fparse_yy_current_buffer )
		fparse_yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE fparse_yy_scan_buffer( char *base, fparse_yy_size_t size )
#else
YY_BUFFER_STATE fparse_yy_scan_buffer( base, size )
char *base;
fparse_yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) fparse_yy_flex_alloc( sizeof( struct fparse_yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in fparse_yy_scan_buffer()" );

	b->fparse_yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->fparse_yy_buf_pos = b->fparse_yy_ch_buf = base;
	b->fparse_yy_is_our_buffer = 0;
	b->fparse_yy_input_file = 0;
	b->fparse_yy_n_chars = b->fparse_yy_buf_size;
	b->fparse_yy_is_interactive = 0;
	b->fparse_yy_at_bol = 1;
	b->fparse_yy_fill_buffer = 0;
	b->fparse_yy_buffer_status = YY_BUFFER_NEW;

	fparse_yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE fparse_yy_scan_string( fparse_yyconst char *str )
#else
YY_BUFFER_STATE fparse_yy_scan_string( str )
fparse_yyconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return fparse_yy_scan_bytes( str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE fparse_yy_scan_bytes( fparse_yyconst char *bytes, int len )
#else
YY_BUFFER_STATE fparse_yy_scan_bytes( bytes, len )
fparse_yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	fparse_yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) fparse_yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in fparse_yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = fparse_yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in fparse_yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->fparse_yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void fparse_yy_push_state( int new_state )
#else
static void fparse_yy_push_state( new_state )
int new_state;
#endif
	{
	if ( fparse_yy_start_stack_ptr >= fparse_yy_start_stack_depth )
		{
		fparse_yy_size_t new_size;

		fparse_yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = fparse_yy_start_stack_depth * sizeof( int );

		if ( ! fparse_yy_start_stack )
			fparse_yy_start_stack = (int *) fparse_yy_flex_alloc( new_size );

		else
			fparse_yy_start_stack = (int *) fparse_yy_flex_realloc(
					(void *) fparse_yy_start_stack, new_size );

		if ( ! fparse_yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	fparse_yy_start_stack[fparse_yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void fparse_yy_pop_state()
	{
	if ( --fparse_yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(fparse_yy_start_stack[fparse_yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int fparse_yy_top_state()
	{
	return fparse_yy_start_stack[fparse_yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void fparse_yy_fatal_error( fparse_yyconst char msg[] )
#else
static void fparse_yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine fparse_yyless() so it works in section 3 code. */

#undef fparse_yyless
#define fparse_yyless(n) \
	do \
		{ \
		/* Undo effects of setting up fparse_yytext. */ \
		fparse_yytext[fparse_yyleng] = fparse_yy_hold_char; \
		fparse_yy_c_buf_p = fparse_yytext + n - YY_MORE_ADJ; \
		fparse_yy_hold_char = *fparse_yy_c_buf_p; \
		*fparse_yy_c_buf_p = '\0'; \
		fparse_yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef fparse_yytext_ptr
#ifdef YY_USE_PROTOS
static void fparse_yy_flex_strncpy( char *s1, fparse_yyconst char *s2, int n )
#else
static void fparse_yy_flex_strncpy( s1, s2, n )
char *s1;
fparse_yyconst char *s2;
int n;
#endif
	{
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif


#ifdef YY_USE_PROTOS
static void *fparse_yy_flex_alloc( fparse_yy_size_t size )
#else
static void *fparse_yy_flex_alloc( size )
fparse_yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *fparse_yy_flex_realloc( void *ptr, fparse_yy_size_t size )
#else
static void *fparse_yy_flex_realloc( ptr, size )
void *ptr;
fparse_yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void fparse_yy_flex_free( void *ptr )
#else
static void fparse_yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	fparse_yylex();
	return 0;
	}
#endif
#line 47 "../lexical.l"

/* more c stuff */
