
def test_context_repr():
    """
    Context: Representation.

    >>> from glitch.context import Context
    >>> c = Context()

    >>> c
    Context({})
    >>> c = Context({'foo': 1})
    >>> c
    Context({'foo': 1})
    """

def test_context_get_set():
    """
    Context: Getting and setting values.

    >>> from glitch.context import Context
    >>> c = Context({'foo': 1})

    >>> c['foo']
    1
    >>> c['foo'] = 3
    >>> c['foo']
    3
    """

def test_context_push_pop():
    """
    Context: Pushing and popping.

    >>> from glitch.context import Context
    >>> c = Context()

    >>> c['bar'] = 2
    >>> c.push('bar') # doctest: +ELLIPSIS
    <...>
    >>> c['bar']
    2
    >>> c['bar'] = 4
    >>> c['bar']
    4
    >>> c.pop()
    >>> c['bar']
    2

    Pushing with value.

    >>> c.push('bar', 4) # doctest: +ELLIPSIS
    <...>
    >>> c['bar']
    4
    >>> c.pop()
    >>> c['bar']
    2
    """

def test_context_push_absent():
    """
    Context: Pushing an absent value.

    >>> from glitch.context import Context
    >>> c = Context()

    >>> c.push('baz') # doctest: +ELLIPSIS
    <...>
    >>> c['baz'] = 5
    >>> c['baz']
    5
    >>> c.pop()
    >>> 'baz' in c
    False

    Pushing a value that doesn't get set before getting popped.

    >>> c.push('quux') # doctest: +ELLIPSIS
    <...>
    >>> c.pop()
    """

def test_context_with():
    """
    Context: Using with statement.

    >>> from __future__ import with_statement

    >>> from glitch.context import Context
    >>> c = Context()

    >>> with c.push('quux'):
    ...     c['quux'] = 2
    ...
    >>> 'quux' in c
    False
    """

def test_context_copy():
    """
    Context: Pushing mutable values.

    >>> from __future__ import with_statement

    >>> from glitch.context import Context
    >>> c = Context()

    >>> c['x'] = {'a': 1, 'b': 2}
    >>> with c.push('x'):
    ...     c['x']['c'] = 3
    ...
    >>> sorted(c['x'].items())
    [('a', 1), ('b', 2)]
    """
