#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "gm-support.h"
#include "gm-debug.h"
#include "gm-app.h"
#include "gm-open-world-dialog.h"
#include "gm-pixbuf.h"
#include "widgets/gm-worlds-view.h"

typedef struct _GmOpenWorldDialog {
	GladeXML *xml;
	GtkWidget *dialog;
} GmOpenWorldDialog;

void on_gm_open_world_dialog_tree_view_worlds_row_activated(
		GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column,
		gpointer user_data);

void on_gm_open_world_dialog_response(GtkDialog *dialog, gint response,
		gpointer user_data);

static GmOpenWorldDialog *gm_open_world_dialog_instance;

GtkWidget *
gm_open_world_dialog_widget(gchar *name) {
	return glade_xml_get_widget(gm_open_world_dialog_instance->xml, name);
}

#define GM_OPEN_WORLD_DIALOG_XML PACKAGE_DATA_DIR "/" PACKAGE \
		"/ui/gm-open-world.glade"

GtkWidget *
gm_open_world_dialog_create_tree_view(gchar *widget_name, gchar *string1, 
		gchar *string2, gint int1, gint int2) {
	GtkWidget *tree_view = gm_worlds_view_new();

	g_signal_connect(tree_view, "row-activated",
			G_CALLBACK(on_gm_open_world_dialog_tree_view_worlds_row_activated), 
			NULL);

	gtk_widget_show(GTK_WIDGET(tree_view));
	return GTK_WIDGET(tree_view);
}

void
gm_open_world_dialog_run() {
	GladeXML *xml;
	
	if (gm_open_world_dialog_instance) {
		gtk_widget_show(gm_open_world_dialog_instance->dialog);
		gtk_window_present(GTK_WINDOW(gm_open_world_dialog_instance->dialog));
		return;
	}

	xml = glade_xml_new(GM_OPEN_WORLD_DIALOG_XML, "gm_open_world_dialog", 
			NULL);
	
	if (xml == NULL) {
		gm_debug_msg(DEBUG_ALWAYS, "Couldn't find glade file %s!", 
				GM_OPEN_WORLD_DIALOG_XML);
		return;
	}

	gm_open_world_dialog_instance = g_new0(GmOpenWorldDialog, 1);	
	gm_open_world_dialog_instance->xml = xml;
  	gm_open_world_dialog_instance->dialog = 
  			gm_open_world_dialog_widget("gm_open_world_dialog");
  	
  	gtk_window_set_icon(GTK_WINDOW(gm_open_world_dialog_instance->dialog), 
				gm_pixbuf_get("world.svg"));
 
  	g_signal_connect(gm_open_world_dialog_instance->dialog, "response",
  			G_CALLBACK(on_gm_open_world_dialog_response), NULL);

	gtk_widget_show(gm_open_world_dialog_instance->dialog);
}

static void
gm_open_world_dialog_open_selected_worlds() {
	GtkTreeView *tree_view = GTK_TREE_VIEW(
			gm_open_world_dialog_widget("tree_view_worlds"));
	GtkTreeModel *model = gm_worlds_view_model(GM_WORLDS_VIEW(tree_view));
	GtkTreeSelection *selection = gtk_tree_view_get_selection(tree_view);
	GtkTreeIter iter;
	GList *paths = gtk_tree_selection_get_selected_rows(selection, &model);
	GList *node;
	GmWorld *world;

	if (paths) {
		for (node = paths; node; node = node->next) {
			gtk_tree_model_get_iter(model, &iter, node->data);
			gtk_tree_model_get(model, &iter, GM_WORLDS_VIEW_WORLD_COLUMN, 
						&world, -1);
			
			if (world) {
				gm_world_load(world);
			}
					
			gtk_tree_path_free(node->data);
		}

		g_list_free(paths);
	} else {
		gm_error_dialog(_("You first need to select a world to connect to."),
				GTK_WINDOW(gm_open_world_dialog_instance->dialog));
	}
}

// Callbacks

void
on_gm_open_world_dialog_response(GtkDialog *dialog, gint response,
		gpointer user_data) {
	
	if (response == GTK_RESPONSE_OK) {
		gm_open_world_dialog_open_selected_worlds();
	}
	
  	g_object_unref(gm_open_world_dialog_instance->xml);
  	gtk_widget_destroy(gm_open_world_dialog_instance->dialog);
  	g_free(gm_open_world_dialog_instance);
  	gm_open_world_dialog_instance = NULL;
}

void
on_gm_open_world_dialog_tree_view_worlds_row_activated(
		GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column,
		gpointer user_data) {
	GmWorld *world;
	GtkTreeIter iter;
	GtkTreeModel *model = gm_worlds_view_model(GM_WORLDS_VIEW(tree_view));

	gtk_tree_model_get_iter(model, &iter, path);
	gtk_tree_model_get(model, &iter, GM_WORLDS_VIEW_WORLD_COLUMN, 
				&world, -1);
	
	if (world) {
		gm_world_load(world);
	}
	
	gtk_dialog_response(GTK_DIALOG(gm_open_world_dialog_instance->dialog), 
			GTK_RESPONSE_CLOSE);
}
