/* taquin-game.c generated by valac 0.40.0.6-2c488, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2014-2016 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This file is part of Taquin.
 *
 * Taquin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Taquin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with Taquin. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
enum  {
	GAME_0_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_GAME_TYPE_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	GAME_COMPLETE_SIGNAL,
	GAME_MOVE_SIGNAL,
	GAME_EMPTY_TILE_SIGNAL,
	GAME_CANNOT_MOVE_SIGNAL,
	GAME_CANNOT_UNDO_MORE_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint x;
	gint y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint* _tiles;
	gint _tiles_length1;
	gint _tiles_length2;
	gint _size;
	GameType _game_type;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	gint x_gap;
	gint y_gap;
};


static gpointer game_parent_class = NULL;

GType game_type_get_type (void) G_GNUC_CONST;
gchar* game_type_to_string (GameType self);
GType game_get_type (void) G_GNUC_CONST;
static GType game_undo_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self,
                          GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
Game* game_new (GameType game_type,
                gint size);
Game* game_construct (GType object_type,
                      GameType game_type,
                      gint size);
static void game_set_size (Game* self,
                    gint value);
static void game_set_game_type (Game* self,
                         GameType value);
static void game_set_tiles (Game* self,
                     gint* value,
                     int value_length1,
                     int value_length2);
static gint* _int_dup (gint* self);
gint* game_get_tiles (Game* self,
                      int* result_length1,
                      int* result_length2);
gchar* game_to_string (Game* self);
gint game_get_size (Game* self);
void game_request_move (Game* self,
                        gint x,
                        gint y);
GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self,
                        gint x,
                        gint y,
                        gboolean undoing);
static void game_sixteen_move (Game* self,
                        gint x,
                        gint y,
                        gboolean undoing);
static void game_add_move (Game* self,
                    gint x_gap,
                    gint y_gap);
static void game_check_complete (Game* self);
void game_undo (Game* self);
static gint* _vala_array_dup1 (gint* self,
                        int length);
static void g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void game_finalize (GObject * obj);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


gchar*
game_type_to_string (GameType self)
{
	gchar* result = NULL;
	switch (self) {
		case GAME_TYPE_FIFTEEN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fifteen");
			result = _tmp0_;
			return result;
		}
		case GAME_TYPE_SIXTEEN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("sixteen");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType
game_type_get_type (void)
{
	static volatile gsize game_type_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
		GType game_type_type_id;
		game_type_type_id = g_enum_register_static ("GameType", values);
		g_once_init_leave (&game_type_type_id__volatile, game_type_type_id);
	}
	return game_type_type_id__volatile;
}


static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}


Game*
game_construct (GType object_type,
                GameType game_type,
                gint size)
{
	Game * self = NULL;
	gint* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint ntiles = 0;
	gint** line = NULL;
	gint _tmp2_;
	gint** _tmp3_;
	gint line_length1;
	gint _line_size_;
	gint i = 0;
	gboolean parity_grid = FALSE;
	gboolean parity_game = FALSE;
	gboolean _tmp44_;
	gboolean _tmp45_;
	_vala_return_val_if_fail (size >= 2, "size >= 2", NULL);
	self = (Game*) g_object_new (object_type, NULL);
	game_set_size (self, size);
	game_set_game_type (self, game_type);
	_tmp0_ = g_new0 (gint, size * size);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = size;
	_tmp1__length2 = size;
	game_set_tiles (self, _tmp1_, size, size);
	_tmp1_ = (g_free (_tmp1_), NULL);
	ntiles = size * size;
	_tmp2_ = ntiles;
	_tmp3_ = g_new0 (gint*, _tmp2_);
	line = _tmp3_;
	line_length1 = _tmp2_;
	_line_size_ = line_length1;
	i = 0;
	{
		gint n = 0;
		gint _tmp4_;
		_tmp4_ = ntiles;
		n = _tmp4_ - 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint _tmp15_;
				gint* _tmp16_;
				gint* _tmp17_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = n;
					n = _tmp6_ - 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = n;
				if (!(_tmp7_ >= 0)) {
					break;
				}
				{
					gboolean _tmp8_ = FALSE;
					_tmp8_ = TRUE;
					while (TRUE) {
						gint _tmp12_;
						if (!_tmp8_) {
							gint** _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint* _tmp11_;
							_tmp9_ = line;
							_tmp9__length1 = line_length1;
							_tmp10_ = i;
							_tmp11_ = _tmp9_[_tmp10_];
							if (!(_tmp11_ != NULL)) {
								break;
							}
						}
						_tmp8_ = FALSE;
						_tmp12_ = ntiles;
						i = (gint) g_random_int_range ((gint32) 0, (gint32) _tmp12_);
					}
				}
				_tmp13_ = line;
				_tmp13__length1 = line_length1;
				_tmp14_ = i;
				_tmp15_ = n;
				_tmp16_ = __int_dup0 (&_tmp15_);
				_g_free0 (_tmp13_[_tmp14_]);
				_tmp13_[_tmp14_] = _tmp16_;
				_tmp17_ = _tmp13_[_tmp14_];
			}
		}
	}
	if (game_type == GAME_TYPE_FIFTEEN) {
		gint** _tmp18_;
		gint _tmp18__length1;
		gint _tmp19_;
		gint** _tmp20_;
		gint _tmp20__length1;
		gint* _tmp21_;
		gint* _tmp22_;
		gint* _tmp23_;
		gint** _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
		gint* _tmp26_;
		gint* _tmp27_;
		_tmp18_ = line;
		_tmp18__length1 = line_length1;
		_tmp19_ = i;
		_tmp20_ = line;
		_tmp20__length1 = line_length1;
		_tmp21_ = _tmp20_[0];
		_tmp22_ = __int_dup0 (_tmp21_);
		_g_free0 (_tmp18_[_tmp19_]);
		_tmp18_[_tmp19_] = _tmp22_;
		_tmp23_ = _tmp18_[_tmp19_];
		_tmp24_ = line;
		_tmp24__length1 = line_length1;
		_tmp25_ = -1;
		_tmp26_ = __int_dup0 (&_tmp25_);
		_g_free0 (_tmp24_[0]);
		_tmp24_[0] = _tmp26_;
		_tmp27_ = _tmp24_[0];
		self->priv->x_gap = 0;
		self->priv->y_gap = 0;
	}
	parity_grid = ((gboolean) ((size % 2) ^ (size % 2))) & (1 == 0);
	parity_game = FALSE;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = j;
					j = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = j;
				_tmp31_ = ntiles;
				if (!(_tmp30_ < (_tmp31_ - 1))) {
					break;
				}
				{
					gint k = 0;
					gint _tmp32_;
					_tmp32_ = j;
					k = _tmp32_ + 1;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							gint _tmp35_;
							gint _tmp36_;
							gint** _tmp37_;
							gint _tmp37__length1;
							gint _tmp38_;
							gint* _tmp39_;
							gint** _tmp40_;
							gint _tmp40__length1;
							gint _tmp41_;
							gint* _tmp42_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = k;
								k = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							_tmp35_ = k;
							_tmp36_ = ntiles;
							if (!(_tmp35_ < _tmp36_)) {
								break;
							}
							_tmp37_ = line;
							_tmp37__length1 = line_length1;
							_tmp38_ = j;
							_tmp39_ = _tmp37_[_tmp38_];
							_tmp40_ = line;
							_tmp40__length1 = line_length1;
							_tmp41_ = k;
							_tmp42_ = _tmp40_[_tmp41_];
							if ((*_tmp39_) > (*_tmp42_)) {
								gboolean _tmp43_;
								_tmp43_ = parity_game;
								parity_game = !_tmp43_;
							}
						}
					}
				}
			}
		}
	}
	_tmp44_ = parity_game;
	_tmp45_ = parity_grid;
	if (_tmp44_ != _tmp45_) {
		gint* save = NULL;
		gint** _tmp46_;
		gint _tmp46__length1;
		gint* _tmp47_;
		gint* _tmp48_;
		gint** _tmp49_;
		gint _tmp49__length1;
		gint** _tmp50_;
		gint _tmp50__length1;
		gint* _tmp51_;
		gint* _tmp52_;
		gint* _tmp53_;
		gint** _tmp54_;
		gint _tmp54__length1;
		gint* _tmp55_;
		gint* _tmp56_;
		gint* _tmp57_;
		_tmp46_ = line;
		_tmp46__length1 = line_length1;
		_tmp47_ = _tmp46_[1];
		_tmp48_ = __int_dup0 (_tmp47_);
		save = _tmp48_;
		_tmp49_ = line;
		_tmp49__length1 = line_length1;
		_tmp50_ = line;
		_tmp50__length1 = line_length1;
		_tmp51_ = _tmp50_[size + 1];
		_tmp52_ = __int_dup0 (_tmp51_);
		_g_free0 (_tmp49_[1]);
		_tmp49_[1] = _tmp52_;
		_tmp53_ = _tmp49_[1];
		_tmp54_ = line;
		_tmp54__length1 = line_length1;
		_tmp55_ = save;
		_tmp56_ = __int_dup0 (_tmp55_);
		_g_free0 (_tmp54_[size + 1]);
		_tmp54_[size + 1] = _tmp56_;
		_tmp57_ = _tmp54_[size + 1];
		_g_free0 (save);
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				gint _tmp60_;
				gint _tmp61_;
				gint* _tmp62_;
				gint _tmp62__length1;
				gint _tmp62__length2;
				gint* _tmp63_;
				gint _tmp63__length1;
				gint _tmp63__length2;
				gint _tmp64_;
				gint _tmp65_;
				gint** _tmp66_;
				gint _tmp66__length1;
				gint _tmp67_;
				gint* _tmp68_;
				gint _tmp69_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = j;
					j = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = j;
				_tmp61_ = ntiles;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = game_get_tiles (self, &_tmp62__length1, &_tmp62__length2);
				_tmp63_ = _tmp62_;
				_tmp63__length1 = _tmp62__length1;
				_tmp63__length2 = _tmp62__length2;
				_tmp64_ = j;
				_tmp65_ = j;
				_tmp66_ = line;
				_tmp66__length1 = line_length1;
				_tmp67_ = j;
				_tmp68_ = _tmp66_[_tmp67_];
				_tmp63_[((_tmp64_ % size) * _tmp63__length2) + (_tmp65_ / size)] = *_tmp68_;
				_tmp69_ = _tmp63_[((_tmp64_ % size) * _tmp63__length2) + (_tmp65_ / size)];
			}
		}
	}
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Game*
game_new (GameType game_type,
          gint size)
{
	return game_construct (TYPE_GAME, game_type, size);
}


gchar*
game_to_string (Game* self)
{
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = x;
				_tmp4_ = self->priv->_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gint _tmp8_;
							const gchar* _tmp9_;
							gint* _tmp10_;
							gint _tmp10__length1;
							gint _tmp10__length2;
							gint* _tmp11_;
							gint _tmp11__length1;
							gint _tmp11__length2;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							gchar* _tmp19_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = y;
							_tmp8_ = self->priv->_size;
							if (!(_tmp7_ < _tmp8_)) {
								break;
							}
							_tmp9_ = s;
							_tmp10_ = game_get_tiles (self, &_tmp10__length1, &_tmp10__length2);
							_tmp11_ = _tmp10_;
							_tmp11__length1 = _tmp10__length1;
							_tmp11__length2 = _tmp10__length2;
							_tmp12_ = y;
							_tmp13_ = x;
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
							_tmp15_ = g_strdup_printf ("%i", _tmp14_ + 1);
							_tmp16_ = _tmp15_;
							_tmp17_ = g_strconcat (" ", _tmp16_, NULL);
							_tmp18_ = _tmp17_;
							_tmp19_ = g_strconcat (_tmp9_, _tmp18_, NULL);
							_g_free0 (s);
							s = _tmp19_;
							_g_free0 (_tmp18_);
							_g_free0 (_tmp16_);
						}
					}
				}
				_tmp20_ = s;
				_tmp21_ = g_strconcat (_tmp20_, "\n", NULL);
				_g_free0 (s);
				s = _tmp21_;
			}
		}
	}
	result = s;
	return result;
}


void
game_request_move (Game* self,
                   gint x,
                   gint y)
{
	GameType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_type;
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
		game_fifteen_move (self, x, y, FALSE);
	} else {
		game_sixteen_move (self, x, y, FALSE);
	}
}


static void
game_fifteen_move (Game* self,
                   gint x,
                   gint y,
                   gboolean undoing)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gboolean move_x_axis = FALSE;
	gint _tmp11_;
	gint _tmp12_ = 0;
	gboolean _tmp13_;
	gint move_number = 0;
	gboolean _tmp18_;
	gint* _tmp65_;
	gint _tmp65__length1;
	gint _tmp65__length2;
	gint* _tmp66_;
	gint _tmp66__length1;
	gint _tmp66__length2;
	gint _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gboolean _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	g_return_if_fail (self != NULL);
	if (x < 0) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp3_;
		_tmp3_ = self->priv->_size;
		_tmp2_ = x >= _tmp3_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = y < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp4_;
		_tmp4_ = self->priv->_size;
		_tmp0_ = y >= _tmp4_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->x_gap;
	if (x == _tmp6_) {
		gint _tmp7_;
		_tmp7_ = self->priv->y_gap;
		_tmp5_ = y == _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		g_signal_emit (self, game_signals[GAME_EMPTY_TILE_SIGNAL], 0);
		return;
	}
	_tmp9_ = self->priv->x_gap;
	if (x != _tmp9_) {
		gint _tmp10_;
		_tmp10_ = self->priv->y_gap;
		_tmp8_ = y != _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		g_signal_emit (self, game_signals[GAME_CANNOT_MOVE_SIGNAL], 0, x, y);
		return;
	}
	_tmp11_ = self->priv->x_gap;
	move_x_axis = x != _tmp11_;
	_tmp13_ = move_x_axis;
	if (_tmp13_) {
		gint _tmp14_;
		_tmp14_ = self->priv->x_gap;
		_tmp12_ = _tmp14_ - x;
	} else {
		gint _tmp15_;
		_tmp15_ = self->priv->y_gap;
		_tmp12_ = _tmp15_ - y;
	}
	move_number = _tmp12_;
	if (!undoing) {
		gint _tmp16_;
		gint _tmp17_;
		_tmp16_ = self->priv->x_gap;
		_tmp17_ = self->priv->y_gap;
		game_add_move (self, _tmp16_, _tmp17_);
	}
	_tmp18_ = move_x_axis;
	if (_tmp18_) {
		gint _tmp19_;
		_tmp19_ = self->priv->x_gap;
		if (x < _tmp19_) {
			{
				gboolean _tmp20_ = FALSE;
				_tmp20_ = TRUE;
				while (TRUE) {
					gint* _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					gint* _tmp23_;
					gint _tmp23__length1;
					gint _tmp23__length2;
					gint _tmp24_;
					gint* _tmp25_;
					gint _tmp25__length1;
					gint _tmp25__length2;
					gint* _tmp26_;
					gint _tmp26__length1;
					gint _tmp26__length2;
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					if (!_tmp20_) {
						gint _tmp21_;
						_tmp21_ = self->priv->x_gap;
						if (!(_tmp21_ != x)) {
							break;
						}
					}
					_tmp20_ = FALSE;
					_tmp22_ = game_get_tiles (self, &_tmp22__length1, &_tmp22__length2);
					_tmp23_ = _tmp22_;
					_tmp23__length1 = _tmp22__length1;
					_tmp23__length2 = _tmp22__length2;
					_tmp24_ = self->priv->x_gap;
					_tmp25_ = game_get_tiles (self, &_tmp25__length1, &_tmp25__length2);
					_tmp26_ = _tmp25_;
					_tmp26__length1 = _tmp25__length1;
					_tmp26__length2 = _tmp25__length2;
					_tmp27_ = self->priv->x_gap;
					_tmp28_ = _tmp26_[((_tmp27_ - 1) * _tmp26__length2) + y];
					_tmp23_[(_tmp24_ * _tmp23__length2) + y] = _tmp28_;
					_tmp29_ = _tmp23_[(_tmp24_ * _tmp23__length2) + y];
					_tmp30_ = self->priv->x_gap;
					self->priv->x_gap = _tmp30_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp31_ = FALSE;
				_tmp31_ = TRUE;
				while (TRUE) {
					gint* _tmp33_;
					gint _tmp33__length1;
					gint _tmp33__length2;
					gint* _tmp34_;
					gint _tmp34__length1;
					gint _tmp34__length2;
					gint _tmp35_;
					gint* _tmp36_;
					gint _tmp36__length1;
					gint _tmp36__length2;
					gint* _tmp37_;
					gint _tmp37__length1;
					gint _tmp37__length2;
					gint _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					if (!_tmp31_) {
						gint _tmp32_;
						_tmp32_ = self->priv->x_gap;
						if (!(_tmp32_ != x)) {
							break;
						}
					}
					_tmp31_ = FALSE;
					_tmp33_ = game_get_tiles (self, &_tmp33__length1, &_tmp33__length2);
					_tmp34_ = _tmp33_;
					_tmp34__length1 = _tmp33__length1;
					_tmp34__length2 = _tmp33__length2;
					_tmp35_ = self->priv->x_gap;
					_tmp36_ = game_get_tiles (self, &_tmp36__length1, &_tmp36__length2);
					_tmp37_ = _tmp36_;
					_tmp37__length1 = _tmp36__length1;
					_tmp37__length2 = _tmp36__length2;
					_tmp38_ = self->priv->x_gap;
					_tmp39_ = _tmp37_[((_tmp38_ + 1) * _tmp37__length2) + y];
					_tmp34_[(_tmp35_ * _tmp34__length2) + y] = _tmp39_;
					_tmp40_ = _tmp34_[(_tmp35_ * _tmp34__length2) + y];
					_tmp41_ = self->priv->x_gap;
					self->priv->x_gap = _tmp41_ + 1;
				}
			}
		}
	} else {
		gint _tmp42_;
		_tmp42_ = self->priv->y_gap;
		if (y < _tmp42_) {
			{
				gboolean _tmp43_ = FALSE;
				_tmp43_ = TRUE;
				while (TRUE) {
					gint* _tmp45_;
					gint _tmp45__length1;
					gint _tmp45__length2;
					gint* _tmp46_;
					gint _tmp46__length1;
					gint _tmp46__length2;
					gint _tmp47_;
					gint* _tmp48_;
					gint _tmp48__length1;
					gint _tmp48__length2;
					gint* _tmp49_;
					gint _tmp49__length1;
					gint _tmp49__length2;
					gint _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					if (!_tmp43_) {
						gint _tmp44_;
						_tmp44_ = self->priv->y_gap;
						if (!(_tmp44_ != y)) {
							break;
						}
					}
					_tmp43_ = FALSE;
					_tmp45_ = game_get_tiles (self, &_tmp45__length1, &_tmp45__length2);
					_tmp46_ = _tmp45_;
					_tmp46__length1 = _tmp45__length1;
					_tmp46__length2 = _tmp45__length2;
					_tmp47_ = self->priv->y_gap;
					_tmp48_ = game_get_tiles (self, &_tmp48__length1, &_tmp48__length2);
					_tmp49_ = _tmp48_;
					_tmp49__length1 = _tmp48__length1;
					_tmp49__length2 = _tmp48__length2;
					_tmp50_ = self->priv->y_gap;
					_tmp51_ = _tmp49_[(x * _tmp49__length2) + (_tmp50_ - 1)];
					_tmp46_[(x * _tmp46__length2) + _tmp47_] = _tmp51_;
					_tmp52_ = _tmp46_[(x * _tmp46__length2) + _tmp47_];
					_tmp53_ = self->priv->y_gap;
					self->priv->y_gap = _tmp53_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp54_ = FALSE;
				_tmp54_ = TRUE;
				while (TRUE) {
					gint* _tmp56_;
					gint _tmp56__length1;
					gint _tmp56__length2;
					gint* _tmp57_;
					gint _tmp57__length1;
					gint _tmp57__length2;
					gint _tmp58_;
					gint* _tmp59_;
					gint _tmp59__length1;
					gint _tmp59__length2;
					gint* _tmp60_;
					gint _tmp60__length1;
					gint _tmp60__length2;
					gint _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = self->priv->y_gap;
						if (!(_tmp55_ != y)) {
							break;
						}
					}
					_tmp54_ = FALSE;
					_tmp56_ = game_get_tiles (self, &_tmp56__length1, &_tmp56__length2);
					_tmp57_ = _tmp56_;
					_tmp57__length1 = _tmp56__length1;
					_tmp57__length2 = _tmp56__length2;
					_tmp58_ = self->priv->y_gap;
					_tmp59_ = game_get_tiles (self, &_tmp59__length1, &_tmp59__length2);
					_tmp60_ = _tmp59_;
					_tmp60__length1 = _tmp59__length1;
					_tmp60__length2 = _tmp59__length2;
					_tmp61_ = self->priv->y_gap;
					_tmp62_ = _tmp60_[(x * _tmp60__length2) + (_tmp61_ + 1)];
					_tmp57_[(x * _tmp57__length2) + _tmp58_] = _tmp62_;
					_tmp63_ = _tmp57_[(x * _tmp57__length2) + _tmp58_];
					_tmp64_ = self->priv->y_gap;
					self->priv->y_gap = _tmp64_ + 1;
				}
			}
		}
	}
	_tmp65_ = game_get_tiles (self, &_tmp65__length1, &_tmp65__length2);
	_tmp66_ = _tmp65_;
	_tmp66__length1 = _tmp65__length1;
	_tmp66__length2 = _tmp65__length2;
	_tmp67_ = self->priv->x_gap;
	_tmp68_ = self->priv->y_gap;
	_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = -1;
	_tmp69_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
	_tmp70_ = move_x_axis;
	_tmp71_ = move_number;
	_tmp72_ = self->priv->x_gap;
	_tmp73_ = self->priv->y_gap;
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, _tmp70_, _tmp71_, _tmp72_, _tmp73_);
	game_check_complete (self);
}


static void
game_sixteen_move (Game* self,
                   gint x,
                   gint y,
                   gboolean undoing)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean move_x_axis = FALSE;
	gboolean _tmp5_ = FALSE;
	gint new_coord = 0;
	gboolean _tmp11_;
	gint _tmp104_ = 0;
	gint _tmp105_;
	gint _tmp108_ = 0;
	gboolean _tmp109_;
	gint _tmp111_ = 0;
	gboolean _tmp112_;
	gboolean _tmp114_;
	g_return_if_fail (self != NULL);
	if (x >= 0) {
		gint _tmp3_;
		_tmp3_ = self->priv->_size;
		_tmp2_ = x < _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp4_;
		_tmp4_ = self->priv->_size;
		_tmp0_ = y < _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	move_x_axis = FALSE;
	if (x < 0) {
		_tmp5_ = TRUE;
	} else {
		gint _tmp6_;
		_tmp6_ = self->priv->_size;
		_tmp5_ = x >= _tmp6_;
	}
	if (_tmp5_) {
		gboolean _tmp7_ = FALSE;
		if (y < 0) {
			_tmp7_ = TRUE;
		} else {
			gint _tmp8_;
			_tmp8_ = self->priv->_size;
			_tmp7_ = y >= _tmp8_;
		}
		if (_tmp7_) {
			return;
		} else {
			move_x_axis = TRUE;
		}
	} else {
		gboolean _tmp9_ = FALSE;
		if (y >= 0) {
			gint _tmp10_;
			_tmp10_ = self->priv->_size;
			_tmp9_ = y < _tmp10_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			return;
		}
	}
	new_coord = 0;
	_tmp11_ = move_x_axis;
	if (_tmp11_) {
		if (x < 0) {
			gint tmp = 0;
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp12__length2;
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			gint _tmp14_;
			gint* _tmp27_;
			gint _tmp27__length1;
			gint _tmp27__length2;
			gint* _tmp28_;
			gint _tmp28__length1;
			gint _tmp28__length2;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp12_ = game_get_tiles (self, &_tmp12__length1, &_tmp12__length2);
			_tmp13_ = _tmp12_;
			_tmp13__length1 = _tmp12__length1;
			_tmp13__length2 = _tmp12__length2;
			_tmp14_ = _tmp13_[(0 * _tmp13__length2) + y];
			tmp = _tmp14_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						gint* _tmp19_;
						gint _tmp19__length1;
						gint _tmp19__length2;
						gint* _tmp20_;
						gint _tmp20__length1;
						gint _tmp20__length2;
						gint _tmp21_;
						gint* _tmp22_;
						gint _tmp22__length1;
						gint _tmp22__length2;
						gint* _tmp23_;
						gint _tmp23__length1;
						gint _tmp23__length2;
						gint _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						if (!_tmp15_) {
							gint _tmp16_;
							_tmp16_ = i;
							i = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = i;
						_tmp18_ = self->priv->_size;
						if (!(_tmp17_ < (_tmp18_ - 1))) {
							break;
						}
						_tmp19_ = game_get_tiles (self, &_tmp19__length1, &_tmp19__length2);
						_tmp20_ = _tmp19_;
						_tmp20__length1 = _tmp19__length1;
						_tmp20__length2 = _tmp19__length2;
						_tmp21_ = i;
						_tmp22_ = game_get_tiles (self, &_tmp22__length1, &_tmp22__length2);
						_tmp23_ = _tmp22_;
						_tmp23__length1 = _tmp22__length1;
						_tmp23__length2 = _tmp22__length2;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[((_tmp24_ + 1) * _tmp23__length2) + y];
						_tmp20_[(_tmp21_ * _tmp20__length2) + y] = _tmp25_;
						_tmp26_ = _tmp20_[(_tmp21_ * _tmp20__length2) + y];
					}
				}
			}
			_tmp27_ = game_get_tiles (self, &_tmp27__length1, &_tmp27__length2);
			_tmp28_ = _tmp27_;
			_tmp28__length1 = _tmp27__length1;
			_tmp28__length2 = _tmp27__length2;
			_tmp29_ = self->priv->_size;
			_tmp30_ = tmp;
			_tmp28_[((_tmp29_ - 1) * _tmp28__length2) + y] = _tmp30_;
			_tmp31_ = _tmp28_[((_tmp29_ - 1) * _tmp28__length2) + y];
			_tmp32_ = self->priv->_size;
			new_coord = _tmp32_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp33_;
			gint _tmp33__length1;
			gint _tmp33__length2;
			gint* _tmp34_;
			gint _tmp34__length1;
			gint _tmp34__length2;
			gint _tmp35_;
			gint _tmp36_;
			gint* _tmp49_;
			gint _tmp49__length1;
			gint _tmp49__length2;
			gint* _tmp50_;
			gint _tmp50__length1;
			gint _tmp50__length2;
			gint _tmp51_;
			gint _tmp52_;
			_tmp33_ = game_get_tiles (self, &_tmp33__length1, &_tmp33__length2);
			_tmp34_ = _tmp33_;
			_tmp34__length1 = _tmp33__length1;
			_tmp34__length2 = _tmp33__length2;
			_tmp35_ = self->priv->_size;
			_tmp36_ = _tmp34_[((_tmp35_ - 1) * _tmp34__length2) + y];
			tmp = _tmp36_;
			{
				gint i = 0;
				gint _tmp37_;
				_tmp37_ = self->priv->_size;
				i = _tmp37_ - 1;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						gint _tmp40_;
						gint* _tmp41_;
						gint _tmp41__length1;
						gint _tmp41__length2;
						gint* _tmp42_;
						gint _tmp42__length1;
						gint _tmp42__length2;
						gint _tmp43_;
						gint* _tmp44_;
						gint _tmp44__length1;
						gint _tmp44__length2;
						gint* _tmp45_;
						gint _tmp45__length1;
						gint _tmp45__length2;
						gint _tmp46_;
						gint _tmp47_;
						gint _tmp48_;
						if (!_tmp38_) {
							gint _tmp39_;
							_tmp39_ = i;
							i = _tmp39_ - 1;
						}
						_tmp38_ = FALSE;
						_tmp40_ = i;
						if (!(_tmp40_ > 0)) {
							break;
						}
						_tmp41_ = game_get_tiles (self, &_tmp41__length1, &_tmp41__length2);
						_tmp42_ = _tmp41_;
						_tmp42__length1 = _tmp41__length1;
						_tmp42__length2 = _tmp41__length2;
						_tmp43_ = i;
						_tmp44_ = game_get_tiles (self, &_tmp44__length1, &_tmp44__length2);
						_tmp45_ = _tmp44_;
						_tmp45__length1 = _tmp44__length1;
						_tmp45__length2 = _tmp44__length2;
						_tmp46_ = i;
						_tmp47_ = _tmp45_[((_tmp46_ - 1) * _tmp45__length2) + y];
						_tmp42_[(_tmp43_ * _tmp42__length2) + y] = _tmp47_;
						_tmp48_ = _tmp42_[(_tmp43_ * _tmp42__length2) + y];
					}
				}
			}
			_tmp49_ = game_get_tiles (self, &_tmp49__length1, &_tmp49__length2);
			_tmp50_ = _tmp49_;
			_tmp50__length1 = _tmp49__length1;
			_tmp50__length2 = _tmp49__length2;
			_tmp51_ = tmp;
			_tmp50_[(0 * _tmp50__length2) + y] = _tmp51_;
			_tmp52_ = _tmp50_[(0 * _tmp50__length2) + y];
			new_coord = 0;
		}
	} else {
		if (y < 0) {
			gint tmp = 0;
			gint* _tmp53_;
			gint _tmp53__length1;
			gint _tmp53__length2;
			gint* _tmp54_;
			gint _tmp54__length1;
			gint _tmp54__length2;
			gint _tmp55_;
			gint* _tmp68_;
			gint _tmp68__length1;
			gint _tmp68__length2;
			gint* _tmp69_;
			gint _tmp69__length1;
			gint _tmp69__length2;
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			_tmp53_ = game_get_tiles (self, &_tmp53__length1, &_tmp53__length2);
			_tmp54_ = _tmp53_;
			_tmp54__length1 = _tmp53__length1;
			_tmp54__length2 = _tmp53__length2;
			_tmp55_ = _tmp54_[(x * _tmp54__length2) + 0];
			tmp = _tmp55_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp56_ = FALSE;
					_tmp56_ = TRUE;
					while (TRUE) {
						gint _tmp58_;
						gint _tmp59_;
						gint* _tmp60_;
						gint _tmp60__length1;
						gint _tmp60__length2;
						gint* _tmp61_;
						gint _tmp61__length1;
						gint _tmp61__length2;
						gint _tmp62_;
						gint* _tmp63_;
						gint _tmp63__length1;
						gint _tmp63__length2;
						gint* _tmp64_;
						gint _tmp64__length1;
						gint _tmp64__length2;
						gint _tmp65_;
						gint _tmp66_;
						gint _tmp67_;
						if (!_tmp56_) {
							gint _tmp57_;
							_tmp57_ = i;
							i = _tmp57_ + 1;
						}
						_tmp56_ = FALSE;
						_tmp58_ = i;
						_tmp59_ = self->priv->_size;
						if (!(_tmp58_ < (_tmp59_ - 1))) {
							break;
						}
						_tmp60_ = game_get_tiles (self, &_tmp60__length1, &_tmp60__length2);
						_tmp61_ = _tmp60_;
						_tmp61__length1 = _tmp60__length1;
						_tmp61__length2 = _tmp60__length2;
						_tmp62_ = i;
						_tmp63_ = game_get_tiles (self, &_tmp63__length1, &_tmp63__length2);
						_tmp64_ = _tmp63_;
						_tmp64__length1 = _tmp63__length1;
						_tmp64__length2 = _tmp63__length2;
						_tmp65_ = i;
						_tmp66_ = _tmp64_[(x * _tmp64__length2) + (_tmp65_ + 1)];
						_tmp61_[(x * _tmp61__length2) + _tmp62_] = _tmp66_;
						_tmp67_ = _tmp61_[(x * _tmp61__length2) + _tmp62_];
					}
				}
			}
			_tmp68_ = game_get_tiles (self, &_tmp68__length1, &_tmp68__length2);
			_tmp69_ = _tmp68_;
			_tmp69__length1 = _tmp68__length1;
			_tmp69__length2 = _tmp68__length2;
			_tmp70_ = self->priv->_size;
			_tmp71_ = tmp;
			_tmp69_[(x * _tmp69__length2) + (_tmp70_ - 1)] = _tmp71_;
			_tmp72_ = _tmp69_[(x * _tmp69__length2) + (_tmp70_ - 1)];
			_tmp73_ = self->priv->_size;
			new_coord = _tmp73_ - 1;
		} else {
			gint tmp = 0;
			gint* _tmp74_;
			gint _tmp74__length1;
			gint _tmp74__length2;
			gint* _tmp75_;
			gint _tmp75__length1;
			gint _tmp75__length2;
			gint _tmp76_;
			gint _tmp77_;
			gint* _tmp90_;
			gint _tmp90__length1;
			gint _tmp90__length2;
			gint* _tmp91_;
			gint _tmp91__length1;
			gint _tmp91__length2;
			gint _tmp92_;
			gint _tmp93_;
			_tmp74_ = game_get_tiles (self, &_tmp74__length1, &_tmp74__length2);
			_tmp75_ = _tmp74_;
			_tmp75__length1 = _tmp74__length1;
			_tmp75__length2 = _tmp74__length2;
			_tmp76_ = self->priv->_size;
			_tmp77_ = _tmp75_[(x * _tmp75__length2) + (_tmp76_ - 1)];
			tmp = _tmp77_;
			{
				gint i = 0;
				gint _tmp78_;
				_tmp78_ = self->priv->_size;
				i = _tmp78_ - 1;
				{
					gboolean _tmp79_ = FALSE;
					_tmp79_ = TRUE;
					while (TRUE) {
						gint _tmp81_;
						gint* _tmp82_;
						gint _tmp82__length1;
						gint _tmp82__length2;
						gint* _tmp83_;
						gint _tmp83__length1;
						gint _tmp83__length2;
						gint _tmp84_;
						gint* _tmp85_;
						gint _tmp85__length1;
						gint _tmp85__length2;
						gint* _tmp86_;
						gint _tmp86__length1;
						gint _tmp86__length2;
						gint _tmp87_;
						gint _tmp88_;
						gint _tmp89_;
						if (!_tmp79_) {
							gint _tmp80_;
							_tmp80_ = i;
							i = _tmp80_ - 1;
						}
						_tmp79_ = FALSE;
						_tmp81_ = i;
						if (!(_tmp81_ > 0)) {
							break;
						}
						_tmp82_ = game_get_tiles (self, &_tmp82__length1, &_tmp82__length2);
						_tmp83_ = _tmp82_;
						_tmp83__length1 = _tmp82__length1;
						_tmp83__length2 = _tmp82__length2;
						_tmp84_ = i;
						_tmp85_ = game_get_tiles (self, &_tmp85__length1, &_tmp85__length2);
						_tmp86_ = _tmp85_;
						_tmp86__length1 = _tmp85__length1;
						_tmp86__length2 = _tmp85__length2;
						_tmp87_ = i;
						_tmp88_ = _tmp86_[(x * _tmp86__length2) + (_tmp87_ - 1)];
						_tmp83_[(x * _tmp83__length2) + _tmp84_] = _tmp88_;
						_tmp89_ = _tmp83_[(x * _tmp83__length2) + _tmp84_];
					}
				}
			}
			_tmp90_ = game_get_tiles (self, &_tmp90__length1, &_tmp90__length2);
			_tmp91_ = _tmp90_;
			_tmp91__length1 = _tmp90__length1;
			_tmp91__length2 = _tmp90__length2;
			_tmp92_ = tmp;
			_tmp91_[(x * _tmp91__length2) + 0] = _tmp92_;
			_tmp93_ = _tmp91_[(x * _tmp91__length2) + 0];
			new_coord = 0;
		}
	}
	if (!undoing) {
		gint _tmp94_ = 0;
		gboolean _tmp95_;
		gint _tmp99_ = 0;
		gboolean _tmp100_;
		_tmp95_ = move_x_axis;
		if (_tmp95_) {
			gint _tmp96_ = 0;
			gint _tmp97_;
			_tmp97_ = new_coord;
			if (_tmp97_ == 0) {
				_tmp96_ = -1;
			} else {
				gint _tmp98_;
				_tmp98_ = self->priv->_size;
				_tmp96_ = _tmp98_;
			}
			_tmp94_ = _tmp96_;
		} else {
			_tmp94_ = x;
		}
		_tmp100_ = move_x_axis;
		if (_tmp100_) {
			_tmp99_ = y;
		} else {
			gint _tmp101_ = 0;
			gint _tmp102_;
			_tmp102_ = new_coord;
			if (_tmp102_ == 0) {
				_tmp101_ = -1;
			} else {
				gint _tmp103_;
				_tmp103_ = self->priv->_size;
				_tmp101_ = _tmp103_;
			}
			_tmp99_ = _tmp101_;
		}
		game_add_move (self, _tmp94_, _tmp99_);
	}
	_tmp105_ = new_coord;
	if (_tmp105_ == 0) {
		gint _tmp106_;
		_tmp106_ = self->priv->_size;
		_tmp104_ = _tmp106_ - 1;
	} else {
		gint _tmp107_;
		_tmp107_ = self->priv->_size;
		_tmp104_ = 1 - _tmp107_;
	}
	_tmp109_ = move_x_axis;
	if (_tmp109_) {
		gint _tmp110_;
		_tmp110_ = new_coord;
		_tmp108_ = _tmp110_;
	} else {
		_tmp108_ = x;
	}
	_tmp112_ = move_x_axis;
	if (_tmp112_) {
		_tmp111_ = y;
	} else {
		gint _tmp113_;
		_tmp113_ = new_coord;
		_tmp111_ = _tmp113_;
	}
	_tmp114_ = move_x_axis;
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, _tmp114_, _tmp104_, _tmp108_, _tmp111_);
	game_check_complete (self);
}


static void
game_check_complete (Game* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint* _tmp6_;
				gint _tmp6__length1;
				gint _tmp6__length2;
				gint* _tmp7_;
				gint _tmp7__length1;
				gint _tmp7__length2;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_size;
				_tmp4_ = self->priv->_size;
				if (!(_tmp2_ < (_tmp3_ * _tmp4_))) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = game_get_tiles (self, &_tmp6__length1, &_tmp6__length2);
				_tmp7_ = _tmp6_;
				_tmp7__length1 = _tmp6__length1;
				_tmp7__length2 = _tmp6__length2;
				_tmp8_ = i;
				_tmp9_ = self->priv->_size;
				_tmp10_ = i;
				_tmp11_ = self->priv->_size;
				_tmp12_ = _tmp7_[((_tmp8_ % _tmp9_) * _tmp7__length2) + (_tmp10_ / _tmp11_)];
				if (_tmp5_ != _tmp12_) {
					return;
				}
			}
		}
	}
	g_signal_emit (self, game_signals[GAME_COMPLETE_SIGNAL], 0);
}


static gpointer
_game_undo_item_dup0 (gpointer self)
{
	return self ? game_undo_item_dup (self) : NULL;
}


void
game_undo (Game* self)
{
	GameUndoItem* _tmp0_;
	GameType _tmp1_;
	GameUndoItem* _tmp10_;
	GameUndoItem* _tmp11_;
	GameUndoItem* _tmp12_ = NULL;
	GameUndoItem* _tmp13_;
	GameUndoItem* _tmp16_;
	GameUndoItem* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_game_type;
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
		GameUndoItem* _tmp2_;
		gint _tmp3_;
		GameUndoItem* _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->state;
		_tmp3_ = (*_tmp2_).x;
		_tmp4_ = self->priv->state;
		_tmp5_ = (*_tmp4_).y;
		game_fifteen_move (self, _tmp3_, _tmp5_, TRUE);
	} else {
		GameUndoItem* _tmp6_;
		gint _tmp7_;
		GameUndoItem* _tmp8_;
		gint _tmp9_;
		_tmp6_ = self->priv->state;
		_tmp7_ = (*_tmp6_).x;
		_tmp8_ = self->priv->state;
		_tmp9_ = (*_tmp8_).y;
		game_sixteen_move (self, _tmp7_, _tmp9_, TRUE);
	}
	_tmp10_ = self->priv->previous_state;
	_tmp11_ = _game_undo_item_dup0 (_tmp10_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp11_;
	_tmp13_ = self->priv->state;
	if (_tmp13_ == NULL) {
		_tmp12_ = NULL;
	} else {
		GameUndoItem* _tmp14_;
		GameUndoItem* _tmp15_;
		_tmp14_ = self->priv->state;
		_tmp15_ = (*_tmp14_).previous;
		_tmp12_ = _tmp15_;
	}
	_tmp16_ = _game_undo_item_dup0 (_tmp12_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp16_;
	_tmp17_ = self->priv->state;
	if (_tmp17_ == NULL) {
		g_signal_emit (self, game_signals[GAME_CANNOT_UNDO_MORE_SIGNAL], 0);
	}
}


static void
game_add_move (Game* self,
               gint x_gap,
               gint y_gap)
{
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_;
	GameUndoItem* _tmp3_;
	GameUndoItem* _tmp4_;
	GameUndoItem* _tmp5_;
	GameUndoItem _tmp6_ = {0};
	GameUndoItem _tmp7_;
	GameUndoItem* _tmp8_;
	GameUndoItem* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == NULL) {
		_tmp0_ = NULL;
	} else {
		GameUndoItem* _tmp2_;
		_tmp2_ = self->priv->state;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp3_;
	_tmp4_ = self->priv->previous_state;
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
	memset (&_tmp6_, 0, sizeof (GameUndoItem));
	_tmp6_.x = x_gap;
	_tmp6_.y = y_gap;
	_game_undo_item_free0 (_tmp6_.next);
	_tmp6_.next = NULL;
	_game_undo_item_free0 (_tmp6_.previous);
	_tmp6_.previous = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = _game_undo_item_dup0 (&_tmp7_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp8_;
	game_undo_item_destroy (&_tmp7_);
	_tmp9_ = self->priv->previous_state;
	if (_tmp9_ != NULL) {
		GameUndoItem* _tmp10_;
		GameUndoItem* _tmp11_;
		GameUndoItem* _tmp12_;
		_tmp10_ = self->priv->previous_state;
		_tmp11_ = self->priv->state;
		_tmp12_ = _game_undo_item_dup0 (_tmp11_);
		_game_undo_item_free0 ((*_tmp10_).next);
		(*_tmp10_).next = _tmp12_;
	}
}


gint*
game_get_tiles (Game* self,
                int* result_length1,
                int* result_length2)
{
	gint* result;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tiles;
	_tmp0__length1 = self->priv->_tiles_length1;
	_tmp0__length2 = self->priv->_tiles_length2;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp1__length2;
	}
	result = _tmp1_;
	return result;
}


static gint*
_vala_array_dup1 (gint* self,
                  int length)
{
	return g_memdup (self, length * sizeof (gint));
}


static void
game_set_tiles (Game* self,
                gint* value,
                int value_length1,
                int value_length2)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1 * value_length2) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	_tmp0__length2 = value_length2;
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	self->priv->_tiles = _tmp0_;
	self->priv->_tiles_length1 = _tmp0__length1;
	self->priv->_tiles_length2 = _tmp0__length2;
}


gint
game_get_size (Game* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static void
game_set_size (Game* self,
               gint value)
{
	g_return_if_fail (self != NULL);
	if (game_get_size (self) != value) {
		self->priv->_size = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SIZE_PROPERTY]);
	}
}


GameType
game_get_game_type (Game* self)
{
	GameType result;
	GameType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_game_type;
	result = _tmp0_;
	return result;
}


static void
game_set_game_type (Game* self,
                    GameType value)
{
	g_return_if_fail (self != NULL);
	if (game_get_game_type (self) != value) {
		self->priv->_game_type = value;
		g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_GAME_TYPE_PROPERTY]);
	}
}


static void
g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (gpointer data1, gboolean arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void
game_undo_item_copy (const GameUndoItem* self,
                     GameUndoItem* dest)
{
	gint _tmp0_;
	gint _tmp1_;
	GameUndoItem* _tmp2_;
	GameUndoItem* _tmp3_;
	GameUndoItem* _tmp4_;
	GameUndoItem* _tmp5_;
	_tmp0_ = (*self).x;
	(*dest).x = _tmp0_;
	_tmp1_ = (*self).y;
	(*dest).y = _tmp1_;
	_tmp2_ = (*self).next;
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
	_game_undo_item_free0 ((*dest).next);
	(*dest).next = _tmp3_;
	_tmp4_ = (*self).previous;
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
	_game_undo_item_free0 ((*dest).previous);
	(*dest).previous = _tmp5_;
}


static void
game_undo_item_destroy (GameUndoItem* self)
{
	_game_undo_item_free0 ((*self).next);
	_game_undo_item_free0 ((*self).previous);
}


static GameUndoItem*
game_undo_item_dup (const GameUndoItem* self)
{
	GameUndoItem* dup;
	dup = g_new0 (GameUndoItem, 1);
	game_undo_item_copy (self, dup);
	return dup;
}


static void
game_undo_item_free (GameUndoItem* self)
{
	game_undo_item_destroy (self);
	g_free (self);
}


static GType
game_undo_item_get_type (void)
{
	static volatile gsize game_undo_item_type_id__volatile = 0;
	if (g_once_init_enter (&game_undo_item_type_id__volatile)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
		g_once_init_leave (&game_undo_item_type_id__volatile, game_undo_item_type_id);
	}
	return game_undo_item_type_id__volatile;
}


static void
game_class_init (GameClass * klass)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE_PROPERTY, game_properties[GAME_GAME_TYPE_PROPERTY] = g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_COMPLETE_SIGNAL] = g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_MOVE_SIGNAL] = g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	game_signals[GAME_EMPTY_TILE_SIGNAL] = g_signal_new ("empty-tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_CANNOT_MOVE_SIGNAL] = g_signal_new ("cannot-move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	game_signals[GAME_CANNOT_UNDO_MORE_SIGNAL] = g_signal_new ("cannot-undo-more", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
game_instance_init (Game * self)
{
	self->priv = GAME_GET_PRIVATE (self);
	self->priv->state = NULL;
	self->priv->previous_state = NULL;
	self->priv->x_gap = 0;
	self->priv->y_gap = 0;
}


static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->_tiles = (g_free (self->priv->_tiles), NULL);
	_game_undo_item_free0 (self->priv->state);
	_game_undo_item_free0 (self->priv->previous_state);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType
game_get_type (void)
{
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		g_value_set_int (value, game_get_size (self));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		g_value_set_enum (value, game_get_game_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_int (value));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		game_set_game_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



