extension = {
	source_url: 'http://download.tsi.telecom-paristech.fr/gpac/gpac_test_suite/regression_tests/bifs/',

	filter_event : function(evt) {
		switch (evt.type) {
		case GF_JS_EVENT_PLAYBACK:
			this.set_option('SequenceIndex', ''+ evt.index);
			return false;
		default:
			return false;
		}
	},
	
	create_event_filter : function (__anobj) {
		return function (evt) {
			return __anobj.filter_event(evt);
		}
	},
	
	_event_filter : null,

	start: function () {
		if (!this._event_filter) {
			this._event_filter = this.create_event_filter(this);
			gwlib_add_event_filter(this._event_filter);
		}
		var e = {};
		e.type = GF_JS_EVENT_PLAYLIST_RESET;
		gwlib_filter_event(e);

		e.type = GF_JS_EVENT_PLAYLIST_ADD;
		for (var i=0; i<this.sequences.length; i++) {
			e.url = this.source_url + this.sequences[i];
			gwlib_filter_event(e);
		}
		
		var sequence_index = parseInt( this.get_option('SequenceIndex', '0') );
		if (sequence_index >= this.sequences.length) sequence_index = 0;
		else if (sequence_index < 0) sequence_index = 0;
		
		var msg = gw_new_message(null, 'Playlist Loaded', '');
		msg.set_size(20 * gwskin.default_text_font_size, gwskin.default_icon_height + gwskin.default_text_font_size);
		msg.set_alpha(0.8);
		msg.show();

		e.type = GF_JS_EVENT_PLAYLIST_PLAY;
		e.index = sequence_index;
		gwlib_filter_event(e);
    },
	
	sequences : [

				 'bifs-2D-background-background2D-bind.mp4',
				 'bifs-2D-background-background2D-image.mp4',
				 'bifs-2D-background-background2D-layer2D.mp4',
				 'bifs-2D-background-background2D-movie.mp4',
				 'bifs-2D-background-background2D-url-change.mp4',
				 'bifs-2D-interactivity-discsensor.mp4',
				 'bifs-2D-interactivity-htk-sensor.mp4',
				 'bifs-2D-interactivity-keysensor.mp4',
				 'bifs-2D-interactivity-mousesensor.mp4',
				 'bifs-2D-interactivity-nested-sensors.mp4',
				 'bifs-2D-interactivity-planesensor2D.mp4',
				 'bifs-2D-interactivity-proximitysensor2D.mp4',
				 'bifs-2D-interactivity-stringsensor.mp4',
				 'bifs-2D-interactivity-touchsensor-4states.mp4',
				 'bifs-2D-interactivity-touchsensor-hitpoint.mp4',
				 'bifs-2D-interactivity-touchsensor-isactive-exposedfield.mp4',
				 'bifs-2D-interactivity-touchsensor-isactive.mp4',
				 'bifs-2D-interactivity-touchsensor-isover.mp4',
				 'bifs-2D-interactivity-touchsensor-move_over.mp4',
				 'bifs-2D-painting-colortransform-alpha.mp4',
				 'bifs-2D-painting-colortransform-bitmap.mp4',
				 'bifs-2D-painting-colortransform-color.mp4',
				 'bifs-2D-painting-lineproperties.mp4',
				 'bifs-2D-painting-material2D.mp4',
				 'bifs-2D-painting-xlineproperties-cap.mp4',
				 'bifs-2D-painting-xlineproperties-compositetexture2D.mp4',
				 'bifs-2D-painting-xlineproperties-dash.mp4',
				 'bifs-2D-painting-xlineproperties-imagetexture.mp4',
				 'bifs-2D-painting-xlineproperties-join.mp4',
				 'bifs-2D-painting-xlineproperties-lineargradient.mp4',
				 'bifs-2D-painting-xlineproperties-radialgradient.mp4',
				 'bifs-2D-painting-xlineproperties-scalable.mp4',
				 'bifs-2D-painting-xlineproperties-transparent.mp4',
				 'bifs-2D-positioning-clipper2D.mp4',
				 'bifs-2D-positioning-form-align-center.mp4',
				 'bifs-2D-positioning-form-align-horiz.mp4',
				 'bifs-2D-positioning-form-align-vert.mp4',
				 'bifs-2D-positioning-form-spread-horiz.mp4',
				 'bifs-2D-positioning-form-spread-vert.mp4',
				 'bifs-2D-positioning-layer2D.mp4',
				 'bifs-2D-positioning-layer2d-in-layer2d.mp4',
				 'bifs-2D-positioning-layout-horiz-ltr-nowrap.mp4',
				 'bifs-2D-positioning-layout-horiz-ltr-wrap-btt.mp4',
				 'bifs-2D-positioning-layout-horiz-ltr-wrap-ttb.mp4',
				 'bifs-2D-positioning-layout-horiz-rtl-nowrap.mp4',
				 'bifs-2D-positioning-layout-horiz-rtl-wrap-btt.mp4',
				 'bifs-2D-positioning-layout-horiz-rtl-wrap-ttb.mp4',
				 'bifs-2D-positioning-layout-horiz-text.mp4',
				 'bifs-2D-positioning-layout-scroll-child.mp4',
				 'bifs-2D-positioning-layout-scroll-full.mp4',
				 'bifs-2D-positioning-layout-scroll-modes-horiz.mp4',
				 'bifs-2D-positioning-layout-scroll-modes-vert.mp4',
				 'bifs-2D-positioning-layout-scroll-on-off.mp4',
				 'bifs-2D-positioning-layout-vert-btt-nowrap.mp4',
				 'bifs-2D-positioning-layout-vert-btt-wrap-ltr.mp4',
				 'bifs-2D-positioning-layout-vert-btt-wrap-rtl.mp4',
				 'bifs-2D-positioning-layout-vert-ttb-nowrap.mp4',
				 'bifs-2D-positioning-layout-vert-ttb-wrap-ltr.mp4',
				 'bifs-2D-positioning-layout-vert-ttb-wrap-rtl.mp4',
				 'bifs-2D-positioning-orderedgroup.mp4',
				 'bifs-2D-positioning-pathlayout-graphics.mp4',
				 'bifs-2D-positioning-pathlayout.mp4',
				 'bifs-2D-positioning-transform2D.mp4',
				 'bifs-2D-positioning-transformmatrix2D.mp4',
				 'bifs-2D-shapes-all.mp4',
				 'bifs-2D-shapes-indexfaceset2D.mp4',
				 'bifs-2D-shapes-indexlineset2D.mp4',
				 'bifs-2D-shapes-pointset2D.mp4',
				 'bifs-2D-shapes-xcurve2D.mp4',
				 'bifs-2D-texturing-compositetexture2D-background.mp4',
				 'bifs-2D-texturing-compositetexture2D-bitmap.mp4',
				 'bifs-2D-texturing-compositetexture2D-transparent.mp4',
				 'bifs-2D-texturing-gradients-text.mp4',
				 'bifs-2D-texturing-gradients-transparent.mp4',
				 'bifs-2D-texturing-imagetexture-shapes.mp4',
				 'bifs-2D-texturing-lineargradient-simple.mp4',
				 'bifs-2D-texturing-lineargradient-spread.mp4',
				 'bifs-2D-texturing-movietexture-shapes.mp4',
				 'bifs-2D-texturing-pixeltexture.mp4',
				 'bifs-2D-texturing-radialgradient-simple.mp4',
				 'bifs-2D-texturing-radialgradient-spread.mp4',
				 'bifs-2D-texturing-texturetransform-base.mp4',
				 'bifs-2D-texturing-texturetransform-interact.mp4',
				 'bifs-2D-texturing-texturetransform-transformmatrix2D.mp4',
				 'bifs-2D-viewport-complete.mp4',
				 'bifs-2D-viewport-simple.mp4',
				 'bifs-3D-background-images.mp4',
				 'bifs-3D-background.mp4',
				 'bifs-3D-interactivity-collision-proxy.mp4',
				 'bifs-3D-interactivity-collision.mp4',
				 'bifs-3D-interactivity-cylindersensor.mp4',
				 'bifs-3D-interactivity-planesensor.mp4',
				 'bifs-3D-interactivity-proximitysensor.mp4',
				 'bifs-3D-interactivity-spheresensor.mp4',
				 'bifs-3D-interactivity-visibilitysensor.mp4',
				 'bifs-3D-lighting-directionalLight.mp4',
				 'bifs-3D-lighting-fog.mp4',
				 'bifs-3D-lighting-pointlight.mp4',
				 'bifs-3D-lighting-spotlight.mp4',
				 'bifs-3D-positioning-billboard-viewer-alignment.mp4',
				 'bifs-3D-positioning-billboard.mp4',
				 'bifs-3D-positioning-gravity.mp4',
				 'bifs-3D-positioning-layer3D-views.mp4',
				 'bifs-3D-positioning-layer3D.mp4',
				 'bifs-3D-positioning-lod.mp4',
				 'bifs-3D-positioning-transform.mp4',
				 'bifs-3D-shapes-box-transparent.mp4',
				 'bifs-3D-shapes-box.mp4',
				 'bifs-3D-shapes-cone.mp4',
				 'bifs-3D-shapes-cylinder.mp4',
				 'bifs-3D-shapes-elevationgrid.mp4',
				 'bifs-3D-shapes-extrusion.mp4',
				 'bifs-3D-shapes-indexedfaceset.mp4',
				 'bifs-3D-shapes-indexedlineset.mp4',
				 'bifs-3D-shapes-nonlineardeformer.mp4',
				 'bifs-3D-shapes-pointset.mp4',
				 'bifs-3D-texturing-box-transparent.mp4',
				 'bifs-3D-texturing-box-video.mp4',
				 'bifs-3D-texturing-box.mp4',
				 'bifs-3D-texturing-compositetexture3D-bitmap.mp4',
				 'bifs-3D-texturing-compositetexture3D-box.mp4',
				 'bifs-3D-texturing-cone-transparent.mp4',
				 'bifs-3D-texturing-cone.mp4',
				 'bifs-3D-texturing-cylinder-transparent.mp4',
				 'bifs-3D-texturing-cylinder.mp4',
				 'bifs-3D-texturing-transform-box.mp4',
				 'bifs-3D-texturing-transform-matrix-box.mp4',
				 'bifs-3D-viewpoint-anim.mp4',
				 'bifs-3D-viewpoint-bind-jump.mp4',
				 'bifs-3D-viewpoint-bind.mp4',
				 'bifs-3D-viewpoint-ortho-bind.mp4',
				 'bifs-bitmap-image-meter-metrics.mp4',
				 'bifs-bitmap-image-pixel-metrics.mp4',
				 'bifs-bitmap-image-resizing.mp4',
				 'bifs-bitmap-movie-materialkey.mp4',
				 'bifs-bitmap-movie.mp4',
				 'bifs-bitmap-video-resizing.mp4',
				 'bifs-cachetexture_cache.mp4',
				 'bifs-cachetexture_nocache.mp4',
				 'bifs-command-animated-osmo4logo.mp4',
				 'bifs-command-delete-index.mp4',
				 'bifs-command-delete-node.mp4',
				 'bifs-command-delete-route.mp4',
				 'bifs-command-global-qp.mp4',
				 'bifs-command-insert-index.mp4',
				 'bifs-command-insert-node.mp4',
				 'bifs-command-insert-nodedef.mp4',
				 'bifs-command-insert-route.mp4',
				 'bifs-command-multiple-replace-field.mp4',
				 'bifs-command-multiple-replace-index.mp4',
				 'bifs-command-node-delete-ex.mp4',
				 'bifs-command-proto-delete.mp4',
				 'bifs-command-proto-insert.mp4',
				 'bifs-command-protolist-delete.mp4',
				 'bifs-command-quantification.mp4',
				 'bifs-command-replace-field.mp4',
				 'bifs-command-replace-index.mp4',
				 'bifs-command-replace-node-null.mp4',
				 'bifs-command-replace-node.mp4',
				 'bifs-command-replace-route.mp4',
				 'bifs-command-replace-scene-null.mp4',
				 'bifs-command-replace-scene.mp4',
				 'bifs-command-route-add-children.mp4',
				 'bifs-command-route-children.mp4',
				 'bifs-command-route-node-exposedfield.mp4',
				 'bifs-command-route-node.mp4',
				 'bifs-command-route-remove-children.mp4',
				 'bifs-environmenttest.mp4',
				 'bifs-externproto-forestgump-lib.mp4',
				 'bifs-externproto-forestgump.mp4',
				 'bifs-externproto-mfurl-lib.mp4',
				 'bifs-externproto-mfurl.mp4',
				 'bifs-externproto-nood-lib.mp4',
				 'bifs-externproto-nood.mp4',
				 'bifs-externproto-simple-lib.mp4',
				 'bifs-externproto-simple.mp4',
				 'bifs-game-arrange.mp4',
				 'bifs-game-breakout.mp4',
				 'bifs-game-bubble.mp4',
				 'bifs-game-minesweeper.mp4',
				 'bifs-game-othello.mp4',
				 'bifs-interpolation-colorinterpolator.mp4',
				 'bifs-interpolation-coordinateinterpolator2D.mp4',
				 'bifs-interpolation-positionanimator.mp4',
				 'bifs-interpolation-positionanimator2D.mp4',
				 'bifs-interpolation-positioninterpolator-position.mp4',
				 'bifs-interpolation-positioninterpolator-size.mp4',
				 'bifs-interpolation-positioninterpolator2D-position.mp4',
				 'bifs-interpolation-positioninterpolator2D-size.mp4',
				 'bifs-interpolation-scalaranimator.mp4',
				 'bifs-interpolation-scalarinterpolator.mp4',
				 'bifs-interpolation-timesensor-enabled.mp4',
				 'bifs-interpolation-timesensor-starttime_norestart.mp4',
				 'bifs-interpolation-timesensor-starttime_restart.mp4',
				 'bifs-interpolation-valuator-sftime.mp4',
				 'bifs-keynavigator.mp4',
				 'bifs-linking-anchor-mp4-next.mp4',
				 'bifs-linking-anchor-mp4-prev.mp4',
				 'bifs-linking-anchor-viewpoint.mp4',
				 'bifs-linking-anchor-www.mp4',
				 'bifs-linking-animationstream.mp4',
				 'bifs-linking-inline-direct-inline.mp4',
				 'bifs-linking-inline-direct.mp4',
				 'bifs-linking-inline-od-inline.mp4',
				 'bifs-linking-inline-od.mp4',
				 'bifs-linking-inline-rtsp-no-od.mp4',
				 'bifs-linking-inline-rtsp.mp4',
				 'bifs-linking-inline-segment-inline.mp4',
				 'bifs-linking-inline-segment.mp4',
				 'bifs-media-audiobuffer.mp4',
				 'bifs-media-audioclip-urlchanged.mp4',
				 'bifs-media-audioclip.mp4',
				 'bifs-media-audiosource-mixing.mp4',
				 'bifs-media-audiosource-urlchanged.mp4',
				 'bifs-media-audiosource.mp4',
				 'bifs-media-imagetexture-OD-reuse.mp4',
				 'bifs-media-imagetexture-no-od.mp4',
				 'bifs-media-imagetexture-object-scale.mp4',
				 'bifs-media-imagetexture-transparent.mp4',
				 'bifs-media-imagetexture-url-change.mp4',
				 'bifs-media-movietexture-control.mp4',
				 'bifs-media-movietexture-no-od.mp4',
				 'bifs-media-movietexture-od-joinsession.mp4',
				 'bifs-media-movietexture-od-leave-session.mp4',
				 'bifs-media-movietexture-owns-OCR.mp4',
				 'bifs-media-movietexture-shares-OCR.mp4',
				 'bifs-media-movietexture-url-change.mp4',
				 'bifs-media-sound-spatialize.mp4',
				 'bifs-media-sound.mp4',
				 'bifs-misc-UTF16-input.mp4',
				 'bifs-misc-cyclic-graph.mp4',
				 'bifs-misc-hc-proto-events.mp4',
				 'bifs-misc-hc-proto-pathextrusion.mp4',
				 'bifs-misc-hc-proto-planarextrusion.mp4',
				 'bifs-misc-hc-proto-planeclipper.mp4',
				 'bifs-misc-non-linear-parsing-conditional.mp4',
				 'bifs-misc-non-linear-parsing-use.mp4',
				 'bifs-misc-srt-import-3gpp-control-share-ocr.mp4',
				 'bifs-misc-srt-import-3gpp-control.mp4',
				 'bifs-misc-srt-import-3gpp.mp4',
				 'bifs-misc-srt-import.mp4',
				 'bifs-od-remove-esd.mp4',
				 'bifs-od-remove-od.mp4',
				 'bifs-od-update-od.mp4',
				 'bifs-proto-conditional.mp4',
				 'bifs-proto-delete-def.mp4',
				 'bifs-proto-delete-index.mp4',
				 'bifs-proto-forestgump.mp4',
				 'bifs-proto-mfurl.mp4',
				 'bifs-proto-multiple.mp4',
				 'bifs-proto-nested.mp4',
				 'bifs-proto-route.mp4',
				 'bifs-proto-sftime-protocode.mp4',
				 'bifs-proto-sftime-protointerface.mp4',
				 'bifs-proto-simple.mp4',
				 'bifs-proto-use.mp4',
				 'bifs-script-char-to-int.mp4',
				 'bifs-script-child-create.mp4',
				 'bifs-script-date.mp4',
				 'bifs-script-event-out.mp4',
				 'bifs-script-initialize.mp4',
				 'bifs-script-load-url.mp4',
				 'bifs-script-node-access.mp4',
				 'bifs-script-node-create.mp4',
				 'bifs-script-proto.mp4',
				 'bifs-script-timestamp.mp4',
				 'bifs-storage.mp4',
				 'bifs-stream-text-switch.mp4',
				 'bifs-text-align-horiz1.mp4',
				 'bifs-text-align-horiz2.mp4',
				 'bifs-text-align-horiz3.mp4',
				 'bifs-text-align-horiz4.mp4',
				 'bifs-text-align-vert1.mp4',
				 'bifs-text-align-vert2.mp4',
				 'bifs-text-align-vert3.mp4',
				 'bifs-text-align-vert4.mp4',
				 'bifs-text-glyph-advance.mp4',
				 'bifs-text-length.mp4',
				 'bifs-text-maxextend.mp4',
				 'bifs-text-style.mp4',
				 'bifs-text-unicode.mp4',
				 'bifs-text-vrml-alignment.mp4',
				 'bifs-timeline-mediacontrol-OCR.mp4',
				 'bifs-timeline-mediacontrol-audio-speed.mp4',
				 'bifs-timeline-mediacontrol-audio.mp4',
				 'bifs-timeline-mediacontrol-complete.mp4',
				 'bifs-timeline-mediacontrol-deactivation.mp4',
				 'bifs-timeline-mediacontrol-inline-av.mp4',
				 'bifs-timeline-mediacontrol-inline-segments.mp4',
				 'bifs-timeline-mediacontrol-inline.mp4',
				 'bifs-timeline-mediacontrol-rtsp.mp4',
				 'bifs-timeline-mediacontrol-seg-inline.mp4',
				 'bifs-timeline-mediacontrol-segments.mp4',
				 'bifs-timeline-mediacontrol-video.mp4',
				 'bifs-timeline-mediacontrol-videospeed.mp4',
				 'bifs-timeline-mediasensor-segment-switch.mp4',
				 'bifs-timeline-mediasensor-segment.mp4',
				 'bifs-timeline-mediasensor.mp4',
	
	]

};
