# flake8: noqa
# atomization energies in kcal / mol (= 43.364 meV)
# All values evaluated with PBE xc-orbitals and densities at
# experimental geometries. Zero-point vibration has been removed
# from experimental energies (from [1]).
atomization = {
# Molec   expt    LSD    PBE    RPBE   BLYP
'H2'  : ( 109.5, 113.2, 104.6, 105.5, 109.4),
'LiH' : (  57.8,  61.0,  53.5,  53.4,  58.1),
'CH4' : ( 419.3, 462.3, 419.8, 410.6, 416.6),
'NH3' : ( 297.4, 337.3, 301.7, 293.2, 301.4),
'OH'  : ( 106.4, 124.1, 109.8, 106.3, 109.6),
'H2O' : ( 232.2, 266.5, 234.2, 226.6, 232.5),
'HF'  : ( 140.8, 162.2, 142.0, 137.5, 141.0),
'Li2' : (  24.4,  23.9,  19.9,  20.2,  20.5),
'LiF' : ( 138.9, 156.1, 138.6, 132.9, 140.1),
'Be2' : (   3.0,  12.8,   9.8,   7.9,   6.1),
'C2H2': ( 405.4, 460.3, 414.9, 400.4, 405.3),
'C2H4': ( 562.6, 632.6, 571.5, 554.5, 560.7),
'HCN' : ( 311.9, 361.0, 326.1, 313.6, 320.3),
'CO'  : ( 259.3, 299.1, 268.8, 257.9, 261.8),
'N2'  : ( 228.5, 267.4, 243.2, 232.7, 239.8),
'NO'  : ( 152.9, 198.7, 171.9, 161.6, 166.0),
'O2'  : ( 120.5, 175.0, 143.7, 133.3, 135.3),
'F2'  : (  38.5,  78.2,  53.4,  45.6,  49.4),
'P2'  : ( 117.3, 143.8, 121.1, 114.1, 121.0),
'Cl2' : (  58.0,  83.0,  65.1,  58.9,  57.2)
}

# exchange-only atomization energies in kcal / mol (= 43.364 meV)
# All values evaluated with PBE xc-orbitals and densities at
# experimental geometries. (from [1]).
ex_atomization = {
# Molec   exact   LSD    PBE    RPBE   BLYP
'H2'  : (  84.0,  81.5,  84.8,  85.8,  85.4),
'LiH' : (  33.9,  33.6,  36.9,  36.8,  36.2),
'CH4' : ( 327.2, 369.9, 336.0, 326.9, 331.2),
'NH3' : ( 199.5, 255.0, 227.4, 218.9, 222.6),
'OH'  : (  67.3,  96.2,  84.5,  80.9,  82.7),
'H2O' : ( 154.6, 212.9, 183.9, 176.4, 180.5),
'HF'  : (  96.1, 136.1, 117.1, 112.6, 115.4),
'Li2' : (   3.5,   6.5,   6.4,   6.7,   3.9),
'LiF' : (  86.8, 129.7, 116.5, 110.8, 113.6),
'Be2' : ( -11.0,   9.4,   3.1,   1.2,   1.6),
'C2H2': ( 290.6, 382.7, 333.0, 318.5, 325.5),
'C2H4': ( 423.9, 517.7, 456.5, 439.6, 447.4),
'HCN' : ( 194.5, 294.0, 256.1, 243.5, 249.1),
'CO'  : ( 169.2, 261.9, 224.0, 213.1, 218.7),
'N2'  : ( 110.2, 211.4, 184.1, 173.6, 177.6),
'NO'  : (  45.6, 156.9, 122.8, 112.5, 117.0),
'O2'  : (  24.9, 147.5, 104.4,  94.1,  99.3),
'F2'  : ( -43.3,  64.0,  32.5,  24.7,  28.8),
'P2'  : (  31.8,  98.4,  73.1,  66.1,  70.1),
'Cl2' : (  15.5,  68.2,  39.8,  33.7,  37.0)
}



# Experimental, and calculated bindinglengths of 16 diatomic molecules
# of the G2-1 test set. In Angstroms.
# Data from reference [3].
diatomic = {
#System Expt. PBEVASP PBEG03 PBE0VASP PBE0G03
'BeH': (1.343, 1.354, 1.353, 1.350, 1.348),
'CH' : (1.120, 1.136, 1.136, 1.124, 1.124),
'Cl2': (1.988, 1.999, 2.004, 1.973, 1.978),
'ClF': (1.628, 1.648, 1.650, 1.614, 1.617),
'ClO': (1.570, 1.576, 1.577, 1.554, 1.555),
'CN' : (1.172, 1.173, 1.174, 1.159, 1.159),
'CO' : (1.128, 1.136, 1.135, 1.122, 1.122),
'F2' : (1.412, 1.414, 1.413, 1.377, 1.376),
'FH' : (0.917, 0.932, 0.930, 0.919, 0.918),
'HCl': (1.275, 1.287, 1.288, 1.276, 1.278),
'Li2': (2.673, 2.728, 2.728, 2.727, 2.727),
'LiF': (1.564, 1.583, 1.575, 1.571, 1.561),
'LiH': (1.595, 1.604, 1.604, 1.602, 1.597),
'N2' : (1.098, 1.103, 1.102, 1.089, 1.089),
'O2' : (1.208, 1.218, 1.218, 1.193, 1.192),
'Na2': (3.079, 3.087, 3.076, 3.086, 3.086),
}
