struct grib_var_table {
  int id;
  char name[6] ;
  char desc[38] ;
  char units[16] ;
  } ;

struct grib_var_table vt[256] = {

  { 0 , "undef" , "undef" , "[undef]" },
  { 1 , "pres" , "Pressure" , "[Pa]" },
  { 2 , "prmsl" , "Pressure reduced to MSL" , "[Pa]" },
  { 3 , "ptend" , "Pressure tendency" , "[Pa/s]" },
  { 4 , "undef" , "undef" , "[undef]" },
  { 5 , "undef" , "undef" , "[undef]" },
  { 6 , "gp" , "Geopotential" , "[m**2/s**2]" },
  { 7 , "hgt" , "Geopotential height" , "[gpm]" },
  { 8 , "dist" , "Geometric height" , "[m]" },
  { 9 , "hstdv" , "Standard deviation of height" , "[m]" },
  { 10 , "hvar" , "Variance of height" , "[m**2]" },
  { 11 , "tmp" , "Temperature" , "[K]" },
  { 12 , "vtmp" , "Virtual temperature" , "[K]" },
  { 13 , "pot" , "Potential temperature" , "[K]" },
  { 14 , "epot" , "Pseudo-adiabatic potential temperature" , "[K]" },
  { 15 , "tmax" , "Maximum temperature" , "[K]" },
  { 16 , "tmin" , "Minimum temperature" , "[K]" },
  { 17 , "dpt" , "Dew point temperature" , "[K]" },
  { 18 , "depr" , "Dew point depression" , "[K]" },
  { 19 , "lapr" , "Lapse rate" , "[K/m]" },
  { 20 , "visib" , "Visibility" , "[m]" },
  { 21 , "rdsp1" , "Radar spectra (1)" , "[dimensionless]" },
  { 22 , "rdsp2" , "Radar spectra (2)" , "[dimensionless]" },
  { 23 , "rdsp3" , "Radar spectra (3)" , "[dimensionless]" },
  { 24 , "undef" , "undef" , "[undef]" },
  { 25 , "tmpa" , "Temperature anomaly" , "[K]" },
  { 26 , "presa" , "Pressure anomaly" , "[Pa]" },
  { 27 , "gpa" , "Geopotential height anomaly" , "[gpm]" },
  { 28 , "wvsp1" , "Wave spectra (1)" , "[dimensionless]" },
  { 29 , "wvsp2" , "Wave spectra (2)" , "[dimensionless]" },
  { 30 , "wvsp3" , "Wave spectra (3)" , "[dimensionless]" },
  { 31 , "wdir" , "Wind direction" , "[degree]" },
  { 32 , "wind" , "Wind speed" , "[m/s]" },
  { 33 , "ugrd" , "u wind" , "[m/s]" },
  { 34 , "vgrd" , "v wind" , "[m/s]" },
  { 35 , "strm" , "Stream function" , "[m**2/s]" },
  { 36 , "vpot" , "Velocity potential" , "[m**2/s]" },
  { 37 , "mntsf" , "Montgomery stream function" , "[m**2/s**2]" },
  { 38 , "sgcvv" , "Sigma coord. vertical velocity" , "[/s]" },
  { 39 , "vvel" , "Pressure vertical velocity" , "[Pa/s]" },
  { 40 , "dzdt" , "Geometric vertical velocity" , "[m/s]" },
  { 41 , "absv" , "Absolute vorticity" , "[/s]" },
  { 42 , "absd" , "Absolute divergence" , "[/s]" },
  { 43 , "relv" , "Relative vorticity" , "[/s]" },
  { 44 , "reld" , "Relative divergence" , "[/s]" },
  { 45 , "vucsh" , "Vertical u shear" , "[/s]" },
  { 46 , "vvcsh" , "Vertical v shear" , "[/s]" },
  { 47 , "dirc" , "Direction of current" , "[degree]" },
  { 48 , "spc" , "Speed of current" , "[m/s]" },
  { 49 , "uogrd" , "u of current" , "[m/s]" },
  { 50 , "vogrd" , "v of current" , "[m/s]" },
  { 51 , "spfh" , "Specific humidity" , "[kg/kg]" },
  { 52 , "rh" , "Relative humidity" , "[percent]" },
  { 53 , "mixr" , "Humidity mixing ratio" , "[kg/kg]" },
  { 54 , "pwat" , "Precipitable water" , "[kg/m**2]" },
  { 55 , "vapp" , "Vapor pressure" , "[Pa]" },
  { 56 , "satd" , "Saturation deficit" , "[Pa]" },
  { 57 , "evp" , "Evaporation" , "[kg/m**2]" },
  { 58 , "cice" , "Cloud Ice" , "[kg/m**2]" },
  { 59 , "prate" , "Precipitation rate" , "[kg/m**2/s]" },
  { 60 , "tstm" , "Thunderstorm probability" , "[percent]" },
  { 61 , "apcp" , "Total precipitation" , "[kg/m**2]" },
  { 62 , "ncpcp" , "Large scale precipitation" , "[kg/m**2]" },
  { 63 , "acpcp" , "Convective precipitation" , "[kg/m**2]" },
  { 64 , "srweq" , "Snowfall rate water equivalent" , "[kg/m**2/s]" },
  { 65 , "weasd" , "Water equiv. of accum. snow depth" , "[kg/m**2]" },
  { 66 , "snod" , "Snow depth" , "[m]" },
  { 67 , "mixht" , "Mixed layer depth" , "[m]" },
  { 68 , "tthdp" , "Transient thermocline depth" , "[m]" },
  { 69 , "mthd" , "Main thermocline depth" , "[m]" },
  { 70 , "mtha" , "Main thermocline anomaly" , "[m]" },
  { 71 , "tcdc" , "Total cloud cover" , "[percent]" },
  { 72 , "cdcon" , "Convective cloud cover" , "[percent]" },
  { 73 , "lcdc" , "Low level cloud cover" , "[percent]" },
  { 74 , "mcdc" , "Mid level cloud cover" , "[percent]" },
  { 75 , "hcdc" , "High level cloud cover" , "[percent]" },
  { 76 , "cwat" , "Cloud water" , "[kg/m**2]" },
  { 77 , "undef" , "undef" , "[undef]" },
  { 78 , "snoc" , "Convective snow" , "[kg/m**2]" },
  { 79 , "snol" , "Large scale snow" , "[kg/m**2]" },
  { 80 , "wtmp" , "Water temperature" , "[K]" },
  { 81 , "land" , "Land-sea mask (1=land; 0=sea)" , "[integer]" },
  { 82 , "dslm" , "Deviation of sea level from mean" , "[m]" },
  { 83 , "sfcr" , "Surface roughness" , "[m]" },
  { 84 , "albdo" , "Albedo" , "[percent]" },
  { 85 , "tsoil" , "Soil temperature" , "[K]" },
  { 86 , "soilm" , "Soil moisture content" , "[kg/m**2]" },
  { 87 , "veg" , "Vegetation" , "[percent]" },
  { 88 , "salty" , "Salinity" , "[kg/kg]" },
  { 89 , "den" , "Density" , "[kg/m**2]" },
  { 90 , "runof" , "Runoff" , "[kg/m**2]" },
  { 91 , "icec" , "Ice concentration (ice=1; no ice=0)" , "[1/0]" },
  { 92 , "icetk" , "Ice thickness" , "[m]" },
  { 93 , "diced" , "Direction of ice drift" , "[degree]" },
  { 94 , "siced" , "Speed of ice drift" , "[m/s]" },
  { 95 , "uice" , "u of ice drift" , "[m/s]" },
  { 96 , "vice" , "v of ice drift" , "[m/s]" },
  { 97 , "iceg" , "Ice growth" , "[m]" },
  { 98 , "iced" , "Ice divergence" , "[/s]" },
  { 99 , "snom" , "Snow melt" , "[kg/m**2]" },
  { 100 , "htsgw" , "Sig height of wind waves and swell" , "[m]" },
  { 101 , "wvdir" , "Direction of wind waves" , "[degree]" },
  { 102 , "wvhgt" , "Significant height of wind waves" , "[m]" },
  { 103 , "wvper" , "Mean period of wind waves" , "[s]" },
  { 104 , "swdir" , "Direction of swell waves" , "[degree]" },
  { 105 , "swell" , "Significant height of swell waves" , "[m]" },
  { 106 , "swper" , "Mean period of swell waves" , "[s]" },
  { 107 , "dirpw" , "Primary wave direction" , "[degree]" },
  { 108 , "perpw" , "Primary wave mean period" , "[s]" },
  { 109 , "dirsw" , "Secondary wave direction" , "[degree]" },
  { 110 , "persw" , "Secondary wave mean period" , "[s]" },
  { 111 , "nswrs" , "Net short wave radiation (surface)" , "[W/m**2]" },
  { 112 , "nlwrs" , "Net long wave radiation (surface)" , "[W/m**2]" },
  { 113 , "nswrt" , "Net short wave radiation (top)" , "[W/m**2]" },
  { 114 , "nlwrt" , "Net long wave radiation (top)" , "[W/m**2]" },
  { 115 , "lwavr" , "Long wave radiation" , "[W/m**2]" },
  { 116 , "swavr" , "Short wave radiation" , "[W/m**2]" },
  { 117 , "grad" , "Global radiation" , "[W/m**2]" },
  { 118 , "undef" , "undef" , "[undef]" },
  { 119 , "undef" , "undef" , "[undef]" },
  { 120 , "undef" , "undef" , "[undef]" },
  { 121 , "lhtfl" , "Latent heat flux" , "[W/m**2]" },
  { 122 , "shtfl" , "Sensible heat flux" , "[W/m**2]" },
  { 123 , "blydp" , "Boundary layer dissipation" , "[W/m**2]" },
  { 124 , "uflx" , "Zonal component of momentum flux" , "[N/m**2]" },
  { 125 , "vflx" , "Meridional component of momentum flux" , "[N/m**2]" },
  { 126 , "wmixe" , "Wind mixing energy" , "[J]" },
  { 127 , "imgd" , "Image data" , "[integer]" },
  { 128 , "mslsa" , "Mean sea level pressure (Std Atm)" , "[Pa]" },
  { 129 , "mslma" , "Mean sea level pressure (MAPS)" , "[Pa]" },
  { 130 , "mslet" , "Mean sea level pressure (ETA model)" , "[Pa]" },
  { 131 , "lftx" , "Surface lifted index" , "[K]" },
  { 132 , "4lftx" , "Best (4-layer) lifted index" , "[K]" },
  { 133 , "kx" , "K index" , "[K]" },
  { 134 , "sx" , "Sweat index" , "[K]" },
  { 135 , "mconv" , "Horizontal moisture divergence" , "[kg/kg/s]" },
  { 136 , "vssh" , "Vertical speed shear" , "[1/s]" },
  { 137 , "tslsa" , "3-hr pressure tendency" , "[Pa/s]" },
  { 138 , "bvf2" , "Brunt-Vaisala frequency squared" , "[1/s**2]" },
  { 139 , "pvmw" , "Potential vorticity (mass-weighted)" , "[1/s/m]" },
  { 140 , "crain" , "Categorical rain (yes=1;no=0)" , "[non-dim]" },
  { 141 , "cfrzr" , "Categorical freezing rain (yes=1;no=0)" , "[non-dim]" },
  { 142 , "cicep" , "Categorical ice pellets (yes=1;no=0)" , "[non-dim]" },
  { 143 , "csnow" , "Categorical snow (yes=1;no=0)" , "[non-dim]" },
  { 144 , "soilw" , "Volumetric soil moisture content" , "[fraction]" },
  { 145 , "pevpr" , "Potential evaporation rate" , "[w/m**/]" },
  { 146 , "cwork" , "Cloud work function" , "[J/Kg]" },
  { 147 , "u-gwd" , "Zonal gravity wave stress" , "[N/m**2]" },
  { 148 , "v-gwd" , "Meridional gravity wave stress" , "[N/m**2]" },
  { 149 , "pv___" , "Potential vorticity" , "[m**2/s/kg]" },
  { 150 , "undef" , "undef" , "[undef]" },
  { 151 , "undef" , "undef" , "[undef]" },
  { 152 , "undef" , "undef" , "[undef]" },
  { 153 , "mfxdv" , "Moisture flux divergence" , "[gr/gr*m/s/m]" },
  { 154 , "undef" , "undef" , "[undef]" },
  { 155 , "gflux" , "Ground heat flux" , "[W/m**2]" },
  { 156 , "cin" , "Convective inhibition" , "[J/kg]" },
  { 157 , "cape" , "Convective Available Potential Energy" , "[J/kg]" },
  { 158 , "tke" , "Turbulent kinetic energy" , "[J/kg]" },
  { 159 , "condp" , "Condensation pressure of lifted parcel" , "[Pa]" },
  { 160 , "csusf" , "Clear sky upward solar flux" , "[W/m**2]" },
  { 161 , "csdsf" , "Clear sky downward solar flux" , "[W/m**2]" },
  { 162 , "csulf" , "Clear sky upward long wave flux" , "[W/m**2]" },
  { 163 , "csdlf" , "Clear sky downward long wave flux" , "[W/m**2]" },
  { 164 , "cfnsf" , "Cloud forcing net solar flux" , "[W/m**2]" },
  { 165 , "cfnlf" , "Cloud forcing net long wave flux" , "[W/m**2]" },
  { 166 , "vbdsf" , "Visible beam downward solar flux" , "[W/m**2]" },
  { 167 , "vddsf" , "Visible diffuse downward solar flux" , "[W/m**2]" },
  { 168 , "nbdsf" , "Near IR beam downward solar flux" , "[W/m**2]" },
  { 169 , "nddsf" , "Near IR diffuse downward solar flux" , "[W/m**2]" },
  { 170 , "ustr" , "U wind stress" , "[N/m**2]" },
  { 171 , "vstr" , "V wind stress" , "[N/m**2]" },
  { 172 , "mflx" , "Momentum flux" , "[N/m**2]" },
  { 173 , "lmh" , "Mass point model surface" , "[integer]" },
  { 174 , "lmv" , "Velocity point model surface" , "[integer]" },
  { 175 , "sglyr" , "Nearby model level" , "[integer]" },
  { 176 , "nlat" , "Latitude" , "[degree]" },
  { 177 , "nlon" , "Longitude" , "[degree]" },
  { 178 , "umas" , "Mass weighted u" , "[gm/m*K*s]" },
  { 179 , "vmas" , "Mass weighted v" , "[gm/m*K*s]" },
  { 180 , "undef" , "undef" , "[undef]" },
  { 181 , "lpsx" , "x-gradient of log pressure" , "[1/m]" },
  { 182 , "lpsy" , "y-gradient of log pressure" , "[1/m]" },
  { 183 , "hgtx" , "x-gradient of height" , "[m/m]" },
  { 184 , "hgty" , "y-gradient of height" , "[m/m]" },
  { 185 , "stdz" , "Standard deviation of Geop. hgt." , "[m]" },
  { 186 , "stdu" , "Standard deviation of zonal wind" , "[m/s]" },
  { 187 , "stdv" , "Standard deviation of meridional wind" , "[m/s]" },
  { 188 , "stdq" , "Standard deviation of spec. hum." , "[gm/gm]" },
  { 189 , "stdt" , "Standard deviation of temperature" , "[K]" },
  { 190 , "cbuw" , "Covariance between u and omega" , "[m/s*Pa/s]" },
  { 191 , "cbvw" , "Covariance between v and omega" , "[m/s*Pa/s]" },
  { 192 , "cbuq" , "Covariance between u and specific hum" , "[m/s*gm/gm]" },
  { 193 , "cbvq" , "Covariance between v and specific hum" , "[m/s*gm/gm]" },
  { 194 , "cbtw" , "Covariance between T and omega" , "[K*Pa/s]" },
  { 195 , "cbqw" , "Covariance between spec. hum and omeg" , "[gm/gm*Pa/s]" },
  { 196 , "cbmzw" , "Covariance between v and u" , "[m**2/s**2]" },
  { 197 , "cbtzw" , "Covariance between u and T" , "[K*m/s]" },
  { 198 , "cbtmw" , "Covariance between v and T" , "[K*m/s]" },
  { 199 , "stdrh" , "Standard deviation of Rel. Hum." , "[percent]" },
  { 200 , "sdtz" , "Std dev of time tend of geop. hgt" , "[m]" },
  { 201 , "icwat" , "Ice-free water surface" , "[percent]" },
  { 202 , "sdtu" , "Std dev of time tend of zonal wind" , "[m/s]" },
  { 203 , "sdtv" , "Std dev of time tend of merid wind" , "[m/s]" },
  { 204 , "dswrf" , "Downward solar radiation flux" , "[W/m**2]" },
  { 205 , "dlwrf" , "Downward long wave radiation flux" , "[W/m**2]" },
  { 206 , "sdtq" , "Std dev of time tend of spec. hum" , "[gm/gm]" },
  { 207 , "mstav" , "Moisture availability" , "[percent]" },
  { 208 , "sfexc" , "Exchange coefficient" , "[kg*m/m**3/s]" },
  { 209 , "mixly" , "Number of mixed layers next to sfc" , "[integer]" },
  { 210 , "sdtt" , "Std dev of time tend of temperature" , "[K]" },
  { 211 , "uswrf" , "Upward solar radiation flux" , "[W/m**2]" },
  { 212 , "ulwrf" , "Upward long wave radiation flux" , "[W/m**2]" },
  { 213 , "cdlyr" , "Amount of non-convective cloud" , "[percent]" },
  { 214 , "cprat" , "Convective precipitation rate" , "[kg/m**2/s]" },
  { 215 , "ttdia" , "Temperature tendency by all physics" , "[K/s]" },
  { 216 , "ttrad" , "Temperature tendency by all radiation" , "[K/s]" },
  { 217 , "ttphy" , "Temperature tendency by nonrad physics" , "[K/s]" },
  { 218 , "preix" , "Precipitation index" , "[fraction]" },
  { 219 , "tsd1d" , "Std dev of IR T over 1x1 deg area" , "[K]" },
  { 220 , "nlsgp" , "Natural log of surface pressure" , "[ln(kPa)]" },
  { 221 , "sdtrh" , "Std dev of time tend of rel hum" , "[percent]" },
  { 222 , "5wavh" , "5-wave geopotential height" , "[gpm]" },
  { 223 , "cwat" , "Plant canopy surface water" , "[kg/m**2]" },
  { 224 , "pltrs" , "Maximum stomato plant resistance" , "[s/m]" },
  { 225 , "undef" , "undef" , "[undef]" },
  { 226 , "bmixl" , "Blackadar's mixing length scale" , "[m]" },
  { 227 , "amixl" , "Asymptotic mixing length scale" , "[m]" },
  { 228 , "pevap" , "Potential evaporation" , "[kg/m**2]" },
  { 229 , "snohf" , "Snow phase-change heat flux" , "[W/m**2]" },
  { 230 , "undef" , "undef" , "[undef]" },
  { 231 , "mflux" , "Convective cloud mass flux" , "[Pa/s]" },
  { 232 , "dtrf" , "Downward total radiation flux" , "[W/m**2]" },
  { 233 , "utrf" , "Upward total radiation flux" , "[W/m**2]" },
  { 234 , "bgrun" , "Baseflow-groundwater runoff" , "[kg/m**2]" },
  { 235 , "ssrun" , "Storm surface runoff" , "[kg/m**2]" },
  { 236 , "undef" , "undef" , "[undef]" },
  { 237 , "ozone" , "Total column ozone concentration" , "[Dobson]" },
  { 238 , "snoc" , "Snow cover" , "[percent]" },
  { 239 , "snot" , "Snow temperature" , "[K]" },
  { 240 , "glcr" , "Permanent snow points" , "[mask]" },
  { 241 , "lrghr" , "Large scale condensation heating rate" , "[K/s]" },
  { 242 , "cnvhr" , "Deep convective heating rate" , "[K/s]" },
  { 243 , "cnvmr" , "Deep convective moistening rate" , "[kg/kg/s]" },
  { 244 , "shahr" , "Shallow convective heating rate" , "[K/s]" },
  { 245 , "shamr" , "Shallow convective moistening rate" , "[kg/kg/s]" },
  { 246 , "vdfhr" , "Vertical diffusion heating rate" , "[K/s]" },
  { 247 , "vdfua" , "Vertical diffusion zonal accel" , "[m/s/s]" },
  { 248 , "vdfva" , "Vertical diffusion meridional accel" , "[m/s/s]" },
  { 249 , "vdfmr" , "Vertical diffusion moistening rate" , "[kg/kg/s]" },
  { 250 , "swhr" , "Solar radiative heating rate" , "[K/s]" },
  { 251 , "lwhr" , "Longwave radiative heating rate" , "[K/s]" },
  { 252 , "cd" , "Drag coefficient" , "[dimensionless]" },
  { 253 , "fricv" , "Friction velocity" , "[m/s]" },
  { 254 , "ri" , "Richardson number" , "[dimensionless]" },
  { 255 , "undef" , "undef" , "[undef]" }

} ;
