// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/buffer.h>
#include <gstreamermm/private/buffer_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2015 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gst
{
Glib::RefPtr<Gst::Buffer> Buffer::create(guint size)
{
  return Glib::wrap(gst_buffer_new_allocate(nullptr, size, nullptr));
}

Glib::RefPtr<Buffer> Buffer::create_writable()
{
  return Glib::RefPtr<Buffer>::cast_static(MiniObject::create_writable());
}

guint64 Buffer::offset_none()
{
  return GST_BUFFER_OFFSET_NONE;
}

Glib::RefPtr<Gst::Buffer> Buffer::append_region(Glib::RefPtr<Gst::Buffer>&& buf, gssize offset, gssize size)
{
  if (is_writable())
  {
    return Glib::wrap(gst_buffer_append_region(gobj(), buf.release()->gobj(), offset, size), true);
  }
  else
  {
    reference();
    return Glib::wrap(gst_buffer_append_region(gobj(), buf.release()->gobj(), offset, size), false);
  }
}

Glib::RefPtr<Gst::Buffer> Buffer::append(Glib::RefPtr<Gst::Buffer>&& buf)
{
  return append_region(std::move(buf), 0, -1);
}

} // namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::BufferFlags>::value_type()
{
  return gst_buffer_flags_get_type();
}

// static
GType Glib::Value<Gst::BufferCopyFlags>::value_type()
{
  return gst_buffer_copy_flags_get_type();
}


/* Why reinterpret_cast<Buffer*>(gobject) is needed:
 *
 * A Buffer instance is in fact always a GstBuffer instance.
 * Unfortunately, GstBuffer cannot be a member of Buffer,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Buffer does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy)
{
  if(take_copy && object)
    gst_buffer_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::Buffer>(reinterpret_cast<Gst::Buffer*>(object));
}

} // namespace Glib


namespace Gst
{


// static
Glib::RefPtr<Buffer> Buffer::create()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Buffer>(reinterpret_cast<Buffer*>(gst_buffer_new()));
}

void Buffer::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_ref(reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this)));
}

void Buffer::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_buffer_unref(reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this)));
}

GstBuffer* Buffer::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstBuffer*>(this);
}

const GstBuffer* Buffer::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstBuffer*>(this);
}

GstBuffer* Buffer::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GstBuffer*>(const_cast<Buffer*>(this));
  gst_buffer_ref(gobject);
  return gobject;
}


Glib::RefPtr<Gst::Buffer> Buffer::copy() const
{
  return Glib::wrap(gst_buffer_copy(const_cast<GstBuffer*>(gobj())));
}

Glib::RefPtr<Gst::Buffer> Buffer::copy_deep() const
{
  return Glib::wrap(gst_buffer_copy_deep(const_cast<GstBuffer*>(gobj())));
}

void Buffer::copy_into(const Glib::RefPtr<Gst::Buffer>& destination_buffer, const Glib::RefPtr<Gst::Buffer>& source_buffer, BufferCopyFlags flags, gsize offset, gsize size)
{
  gst_buffer_copy_into(Glib::unwrap(destination_buffer), Glib::unwrap(source_buffer), ((GstBufferCopyFlags)(flags)), offset, size);
}

Glib::RefPtr<Gst::Buffer> Buffer::copy_region(Gst::BufferCopyFlags flags, gsize offset, gsize size)
{
  return Glib::wrap(gst_buffer_copy_region(gobj(), ((GstBufferCopyFlags)(flags)), offset, size));
}

Glib::RefPtr<Gst::Memory> Buffer::get_memory(guint idx) const
{
  return Glib::wrap(gst_buffer_get_memory(const_cast<GstBuffer*>(gobj()), idx));
}

gsize Buffer::get_size() const
{
  return gst_buffer_get_size(const_cast<GstBuffer*>(gobj()));
}

gsize Buffer::get_sizes(gsize& offset, gsize& max_size) const
{
  return gst_buffer_get_sizes(const_cast<GstBuffer*>(gobj()), &(offset), &(max_size));
}

gsize Buffer::get_sizes_range(guint idx, gint length, gsize& offset, gsize& max_size) const
{
  return gst_buffer_get_sizes_range(const_cast<GstBuffer*>(gobj()), idx, length, &(offset), &(max_size));
}

bool Buffer::resize_range(guint idx, gint length, gssize offset, gssize size)
{
  return gst_buffer_resize_range(gobj(), idx, length, offset, size);
}

void Buffer::resize(gssize offset, gssize size)
{
  gst_buffer_resize(gobj(), offset, size);
}

void Buffer::set_size(gssize size)
{
  gst_buffer_set_size(gobj(), size);
}

Glib::RefPtr<Gst::Memory> Buffer::peek_memory(guint idx)
{
  Glib::RefPtr<Gst::Memory> retvalue = Glib::wrap(gst_buffer_peek_memory(gobj(), idx));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

guint Buffer::n_memory() const
{
  return gst_buffer_n_memory(const_cast<GstBuffer*>(gobj()));
}

void Buffer::insert_memory(gint idx, Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_insert_memory(gobj(), idx, (mem) ? mem.release()->gobj() : nullptr);
}

Glib::RefPtr<Gst::Memory> Buffer::get_all_memory() const
{
  return Glib::wrap(gst_buffer_get_all_memory(const_cast<GstBuffer*>(gobj())));
}

gsize Buffer::fill(gsize offset, gconstpointer src, gsize size)
{
  return gst_buffer_fill(gobj(), offset, src, size);
}

void Buffer::replace_memory_range(guint idx, gint length, Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_replace_memory_range(gobj(), idx, length, (mem) ? mem.release()->gobj() : nullptr);
}

Glib::RefPtr<Gst::Memory> Buffer::get_memory_range(guint idx, gint length)
{
  return Glib::wrap(gst_buffer_get_memory_range(gobj(), idx, length));
}

void Buffer::remove_memory_range(guint idx, gint length)
{
  gst_buffer_remove_memory_range(gobj(), idx, length);
}

bool Buffer::find_memory(gsize offset, gsize size, guint& idx, guint& length, gsize& skip)
{
  return gst_buffer_find_memory(gobj(), offset, size, &(idx), &(length), &(skip));
}

void Buffer::prepend_memory(Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_prepend_memory(gobj(), (mem) ? mem.release()->gobj() : nullptr);
}

void Buffer::append_memory(Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_append_memory(gobj(), (mem) ? mem.release()->gobj() : nullptr);
}

void Buffer::remove_memory(guint idx)
{
  gst_buffer_remove_memory(gobj(), idx);
}

void Buffer::remove_all_memory()
{
  gst_buffer_remove_all_memory(gobj());
}

gsize Buffer::memset(gsize offset, guint8 val, gsize size)
{
  return gst_buffer_memset(gobj(), offset, val, size);
}

void Buffer::replace_memory(guint idx, Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_replace_memory(gobj(), idx, (mem) ? mem.release()->gobj() : nullptr);
}

void Buffer::replace_all_memory(Glib::RefPtr<Gst::Memory>&& mem)
{
  gst_buffer_replace_all_memory(gobj(), (mem) ? mem.release()->gobj() : nullptr);
}

gsize Buffer::extract(gsize offset, gpointer dest, gsize size)
{
  return gst_buffer_extract(gobj(), offset, dest, size);
}

void Buffer::extract_dup(gsize offset, gsize size, gpointer& dest, gsize& dest_size)
{
  gst_buffer_extract_dup(gobj(), offset, size, &(dest), &(dest_size));
}

int Buffer::memcmp(gsize offset, gconstpointer mem, gsize size)
{
  return gst_buffer_memcmp(gobj(), offset, mem, size);
}

bool Buffer::is_all_memory_writable() const
{
  return gst_buffer_is_all_memory_writable(const_cast<GstBuffer*>(gobj()));
}

bool Buffer::is_memory_range_writable(guint idx, gint length) const
{
  return gst_buffer_is_memory_range_writable(const_cast<GstBuffer*>(gobj()), idx, length);
}

bool Buffer::map(Gst::MapInfo& info, Gst::MapFlags flags)
{
  return gst_buffer_map(gobj(), (info.gobj()), ((GstMapFlags)(flags)));
}

bool Buffer::map_range(guint idx, gint length, Gst::MapInfo& info, MapFlags flags)
{
  return gst_buffer_map_range(gobj(), idx, length, (info.gobj()), ((GstMapFlags)(flags)));
}

void Buffer::unmap(Gst::MapInfo& info)
{
  gst_buffer_unmap(gobj(), (info.gobj()));
}

ClockTime Buffer::get_pts() const
{
  return ((ClockTime)(gobj()->pts));
}

void Buffer::set_pts(const ClockTime& value)
{
  gobj()->pts = ((GstClockTime)(value));
}

ClockTime Buffer::get_dts() const
{
  return ((ClockTime)(gobj()->dts));
}

void Buffer::set_dts(const ClockTime& value)
{
  gobj()->dts = ((GstClockTime)(value));
}

ClockTime Buffer::get_duration() const
{
  return ((ClockTime)(gobj()->duration));
}

void Buffer::set_duration(const ClockTime& value)
{
  gobj()->duration = ((GstClockTime)(value));
}

guint64 Buffer::get_offset() const
{
  return gobj()->offset;
}

guint64 Buffer::get_offset_end() const
{
  return gobj()->offset_end;
}


} // namespace Gst


