use core:lang;

/**
 * Thrown when an invalid table name is encountered.
 */
class NoSuchTable extends SyntaxError {
	init(SrcPos pos, Str name) {
		init(pos, "No table named ${name} is known.") {}
	}
}

/**
 * Thrown when we don't find a column.
 */
class NoSuchColumn extends SyntaxError {
	init(SrcPos pos, Str col, Str table) {
		init(pos, "No column named ${col} in ${table}.") {}
	}
}

/**
 * Thrown on dupliate alias declaration.
 */
class DuplicateAlias extends SyntaxError {
	init(SrcPos pos, Str alias) {
		init(pos, "The alias ${alias} is already defined in this query.") {}
	}
}


/**
 * Error in the database schema.
 */
class SchemaError extends SQLError {
	init(Str message, Table expected, Schema actual) {
		init(message) {
			expected = expected;
			actual = actual;
		}
	}

	private Table expected;
	private Schema actual;

	void message(StrBuf out) : override {
		super:message(out);

		out << "\nExpected these columns in table " << actual.name << "\n";
		out.indent();
		for (c in expected.columns)
			out << c << "\n";
		out.dedent();
		out << "But got the following columns:\n";
		out.indent();
		for (Nat i = 0; i < actual.count; i++) {
			out << actual[i];
			out << "\n";
		}
		out.dedent();
	}
}
