// SPDX-License-Identifier: Apache-2.0
// SPDX-FileCopyrightText: 2019-2024 Second State INC

//===-- wasmedge/wasmedge.h - WasmEdge C API ------------------------------===//
//
// Part of the WasmEdge Project.
//
//===----------------------------------------------------------------------===//
///
/// \file
/// This file contains the function declarations of WasmEdge C API.
///
//===----------------------------------------------------------------------===//

#ifndef WASMEDGE_C_API_H
#define WASMEDGE_C_API_H

#include "wasmedge/wasmedge_basic.h"

#include "wasmedge/wasmedge_ast.h"
#include "wasmedge/wasmedge_compiler.h"
#include "wasmedge/wasmedge_configure.h"
#include "wasmedge/wasmedge_execution.h"
#include "wasmedge/wasmedge_instance.h"
#include "wasmedge/wasmedge_plugin.h"
#include "wasmedge/wasmedge_tools.h"
#include "wasmedge/wasmedge_value.h"
#include "wasmedge/wasmedge_vm.h"

#include "wasmedge/wasmedge_deprecated.h"
#include "wasmedge/wasmedge_experimental.h"

#endif /// WASMEDGE_C_API_H
