/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextOutlineLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStringValueAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextTocMarkElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "toc-mark");

    public TextTocMarkElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Integer getTextOutlineLevelAttribute() {
        TextOutlineLevelAttribute attr = (TextOutlineLevelAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "outline-level");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setTextOutlineLevelAttribute(Integer textOutlineLevelValue) {
        TextOutlineLevelAttribute attr = new TextOutlineLevelAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(textOutlineLevelValue);
    }

    public String getTextStringValueAttribute() {
        TextStringValueAttribute attr = (TextStringValueAttribute)this.getOdfAttribute(OdfDocumentNamespace.TEXT, "string-value");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setTextStringValueAttribute(String textStringValueValue) {
        TextStringValueAttribute attr = new TextStringValueAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(textStringValueValue);
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

