# Yamagi Quake II

Yamagi Quake II is an enhanced client for id Software's Quake II with
focus on offline and coop gameplay. Both the gameplay and the graphics
are unchanged, but many bugs in the last official release were fixed and
some nice to have features like widescreen support, reliable support for
high framerates, a modern sound backend based upon OpenAL, support for
modern game controllers and a modern OpenGL 3.2 renderer were added.
Unlike most other Quake II source ports Yamagi Quake II is fully 64-bit
clean. It works perfectly on modern processors and operating systems.

This code is built upon Icculus Quake II, which itself is based on Quake
II 3.21. Yamagi Quake II is released under the terms of the GPL version
2. See LICENSE for further information:

* [LICENSE](https://github.com/yquake2/yquake2/blob/master/LICENSE)

Officially supported operating systems are:

* FreeBSD
* Linux
* Windows

Beside theses Yamagi Quake II has community support for MacOS and most
other unixoid operating systems, including NetBSD, OpenBSD and Solaris.


## Addons and partner projects

This repository contains Yamagi Quake II itself. The official addons
have their own repositories:

* [The Reckoning](https://github.com/yquake2/xatrix)
* [Ground Zero](https://github.com/yquake2/rogue)
* [Three Waves Capture The Flag](https://github.com/yquake2/ctf)

Yamagi Quake II Remaster is a project providing optional support for the
assets of Quake II Remaster by Nightdive Studios and has a less
conservative approach in regards to new features. It also lives in it's
own repository:

* [Yamagi Quake II Remaster](https://github.com/yquake2/yquake2remaster)


## Development

Yamagi Quake II is a community driven project and lives from community
involvement. Please report bugs in our issue tracker:

* [Issue Tracker](https://github.com/yquake2/yquake2/issues)

We are always open to code contributions, no matter if they are small
bugfixes or bigger features. However, Yamagi Quake II is a conservative
project with big focus on stability and backward compatibility. We don't
accept breaking changes. When in doubt please open an issue and ask if a
contribution in welcome before putting too much work into it. Open a
pull request to submit code:

* [Pull Requests](https://github.com/yquake2/yquake2/pulls)

Also have a look at our contributors guide:

* [Contributors Guide](https://github.com/yquake2/yquake2/blob/master/doc/080_contributing.md)


## Documentation

Yamagi Quake II has rather extensive documentation covering all relevant
areas from installation and configuration to package building. Have a
look at the documentation index:

* [Documentation Index](https://github.com/yquake2/yquake2/blob/master/doc/010_index.md)


## Releases

Yamagi Quake II releases at an irregular schedule. The official releases
with source code tarballs and prebuild Windows binaries can be found at
the homepage:

* [Homepage](https://www.yamagi.org/quake2/)

Our CI builds **unsupported** Linux, MacOS and Windows binaries at every
commit. The artifacts can be found here:

* [Github Actions](https://github.com/yquake2/yquake2/actions)
