// @HEADER
// *****************************************************************************
//        MueLu: A package for multigrid based preconditioning
//
// Copyright 2012 NTESS and the MueLu contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef MUELU_REBALANCEMAPFACTORY_DECL_HPP_
#define MUELU_REBALANCEMAPFACTORY_DECL_HPP_

#include <Xpetra_MapFactory_fwd.hpp>
#include <Xpetra_VectorFactory_fwd.hpp>
#include <Xpetra_Import_fwd.hpp>
#include <Xpetra_ImportFactory_fwd.hpp>

#include "MueLu_SingleLevelFactoryBase.hpp"
#include "MueLu_RebalanceMapFactory_fwd.hpp"

#include "MueLu_Level_fwd.hpp"
#include "MueLu_FactoryBase_fwd.hpp"

namespace MueLu {

/*!
  @class RebalanceMapFactory
  @brief Factory which rebalances a map on current level using the Importer object generated by the RepartitionFactory
*/

template <class LocalOrdinal  = DefaultLocalOrdinal,
          class GlobalOrdinal = DefaultGlobalOrdinal,
          class Node          = DefaultNode>
class RebalanceMapFactory : public SingleLevelFactoryBase {
  typedef DefaultScalar Scalar;  // FIXME this is just a dummy scalar for being able to access Xpetra::Matrix

#undef MUELU_REBALANCEMAPFACTORY_SHORT
#include "MueLu_UseShortNames.hpp"

 public:
  //! @name Constructors/Destructors
  //@{

  //! Constructor
  RebalanceMapFactory() {}

  //! Destructor
  virtual ~RebalanceMapFactory() {}
  //@}

  RCP<const ParameterList> GetValidParameterList() const;

  //! @name Input
  //@{
  void DeclareInput(Level &level) const;
  //@}

  //! @name Build methods.
  //@{
  void Build(Level &level) const;

  //@}
};

}  // namespace MueLu

#define MUELU_REBALANCEMAPFACTORY_SHORT

#endif /* MUELU_REBALANCEMAPFACTORY_DECL_HPP_ */
