#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
from os.path import getmtime, exists
import time
import types
import __builtin__
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import DummyTransaction
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from prewikka.templates.ClassicLayout import ClassicLayout

##################################################
## MODULE CONSTANTS
try:
    True, False
except NameError:
    True, False = (1==1), (1==0)
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.0.1'
__CHEETAH_versionTuple__ = (2, 0, 1, 'final', 0)
__CHEETAH_genTime__ = 1271307849.0008619
__CHEETAH_genTimestamp__ = 'Wed Apr 14 23:04:09 2010'
__CHEETAH_src__ = 'prewikka/templates/HeartbeatAnalyze.tmpl'
__CHEETAH_srcLastModified__ = 'Tue May  5 08:55:59 2009'
__CHEETAH_docstring__ = 'Autogenerated by CHEETAH: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class HeartbeatAnalyze(ClassicLayout):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        ClassicLayout.__init__(self, *args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def main_content(self, **KWS):



        ## CHEETAH: generated from #block main_content at line 3, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''<table class="heartbeat_analyze">
  <thead>
    <tr class="heartbeat_analyze_header">
      <td>Name</td>
      <td>Model</td>
      <td>OS</td>
      <td>Node Name</td>
      <td>Node Location</td>
      <td>Node Address</td>
      <td>Latest heartbeat</td>
      <td>Current status</td>
    </tr>
  </thead>
  <tbody>

''')
        row_classes = ("table_row_even", "table_row_odd")
        cnt = 0
        write('''  
  <tr class="''')
        _v = VFFSL(SL,"row_classes",True)[VFFSL(SL,"cnt",True)%2] # '$row_classes[$cnt%2]' on line 22, col 14
        if _v is not None: write(_filter(_v, rawExpr='$row_classes[$cnt%2]')) # from line 22, col 14.
        write('''">
    <td>''')
        _v = VFFSL(SL,"analyzer.name",True) # '$analyzer.name' on line 23, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.name')) # from line 23, col 9.
        write('''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.model",True) # '$analyzer.model' on line 24, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.model')) # from line 24, col 9.
        write(''' ''')
        _v = VFFSL(SL,"analyzer.version",True) # '$analyzer.version' on line 24, col 25
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.version')) # from line 24, col 25.
        write('''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.ostype",True) # '$analyzer.ostype' on line 25, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.ostype')) # from line 25, col 9.
        write(''' ''')
        _v = VFFSL(SL,"analyzer.osversion",True) # '$analyzer.osversion' on line 25, col 26
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.osversion')) # from line 25, col 26.
        write('''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.node_name",True) # '$analyzer.node_name' on line 26, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.node_name')) # from line 26, col 9.
        write('''</td>
    <td>''')
        _v = VFFSL(SL,"analyzer.node_location",True) # '$analyzer.node_location' on line 27, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.node_location')) # from line 27, col 9.
        write('''</td>
    <td>
''')
        if len(VFFSL(SL,"analyzer.node_addresses",True)) > 0: # generated from line 29, col 7
            for address in VFFSL(SL,"analyzer.node_addresses",True): # generated from line 30, col 9
                write('''          ''')
                _v = VFFSL(SL,"address",True) # '$address' on line 31, col 11
                if _v is not None: write(_filter(_v, rawExpr='$address')) # from line 31, col 11.
                write('''<br/>
''')
        else: # generated from line 33, col 7
            write('''        n/a
''')
        write('''    </td>
    <td>''')
        _v = VFFSL(SL,"analyzer.last_heartbeat_time",True) # '$analyzer.last_heartbeat_time' on line 37, col 9
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.last_heartbeat_time')) # from line 37, col 9.
        write('''</td>
    <td class="heartbeat_analyze_sensor_status_''')
        _v = VFFSL(SL,"analyzer.status",True) # '$analyzer.status' on line 38, col 48
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.status')) # from line 38, col 48.
        write('''">
      <b>''')
        _v = VFFSL(SL,"analyzer.status_meaning",True) # '$analyzer.status_meaning' on line 39, col 10
        if _v is not None: write(_filter(_v, rawExpr='$analyzer.status_meaning')) # from line 39, col 10.
        write('''</b>
    </td>
  </tr>
''')
        cnt += 1
        write(''' </tbody>
</table>
  
<table class="heartbeat_analyze">
  <thead>
    <tr class="heartbeat_analyze_header"><td class="">Events</td></tr>
  </thead>

  <tbody>
''')
        row_classes = ("table_row_even", "table_row_odd")
        cnt = 0
        for event in VFFSL(SL,"analyzer.events",True): # generated from line 54, col 5
            write('''      <tr class="''')
            _v = VFFSL(SL,"row_classes",True)[VFFSL(SL,"cnt",True)%2] # '$row_classes[$cnt%2]' on line 55, col 18
            if _v is not None: write(_filter(_v, rawExpr='$row_classes[$cnt%2]')) # from line 55, col 18.
            write('''"><td colspan="8" class="heartbeat_analyzer_event_''')
            _v = VFFSL(SL,"event.type",True) # '$event.type' on line 55, col 88
            if _v is not None: write(_filter(_v, rawExpr='$event.type')) # from line 55, col 88.
            write('''">''')
            _v = VFFSL(SL,"event.value",True) # '$event.value' on line 55, col 101
            if _v is not None: write(_filter(_v, rawExpr='$event.value')) # from line 55, col 101.
            write('''</td></tr>
''')
            cnt += 1
        write('''  </tbody>
</table>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        self.main_content(trans=trans)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_HeartbeatAnalyze= 'writeBody'

## END CLASS DEFINITION

if not hasattr(HeartbeatAnalyze, '_initCheetahAttributes'):
    templateAPIClass = getattr(HeartbeatAnalyze, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(HeartbeatAnalyze)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=HeartbeatAnalyze()).run()


