<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php
	/**
	 * Task Module
	 */
	class TaskListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function TaskListModule($id, $data)
		{
			$this->properties = $GLOBALS["properties"]->getTaskProperties();
			
			$this->tablecolumns = array();
			$this->addColumn($this->tablecolumns, "icon_index", true, 0, _("Icon"), _("Sort On Icon"), 25);
			$this->addColumn($this->tablecolumns, "complete", true, 1, _("Complete"), _("Sort On Complete"), 25);
			$this->addColumn($this->tablecolumns, "importance", true, 2, _("Priority"), _("Sort On Priority"));
			$this->addColumn($this->tablecolumns, "subject", true, 3, _("Subject"), _("Sort On Subject"), PERCENTAGE);
			$this->addColumn($this->tablecolumns, "duedate", true, 4, _("Due Date"), _("Sort On Due Date"));
			
			$this->addColumn($this->tablecolumns, "owner", true, 5, _("Owner"), _("Sort On Owner"));
			$this->addColumn($this->tablecolumns, "categories", false, 6, _("Categories"), _("Sort On Categories"));
			$this->addColumn($this->tablecolumns, "percent_complete", false, 7, _("% Completed"), _("Sort On Percent Completed"), 100);
			$this->addColumn($this->tablecolumns, "hidden_column", true, 8);
			$this->addColumn($this->tablecolumns, "startdate", true, 9, _("Start Date"), _("Sort On Start Date"));
			
			
			/*
			*NOTE:
			*1)If value of visibility of any column in above table(i.e tablecolumns) is modifyed,
			*then the same is to be done in the table defined below(i.e insertcolumns) for the respective columns.
			*2)$name parameter of addInputColumn() should contain the value of id of corresponding header column.
			*/
			
			$userdata = $_SESSION["username"];
			$storeid = $data[0]["store"];
			$entryid = $data[0]["entryid"];
			
			$session = $GLOBALS["mapisession"]->getSession();			
			$store = mapi_openmsgstore($session, hex2bin($storeid));	
			$result = mapi_last_hresult();		
			$storeProps = mapi_getprops($store , array(PR_DISPLAY_NAME, PR_MDB_PROVIDER));			
			switch($storeProps[PR_MDB_PROVIDER]){
				  case ZARAFA_SERVICE_GUID:
					$readonly= "readonly";
				    break;
				  
				  case ZARAFA_STORE_PUBLIC_GUID:
				    $readonly = "";
				    break;
			}
			
			$username = mapi_zarafa_getuser_by_name($store,$userdata);			
			
			$this->insertcolumns = array();
			$this->addInputColumn($this->insertcolumns, "icon", "null", true, "", 0, "icon_index",false,  23);
			$this->addInputColumn($this->insertcolumns, "status", "checkbox", true, "", 1, "complete",false,  23);
			$this->addInputColumn($this->insertcolumns, "importance", "importance", true, "", 2, "importance",false);
			$this->addInputColumn($this->insertcolumns, "subject", "textbox", true, "", 3, "subject",_("Click here to add a new item"),PERCENTAGE);
			$this->addInputColumn($this->insertcolumns, "text_duedate", "datepicker", true, "readonly", 4,"duedate",false,150);

			$this->addInputColumn($this->insertcolumns, "owner", "textbox", true, $readonly, 5, "owner", w2u($username["fullname"]), 150);
			$this->addInputColumn($this->insertcolumns, "categories", "categories", false, "", 6, "categories",false, 150);
			$this->addInputColumn($this->insertcolumns, "text_percent_complete", "percent", false, "readonly", 7,"percent_complete",_("0%"), 100);
			$this->addInputColumn($this->insertcolumns, "hiddencolumn", "hidden", false, "", 8,"hidden_column");
			$this->addInputColumn($this->insertcolumns, "text_startdate", "datepicker", true, "readonly", 9, "startdate", false, 150);

			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));

			$this->sort = array();
			$this->sort[$this->properties["duedate"]] = TABLE_SORT_DESCEND;
			
			$this->start = 0;
		}
		/**
		 * Function which saves an item.
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid entryid of the folder
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure		 		 
		 */
		function save($store, $parententryid, $action)
		{
			$result = false;
			if($store && $parententryid && isset($action["props"])) {
				// Fetch message store properties of a current store.
				$msgstoreProps = mapi_getprops($store, array(PR_USER_ENTRYID, PR_MDB_PROVIDER, PR_MAILBOX_OWNER_ENTRYID));

				// Get current session and open addressbook
				$addrbook = $GLOBALS["mapisession"]->getAddressbook();
				//$addrbook = mapi_openaddressbook($session);

				// Open addressbook entry for current user.
				$userObject = mapi_ab_openentry($addrbook, $msgstoreProps[PR_USER_ENTRYID]);

				$props = $action["props"];

				if(mapi_last_hresult() == NOERROR){
					$userProps = mapi_getprops($userObject);
					if(mapi_last_hresult() == NOERROR){
						// Store PR_SENDER_* properties for task in props variable.
						$props["sender_email_address"] = $userProps[PR_EMAIL_ADDRESS];
						$props["sender_name"] = $userProps[PR_DISPLAY_NAME];
						$props["sender_addrtype"] = $userProps[PR_ADDRTYPE];
						$props["sender_entryid"] = bin2hex($userProps[PR_ENTRYID]);
						$props["sender_search_key"] = $userProps[PR_SEARCH_KEY];
					}
				}

				// Store PR_SENT_REPRESENTING_* properties for task according to store type.
				switch ($msgstoreProps[PR_MDB_PROVIDER])
				{
					case ZARAFA_STORE_PUBLIC_GUID:
						/**
						 * store type is "public"
						 * Store PR_SENT_REPRESENTING_* properties for task in props variable.
						 */
						$props["sent_representing_entryid"] = bin2hex($userProps[PR_ENTRYID]);
						$props["sent_representing_name"] = $userProps[PR_DISPLAY_NAME];
						$props["sent_representing_addrtype"] = $userProps[PR_ADDRTYPE];
						$props["sent_representing_email_address"] = $userProps[PR_EMAIL_ADDRESS];
						$props["sent_representing_search_key"] = $userProps[PR_SEARCH_KEY];
						break;
					case ZARAFA_SERVICE_GUID:
						// store type is "default"
					case ZARAFA_STORE_DELEGATE_GUID:
						/**
						 * store type is "delegate"
						 * Open addressbook entry for mailbox owner.
						 */
						$ownerObject = mapi_ab_openentry($addrbook, $msgstoreProps[PR_MAILBOX_OWNER_ENTRYID]);
						if(mapi_last_hresult() == NOERROR){
							$ownerProps = mapi_getprops($ownerObject);
							if(mapi_last_hresult() == NOERROR){
								// Store PR_SENT_REPRESENTING_* properties for task in props variable.
								$props["sent_representing_entryid"] = bin2hex($ownerProps[PR_ENTRYID]);
								$props["sent_representing_name"] = $ownerProps[PR_DISPLAY_NAME];
								$props["sent_representing_addrtype"] = $ownerProps[PR_ADDRTYPE];
								$props["sent_representing_email_address"] = $ownerProps[PR_EMAIL_ADDRESS];
								$props["sent_representing_search_key"] = $ownerProps[PR_SEARCH_KEY];
							}
						}
						break;
				}

				$messageProps = array();
				$result = $GLOBALS["operations"]->saveMessage($store, $parententryid, Conversion::mapXML2MAPI($this->properties, $props), null, "", $messageProps);
	
				if($result) {
					$GLOBALS["bus"]->notify($this->entryid, TABLE_SAVE, $messageProps);
				}
			}
			
			return $result;
		}
	}
?>
