/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PostgresDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.22 $";
    private static final Logger logger = Logger.getLogger(PostgresDDLGenerator.class);
    private static HashSet reservedWords = new HashSet();

    public boolean isReservedWord(String word) {
        return reservedWords.contains(word.toUpperCase());
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower PostgreSQL DDL Generator $Revision: 1.22 $ --");
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("NUMERIC", -5, 1000L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BYTEA", -2, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("BYTEA", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("TEXT", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("NUMERIC", 3, 1000L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE PRECISION", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("REAL", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("BYTEA", -4, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("TEXT", -1, 4000000000L, "'", "'", 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 1000L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 16L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("SMALLINT", -6, 16L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("BYTEA", -3, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 4000000000L, "'", "'", 1, true, false));
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap();
        this.profileFunctionMap.put("varchar", new ProfileFunctionDescriptor("varchar", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("char", new ProfileFunctionDescriptor("char", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("name", new ProfileFunctionDescriptor("name", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("bpchar", new ProfileFunctionDescriptor("bpchar", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("date", new ProfileFunctionDescriptor("date", 91, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("time", new ProfileFunctionDescriptor("time", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timestamp", new ProfileFunctionDescriptor("timestamp", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timestamptz", new ProfileFunctionDescriptor("timestamptz", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timetz", new ProfileFunctionDescriptor("timetz", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float8", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int2", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int4", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int8", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("numeric", new ProfileFunctionDescriptor("numeric", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("interval", new ProfileFunctionDescriptor("interval", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("bool", new ProfileFunctionDescriptor("bool", 16, true, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("bit", new ProfileFunctionDescriptor("bit", -7, true, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("bytea", new ProfileFunctionDescriptor("bytea", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("text", new ProfileFunctionDescriptor("text", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("oid", new ProfileFunctionDescriptor("oid", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("xid", new ProfileFunctionDescriptor("xid", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("cid", new ProfileFunctionDescriptor("cid", 2004, false, false, false, false, false, false, false, true));
        HashMap<String, ProfileFunctionDescriptor> profileFunctionMap2 = new HashMap<String, ProfileFunctionDescriptor>();
        for (Map.Entry entry : this.profileFunctionMap.entrySet()) {
            String key = (String)entry.getKey();
            ProfileFunctionDescriptor pfd = (ProfileFunctionDescriptor)entry.getValue();
            profileFunctionMap2.put("_" + key, pfd);
        }
        this.profileFunctionMap.putAll(profileFunctionMap2);
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting physical name for: " + logicalName));
        }
        String ident = logicalName.replace(' ', '_').toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after replace of spaces: " + ident));
        }
        ident = ident.replaceAll("[^a-zA-Z0-9_$]", "_");
        if (physicalName == null) {
            if (ident.length() <= 63) {
                return ident;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("truncating identifier: " + ident));
            }
            String base = ident.substring(0, 60);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new identifier: " + base + tiebreaker));
            }
            return base + tiebreaker;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("physical identifier is not unique, regenerating: " + physicalName));
        }
        String base = ident;
        if (ident.length() > 63) {
            base = ident.substring(0, 60);
        }
        int tiebreaker = ((ident + physicalName).hashCode() % 1000 + 1000) % 1000;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        }
        return base + tiebreaker;
    }

    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\n ALTER TABLE ONLY " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    public void modifyColumn(SQLColumn c) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        SQLTable t = c.getParentTable();
        this.print("\n ALTER TABLE ONLY ");
        this.print(this.toQualifiedName(t));
        this.print(" ALTER COLUMN ");
        String columnPhysName = this.createPhysicalName(colNameMap, c);
        this.print(columnPhysName);
        this.print(" TYPE ");
        this.print(this.columnType(c));
        this.print(", ALTER COLUMN ");
        this.print(columnPhysName);
        this.print(" ");
        this.print(c.isDefinitelyNullable() ? "DROP" : "SET");
        this.print(" NOT NULL");
        this.endStatement(DDLStatement.StatementType.MODIFY, c);
    }

    public String getCatalogTerm() {
        return null;
    }

    public String getSchemaTerm() {
        return "Schema";
    }

    public String getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return "public";
    }

    public void addIndex(SQLIndex index) throws ArchitectException {
        if (index.getType() == SQLIndex.IndexType.STATISTIC) {
            return;
        }
        this.checkDupIndexname(index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(index.getName());
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParentTable()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren()) {
            if (!first) {
                this.print(", ");
            }
            this.print(c.getName());
            first = false;
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, index);
    }

    static {
        reservedWords.add("AND");
        reservedWords.add("ANY");
        reservedWords.add("ARRAY");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("ASYMMETRIC");
        reservedWords.add("BOTH");
        reservedWords.add("CASE");
        reservedWords.add("CAST");
        reservedWords.add("CHECK");
        reservedWords.add("COLLATE");
        reservedWords.add("COLUMN");
        reservedWords.add("CONSTRAINT");
        reservedWords.add("CREATE");
        reservedWords.add("CURRENT_DATE");
        reservedWords.add("CURRENT_ROLE");
        reservedWords.add("CURRENT_TIME");
        reservedWords.add("CURRENT_TIMESTAMP");
        reservedWords.add("CURRENT_USER");
        reservedWords.add("DEFAULT");
        reservedWords.add("DEFERRABLE");
        reservedWords.add("DESC");
        reservedWords.add("DISTINCT");
        reservedWords.add("DO");
        reservedWords.add("ELSE");
        reservedWords.add("END");
        reservedWords.add("EXCEPT");
        reservedWords.add("FOR");
        reservedWords.add("FOREIGN");
        reservedWords.add("FROM");
        reservedWords.add("GRANT");
        reservedWords.add("GROUP");
        reservedWords.add("HAVING");
        reservedWords.add("IN");
        reservedWords.add("INITIALLY");
        reservedWords.add("INTERSECT");
        reservedWords.add("INTO");
        reservedWords.add("LEADING");
        reservedWords.add("LIMIT");
        reservedWords.add("LOCALTIME");
        reservedWords.add("LOCALTIMESTAMP");
        reservedWords.add("NEW");
        reservedWords.add("NOT");
        reservedWords.add("NULL");
        reservedWords.add("OFF");
        reservedWords.add("OFFSET");
        reservedWords.add("OLD");
        reservedWords.add("ON");
        reservedWords.add("ONLY");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("PLACING");
        reservedWords.add("PRIMARY");
        reservedWords.add("REFERENCES");
        reservedWords.add("RETURNING");
        reservedWords.add("SELECT");
        reservedWords.add("SESSION_USER");
        reservedWords.add("SOME");
        reservedWords.add("SYMMETRIC");
        reservedWords.add("TABLE");
        reservedWords.add("THEN");
        reservedWords.add("TO");
        reservedWords.add("TRAILING");
        reservedWords.add("UNION");
        reservedWords.add("UNIQUE");
        reservedWords.add("USER");
        reservedWords.add("USING");
        reservedWords.add("WHEN");
        reservedWords.add("WHERE");
        reservedWords.add("AUTHORIZATION");
        reservedWords.add("BETWEEN");
        reservedWords.add("BINARY");
        reservedWords.add("CROSS");
        reservedWords.add("FREEZE");
        reservedWords.add("FULL");
        reservedWords.add("ILIKE");
        reservedWords.add("INNER");
        reservedWords.add("IS");
        reservedWords.add("ISNULL");
        reservedWords.add("JOIN");
        reservedWords.add("LEFT");
        reservedWords.add("LIKE");
        reservedWords.add("NATURAL");
        reservedWords.add("NOTNULL");
        reservedWords.add("OUTER");
        reservedWords.add("OVERLAPS");
        reservedWords.add("RIGHT");
        reservedWords.add("SIMILAR");
        reservedWords.add("VERBOSE");
    }
}

