/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSourceType;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectDataSourceTypeListCellRenderer;
import ca.sqlpower.architect.swingui.ArchitectDataSourceTypePanel;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.JDBCDriverPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ArchitectDataSourceTypeEditor
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(ArchitectDataSourceTypeEditor.class);
    private final JPanel panel;
    private final DataSourceCollection dataSourceCollection;
    private final JList dsTypeList;
    private final ArchitectDataSourceTypePanel dsTypePanel;
    private final JDBCDriverPanel jdbcPanel;

    public ArchitectDataSourceTypeEditor(DataSourceCollection dataSourceCollection) {
        this.dataSourceCollection = dataSourceCollection;
        this.dsTypeList = new JList<Object>(dataSourceCollection.getDataSourceTypes().toArray());
        this.dsTypeList.setCellRenderer(new ArchitectDataSourceTypeListCellRenderer());
        this.dsTypePanel = new ArchitectDataSourceTypePanel();
        this.jdbcPanel = new JDBCDriverPanel();
        this.dsTypeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                try {
                    if (!e.getValueIsAdjusting()) {
                        ArchitectDataSourceType dst = (ArchitectDataSourceType)ArchitectDataSourceTypeEditor.this.dsTypeList.getSelectedValue();
                        ArchitectDataSourceTypeEditor.this.switchToDsType(dst);
                    }
                }
                catch (ArchitectException ex) {
                    ASUtils.showExceptionDialogNoReport("Can't edit this database type due to an unexpected error", ex);
                }
            }
        });
        this.panel = this.createPanel();
    }

    private JPanel createPanel() {
        FormLayout layout = new FormLayout("60dlu, 6dlu, pref:grow", "pref, 6dlu, pref:grow");
        DefaultFormBuilder fb = new DefaultFormBuilder(layout);
        fb.setDefaultDialogBorder();
        fb.add((Component)new JScrollPane(this.dsTypeList), "1, 1, 1, 3");
        fb.add((Component)this.dsTypePanel.getPanel(), "3, 1");
        fb.add((Component)this.jdbcPanel, "3, 3");
        return fb.getPanel();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean applyChanges() {
        logger.debug((Object)"Applying changes to all data source types");
        this.applyCurrentChanges();
        ListModel lm = this.dsTypeList.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            ArchitectDataSourceType dst = (ArchitectDataSourceType)lm.getElementAt(i);
            this.dataSourceCollection.mergeDataSourceType(dst);
        }
        return true;
    }

    public void discardChanges() {
    }

    public void switchToDsType(ArchitectDataSourceType dst) throws ArchitectException {
        this.applyCurrentChanges();
        this.dsTypeList.setSelectedValue(dst, true);
        this.dsTypePanel.editDsType(dst);
        this.jdbcPanel.editDsType(dst);
    }

    private void applyCurrentChanges() {
        this.dsTypePanel.applyChanges();
        this.jdbcPanel.applyChanges();
    }
}

