/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.swingui.ASUtils;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DBTreeCellRenderer
extends DefaultTreeCellRenderer {
    public static final ImageIcon dbIcon = ASUtils.createIcon("Database", "SQL Database", 16);
    public static final ImageIcon dbProfiledIcon = ASUtils.createIcon("Database_profiled", "SQL Database", 16);
    public static final ImageIcon targetIcon = ASUtils.createIcon("Database_target", "SQL Database", 16);
    public static final ImageIcon cataIcon = ASUtils.createIcon("Catalog", "SQL Catalog", 16);
    public static final ImageIcon schemaIcon = ASUtils.createIcon("Schema", "SQL Schema", 16);
    public static final ImageIcon tableIcon = ASUtils.createIcon("Table", "SQL Table", 16);
    public static final ImageIcon tableProfiledIcon = ASUtils.createIcon("Table_profiled", "SQL Table", 16);
    public static final ImageIcon exportedKeyIcon = ASUtils.createIcon("ExportedKey", "Exported key", 16);
    public static final ImageIcon importedKeyIcon = ASUtils.createIcon("ImportedKey", "Imported key", 16);
    public static final ImageIcon ownerIcon = ASUtils.createIcon("Owner", "Owner", 16);
    public static final ImageIcon indexIcon = ASUtils.createIcon("Index", "Index", 16);
    public static final ImageIcon pkIndexIcon = ASUtils.createIcon("Index_key", "Primary Key Index", 16);
    public static final ImageIcon uniqueIndexIcon = ASUtils.createIcon("Index_unique", "Unique Index", 16);
    public static final ImageIcon columnIcon = ASUtils.createIcon("Column", "Column", 16);
    private final ArchitectSession session;

    public DBTreeCellRenderer(ArchitectSession session) {
        this.session = session;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(value.toString());
        if (value instanceof SQLDatabase) {
            SQLDatabase db = (SQLDatabase)value;
            if (db.isPlayPenDatabase()) {
                this.setIcon(targetIcon);
                if (db.getName() == null || db.getName().length() == 0) {
                    this.setText("Project");
                } else {
                    this.setText("Project (" + db.getName() + ")");
                }
            } else {
                this.setIcon(dbIcon);
            }
        } else if (value instanceof SQLCatalog) {
            if (((SQLCatalog)value).getNativeTerm().equals("owner")) {
                this.setIcon(ownerIcon);
            } else if (((SQLCatalog)value).getNativeTerm().equals("database")) {
                this.setIcon(dbIcon);
            } else if (((SQLCatalog)value).getNativeTerm().equals("schema")) {
                this.setIcon(schemaIcon);
            } else {
                this.setIcon(cataIcon);
            }
        } else if (value instanceof SQLSchema) {
            if (((SQLSchema)value).getNativeTerm().equals("owner")) {
                this.setIcon(ownerIcon);
            } else {
                this.setIcon(schemaIcon);
            }
        } else if (value instanceof SQLTable) {
            SQLTable table = (SQLTable)value;
            if (((TableProfileManager)this.session.getProfileManager()).isTableProfiled(table)) {
                this.setIcon(tableProfiledIcon);
            } else {
                this.setIcon(tableIcon);
            }
            if (table.getObjectType() != null) {
                this.setText(table.getName() + " (" + table.getObjectType() + ")");
            } else {
                this.setText(table.getName());
            }
        } else if (value instanceof SQLRelationship) {
            this.setIcon(exportedKeyIcon);
        } else if (value instanceof SQLIndex) {
            SQLIndex i = (SQLIndex)value;
            if (i.isPrimaryKeyIndex()) {
                this.setIcon(pkIndexIcon);
            } else if (i.isUnique()) {
                this.setIcon(uniqueIndexIcon);
            } else {
                this.setIcon(indexIcon);
            }
        } else if (value instanceof SQLColumn || value instanceof SQLIndex.Column) {
            this.setIcon(columnIcon);
        } else {
            this.setIcon(null);
        }
        this.selected = sel;
        this.hasFocus = hasFocus;
        if (value instanceof SQLObject) {
            if (((SQLObject)value).isPopulated()) {
                this.setForeground(Color.black);
            } else {
                this.setForeground(Color.lightGray);
            }
        }
        return this;
    }
}

