/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.etl.PLExport;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.ArchitectWizard;
import ca.sqlpower.architect.swingui.QuickStartPanel1;
import ca.sqlpower.architect.swingui.QuickStartPanel2;
import ca.sqlpower.architect.swingui.QuickStartPanel3;
import ca.sqlpower.architect.swingui.QuickStartPanel4;
import ca.sqlpower.architect.swingui.QuickStartPanel5;
import ca.sqlpower.architect.swingui.WizardDialog;
import ca.sqlpower.architect.swingui.WizardPanel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class QuickStartWizard
implements ArchitectWizard {
    private static final Logger logger = Logger.getLogger(QuickStartWizard.class);
    boolean onLastPanel = false;
    LinkedList panels = new LinkedList();
    WizardPanel currentPanel = new QuickStartPanel1(this);
    String title;
    List sourceTables;
    PLExport plExport;
    private JTextArea resultOutput;
    private JDialog parentDialog;

    public QuickStartWizard() {
        this.panels.add(this.currentPanel);
        this.title = "Power Architect Quick Start Wizard";
        this.resultOutput = new JTextArea();
        this.resultOutput.setEditable(false);
    }

    public WizardPanel getNext() {
        if (this.panels.indexOf(this.currentPanel) < this.panels.size() - 1) {
            this.currentPanel = (WizardPanel)this.panels.get(this.panels.indexOf(this.currentPanel) + 1);
        } else if (this.panels.indexOf(this.currentPanel) == 0) {
            this.currentPanel = new QuickStartPanel2(this);
            this.panels.add(this.currentPanel);
        } else if (this.panels.indexOf(this.currentPanel) == 1) {
            this.currentPanel = new QuickStartPanel3(this);
            this.panels.add(this.currentPanel);
        } else if (this.panels.indexOf(this.currentPanel) == 2) {
            this.currentPanel = new QuickStartPanel4(this);
            this.panels.add(this.currentPanel);
        } else if (this.panels.indexOf(this.currentPanel) == 3) {
            this.currentPanel = new QuickStartPanel5(this);
            this.panels.add(this.currentPanel);
        } else {
            throw new IllegalStateException("called getNext when Wizard was on last Panel");
        }
        return this.currentPanel;
    }

    public WizardPanel getPrevious() {
        if (this.panels.indexOf(this.currentPanel) > 0) {
            this.currentPanel = (WizardPanel)this.panels.get(this.panels.indexOf(this.currentPanel) - 1);
            return this.currentPanel;
        }
        throw new IllegalStateException("called getPrevious() when wizard panels had less than 2 items!");
    }

    public WizardPanel getCurrent() {
        return this.currentPanel;
    }

    public boolean isOnLastPanel() {
        return this.panels.indexOf(this.currentPanel) == 4;
    }

    public boolean isOnExecutePanel() {
        return this.panels.indexOf(this.currentPanel) == 3;
    }

    public boolean isOnFirstPanel() {
        return this.panels.indexOf(this.currentPanel) == 0;
    }

    public void addTargetDatabase(ArchitectDataSource target) {
        ArchitectDataSource tSpec = ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase().getDataSource();
        ArchitectDataSource dbcs = this.plExport.getTargetDataSource();
        tSpec.getParentType().setJdbcDriver(dbcs.getDriverClass());
        tSpec.setUrl(dbcs.getUrl());
        tSpec.setUser(dbcs.getUser());
        tSpec.setPass(dbcs.getPass());
        tSpec.setPlSchema(dbcs.getPlSchema());
        tSpec.setPlDbType(dbcs.getPlDbType());
        tSpec.setOdbcDsn(dbcs.getOdbcDsn());
    }

    void addSourceDatabases(List sourceTables) {
        HashSet<SQLDatabase> s = new HashSet<SQLDatabase>();
        for (SQLTable t : sourceTables) {
            s.add(t.getParentDatabase());
        }
        SQLObject root = (SQLObject)ArchitectFrame.getMainInstance().dbTree.getModel().getRoot();
        Iterator it2 = s.iterator();
        while (it2.hasNext()) {
            try {
                SQLDatabase source = (SQLDatabase)it2.next();
                SQLDatabase newDB = new SQLDatabase(source.getDataSource());
                root.addChild(root.getChildCount(), newDB);
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Couldn't add new database to tree", (Throwable)ex);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public static List getDatabases() {
        ArrayList<SQLDatabase> list = new ArrayList<SQLDatabase>();
        Iterator<ArchitectDataSource> it = ArchitectFrame.getMainInstance().getUserSettings().getConnections().iterator();
        while (it.hasNext()) {
            list.add(new SQLDatabase(it.next()));
        }
        return list;
    }

    public List getSourceTables() {
        return this.sourceTables;
    }

    public void setSourceTables(List sourceTables) {
        this.sourceTables = sourceTables;
    }

    public PLExport getPlExport() {
        return this.plExport;
    }

    public void setPlExport(PLExport plExport) {
        this.plExport = plExport;
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    public void setParentDialog(JDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public JTextArea getResultOutput() {
        return this.resultOutput;
    }

    public void setResultOutput(JTextArea resultOutput) {
        this.resultOutput = resultOutput;
    }

    public void UpdateTextArea() {
        WizardDialog wd = (WizardDialog)this.getParentDialog();
        wd.getNextButton().setEnabled(true);
        wd.getProgressBar().setVisible(false);
        wd.getProgressLabel().setVisible(false);
        StringBuffer text = new StringBuffer();
        for (ASUtils.LabelValueBean lvb : this.plExport.getExportResultList()) {
            text.append("  " + lvb.getLabel() + "\n\t" + lvb.getValue() + "\n");
        }
        this.resultOutput.setText(text.toString());
    }

    public static class GenerateStatementsTask
    extends ArchitectSwingWorker {
        List statements;
        DDLGenerator ddlg;
        SQLDatabase db;
        JDialog parentDialog;
        String errorMessage = null;

        GenerateStatementsTask(List statements, DDLGenerator ddlg, SQLDatabase db, JDialog parentDialog) {
            this.statements = statements;
            this.ddlg = ddlg;
            this.db = db;
            this.parentDialog = parentDialog;
        }

        public void doStuff() {
            if (!this.isCanceled()) {
                try {
                    List<DDLStatement> list = this.ddlg.generateDDLStatements(this.db);
                    logger.debug((Object)("generated statements are: " + list));
                    Iterator<DDLStatement> it = list.iterator();
                    while (it.hasNext()) {
                        this.statements.add(it.next());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while generating DDL", (Throwable)ex);
                    this.errorMessage = "Error while generating DDL:\n\n" + ex.getMessage();
                }
            }
        }

        public void cleanup() {
            if (this.errorMessage != null) {
                JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, "Error while generating DDL", 0);
                this.setCancelled(true);
            }
        }
    }
}

