/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.util.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResultsDecoratorJTable
extends ResultsDecorator {
    JTable table;

    public ResultsDecoratorJTable(JTable table, PrintWriter out, Verbosity v) {
        super(out, v);
        this.table = table;
    }

    public int write(final ResultSet rs) throws IOException, SQLException {
        final ResultSetMetaData md = rs.getMetaData();
        final int colCount = md.getColumnCount();
        TableModel dataModel = new TableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                try {
                    return Class.forName(md.getColumnClassName(1 + columnIndex));
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public int getColumnCount() {
                return colCount;
            }

            @Override
            public String getColumnName(int columnIndex) {
                try {
                    return md.getColumnLabel(1 + columnIndex);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return "unknown";
                }
            }

            @Override
            public int getRowCount() {
                try {
                    rs.last();
                    return rs.getRow();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return -1;
                }
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                try {
                    rs.absolute(1 + rowIndex);
                    return rs.getObject(1 + columnIndex);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                throw new IllegalArgumentException("Model is read-only");
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
            }
        };
        this.table.setModel(dataModel);
        return dataModel.getRowCount();
    }

    public String getName() {
        return "JTable";
    }
}

