-- (c) The FFI task force, [2000..2001]
--
-- Haskell representation of basic C types

module CTypes (
  -- Integral types; instances: Eq, Ord, Num, Read, Show, Enum,
  -- Storable, Bounded, Real, Integral
  --
  CChar(..), CSChar(..), CUChar(..)
  CShort(..), CUShort(..), CInt(..), CUInt(..),
  CLong(..), CULong(..), CLLong(..), CULLong(..),

  -- Floating types; instances: Eq, Ord, Num, Read, Show, Enum,
  -- Storable, Real, Fractional, Floating, RealFrac, RealFloat
  --
  CFloat(..),   CDouble(..), CLDouble(..)
) where

import Int
import Word
import Storable (Storable(..))

-- the exact representations are architecture dependent

newtype CChar    = CChar   WordInt8            -- char
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CSChar   = CSChar  Int8                -- signed char
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CUChar   = CUChar  Word8               -- unsigned char
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CShort   = CShort  IntXY               -- short
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CUShort  = CUShort WordXY	       -- unsigned short
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CInt     = CInt    IntXY               -- int
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CUInt    = CUInt   WordXY              -- unsigned int
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CLong    = CLong   IntXY               -- long
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CULong   = CULong  WordXY              -- unsigned long
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CLLong   = CLLong  IntXY               -- long long
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)
newtype CULLong  = CULLong WordXY              -- unsigned long long
		 deriving (Eq, Ord, Enum, Bounded, Show, Read)

newtype CFloat   = CFloat   ...                 -- float
		 deriving (Eq, Ord, Enum, Show, Read)
newtype CDouble  = CDouble  ...                 -- double
		 deriving (Eq, Ord, Enum, Show, Read)
newtype CLDouble = CLDouble ...                 -- long double
		 deriving (Eq, Ord, Enum, Show, Read)

instance Num      CChar   where ...
instance Real     CChar   where ...
instance Integral CChar   where ...
instance Num      CSChar  where ...
instance Real     CSChar  where ...
instance Integral CSChar  where ...
instance Num      CUChar  where ...
instance Real     CUChar  where ...
instance Integral CUChar  where ...
instance Num      CShort  where ...
instance Real     CShort  where ...
instance Integral CShort  where ...
instance Num      CUShort where ...
instance Real     CUShort where ...
instance Integral CUShort where ...
instance Num      CInt    where ...
instance Real     CInt    where ...
instance Integral CInt    where ...
instance Num      CLong   where ...
instance Real     CLong   where ...
instance Integral CLong   where ...
instance Num      CULong  where ...
instance Real     CULong  where ...
instance Integral CULong  where ...
instance Num      CLLong  where ...
instance Real     CLLong  where ...
instance Integral CLLong  where ...
instance Num      CULLong where ...
instance Real     CULLong where ...
instance Integral CULLong where ...

instance Num       CFloat   where ...
instance Real      CFloat   where ...
instance Floating  CFloat   where ...
instance RealFrac  CFloat   where ...
instance RealFloat CFloat   where ...
instance Num       CDouble  where ...
instance Real      CDouble  where ...
instance Floating  CDouble  where ...
instance RealFrac  CDouble  where ...
instance RealFloat CDouble  where ...
instance Num       CLDouble where ...
instance Real      CLDouble where ...
instance Floating  CLDouble where ...
instance RealFrac  CLDouble where ...
instance RealFloat CLDouble where ...
