/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.provider.XSDEditPlugin;

public class XSDItemProviderAdapter
extends ItemProviderAdapter
implements CreateChildCommand.Helper {
    protected static final XSDPackage xsdPackage = XSDPackage.eINSTANCE;
    protected static final XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    protected AdapterFactoryItemDelegator itemDelegator;

    protected XSDItemProviderAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
    }

    public Object getParent(Object object) {
        EObject grandParent;
        EObject parent = ((EObject)object).eContainer();
        if (parent != null && ((grandParent = parent.eContainer()) instanceof XSDParticle || grandParent instanceof XSDAttributeUse)) {
            return grandParent;
        }
        return parent;
    }

    public List getPropertyDescriptors(final Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList(){

                public boolean add(Object o) {
                    String id = ((IItemPropertyDescriptor)o).getId(object);
                    Iterator i = this.iterator();
                    while (i.hasNext()) {
                        IItemPropertyDescriptor propertyDescriptor = (IItemPropertyDescriptor)i.next();
                        if (!id.equals(propertyDescriptor.getId(object))) continue;
                        return false;
                    }
                    return super.add(o);
                }
            };
        }
        return this.itemPropertyDescriptors;
    }

    protected Object getParticleOrAttributeUseContent(Object object) {
        if (object instanceof XSDParticle) {
            return ((XSDParticle)object).getContent();
        }
        if (object instanceof XSDAttributeUse) {
            return ((XSDAttributeUse)object).getContent();
        }
        return object;
    }

    protected CommandParameter createChildParameter(EReference feature, XSDConcreteComponent child) {
        return new CommandParameter(null, (Object)feature, (Object)child);
    }

    protected void addModelGroupChildParameters(Collection newChildDescriptors, EReference feature, boolean all, boolean useParticle) {
        XSDCompositor[] compositor = new XSDCompositor[]{XSDCompositor.ALL_LITERAL, XSDCompositor.CHOICE_LITERAL, XSDCompositor.SEQUENCE_LITERAL};
        int i = all ? 0 : 1;
        while (i < compositor.length) {
            XSDModelGroup mg = xsdFactory.createXSDModelGroup();
            mg.setCompositor(compositor[i]);
            XSDModelGroup child = mg;
            if (useParticle) {
                child = this.createParticle((XSDParticleContent)mg, false);
            }
            newChildDescriptors.add(this.createChildParameter(feature, (XSDConcreteComponent)child));
            ++i;
        }
    }

    protected void addSimpleTypeDefinitionChildParameters(Collection newChildDescriptors, XSDConcreteComponent parent, EReference feature, boolean atomic, boolean list, boolean union) {
        XSDSchema xsdSchema = parent.getSchema();
        if (xsdSchema != null) {
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
            XSDSimpleTypeDefinition baseType = parent.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
            if (atomic) {
                xsdSimpleTypeDefinition = this.createSimpleTypeDefinition(parent);
                xsdSimpleTypeDefinition.setVariety(XSDVariety.ATOMIC_LITERAL);
                xsdSimpleTypeDefinition.setBaseTypeDefinition(baseType);
                newChildDescriptors.add(this.createChildParameter(feature, (XSDConcreteComponent)xsdSimpleTypeDefinition));
            }
            if (list) {
                xsdSimpleTypeDefinition = this.createSimpleTypeDefinition(parent);
                xsdSimpleTypeDefinition.setVariety(XSDVariety.LIST_LITERAL);
                xsdSimpleTypeDefinition.setItemTypeDefinition(baseType);
                newChildDescriptors.add(this.createChildParameter(feature, (XSDConcreteComponent)xsdSimpleTypeDefinition));
            }
            if (union) {
                xsdSimpleTypeDefinition = this.createSimpleTypeDefinition(parent);
                xsdSimpleTypeDefinition.setVariety(XSDVariety.UNION_LITERAL);
                xsdSimpleTypeDefinition.getMemberTypeDefinitions().add((Object)baseType);
                newChildDescriptors.add(this.createChildParameter(feature, (XSDConcreteComponent)xsdSimpleTypeDefinition));
            }
        }
    }

    protected boolean isGlobal(Object parent) {
        return parent instanceof XSDSchema || parent instanceof XSDRedefine;
    }

    protected XSDAttributeDeclaration createAttributeDeclaration(XSDConcreteComponent parent) {
        XSDAttributeDeclaration child = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDAttributeDeclaration().getName());
        if (this.isGlobal(parent)) {
            String name = null;
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while ((child = parent.resolveAttributeDeclaration(name)).eContainer() != null);
        } else {
            XSDSchema schema = parent.getSchema();
            String namespace = null;
            if (schema != null && schema.getAttributeFormDefault() == XSDForm.QUALIFIED_LITERAL) {
                namespace = schema.getTargetNamespace();
            }
            Collection siblings = this.getAttributeSiblings(parent);
            String name = null;
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while (!this.isUniqueAttributeDeclarationName(name, namespace, siblings));
            child = xsdFactory.createXSDAttributeDeclaration();
            child.setName(name);
            if (namespace != null) {
                child.setTargetNamespace(namespace);
            }
            child.setResolvedAttributeDeclaration(child);
        }
        child.setTypeDefinition(parent.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        return child;
    }

    protected Collection getAttributeSiblings(XSDConcreteComponent parent) {
        EList siblings = null;
        if (parent instanceof XSDAttributeGroupDefinition) {
            XSDAttributeGroupDefinition group = (XSDAttributeGroupDefinition)parent;
            while (group.eContainer() instanceof XSDAttributeGroupDefinition) {
                group = (XSDAttributeGroupDefinition)group.eContainer();
            }
            if (group.eContainer() instanceof XSDComplexTypeDefinition) {
                parent = (XSDComplexTypeDefinition)group.eContainer();
            } else {
                siblings = group.getAttributeUses();
            }
        }
        if (parent instanceof XSDComplexTypeDefinition) {
            siblings = ((XSDComplexTypeDefinition)parent).getAttributeUses();
        }
        return siblings;
    }

    protected boolean isUniqueAttributeDeclarationName(String localName, String targetNamespace, Collection attributeUses) {
        boolean dup = false;
        if (attributeUses != null) {
            Iterator i = attributeUses.iterator();
            while (!dup && i.hasNext()) {
                XSDAttributeUse attributeUse = (XSDAttributeUse)i.next();
                if (attributeUse.getAttributeDeclaration() == null) continue;
                XSDAttributeDeclaration other = attributeUse.getAttributeDeclaration();
                dup = other.hasNameAndTargetNamespace(localName, targetNamespace);
            }
        }
        return !dup;
    }

    protected XSDElementDeclaration createElementDeclaration(XSDConcreteComponent parent) {
        XSDElementDeclaration child = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDElementDeclaration().getName());
        if (this.isGlobal(parent)) {
            String name = null;
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while ((child = parent.resolveElementDeclaration(name)).eContainer() != null);
        } else {
            XSDSchema schema = parent.getSchema();
            String namespace = null;
            if (schema != null && schema.getElementFormDefault() == XSDForm.QUALIFIED_LITERAL) {
                namespace = schema.getTargetNamespace();
            }
            XSDModelGroup modelGroup = this.getTopModelGroup(parent);
            String name = null;
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while (!this.isUniqueElementDeclarationName(name, namespace, modelGroup, null));
            child = xsdFactory.createXSDElementDeclaration();
            child.setName(name);
            if (namespace != null) {
                child.setTargetNamespace(namespace);
            }
            child.setResolvedElementDeclaration(child);
        }
        child.setTypeDefinition((XSDTypeDefinition)parent.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string"));
        return child;
    }

    protected XSDModelGroup getTopModelGroup(XSDConcreteComponent parent) {
        XSDModelGroup modelGroup = null;
        if (parent instanceof XSDModelGroup) {
            modelGroup = (XSDModelGroup)parent;
            while (parent.eContainer() instanceof XSDParticle || parent.eContainer() instanceof XSDModelGroup) {
                if (!((parent = (XSDConcreteComponent)parent.eContainer()) instanceof XSDModelGroup)) continue;
                modelGroup = (XSDModelGroup)parent;
            }
        }
        return modelGroup;
    }

    protected boolean isUniqueElementDeclarationName(String localName, String targetNamespace, XSDModelGroup modelGroup, HashSet visited) {
        boolean dup = false;
        if (visited == null) {
            visited = new HashSet<XSDModelGroup>();
        }
        if (modelGroup != null && visited.add(modelGroup) && modelGroup.getParticles() != null) {
            Iterator i = modelGroup.getParticles().iterator();
            while (!dup && i.hasNext()) {
                XSDParticle particle = (XSDParticle)i.next();
                if (particle.getTerm() instanceof XSDElementDeclaration) {
                    XSDElementDeclaration other = (XSDElementDeclaration)particle.getTerm();
                    dup = other.hasNameAndTargetNamespace(localName, targetNamespace);
                    continue;
                }
                if (!(particle.getTerm() instanceof XSDModelGroup)) continue;
                XSDModelGroup others = (XSDModelGroup)particle.getTerm();
                boolean bl = dup = !this.isUniqueElementDeclarationName(localName, targetNamespace, others, visited);
            }
        }
        return !dup;
    }

    protected XSDAttributeGroupDefinition createAttributeGroupDefinition(XSDConcreteComponent parent) {
        XSDAttributeGroupDefinition child = null;
        String name = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDAttributeGroupDefinition().getName());
        int i = 0;
        do {
            name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
            int n = i = i > 0 ? i + 1 : 1;
        } while ((child = parent.resolveAttributeGroupDefinition(name)).eContainer() != null);
        return child;
    }

    protected XSDModelGroupDefinition createModelGroupDefinition(XSDConcreteComponent parent) {
        XSDModelGroupDefinition child = null;
        String name = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDModelGroupDefinition().getName());
        int i = 0;
        do {
            name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
            int n = i = i > 0 ? i + 1 : 1;
        } while ((child = parent.resolveModelGroupDefinition(name)).eContainer() != null);
        return child;
    }

    protected XSDComplexTypeDefinition createComplexTypeDefinition(XSDConcreteComponent parent) {
        XSDComplexTypeDefinition child = null;
        if (this.isGlobal(parent)) {
            String name = null;
            String baseName = this.getNewObjectName(xsdPackage.getXSDComplexTypeDefinition().getName());
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while ((child = parent.resolveComplexTypeDefinition(name)).eContainer() != null);
        } else {
            child = xsdFactory.createXSDComplexTypeDefinition();
        }
        return child;
    }

    protected XSDSimpleTypeDefinition createSimpleTypeDefinition(XSDConcreteComponent parent) {
        XSDSimpleTypeDefinition child = null;
        if (this.isGlobal(parent)) {
            String name = null;
            String baseName = this.getNewObjectName(xsdPackage.getXSDSimpleTypeDefinition().getName());
            int i = 0;
            do {
                name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
                int n = i = i > 0 ? i + 1 : 1;
            } while ((child = parent.resolveSimpleTypeDefinition(name)).eContainer() != null);
        } else {
            child = xsdFactory.createXSDSimpleTypeDefinition();
        }
        return child;
    }

    protected XSDIdentityConstraintDefinition createIdentityConstraintDefinition(XSDConcreteComponent parent) {
        XSDIdentityConstraintDefinition child = null;
        String name = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDIdentityConstraintDefinition().getName());
        int i = 0;
        do {
            name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
            int n = i = i > 0 ? i + 1 : 1;
        } while ((child = parent.resolveIdentityConstraintDefinition(name)).eContainer() != null);
        return child;
    }

    protected XSDNotationDeclaration createNotationDeclaration(XSDConcreteComponent parent) {
        XSDNotationDeclaration child = null;
        String name = null;
        String baseName = this.getNewObjectName(xsdPackage.getXSDNotationDeclaration().getName());
        int i = 0;
        do {
            name = String.valueOf(baseName) + (i > 0 ? String.valueOf(i) : "");
            int n = i = i > 0 ? i + 1 : 1;
        } while ((child = parent.resolveNotationDeclaration(name)).eContainer() != null);
        child.setPublicIdentifier("");
        return child;
    }

    protected XSDAttributeUse createAttributeUse(XSDAttributeDeclaration attributeDeclaration, boolean isReference) {
        XSDAttributeUse au = xsdFactory.createXSDAttributeUse();
        if (isReference) {
            XSDAttributeDeclaration ref = xsdFactory.createXSDAttributeDeclaration();
            ref.setResolvedAttributeDeclaration(attributeDeclaration);
            au.setContent(ref);
        } else {
            au.setContent(attributeDeclaration);
        }
        return au;
    }

    protected XSDAttributeGroupDefinition createAttributeGroupDefinitionReference(XSDAttributeGroupDefinition attributeGroupDefinition) {
        XSDAttributeGroupDefinition ref = xsdFactory.createXSDAttributeGroupDefinition();
        ref.setResolvedAttributeGroupDefinition(attributeGroupDefinition);
        return ref;
    }

    protected XSDParticle createParticle(XSDParticleContent particleContent, boolean isReference) {
        XSDParticle p = xsdFactory.createXSDParticle();
        if (particleContent instanceof XSDModelGroupDefinition) {
            XSDModelGroupDefinition ref = xsdFactory.createXSDModelGroupDefinition();
            ref.setResolvedModelGroupDefinition((XSDModelGroupDefinition)particleContent);
            p.setContent((XSDParticleContent)ref);
        } else if (particleContent instanceof XSDElementDeclaration && isReference) {
            XSDElementDeclaration ref = xsdFactory.createXSDElementDeclaration();
            ref.setResolvedElementDeclaration((XSDElementDeclaration)particleContent);
            p.setContent((XSDParticleContent)ref);
        } else {
            p.setContent(particleContent);
        }
        return p;
    }

    protected String getNewObjectName(String typeName) {
        return XSDEditPlugin.INSTANCE.getString("_UI_" + typeName + "_new_object");
    }

    public Collection getCreateChildResult(Object child) {
        ArrayList<Object> result = new ArrayList<Object>(1);
        result.add(child);
        return result;
    }

    public String getCreateChildText(Object parent, Object feature, Object child, Collection selection) {
        child = this.getParticleOrAttributeUseContent(child);
        EReference refFeature = feature instanceof EReference ? (EReference)feature : null;
        String qualifier = this.getTypeTextQualifier(parent, refFeature, child);
        return this.getTypeText(child, qualifier);
    }

    public String getCreateChildDescription(Object parent, Object feature, Object child, Collection selection) {
        Object selectedObject;
        child = this.getParticleOrAttributeUseContent(child);
        EReference refFeature = feature instanceof EReference ? (EReference)feature : null;
        String qualifier = this.getTypeTextQualifier(parent, refFeature, child);
        Object object = selectedObject = selection == null || selection.isEmpty() ? null : this.getParticleOrAttributeUseContent(selection.iterator().next());
        if (parent != selectedObject) {
            return XSDEditPlugin.INSTANCE.getString("_UI_CreateSibling_description", new Object[]{this.getTypeText(child, qualifier), this.getTypeText(selectedObject, null)});
        }
        return XSDEditPlugin.INSTANCE.getString("_UI_CreateChild_description", new Object[]{this.getTypeText(child, qualifier), this.getTypeText(parent, null)});
    }

    public String getCreateChildToolTipText(Object parent, Object feature, Object child, Collection selection) {
        Object selectedObject;
        child = this.getParticleOrAttributeUseContent(child);
        EReference refFeature = feature instanceof EReference ? (EReference)feature : null;
        String qualifier = this.getTypeTextQualifier(parent, refFeature, child);
        Object object = selectedObject = selection == null || selection.isEmpty() ? null : this.getParticleOrAttributeUseContent(selection.iterator().next());
        if (parent != selectedObject) {
            return XSDEditPlugin.INSTANCE.getString("_UI_CreateSibling_tooltip", new Object[]{this.getTypeText(child, qualifier), this.getTypeText(selectedObject, null)});
        }
        return XSDEditPlugin.INSTANCE.getString("_UI_CreateChild_tooltip", new Object[]{this.getTypeText(child, qualifier), this.getTypeText(parent, null)});
    }

    protected String getTypeText(Object object, String qualifier) {
        StringBuffer typeKey = new StringBuffer("_UI_");
        typeKey.append(object instanceof EObject ? ((EObject)object).eClass().getName() : "Unknown");
        typeKey.append("_type");
        if (qualifier != null) {
            typeKey.append('_');
            typeKey.append(qualifier);
        }
        return XSDEditPlugin.INSTANCE.getString(typeKey.toString());
    }

    public Object getCreateChildImage(Object parent, Object feature, Object child, Collection selection) {
        child = this.getParticleOrAttributeUseContent(child);
        Object image = null;
        if (child instanceof EObject) {
            int i;
            StringBuffer imageName = new StringBuffer("full/obj16/");
            String typeName = ((EObject)child).eClass().getName();
            EReference refFeature = feature instanceof EReference ? (EReference)feature : null;
            String qualifier = this.getImageNameQualifier(parent, refFeature, child);
            int n = i = "Use".equals(qualifier) ? typeName.lastIndexOf(68) : 0;
            if (i > 0) {
                typeName = typeName.substring(0, i);
            }
            imageName.append(typeName);
            if (qualifier != null) {
                imageName.append(qualifier);
            }
            image = XSDEditPlugin.INSTANCE.getImage(imageName.toString());
        }
        return image;
    }

    protected String getTypeTextQualifier(Object parent, EReference feature, Object child) {
        return this.getQualifier(parent, feature, child);
    }

    protected String getImageNameQualifier(Object parent, EReference feature, Object child) {
        Object p = child instanceof XSDAnnotation ? null : parent;
        String qualifier = this.getQualifier(p, feature, child);
        if ("keyref".equals(qualifier)) {
            qualifier = "KeyReference";
        } else if ("reference".equals(qualifier)) {
            qualifier = "Use";
        } else if (qualifier != null && qualifier.length() > 0) {
            StringBuffer buffer = new StringBuffer(qualifier);
            char c = buffer.charAt(0);
            buffer.setCharAt(0, Character.toUpperCase(c));
            qualifier = buffer.toString();
        }
        return qualifier;
    }

    private String getQualifier(Object parent, EReference feature, Object child) {
        String qualifier = null;
        if (child instanceof XSDElementDeclaration && ((XSDElementDeclaration)child).isElementDeclarationReference() || child instanceof XSDAttributeDeclaration && ((XSDAttributeDeclaration)child).isAttributeDeclarationReference() || child instanceof XSDModelGroupDefinition && ((XSDModelGroupDefinition)child).isModelGroupDefinitionReference() || child instanceof XSDAttributeGroupDefinition && ((XSDAttributeGroupDefinition)child).isAttributeGroupDefinitionReference()) {
            qualifier = "reference";
        } else if (child instanceof XSDModelGroup) {
            qualifier = ((XSDModelGroup)child).getCompositor().getName();
        } else if (child instanceof XSDSimpleTypeDefinition) {
            qualifier = ((XSDSimpleTypeDefinition)child).getVariety().getName();
        } else if (child instanceof XSDIdentityConstraintDefinition) {
            qualifier = ((XSDIdentityConstraintDefinition)child).getIdentityConstraintCategory().getName();
        } else if (child instanceof XSDXPathDefinition) {
            qualifier = ((XSDXPathDefinition)child).getVariety().getName();
        } else if (child instanceof XSDWildcard) {
            if (parent instanceof XSDAttributeGroupDefinition || parent instanceof XSDComplexTypeDefinition) {
                qualifier = "attribute";
            } else if (parent instanceof XSDModelGroup) {
                qualifier = "element";
            }
        } else if (child instanceof XSDAnnotation && parent instanceof XSDTypeDefinition && feature != null) {
            qualifier = feature.getName();
        }
        return qualifier;
    }

    public static class ItemPropertyDescriptorWithDefault
    extends ItemPropertyDescriptor {
        public ItemPropertyDescriptorWithDefault(AdapterFactory adapterFactory, String displayName, String description, EStructuralFeature feature, boolean isSettable, Object staticImage) {
            super(adapterFactory, displayName, description, feature, isSettable, staticImage);
        }

        public Object getPropertyValue(Object o) {
            if (this.feature instanceof EAttribute) {
                EObject refObject = (EObject)o;
                EAttribute attribute = (EAttribute)this.feature;
                if (!attribute.isMany() && !refObject.eIsSet((EStructuralFeature)attribute)) {
                    return this.createPropertyValueWrapper(o, this.getPropertyDefaultValue(o));
                }
            }
            return super.getPropertyValue(o);
        }

        public void setPropertyValue(Object o, Object value) {
            Object propertyDefaultValue;
            EAttribute attribute;
            if (this.feature instanceof EAttribute && !(attribute = (EAttribute)this.feature).isMany() && (propertyDefaultValue = this.getPropertyDefaultValue(o)).equals(value)) {
                this.resetPropertyValue(o);
                return;
            }
            super.setPropertyValue(o, value);
        }

        public Collection getChoiceOfValues(Object o) {
            EAttribute attribute;
            ArrayList<Object> result = super.getChoiceOfValues(o);
            if (result != null && this.feature instanceof EAttribute && !(attribute = (EAttribute)this.feature).isMany()) {
                ArrayList<Object> newResult = new ArrayList<Object>(result);
                Object propertyDefaultValue = this.getPropertyDefaultValue(o);
                newResult.add(propertyDefaultValue);
                result = newResult;
            }
            return result;
        }

        public Object getPropertyDefaultValue(Object o) {
            EAttribute attribute;
            if (this.feature instanceof EAttribute && !(attribute = (EAttribute)this.feature).isMany()) {
                Object result = attribute.getDefaultValue();
                if (result == null) {
                    result = ItemPropertyDescriptorWithDefault.getDefaultValue((EClassifier)attribute.getEType());
                }
                if (result == null) {
                    return XSDEditPlugin.INSTANCE.getString("_UI_DefaultValue_label", new Object[]{""});
                }
                return XSDEditPlugin.INSTANCE.getString("_UI_DefaultValue_label", new Object[]{this.itemDelegator.getText(result)});
            }
            return null;
        }
    }
}

