/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.perl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.epic.perleditor.templates.ContextType;
import org.epic.perleditor.templates.DocumentTemplateContext;
import org.epic.perleditor.templates.Template;
import org.epic.perleditor.templates.TemplateBuffer;
import org.epic.perleditor.templates.TemplateTranslator;

public class PerlUnitContext
extends DocumentTemplateContext {
    private static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");
    private static final String specialChars = "=#$@%<";

    protected PerlUnitContext(ContextType type, IDocument document, int completionPosition) {
        super(type, document, completionPosition, 0);
    }

    public boolean canEvaluate(Template template) {
        return template.matches(this.getKey(), this.getContextType().getName());
    }

    public boolean canEvaluate(String identifier, boolean showAllOnEmpty) {
        String prefix = this.getKey();
        if (showAllOnEmpty) {
            return prefix.length() == 0 || identifier.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return prefix.length() != 0 && identifier.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template.getPattern());
        this.getContextType().edit(buffer, this);
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter == null) {
            lineDelimiter = PLATFORM_LINE_DELIMITER;
        }
        return buffer;
    }

    public int getStart() {
        IDocument document = this.getDocument();
        try {
            int start = this.getCompletionOffset();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1)) || start != 0 && specialChars.indexOf(document.getChar(start - 1)) != -1) {
                --start;
            }
            if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1)) || start != 0 && specialChars.indexOf(document.getChar(start - 1)) != -1) {
                --start;
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return this.getCompletionOffset();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }
}

