/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import java.util.regex.Pattern;

public class NameMatch {
    private String exact;
    private Pattern pattern;

    public String getValue() {
        if (this.exact != null) {
            return this.exact;
        }
        return this.pattern.toString();
    }

    public NameMatch(String matchSpec) {
        if (matchSpec != null) {
            if (matchSpec.startsWith("~")) {
                this.pattern = Pattern.compile(matchSpec.substring(1));
            } else {
                this.exact = matchSpec;
            }
        }
    }

    public boolean match(String value) {
        if (this.exact != null) {
            return this.exact.equals(value);
        }
        if (this.pattern != null) {
            return this.pattern.matcher(value).matches();
        }
        return true;
    }

    public String toString() {
        if (this.exact != null) {
            return "exact(" + this.exact + ")";
        }
        if (this.pattern != null) {
            return "regex(" + this.pattern.toString() + ")";
        }
        return "any()";
    }
}

