/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.builder.AbstractFilesCollector;
import de.tobject.findbugs.builder.ContainerFilesCollector;
import de.tobject.findbugs.builder.NullFilesCollector;
import de.tobject.findbugs.builder.ResourceDeltaFilesCollector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FilesCollectorFactory {
    public static boolean DEBUG = false;

    public static AbstractFilesCollector getFilesCollector(IContainer container) {
        if (container != null) {
            return new ContainerFilesCollector(container);
        }
        return new NullFilesCollector();
    }

    public static AbstractFilesCollector getFilesCollector(IncrementalProjectBuilder builder) {
        if (builder != null) {
            IProject project = builder.getProject();
            if (project != null) {
                IResourceDelta resourceDelta = builder.getDelta(project);
                if (resourceDelta != null) {
                    if (resourceDelta.findMember((IPath)new Path(".project")) != null) {
                        if (DEBUG) {
                            System.out.println("Delta contains the PROJECT file.");
                        }
                        return new ContainerFilesCollector((IContainer)project);
                    }
                    return new ResourceDeltaFilesCollector(resourceDelta);
                }
                return new ContainerFilesCollector((IContainer)project);
            }
            if (DEBUG) {
                System.out.println("project is null");
            }
        }
        return new NullFilesCollector();
    }
}

