/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reporter
extends AbstractBugReporter
implements FindBugsProgress {
    public static boolean DEBUG = false;
    private static final int MAX_CLASS_NAME_LENGTH = 35;
    private IProject project;
    private Project findBugsProject;
    private static int MONITOR_INTERVAL = 1;
    private IProgressMonitor monitor;
    private SortedBugCollection bugCollection;
    private Set<String> analyzedClassNameSet;
    private UserPreferences userPrefs;
    private boolean workStarted;
    int filesNumber;
    int expectedWork;
    int pass = -1;
    int filteredBugCount = 0;
    int workCount = 0;

    public Reporter(IProject project, IProgressMonitor monitor, Project findBugsProject) {
        if (!FindbugsPlugin.isJavaProject(project)) {
            throw new IllegalArgumentException("Not a Java project");
        }
        this.monitor = monitor;
        this.project = project;
        this.findBugsProject = findBugsProject;
        this.project = project;
        this.bugCollection = new SortedBugCollection();
        this.analyzedClassNameSet = new HashSet<String>();
        try {
            this.userPrefs = FindbugsPlugin.getUserPreferences(project);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Error getting FindBugs preferences for project");
            this.userPrefs = UserPreferences.createDefaultUserPreferences();
        }
    }

    protected void doReportBug(BugInstance bug) {
        this.getBugCollection().add(bug);
        if (MarkerUtil.displayWarning(bug, this.userPrefs.getFilterSettings())) {
            MarkerUtil.createMarker(bug, this.project, (BugCollection)this.getBugCollection());
            ++this.filteredBugCount;
        }
    }

    public void finish() {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Finish: Found ").append(this.filteredBugCount).append(" bugs.").toString());
        }
    }

    public SortedBugCollection getBugCollection() {
        return this.bugCollection;
    }

    public IProject getProject() {
        return this.project;
    }

    public Set<String> getAnalyzedClassNames() {
        return this.analyzedClassNameSet;
    }

    public static IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        JavaClass clazz;
        try {
            clazz = AnalysisContext.currentAnalysisContext().lookupClass(classDescriptor);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Observing class: ").append(clazz.getClassName()).toString());
        }
        this.analyzedClassNameSet.add(clazz.getClassName());
        if (this.filesNumber < this.analyzedClassNameSet.size()) {
            this.filesNumber = this.analyzedClassNameSet.size();
        }
        if (this.monitor == null) {
            return;
        }
        if (!this.workStarted) {
            this.workStarted = true;
            this.filesNumber = this.findBugsProject.getFileCount();
            if (!(this.monitor instanceof SubProgressMonitor)) {
                this.monitor.beginTask("Performing bug checking...", this.expectedWork);
            }
        }
        if (this.monitor.isCanceled()) {
            Thread.currentThread().interrupt();
        }
        if (this.pass <= 0) {
            this.monitor.setTaskName(new StringBuffer().append("Prescanning... (found ").append(this.filteredBugCount).append(", checking ").append(this.getAbbreviatedClassName(clazz)).append(")").toString());
        } else if (this.pass == 1) {
            this.monitor.setTaskName(new StringBuffer().append("Checking... (found ").append(this.filteredBugCount).append(", checking ").append(this.getAbbreviatedClassName(clazz)).append(")").toString());
        } else if (this.pass == 2) {
            this.monitor.setTaskName(new StringBuffer().append("Checking... (3rd pass) (found ").append(this.filteredBugCount).append(", checking ").append(this.getAbbreviatedClassName(clazz)).append(")").toString());
        }
        int work = this.pass == 0 ? 1 : 2;
        this.monitor.worked(work);
        this.workCount += work;
    }

    private String getAbbreviatedClassName(JavaClass clazz) {
        String name = clazz.getClassName();
        if (name.length() > 35) {
            int startCutIdx = name.length() - 35;
            int pointIdx = name.indexOf(".", startCutIdx);
            if (pointIdx > startCutIdx) {
                startCutIdx = pointIdx;
            }
            name = new StringBuffer().append("..").append(name.substring(startCutIdx)).toString();
        }
        return name;
    }

    public void reportAnalysisError(AnalysisError error) {
        FindbugsPlugin.getDefault().logWarning(new StringBuffer().append("FindBugs analysis error: ").append(error.getMessage()).toString());
    }

    public void reportMissingClass(String missingClass) {
        FindbugsPlugin.getDefault().logWarning(new StringBuffer().append("FindBugs could not find a class that would be useful in analyzing your code: ").append(missingClass).toString());
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void finishArchive() {
    }

    public void finishClass() {
    }

    public void finishPerClassAnalysis() {
    }

    public void reportNumberOfArchives(int numArchives) {
    }

    public void startAnalysis(int numClasses) {
        ++this.pass;
    }

    public void predictPassCount(int[] classesPerPass) {
        for (int count : classesPerPass) {
            this.expectedWork += 2 * count;
        }
        this.expectedWork -= classesPerPass[0];
    }
}

