/*
 * Decompiled with CFR 0.152.
 */
package org.epic.regexp.views;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.epic.regexp.RegExpPlugin;
import org.epic.regexp.views.RegExpImages;

public class RegExpView
extends ViewPart {
    private Composite panel;
    private List colorTable = new ArrayList();
    private Action validateAction;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action stopDebugAction;
    private Action forwardDebugAction;
    private Action backDebugAction;
    private StyledText regExpText;
    private StyledText matchText;
    private Label resultImageLabel;
    private Button ignoreCaseCheckBox;
    private Button multilineCheckBox;
    private Object activeInput = null;
    private DebugInfo debugInfo = null;
    private int debugPosition = 0;

    public void createPartControl(Composite composite) {
        this.makeActions();
        this.contributeToActionBars();
        this.panel = new Composite(composite, 0);
        this.buildColorTable();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.panel.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.panel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        Label label = new Label(this.panel, 0);
        label.setText("RegExp:");
        label.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.resultImageLabel = new Label(this.panel, 0);
        this.setResultLabelImage(RegExpImages.RESULT_GRAY);
        this.resultImageLabel.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.ignoreCaseCheckBox = new Button(this.panel, 32);
        this.ignoreCaseCheckBox.setText("ignore case");
        this.ignoreCaseCheckBox.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.multilineCheckBox = new Button(this.panel, 32);
        this.multilineCheckBox.setText("multiline");
        this.multilineCheckBox.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        this.regExpText = new StyledText(this.panel, 2048);
        this.regExpText.setLayoutData((Object)gridData);
        this.regExpText.addFocusListener((FocusListener)new focusListener());
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Label label2 = new Label(this.panel, 0);
        label2.setText("Match text:");
        label2.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        this.matchText = new StyledText(this.panel, 2816);
        this.matchText.setLayoutData((Object)gridData);
        this.matchText.addFocusListener((FocusListener)new focusListener());
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                RegExpView.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.regExpText);
        this.regExpText.setMenu(menu);
        Menu menu2 = menuManager.createContextMenu((Control)this.matchText);
        this.matchText.setMenu(menu2);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.cutAction);
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IAction)this.pasteAction);
        this.createShortcutsMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("Additions"));
    }

    private void buildColorTable() {
        Display display = this.panel.getDisplay();
        this.colorTable.add(display.getSystemColor(9));
        this.colorTable.add(display.getSystemColor(2));
        this.colorTable.add(display.getSystemColor(3));
        this.colorTable.add(display.getSystemColor(16));
        this.colorTable.add(display.getSystemColor(6));
        this.colorTable.add(new Color((Device)display, 255, 127, 0));
        this.colorTable.add(display.getSystemColor(12));
        this.colorTable.add(new Color((Device)display, 201, 141, 141));
        this.colorTable.add(new Color((Device)display, 214, 179, 74));
        this.colorTable.add(new Color((Device)display, 204, 74, 214));
    }

    private void createShortcutsMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("Shortcuts");
        iMenuManager.add((IContributionItem)menuManager);
        try {
            String string;
            File file = new File(String.valueOf(RegExpPlugin.getPlugInDir()) + File.separator + "shortcuts");
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                if (stringTokenizer.countTokens() == 2) {
                    string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    Action action = new Action(){

                        public void run() {
                            RegExpView.this.insertShortcut(string2);
                        }
                    };
                    action.setText(String.valueOf(string2) + " - " + string3);
                    menuManager.add((IAction)action);
                    iMenuManager.update(true);
                    continue;
                }
                if (stringTokenizer.countTokens() != 1 || !(string2 = stringTokenizer.nextToken()).equals("<DEL>")) continue;
                menuManager.add((IContributionItem)new Separator());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.stopDebugAction);
        iToolBarManager.add((IAction)this.backDebugAction);
        iToolBarManager.add((IAction)this.forwardDebugAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.validateAction);
    }

    private void makeActions() {
        this.stopDebugAction = new Action(){

            public void run() {
                RegExpView.this.resetDebug();
            }
        };
        this.stopDebugAction.setText("Reset");
        this.stopDebugAction.setToolTipText("Reset");
        this.stopDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_STOP);
        this.backDebugAction = new Action(){

            public void run() {
                RegExpView.this.backDebug();
            }
        };
        this.backDebugAction.setText("Backward");
        this.backDebugAction.setToolTipText("Backward");
        this.backDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_BACK);
        this.forwardDebugAction = new Action(){

            public void run() {
                RegExpView.this.forwardDebug();
            }
        };
        this.forwardDebugAction.setText("Forward");
        this.forwardDebugAction.setToolTipText("Forward");
        this.forwardDebugAction.setImageDescriptor(RegExpImages.ICON_DEBUG_FORWARD);
        this.validateAction = new Action(){

            public void run() {
                RegExpView.this.validateRegExp();
            }
        };
        this.validateAction.setText("Validate RegExp");
        this.validateAction.setToolTipText("Validate RegExp");
        this.validateAction.setImageDescriptor(RegExpImages.ICON_RUN);
        this.cutAction = new Action("Cut", RegExpImages.EDIT_CUT){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).cut();
            }
        };
        this.copyAction = new Action("Copy", RegExpImages.EDIT_COPY){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).copy();
            }
        };
        this.pasteAction = new Action("Paste", RegExpImages.EDIT_PASTE){

            public void run() {
                ((StyledText)RegExpView.this.activeInput).paste();
            }
        };
    }

    private void insertShortcut(String string) {
        int n = this.regExpText.getSelectionCount();
        int n2 = this.regExpText.getCaretOffset();
        this.regExpText.insert(string);
        if (n == 0) {
            this.regExpText.setCaretOffset(n2 + string.length());
        }
    }

    public void validateRegExp() {
        boolean bl = false;
        int n = 0;
        this.regExpText.setStyleRange(null);
        this.debugPosition = 0;
        if (this.ignoreCaseCheckBox.getSelection()) {
            n |= 2;
        }
        if (this.multilineCheckBox.getSelection()) {
            n |= 8;
        }
        try {
            RE rE = new RE((Object)this.regExpText.getText(), n);
            REMatch[] rEMatchArray = rE.getAllMatches((Object)this.matchText.getText());
            bl = rEMatchArray.length > 0;
            this.matchText.setStyleRange(null);
            int n2 = 0;
            while (n2 < rEMatchArray.length) {
                int n3 = 0;
                int n4 = 1;
                while (n4 <= rE.getNumSubs()) {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = rEMatchArray[n2].getStartIndex(n4);
                    styleRange.length = rEMatchArray[n2].getEndIndex(n4) - rEMatchArray[n2].getStartIndex(n4);
                    Display display = this.panel.getDisplay();
                    styleRange.foreground = display.getSystemColor(1);
                    styleRange.background = (Color)this.colorTable.get(n3);
                    this.matchText.setStyleRange(styleRange);
                    this.matchText.setTopIndex(styleRange.start);
                    this.matchText.setCaretOffset(styleRange.start);
                    int n5 = styleRange.start - this.matchText.getOffsetAtLine(this.matchText.getLineAtOffset(styleRange.start));
                    this.matchText.setHorizontalIndex(n5);
                    this.matchText.redraw();
                    if (++n3 > this.colorTable.size()) {
                        n3 = 0;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (REException rEException) {
            rEException.printStackTrace();
        }
        if (bl) {
            this.setResultLabelImage(RegExpImages.RESULT_GREEN);
        } else {
            this.setResultLabelImage(RegExpImages.RESULT_RED);
        }
    }

    public void setResultLabelImage(ImageDescriptor imageDescriptor) {
        Image image = new Image((Device)this.resultImageLabel.getDisplay(), imageDescriptor.getImageData());
        image.setBackground(this.panel.getBackground());
        this.resultImageLabel.setImage(image);
    }

    public void setFocus() {
    }

    private void buildDebugRegExp(String string, String string2) {
        String string3 = "";
        RE rE = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.debugInfo = new DebugInfo();
        this.debugInfo.setInput(string);
        this.debugInfo.setMatchString(string2);
        try {
            rE = new RE((Object)"\\[^.]");
            String string4 = rE.substitute((Object)string, "..");
            if (string4.indexOf(40) == -1) {
                int n4 = 0;
                while (n4 < string.length()) {
                    String string5;
                    String string6 = string.substring(n4, n4 + 1);
                    if (!bl) {
                        rE = new RE((Object)"[\\[\\{]");
                        if (rE.isMatch((Object)string6)) {
                            n3 = string3.length();
                            string3 = String.valueOf(string3) + "(" + string6;
                            bl = true;
                            n = n4;
                        } else {
                            if (!bl2) {
                                n3 = string3.length();
                                string3 = String.valueOf(string3) + "(";
                                n = n4;
                            } else {
                                bl2 = false;
                            }
                            string3 = String.valueOf(string3) + string6;
                            if (string6.equals("\\")) {
                                bl2 = true;
                            } else {
                                if (n4 + 1 < string.length() && (rE = new RE((Object)"[\\*\\+]")).isMatch((Object)(string5 = string.substring(n4 + 1, n4 + 2)))) {
                                    string3 = String.valueOf(string3) + string5;
                                    ++n4;
                                }
                                if (n4 + 1 < string.length() && (rE = new RE((Object)"[\\?]")).isMatch((Object)(string5 = string.substring(n4 + 1, n4 + 2)))) {
                                    string3 = String.valueOf(string3) + string5;
                                    ++n4;
                                }
                                string3 = String.valueOf(string3) + ")";
                                this.debugInfo.addSubexpressionPosition(n, n4 + 1);
                                this.debugInfo.addBracketPosition(n3, string3.length() - 1);
                            }
                        }
                    } else {
                        rE = new RE((Object)"[\\]\\}]");
                        if (rE.isMatch((Object)string6)) {
                            if (n4 + 1 < string.length()) {
                                string5 = string.substring(n4 + 1, n4 + 2);
                                if (string5.equals("{")) {
                                    string3 = String.valueOf(string3) + string6 + string5;
                                    ++n4;
                                } else {
                                    rE = new RE((Object)"[\\+\\*]");
                                    if (rE.isMatch((Object)string5)) {
                                        string3 = String.valueOf(string3) + string6 + string5;
                                        if (++n4 + 1 < string.length() && (rE = new RE((Object)"[\\?]")).isMatch((Object)(string5 = string.substring(n4 + 1, n4 + 2)))) {
                                            string3 = String.valueOf(string3) + string5;
                                            ++n4;
                                        }
                                        string3 = String.valueOf(string3) + ")";
                                        this.debugInfo.addSubexpressionPosition(n, n4 + 1);
                                        this.debugInfo.addBracketPosition(n3, string3.length() - 1);
                                        bl = false;
                                    } else {
                                        string3 = String.valueOf(string3) + string6 + ")";
                                        this.debugInfo.addSubexpressionPosition(n, n4 + 1);
                                        this.debugInfo.addBracketPosition(n3, string3.length() - 1);
                                        bl = false;
                                    }
                                }
                            } else {
                                string3 = String.valueOf(string3) + string6 + ")";
                                this.debugInfo.addSubexpressionPosition(n, n4 + 1);
                                this.debugInfo.addBracketPosition(n3, string3.length() - 1);
                                bl = false;
                            }
                        } else {
                            string3 = String.valueOf(string3) + string6;
                        }
                    }
                    ++n4;
                }
            } else {
                string3 = string;
                rE = new RE((Object)"\\((.*?)\\)");
                REMatch[] rEMatchArray = rE.getAllMatches((Object)string4);
                int n5 = 0;
                while (n5 < rEMatchArray.length) {
                    int n6 = 1;
                    while (n6 <= rE.getNumSubs()) {
                        n = rEMatchArray[n5].getStartIndex(n6);
                        n2 = rEMatchArray[n5].getEndIndex(n6);
                        this.debugInfo.addSubexpressionPosition(n, n2);
                        this.debugInfo.addBracketPosition(n, n2);
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        catch (Exception exception) {
            string3 = null;
            exception.printStackTrace();
        }
        this.debugInfo.setRegexp(string3);
    }

    private void resetDebug() {
        this.debugPosition = 0;
        this.regExpText.setStyleRange(null);
        this.matchText.setStyleRange(null);
        this.setResultLabelImage(RegExpImages.RESULT_GRAY);
    }

    private void backDebug() {
        this.showDebugResult(this.debugPosition - 1);
    }

    private void forwardDebug() {
        this.showDebugResult(this.debugPosition + 1);
    }

    private void showDebugResult(int n) {
        if (this.debugInfo == null) {
            this.buildDebugRegExp(this.regExpText.getText(), this.matchText.getText());
            n = 1;
        } else if (!this.debugInfo.getInput().equals(this.regExpText.getText()) || !this.debugInfo.getMatchString().equals(this.matchText.getText())) {
            this.buildDebugRegExp(this.regExpText.getText(), this.matchText.getText());
            n = 1;
        }
        if (n > this.debugInfo.getSubexpressionCount() || n < 1) {
            return;
        }
        REMatch[] rEMatchArray = this.debugInfo.getMatches(n - 1);
        this.debugPosition = n;
        StyleRange styleRange = new StyleRange();
        Display display = this.panel.getDisplay();
        styleRange.background = display.getSystemColor(9);
        styleRange.foreground = display.getSystemColor(1);
        SubexpressionPos subexpressionPos = this.debugInfo.getSubexpressionPosition(n - 1);
        this.regExpText.setStyleRange(null);
        styleRange.start = subexpressionPos.getStart();
        styleRange.length = subexpressionPos.getEnd() - subexpressionPos.getStart();
        this.regExpText.setStyleRange(styleRange);
        this.regExpText.setTopIndex(styleRange.start);
        this.regExpText.setCaretOffset(styleRange.start);
        int n2 = styleRange.start - this.regExpText.getOffsetAtLine(this.regExpText.getLineAtOffset(styleRange.start));
        this.regExpText.setHorizontalIndex(n2);
        this.regExpText.redraw();
        this.matchText.setStyleRange(null);
        if (n <= this.debugInfo.geMatchingBracketsCount()) {
            this.setResultLabelImage(RegExpImages.RESULT_GREEN);
            int n3 = 0;
            while (n3 < rEMatchArray.length) {
                StyleRange styleRange2 = new StyleRange();
                styleRange2.background = display.getSystemColor(9);
                styleRange2.foreground = display.getSystemColor(1);
                styleRange2.start = rEMatchArray[n3].getStartIndex(n);
                styleRange2.length = rEMatchArray[n3].getEndIndex(n) - rEMatchArray[n3].getStartIndex(n);
                this.matchText.setStyleRange(styleRange2);
                this.matchText.setTopIndex(styleRange2.start);
                this.matchText.setCaretOffset(styleRange2.start);
                n2 = styleRange2.start - this.matchText.getOffsetAtLine(this.matchText.getLineAtOffset(styleRange2.start));
                this.matchText.setHorizontalIndex(n2);
                this.matchText.redraw();
                ++n3;
            }
        } else {
            this.setResultLabelImage(RegExpImages.RESULT_RED);
        }
    }

    public void setRegExpText(String string) {
        this.regExpText.setText(string);
    }

    public void setMatchText(String string) {
        this.matchText.setText(string);
    }

    public void setIgnoreCaseCheckbox(boolean bl) {
        this.ignoreCaseCheckBox.setSelection(bl);
    }

    public void setMultilineCheckbox(boolean bl) {
        this.multilineCheckBox.setSelection(bl);
    }

    class focusListener
    implements FocusListener {
        focusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            RegExpView.this.activeInput = focusEvent.getSource();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class DebugInfo {
        private List subexpressions = new ArrayList();
        private List bracketsInRegexp = new ArrayList();
        private List allMatches = new ArrayList();
        private String input;
        private String regexp;
        private String matchString;
        private boolean matchesInitialized = false;
        private int matchingBracketsCount = 0;
        int eflags = 0;

        public void setInput(String string) {
            this.input = string;
        }

        public void setRegexp(String string) {
            this.regexp = string;
        }

        public void setMatchString(String string) {
            this.matchString = string;
        }

        public String getInput() {
            return this.input;
        }

        public String getRegExp() {
            return this.regexp;
        }

        public String getMatchString() {
            return this.matchString;
        }

        public void addBracketPosition(int n, int n2) {
            this.bracketsInRegexp.add(new SubexpressionPos(n, n2));
        }

        public void addSubexpressionPosition(int n, int n2) {
            this.subexpressions.add(new SubexpressionPos(n, n2));
        }

        public SubexpressionPos getSubexpressionPosition(int n) {
            return (SubexpressionPos)this.subexpressions.get(n);
        }

        public int getSubexpressionCount() {
            return this.subexpressions.size();
        }

        public REMatch[] getMatches(int n) {
            int n2 = 0;
            if (RegExpView.this.ignoreCaseCheckBox.getSelection()) {
                n2 |= 2;
            }
            if (RegExpView.this.multilineCheckBox.getSelection()) {
                n2 |= 8;
            }
            if (!this.matchesInitialized || this.eflags != n2) {
                this.eflags = n2;
                this.initMatches();
            }
            return this.allMatches.toArray(new REMatch[0]);
        }

        public int geMatchingBracketsCount() {
            return this.matchingBracketsCount;
        }

        public void initMatches() {
            String string = null;
            boolean bl = false;
            RE rE = null;
            this.allMatches.clear();
            try {
                int n = this.bracketsInRegexp.size() - 1;
                while (n >= 0) {
                    SubexpressionPos subexpressionPos = (SubexpressionPos)this.bracketsInRegexp.get(n);
                    string = this.regexp.substring(0, subexpressionPos.getEnd() + 1);
                    rE = new RE((Object)string, this.eflags);
                    if (rE.getAllMatches((Object)this.matchString).length > 0) {
                        this.matchingBracketsCount = n + 1;
                        bl = true;
                        break;
                    }
                    --n;
                }
                if (rE != null && bl) {
                    REMatch[] rEMatchArray = rE.getAllMatches((Object)this.matchString);
                    int n2 = 0;
                    while (n2 < rEMatchArray.length) {
                        this.allMatches.add(rEMatchArray[n2]);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.matchesInitialized = true;
        }
    }

    class SubexpressionPos {
        int start;
        int end;

        public SubexpressionPos(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        private int getStart() {
            return this.start;
        }

        private int getEnd() {
            return this.end;
        }
    }
}

