/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.comment;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class RubyCommentAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;

    public RubyCommentAutoIndentStrategy(String string) {
        this.fPartitioning = string;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        String[] stringArray;
        int n;
        if (documentCommand.text != null && documentCommand.length == 0 && (n = TextUtilities.endsWith((String[])(stringArray = iDocument.getLegalLineDelimiters()), (String)documentCommand.text)) > -1) {
            if (stringArray[n].equals(documentCommand.text)) {
                this.indentAfterNewLine(iDocument, documentCommand);
            }
            return;
        }
    }

    private void indentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset;
        if (n == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            String string;
            String string2;
            int n2 = n == iDocument.getLength() ? n - 1 : n;
            int n3 = iDocument.getLineOfOffset(n2);
            IRegion iRegion = iDocument.getLineInformation(n3);
            if (!(n3 == 0 || this.isComment(string2 = this.getLine(iDocument, n3 + 1)) || this.isClassDefinition(string2) || this.isMethodDeclaration(string2) || this.isAttributeCall(string2) || this.isAliasCall(string2) || this.isModuleDeclaration(string2) || this.isConstantAssignment(string2) || this.isComment(string = this.getLine(iDocument, n3 - 1)))) {
                return;
            }
            int n4 = iRegion.getOffset();
            int n5 = this.findEndOfWhiteSpace(iDocument, n4, n);
            Assert.isTrue((n5 >= n4 ? 1 : 0) != 0, (String)"indentation must not be negative");
            StringBuffer stringBuffer = new StringBuffer(documentCommand.text);
            IRegion iRegion2 = this.findPrefixRange(iDocument, iRegion);
            String string3 = iDocument.get(iRegion2.getOffset(), iRegion2.getLength());
            int n6 = Math.min(n - iRegion2.getOffset(), iRegion2.getLength());
            stringBuffer.append(string3.substring(0, n6));
            if (n6 < iRegion2.getLength()) {
                documentCommand.caretOffset = n + iRegion2.getLength() - n6;
            }
            documentCommand.text = stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isComment(String string) {
        return string.matches("^\\s*#.*");
    }

    private boolean isClassDefinition(String string) {
        return string.matches("^\\s*class\\s+.+\\s*");
    }

    private boolean isAliasCall(String string) {
        return string.matches("^\\s*alias\\s+.+\\s*");
    }

    private boolean isModuleDeclaration(String string) {
        return string.matches("^\\s*module\\s+.+\\s*");
    }

    private boolean isMethodDeclaration(String string) {
        return string.matches("^\\s*def\\s+.+\\s*");
    }

    private boolean isAttributeCall(String string) {
        return string.matches("^\\s*attr.+\\s*");
    }

    private boolean isConstantAssignment(String string) {
        return string.matches("^\\s*[A-Z_]+\\s?=\\s+.+\\s*");
    }

    private String getLine(IDocument iDocument, int n) throws BadLocationException {
        IRegion iRegion = iDocument.getLineInformation(n + 1);
        return iDocument.get(iRegion.getOffset(), iRegion.getLength());
    }

    private IRegion findPrefixRange(IDocument iDocument, IRegion iRegion) throws BadLocationException {
        int n;
        int n2 = iRegion.getOffset();
        int n3 = this.findEndOfWhiteSpace(iDocument, n2, n = n2 + iRegion.getLength());
        if (n3 < n && iDocument.getChar(n3) == '#') {
            ++n3;
            while (n3 < n && iDocument.getChar(n3) == ' ') {
                ++n3;
            }
        }
        return new Region(n2, n3 - n2);
    }
}

