/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.ReplaceableIconAction;
import org.tigris.subversion.subclipse.ui.util.IPromptCondition;

public abstract class SVNAction
extends ReplaceableIconAction {
    private List accumulatedStatus = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public final void run(IAction action) {
        try {
            if (!this.beginExecution(action)) {
                return;
            }
            this.execute(action);
            this.endExecution();
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            this.handle(null);
        }
    }

    protected boolean beginExecution(IAction action) {
        this.accumulatedStatus.clear();
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors();
    }

    protected abstract void execute(IAction var1) throws InvocationTargetException, InterruptedException;

    protected void endExecution() {
        if (!this.accumulatedStatus.isEmpty()) {
            this.handle(null);
        }
    }

    protected void addStatus(IStatus status) {
        this.accumulatedStatus.add(status);
    }

    protected IStatus[] getAccumulatedStatus() {
        return this.accumulatedStatus.toArray(new IStatus[this.accumulatedStatus.size()]);
    }

    protected String getErrorTitle() {
        return Policy.bind("SVNAction.errorTitle");
    }

    protected String getWarningTitle() {
        return Policy.bind("SVNAction.warningTitle");
    }

    protected String getMultiStatusMessage() {
        return Policy.bind("SVNAction.multipleProblemsMessage");
    }

    protected IStatus getStatusToDisplay(IStatus[] problems) {
        if (problems.length == 1) {
            return problems[0];
        }
        MultiStatus combinedStatus = new MultiStatus("org.tigris.subversion.subclipse.ui", 0, this.getMultiStatusMessage(), null);
        int i = 0;
        while (i < problems.length) {
            combinedStatus.merge(problems[i]);
            ++i;
        }
        return combinedStatus;
    }

    protected void handle(Exception exception) {
        ArrayList<IStatus> problems = new ArrayList<IStatus>();
        IStatus[] status = this.getAccumulatedStatus();
        if (status != null) {
            int i = 0;
            while (i < status.length) {
                IStatus iStatus = status[i];
                if (!iStatus.isOK() || iStatus.getCode() == -10) {
                    problems.add(iStatus);
                }
                ++i;
            }
        }
        if (problems.size() == 0) {
            if (exception == null) {
                return;
            }
            this.handle(exception, this.getErrorTitle(), null);
            return;
        }
        if (exception != null) {
            this.handle(exception, this.getErrorTitle(), null);
        }
        String message = null;
        IStatus statusToDisplay = this.getStatusToDisplay(problems.toArray(new IStatus[problems.size()]));
        if (statusToDisplay.isOK()) {
            return;
        }
        if (statusToDisplay.isMultiStatus() && statusToDisplay.getChildren().length == 1) {
            message = statusToDisplay.getMessage();
            statusToDisplay = statusToDisplay.getChildren()[0];
        }
        String title = statusToDisplay.getSeverity() == 4 ? this.getErrorTitle() : this.getWarningTitle();
        SVNUIPlugin.openError(this.getShell(), title, message, new SVNException(statusToDisplay));
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNUIPlugin.getPlugin().getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    public static Object getAdapter(Object selection, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(selection)) {
            return selection;
        }
        if (selection instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)selection).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected ISVNRemoteFolder[] getSelectedRemoteFolders() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ISVNRemoteFolder) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.tigris.subversion.subclipse.core.ISVNRemoteFolder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ISVNRemoteFolder)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            return resources.toArray(new ISVNRemoteFolder[resources.size()]);
        }
        return new ISVNRemoteFolder[0];
    }

    protected ISVNRemoteFile[] getSelectedRemoteFiles() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ISVNRemoteFile) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.tigris.subversion.subclipse.core.ISVNRemoteFile");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ISVNRemoteFile)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ISVNRemoteFile[] result = new ISVNRemoteFile[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ISVNRemoteFile[0];
    }

    protected ISVNRemoteResource[] getSelectedRemoteResources() {
        ArrayList<Object> resources = null;
        if (!this.selection.isEmpty()) {
            resources = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object adapter;
                Object next = elements.next();
                if (next instanceof ISVNRemoteResource) {
                    resources.add(next);
                    continue;
                }
                if (!(next instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)next;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.tigris.subversion.subclipse.core.ISVNRemoteResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((adapter = a.getAdapter((Class)clazz)) instanceof ISVNRemoteResource)) continue;
                resources.add(adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ISVNRemoteResource[] result = new ISVNRemoteResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ISVNRemoteResource[0];
    }

    private boolean saveAllEditors() {
        final int option = SVNUIPlugin.getPlugin().getPreferenceStore().getInt("pref_save_dirty_editors");
        final boolean[] okToContinue = new boolean[]{true};
        if (option != 1) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    boolean confirm = option == 2;
                    okToContinue[0] = PlatformUI.getWorkbench().saveAllEditors(confirm);
                }
            });
        }
        return okToContinue[0];
    }

    protected void handle(Exception exception, String title, String message) {
        SVNUIPlugin.openError(this.getShell(), title, message, exception, 12);
    }

    public static IPromptCondition getOverwriteLocalChangesPrompt(IResource[] dirtyResources) {
        return new IPromptCondition(dirtyResources){
            List resources;
            {
                this.resources = Arrays.asList(iResourceArray);
            }

            public boolean needsPrompt(IResource resource) {
                return this.resources.contains(resource);
            }

            public String promptMessage(IResource resource) {
                return Policy.bind("ReplaceWithAction.localChanges", resource.getName());
            }
        };
    }
}

