/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.document.ComponentDeclarationEntry;
import org.eclipse.wst.common.core.search.document.Entry;
import org.eclipse.wst.common.core.search.document.FileReferenceEntry;
import org.eclipse.wst.common.core.search.document.SearchDocument;
import org.eclipse.wst.common.core.search.document.SearchDocumentSet;
import org.eclipse.wst.common.core.search.pattern.ComponentSearchPattern;
import org.eclipse.wst.common.core.search.pattern.FileReferencePattern;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.ContentTypeSearchScope;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.search.ComponentSearchContributor;
import org.eclipse.wst.xml.core.internal.search.XMLComponentDeclarationPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentReferencePattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentSearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLSearchPattern;
import org.eclipse.wst.xml.core.internal.search.impl.XMLSearchDocument;
import org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher;
import org.eclipse.wst.xml.core.internal.search.matching.XMLSearchPatternMatcher;
import org.eclipse.wst.xml.core.internal.search.quickscan.XMLQuickScan;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLSearchParticipant
extends SearchParticipant {
    protected static final boolean debugPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.xml.core.internal.search/perf"));
    static /* synthetic */ Class class$0;

    public SearchDocument createSearchDocument(String documentPath) {
        return new XMLSearchDocument(documentPath, this);
    }

    public String getDescription() {
        return "XML search participant";
    }

    private void locateMatches(SearchPattern pattern, SearchDocument document, SearchRequestor requestor, Map searchOptions, IProgressMonitor monitor) {
        if (pattern.getMatchRule() == 2) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(document.getPath()));
            Entry[] entries = document.getEntries("componentDecl", null, 0);
            int i = 0;
            while (i < entries.length) {
                ComponentDeclarationEntry entry = (ComponentDeclarationEntry)entries[i];
                SearchMatch searchMatch = new SearchMatch(null, 0, 0, file);
                searchMatch.map.put("name", entry.getName());
                searchMatch.map.put("metaName", entry.getMetaName());
                try {
                    requestor.acceptSearchMatch(searchMatch);
                }
                catch (Exception exception) {}
                ++i;
            }
        } else if (document.getModel() instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)document.getModel();
            IDOMElement contextNode = (IDOMElement)domModel.getDocument().getDocumentElement();
            DOMVisitor visitor = new DOMVisitor(document.getPath(), pattern, requestor);
            visitor.visit(contextNode);
        }
    }

    private PatternMatcher getAdapter(Object adaptableObject, Class adapterType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapterType) && (adaptableObject instanceof XMLSearchPattern || adaptableObject instanceof XMLComponentSearchPattern)) {
            return new XMLSearchPatternMatcher();
        }
        return null;
    }

    public SearchScope selectDocumentLocations(SearchPattern pattern, SearchScope scope, Map searchOptions, IProgressMonitor monitor) {
        String[] contentTypes = this.getSupportedContentTypes();
        if (contentTypes != null && contentTypes.length > 0) {
            scope = new ContentTypeSearchScope(scope, contentTypes);
        }
        return super.selectDocumentLocations(pattern, scope, searchOptions, monitor);
    }

    public abstract ComponentSearchContributor getSearchContributor();

    public void beginSearching(SearchPattern pattern, Map searchOptions) {
        super.beginSearching(pattern, searchOptions);
        if (pattern instanceof XMLComponentDeclarationPattern) {
            XMLComponentDeclarationPattern componentPattern = (XMLComponentDeclarationPattern)pattern;
            XMLSearchPattern childPattern = this.getSearchContributor().getDeclarationPattern(componentPattern.getMetaName());
            if (childPattern != null) {
                childPattern.setSearchName(componentPattern.getName().getLocalName());
                childPattern.setSearchNamespace(componentPattern.getName().getNamespace());
                componentPattern.setChildren(new XMLSearchPattern[]{childPattern});
            }
        } else if (pattern instanceof XMLComponentReferencePattern) {
            XMLComponentReferencePattern componentPattern = (XMLComponentReferencePattern)pattern;
            XMLSearchPattern[] childPatterns = this.getSearchContributor().getReferencesPatterns(componentPattern.getMetaName());
            int i = 0;
            while (i < childPatterns.length) {
                XMLSearchPattern childPattern = childPatterns[i];
                childPattern.setSearchName(componentPattern.getName().getLocalName());
                childPattern.setSearchNamespace(componentPattern.getName().getNamespace());
                ++i;
            }
            componentPattern.setChildren(childPatterns);
        }
    }

    public abstract String[] getSupportedContentTypes();

    public void populateSearchDocument(SearchDocument document, SearchPattern pattern) {
        PatternMatcher matcher;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((matcher = (PatternMatcher)pattern.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            matcher = this.getAdapter(pattern, clazz2);
        }
        XMLQuickScan.populateSearchDocument(document, matcher, pattern);
    }

    public void locateMatches(SearchDocumentSet documentSet, SearchPattern pattern, SearchScope scope, SearchRequestor requestor, Map searchOptions, IProgressMonitor monitor) throws CoreException {
        long time = System.currentTimeMillis();
        IFile targetFile = null;
        if (pattern instanceof ComponentSearchPattern) {
            ComponentSearchPattern componentSearchPattern = (ComponentSearchPattern)pattern;
            targetFile = componentSearchPattern.getFile();
        }
        IFile[] files = scope.enclosingFiles();
        int i = 0;
        while (i < files.length) {
            Entry[] entries;
            IFile file = files[i];
            String path = file.getLocation().toString();
            SearchDocument document = documentSet.getSearchDocument(path, this.id);
            if (document != null && ((entries = document.getEntries(XMLSearchParticipant.getSearchEntryCategory(pattern), null, 0)) != null && entries.length > 0 || searchOptions != null && searchOptions.get("searchDirtyContent") != null)) {
                boolean isInScope = true;
                if (targetFile != null) {
                    try {
                        isInScope = this.isLinked(documentSet, "file:///" + path, "file:///" + targetFile.getLocation().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (isInScope) {
                    this.locateMatches(pattern, document, requestor, searchOptions, monitor);
                }
            }
            ++i;
        }
        if (debugPerf) {
            System.out.println(this.getDescription() + ": " + (System.currentTimeMillis() - time) + "ms for locateMatches");
        }
    }

    private boolean isLinked(SearchDocumentSet set, String source, String target) {
        return this.isLinked(set, source, target, new HashMap());
    }

    private boolean isLinked(SearchDocumentSet set, String source, String target, HashMap visited) {
        SearchDocument document;
        if (source.equals(target)) {
            return true;
        }
        String fileProtocol = "file:///";
        if (source.startsWith(fileProtocol) && (document = set._tempGetSearchDocumetn(source.substring(fileProtocol.length()))) != null) {
            URIResolver uriResolver = URIResolverPlugin.createResolver();
            Entry[] entries = document.getEntries("outLink", null, 0);
            String[] resolveEntry = new String[entries.length];
            int j = 0;
            while (j < entries.length) {
                FileReferenceEntry fileReferenceEntry;
                Entry entry = entries[j];
                if (entry instanceof FileReferenceEntry && (fileReferenceEntry = (FileReferenceEntry)entry).getRelativeFilePath() != null) {
                    String resolvedURI;
                    resolveEntry[j] = resolvedURI = uriResolver.resolve(source, null, fileReferenceEntry.getRelativeFilePath());
                    if (resolvedURI.equals(target)) {
                        return true;
                    }
                }
                ++j;
            }
            if (visited.get(source) == null) {
                visited.put(source, Boolean.TRUE);
                j = 0;
                while (j < entries.length) {
                    String resolvedURI = resolveEntry[j];
                    if (resolvedURI != null && this.isLinked(set, resolveEntry[j], target, visited)) {
                        return true;
                    }
                    ++j;
                }
            }
        }
        return false;
    }

    public static String getSearchEntryCategory(SearchPattern pattern) {
        if (pattern instanceof XMLComponentDeclarationPattern) {
            return "componentDecl";
        }
        if (pattern instanceof XMLComponentReferencePattern) {
            return "componentDecl";
        }
        if (pattern instanceof FileReferencePattern) {
            return "componentDecl";
        }
        return null;
    }

    private class DOMVisitor {
        String path;
        SearchPattern pattern;
        SearchRequestor requestor;
        PatternMatcher matcher;
        static /* synthetic */ Class class$0;

        protected DOMVisitor(String path, SearchPattern pattern, SearchRequestor requestor) {
            this.path = path;
            this.pattern = pattern;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.matcher = (PatternMatcher)pattern.getAdapter((Class)clazz);
            if (this.matcher == null) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.search.matching.PatternMatcher");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.matcher = XMLSearchParticipant.this.getAdapter(pattern, clazz2);
            }
            this.requestor = requestor;
        }

        private void visit(Node node) {
            if (node.getNodeType() == 1) {
                this.match((Element)node);
                NodeList nodeList = node.getChildNodes();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node aNode = nodeList.item(i);
                    this.visit(aNode);
                    ++i;
                }
            }
        }

        private void match(Element node) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.path));
            if (this.matcher != null) {
                this.matcher.locateMatches(this.pattern, file, node, this.requestor);
            }
        }
    }
}

