/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class WSI3021
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3021(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        TModel tModel = UDDIUtils.getTModelByKey(this.validator.uddiProxy, UDDIUtils.getWSIConformanceTModelKey(this.validator.uddiProxy));
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
        } else {
            boolean validURL = tModel.getOverviewDoc() != null && "http://ws-i.org/schemas/conformanceClaim/".equals(tModel.getOverviewDoc().getOverviewURLString());
            boolean validCategory = this.checkCategoryBag(tModel.getCategoryBag());
            if (validURL && validCategory) {
                this.result = "passed";
            } else {
                this.result = "failed";
                this.failureDetailMessage = this.validator.uddiReference.getInquiryURL();
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private boolean checkCategoryBag(CategoryBag bag) {
        boolean result = false;
        if (bag != null) {
            Vector references = bag.getKeyedReferenceVector();
            int i = 0;
            while (i < references.size() && !result) {
                KeyedReference ref = (KeyedReference)references.get(i);
                result = "uddi-org:types:categorization".equals(ref.getKeyName()) && "categorization".equals(ref.getKeyValue()) && "uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4".equals(ref.getTModelKey());
                ++i;
            }
        }
        return result;
    }
}

