/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.wst.rdb.server.internal.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.rdb.connection.internal.ui.filter.SchemaFilterWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

/**
 * @author ledunnel
*/
public class EditSchemaFilterWizardPage extends SchemaFilterWizardPage{

    /**
     * @param pageName
     */
    public EditSchemaFilterWizardPage(String pageName) {
        super(pageName);
        setTitle(ResourceLoader.INSTANCE.queryString("_UI_TITLE_FILTER"));      //$NON-NLS-1$
    }
    public IWizardPage getPreviousPage() {
        return null;
    }
    public void createControl(Composite composite){
        super.createControl(composite);
        this.setPageComplete(true);
    }
    
    public void setVisible(boolean visible){
        if  (visible){
           setConnectionInfo(((EditConnectionWizard) getWizard()).getDBConnection(false)); 
        this.setPageComplete(validatePage());
        }
        super.setVisible(visible);   
    }
}
