/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJProjectDescription;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;

class VAJRemoteUtil
implements VAJUtil {
    Task caller;
    String remoteServer;

    public VAJRemoteUtil(Task caller, String remote) {
        this.caller = caller;
        this.remoteServer = remote;
    }

    public void exportPackages(File destDir, String[] includePatterns, String[] excludePatterns, boolean exportClasses, boolean exportDebugInfo, boolean exportResources, boolean exportSources, boolean useDefaultExcludes, boolean overwrite) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajexport";
            Vector<URLParam> parameters = new Vector<URLParam>();
            parameters.addElement(new URLParam("deb", exportDebugInfo));
            parameters.addElement(new URLParam("owr", overwrite));
            this.assembleImportExportParams(parameters, destDir, includePatterns, excludePatterns, exportClasses, exportResources, exportSources, useDefaultExcludes);
            this.sendRequest(request, parameters);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void importFiles(String importProject, File srcDir, String[] includePatterns, String[] excludePatterns, boolean importClasses, boolean importResources, boolean importSources, boolean useDefaultExcludes) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajimport";
            Vector<URLParam> parameters = new Vector<URLParam>();
            parameters.addElement(new URLParam("project", importProject));
            this.assembleImportExportParams(parameters, srcDir, includePatterns, excludePatterns, importClasses, importResources, importSources, useDefaultExcludes);
            this.sendRequest(request, parameters);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void assembleImportExportParams(Vector parameters, File dir, String[] includePatterns, String[] excludePatterns, boolean includeClasses, boolean includeResources, boolean includeSources, boolean useDefaultExcludes) {
        int i;
        parameters.addElement(new URLParam("dir", dir.getPath()));
        parameters.addElement(new URLParam("cls", includeClasses));
        parameters.addElement(new URLParam("res", includeResources));
        parameters.addElement(new URLParam("src", includeSources));
        parameters.addElement(new URLParam("dex", useDefaultExcludes));
        if (includePatterns != null) {
            i = 0;
            while (i < includePatterns.length) {
                parameters.addElement(new URLParam("include", includePatterns[i]));
                ++i;
            }
        }
        if (excludePatterns != null) {
            i = 0;
            while (i < excludePatterns.length) {
                parameters.addElement(new URLParam("exclude", excludePatterns[i]));
                ++i;
            }
        }
    }

    public void loadProjects(Vector projectDescriptions) {
        try {
            String request = "http://" + this.remoteServer + "/servlet/vajload";
            Vector<URLParam> parameters = new Vector<URLParam>();
            Enumeration e = projectDescriptions.elements();
            while (e.hasMoreElements()) {
                VAJProjectDescription pd = (VAJProjectDescription)e.nextElement();
                parameters.addElement(new URLParam("project", pd.getName()));
                parameters.addElement(new URLParam("version", pd.getVersion()));
            }
            this.sendRequest(request, parameters);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void log(String msg, int level) {
        this.caller.log(msg, level);
    }

    private void sendRequest(String request, Vector parameters) {
        boolean requestFailed = false;
        String url = request + "?";
        int i = 0;
        while (i < parameters.size()) {
            URLParam p = (URLParam)parameters.elementAt(i);
            url = url + p.getName() + "=" + URLEncoder.encode(p.getValue());
            url = url + (i == parameters.size() - 1 ? "" : "&");
            ++i;
        }
        try {
            this.log("Request: " + url, 4);
            URL requestUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
            InputStream is = null;
            int i2 = 0;
            while (i2 < 3) {
                try {
                    is = connection.getInputStream();
                    break;
                }
                catch (IOException ex) {
                    ++i2;
                }
            }
            if (is == null) {
                this.log("Can't get " + url, 0);
                throw new BuildException("Couldn't execute " + url);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = br.readLine();
            while (line != null) {
                int level = 0;
                try {
                    level = Integer.parseInt(line.substring(0, 1));
                    if (level == 0) {
                        requestFailed = true;
                    }
                }
                catch (Exception e) {
                    this.log("Response line doesn't contain log level!", 0);
                }
                this.log(line.substring(2), level);
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            this.log("Error sending tool request to VAJ" + ex, 0);
            throw new BuildException("Couldn't execute " + url);
        }
        if (requestFailed) {
            throw new BuildException("VAJ tool request failed");
        }
    }

    private class URLParam {
        private String name;
        private String value;

        public URLParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public URLParam(String name, boolean value) {
            this.name = name;
            this.value = new Boolean(value).toString();
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

