/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.observable;

import java.util.ArrayList;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.description.Property;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IListChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;
import org.eclipse.jface.util.Assert;

public class NestedObservableList
extends ObservableList {
    private boolean updating = false;
    private IListChangeListener innerChangeListener = new IListChangeListener(){

        public void handleListChange(IObservableList source, ListDiff diff) {
            if (!NestedObservableList.this.updating) {
                NestedObservableList.this.fireListChange(diff);
            }
        }
    };
    private Object currentOuterValue;
    private Object feature;
    private IObservableList innerObservableList;
    private DataBindingContext databindingContext;
    private IObservableValue outerObservableValue;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            ArrayList oldList = new ArrayList(NestedObservableList.this.wrappedList);
            NestedObservableList.this.updateInnerObservableValue(NestedObservableList.this.outerObservableValue);
            NestedObservableList.this.fireListChange(Diffs.computeListDiff(oldList, NestedObservableList.this.wrappedList));
        }
    };

    public NestedObservableList(DataBindingContext databindingContext, IObservableValue outerObservableValue, Object feature, Class featureType) {
        super(new ArrayList(), featureType);
        this.databindingContext = databindingContext;
        this.feature = feature;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableValue(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableList = null;
            this.wrappedList = new ArrayList();
        } else {
            this.innerObservableList = (IObservableList)this.databindingContext.createObservable(new Property(this.currentOuterValue, this.feature, (Class)this.getElementType(), Boolean.TRUE));
            this.wrappedList = this.innerObservableList;
            Object innerValueType = this.innerObservableList.getElementType();
            Assert.isTrue((boolean)this.getElementType().equals(innerValueType), (String)"Cannot change value type in a nested updatable value");
            this.innerObservableList.addListChangeListener(this.innerChangeListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
            this.outerObservableValue.dispose();
        }
        if (this.innerObservableList != null) {
            this.innerObservableList.removeListChangeListener(this.innerChangeListener);
            this.innerObservableList.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.feature = null;
        this.innerObservableList = null;
        this.innerChangeListener = null;
    }
}

