/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Entry;
import gnu.classpath.tools.jar.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;

public class Main {
    Class operationMode;
    File archiveFile;
    int storageMode;
    boolean readNamesFromStdin;
    boolean verbose;
    boolean wantManifest;
    File manifestFile;
    ArrayList entries;
    String changedDirectory;

    private /* synthetic */ void finit$() {
        this.storageMode = 8;
        this.readNamesFromStdin = false;
        this.verbose = false;
        this.wantManifest = true;
        this.entries = new ArrayList();
    }

    void setArchiveFile(String string) throws OptionException {
        if (this.archiveFile != null) {
            String string2 = MessageFormat.format(Messages.getString("Main.ArchiveAlreadySet"), this.archiveFile);
            throw new OptionException(string2);
        }
        this.archiveFile = new File(string);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Parser initializeParser() {
        JarParser jarParser = new JarParser(this, "jar");
        jarParser.setHeader(Messages.getString("Main.Usage"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("Main.OpMode"));
        optionGroup.add(new ModeOption(this, 'c', Messages.getString("Main.Create"), Main.class$("gnu.classpath.tools.jar.Creator")));
        optionGroup.add(new ModeOption(this, 'x', Messages.getString("Main.Extract"), Main.class$("gnu.classpath.tools.jar.Extractor")));
        optionGroup.add(new ModeOption(this, 't', Messages.getString("Main.List"), Main.class$("gnu.classpath.tools.jar.Lister")));
        optionGroup.add(new ModeOption(this, 'u', Messages.getString("Main.Update"), Main.class$("gnu.classpath.tools.jar.Updater")));
        optionGroup.add(new ModeOption(this, 'i', Messages.getString("Main.Index"), Messages.getString("Main.FileArg"), Main.class$("gnu.classpath.tools.jar.Indexer")));
        jarParser.add(optionGroup);
        optionGroup = new OptionGroup(Messages.getString("Main.OpMods"));
        optionGroup.add(new Option(this, 'f', Messages.getString("Main.ArchiveName"), Messages.getString("Main.FileArg2")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.setArchiveFile(string);
            }
        });
        optionGroup.add(new Option(this, '0', Messages.getString("Main.NoZip")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.storageMode = 0;
            }
        });
        optionGroup.add(new Option(this, 'v', Messages.getString("Main.Verbose")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        optionGroup.add(new Option(this, 'M', Messages.getString("Main.NoManifest")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.wantManifest = false;
            }
        });
        optionGroup.add(new Option(this, 'm', Messages.getString("Main.ManifestName"), Messages.getString("Main.ManifestArgName")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.manifestFile = new File(string);
            }
        });
        jarParser.add(optionGroup);
        optionGroup = new OptionGroup(Messages.getString("Main.FileNameGroup"));
        optionGroup.add(new Option(this, 'C', Messages.getString("Main.ChangeDir"), Messages.getString("Main.ChangeDirArg")){
            private /* synthetic */ Main this$0;
            {
                this.this$0 = main;
                super(c, string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.changedDirectory = string;
            }
        });
        jarParser.add(optionGroup);
        return jarParser;
    }

    private void run(String[] stringArray) throws InstantiationException, IllegalAccessException, IOException {
        Parser parser = this.initializeParser();
        if (stringArray.length > 0 && stringArray[0].charAt(0) != '-') {
            stringArray[0] = '-' + stringArray[0];
        }
        parser.parse(stringArray, new HandleFile(this));
        Action action = (Action)this.operationMode.newInstance();
        action.run(this);
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        try {
            main.run(stringArray);
        }
        catch (Exception exception) {
            System.err.println(Messages.getString("Main.InternalError"));
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public Main() {
        this.finit$();
    }

    private class JarParser
    extends ClasspathToolParser {
        private /* synthetic */ Main this$0;

        public JarParser(Main main, String string) {
            this.this$0 = main;
            super(string);
        }

        protected void validate() throws OptionException {
            if (this.this$0.operationMode == null) {
                throw new OptionException(Messages.getString("Main.MustSpecify"));
            }
            if (this.this$0.changedDirectory != null) {
                throw new OptionException(Messages.getString("Main.TwoArgsReqd"));
            }
            if (!this.this$0.wantManifest && this.this$0.manifestFile != null) {
                throw new OptionException(Messages.getString("Main.CantHaveBoth"));
            }
            if (this.this$0.operationMode == Main.class$("gnu.classpath.tools.jar.Indexer")) {
                if (!this.this$0.entries.isEmpty()) {
                    throw new OptionException(Messages.getString("Main.NoFilesWithi"));
                }
                if (!this.this$0.wantManifest) {
                    throw new OptionException(Messages.getString("Main.NoMAndi"));
                }
                if (this.this$0.manifestFile != null) {
                    throw new OptionException(Messages.getString("Main.AnotherNomAndi"));
                }
            }
        }
    }

    private class ModeOption
    extends Option {
        private /* synthetic */ Main this$0;
        private Class mode;

        public ModeOption(Main main, char c, String string, Class clazz) {
            this.this$0 = main;
            super(c, string);
            this.mode = clazz;
        }

        public ModeOption(Main main, char c, String string, String string2, Class clazz) {
            this.this$0 = main;
            super(c, string, string2);
            this.mode = clazz;
        }

        public void parsed(String string) throws OptionException {
            if (this.this$0.operationMode != null) {
                throw new OptionException(Messages.getString("Main.ModeAlreaySet"));
            }
            this.this$0.operationMode = this.mode;
            if (string != null) {
                this.this$0.setArchiveFile(string);
            }
        }
    }

    class HandleFile
    extends FileArgumentCallback {
        private /* synthetic */ Main this$0;

        public void notifyFile(String string) {
            Entry entry;
            if (this.this$0.changedDirectory != null) {
                entry = new Entry(new File(this.this$0.changedDirectory, string), string);
                this.this$0.changedDirectory = null;
            } else {
                entry = new Entry(new File(string));
            }
            this.this$0.entries.add(entry);
        }

        HandleFile(Main main) {
            this.this$0 = main;
        }
    }
}

