/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkDialogPeer;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.event.PaintEvent;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;

public class GtkFileDialogPeer
extends GtkDialogPeer
implements FileDialogPeer {
    static final String FS = System.getProperty("file.separator");
    private String currentFile;
    private String currentDirectory;
    private FilenameFilter filter;

    private /* synthetic */ void finit$() {
        this.currentFile = null;
        this.currentDirectory = null;
    }

    native void create(GtkContainerPeer var1, int var2);

    native void connectSignals();

    native void nativeSetFile(String var1);

    public native String nativeGetDirectory();

    public native void nativeSetDirectory(String var1);

    native void nativeSetFilenameFilter(FilenameFilter var1);

    public void create() {
        this.create((GtkContainerPeer)this.awtComponent.getParent().getPeer(), ((FileDialog)this.awtComponent).getMode());
        FileDialog fileDialog = (FileDialog)this.awtComponent;
        this.nativeSetDirectory(System.getProperty("user.dir"));
        this.setDirectory(fileDialog.getDirectory());
        this.setFile(fileDialog.getFile());
        FilenameFilter filenameFilter = fileDialog.getFilenameFilter();
        if (filenameFilter != null) {
            this.setFilenameFilter(filenameFilter);
        }
    }

    public GtkFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
        this.finit$();
    }

    void setComponentBounds() {
        if (this.awtComponent.getHeight() == 0 && this.awtComponent.getWidth() == 0) {
            int[] nArray = new int[2];
            this.gtkWidgetGetPreferredDimensions(nArray);
            if (nArray[0] != this.awtComponent.getWidth() || nArray[1] != this.awtComponent.getHeight()) {
                this.awtComponent.setSize(nArray[0], nArray[1]);
            }
        }
        super.setComponentBounds();
    }

    public void setFile(String string) {
        if (string == null && this.currentFile == null || string != null && string.equals(this.currentFile)) {
            return;
        }
        if (string == null || string.equals("")) {
            this.currentFile = "";
            this.nativeSetFile("");
            return;
        }
        this.currentFile = string;
        if (string.indexOf(FS) == 0) {
            this.nativeSetFile(string);
        } else {
            this.nativeSetFile(this.nativeGetDirectory() + FS + string);
        }
    }

    public void setDirectory(String string) {
        if (string == null && this.currentDirectory == null || string != null && string.equals(this.currentDirectory)) {
            return;
        }
        if (string == null || string.equals("")) {
            this.currentDirectory = FS;
            this.nativeSetDirectory(FS);
            return;
        }
        this.currentDirectory = string;
        if (string.indexOf(FS) == 0) {
            this.nativeSetDirectory(string);
        } else {
            this.nativeSetDirectory(this.nativeGetDirectory() + FS + string);
        }
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
        this.nativeSetFilenameFilter(filenameFilter);
    }

    boolean filenameFilterCallback(String string) {
        String string2 = string.substring(string.lastIndexOf(FS) + 1);
        String string3 = string.substring(0, string.lastIndexOf(FS));
        File file = new File(string3);
        return this.filter.accept(file, string2);
    }

    protected void updateComponent(PaintEvent paintEvent) {
    }

    void gtkHideFileDialog() {
        ((Dialog)this.awtComponent).hide();
    }

    void gtkDisposeFileDialog() {
        ((Dialog)this.awtComponent).dispose();
    }

    void gtkSetFilename(String string) {
        FileDialog fileDialog = (FileDialog)this.awtWidget;
        if (string == null) {
            this.currentFile = null;
            fileDialog.setFile(null);
            return;
        }
        int n = string.lastIndexOf(FS);
        if (n < 0) {
            this.currentFile = string;
        } else {
            String string2;
            this.currentFile = string.length() > n + 1 ? (string2 = string.substring(n + 1)) : null;
            this.currentDirectory = string2 = string.substring(0, n + 1);
            fileDialog.setDirectory(string2);
        }
        fileDialog.setFile(this.currentFile);
    }
}

