/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;

public class GtkWindowPeer
extends GtkContainerPeer
implements WindowPeer {
    protected static final int GDK_WINDOW_TYPE_HINT_NORMAL = 0;
    protected static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
    protected static final int GDK_WINDOW_TYPE_HINT_MENU = 2;
    protected static final int GDK_WINDOW_TYPE_HINT_TOOLBAR = 3;
    protected static final int GDK_WINDOW_TYPE_HINT_SPLASHSCREEN = 4;
    protected static final int GDK_WINDOW_TYPE_HINT_UTILITY = 5;
    protected static final int GDK_WINDOW_TYPE_HINT_DOCK = 6;
    protected static final int GDK_WINDOW_TYPE_HINT_DESKTOP = 7;
    private boolean hasBeenShown;
    private int oldState;
    private int x;
    private int y;
    private int width;
    private int height;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.hasBeenShown = false;
        this.oldState = 0;
    }

    native void gtkWindowSetTitle(String var1);

    native void gtkWindowSetResizable(boolean var1);

    native void gtkWindowSetModal(boolean var1);

    native void gtkWindowSetAlwaysOnTop(boolean var1);

    native boolean gtkWindowHasFocus();

    native void realize();

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    native void create(int var1, boolean var2, GtkWindowPeer var3);

    void create(int n, boolean bl) {
        Window window = (Window)this.awtComponent;
        GtkWindowPeer gtkWindowPeer = null;
        Container container = this.awtComponent.getParent();
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.height = this.awtComponent.getHeight();
        this.width = this.awtComponent.getWidth();
        if (!window.isFocusableWindow()) {
            n = 2;
        }
        if (container != null) {
            gtkWindowPeer = (GtkWindowPeer)this.awtComponent.getParent().getPeer();
        }
        this.create(n, bl, gtkWindowPeer);
    }

    void create() {
        this.create(0, false);
    }

    void setParent() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    void setVisibleAndEnabled() {
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    native void connectSignals();

    public GtkWindowPeer(Window window) {
        super(window);
        this.finit$();
    }

    public native void toBack();

    public native void toFront();

    native void nativeSetBounds(int var1, int var2, int var3, int var4);

    native void nativeSetBoundsUnlocked(int var1, int var2, int var3, int var4);

    native void nativeSetLocation(int var1, int var2);

    native void nativeSetLocationUnlocked(int var1, int var2);

    protected void setLocation(int n, int n2) {
        this.nativeSetLocation(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n != this.getX() || n2 != this.getY() || n3 != this.getWidth() || n4 != this.getHeight()) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.nativeSetBounds(n, n2, n3 - this.insets.left - this.insets.right, n4 - this.insets.top - this.insets.bottom);
        }
    }

    public void setTitle(String string) {
        this.gtkWindowSetTitle(string);
    }

    protected native void setSize(int var1, int var2);

    public void setResizable(boolean bl) {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setSize(this.width - this.insets.left - this.insets.right, this.height - this.insets.top - this.insets.bottom);
        this.gtkWindowSetResizable(bl);
    }

    protected void postInsetsChangedEvent(int n, int n2, int n3, int n4) {
        this.insets.top = n;
        this.insets.left = n2;
        this.insets.bottom = n3;
        this.insets.right = n4;
    }

    protected void postConfigureEvent(int n, int n2, int n3, int n4) {
        int n5 = n3 + this.insets.left + this.insets.right;
        int n6 = n4 + this.insets.top + this.insets.bottom;
        if (n5 != this.getWidth() || n6 != this.getHeight()) {
            this.width = n5;
            this.height = n6;
            GtkGenericPeer.q().postEvent(new ComponentEvent(this.awtComponent, 101));
        }
        int n7 = n - this.insets.left;
        int n8 = n2 - this.insets.top;
        if (n7 != this.getX() || n8 != this.getY()) {
            this.x = n7;
            this.y = n8;
            GtkGenericPeer.q().postEvent(new ComponentEvent(this.awtComponent, 100));
        }
    }

    public void show() {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setLocation(this.x, this.y);
        this.setVisible(true);
    }

    void postWindowEvent(int n, Window window, int n2) {
        if (n == 200) {
            if (!this.hasBeenShown) {
                GtkGenericPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, n, window));
                this.hasBeenShown = true;
            }
        } else if (n == 209) {
            if (this.oldState != n2) {
                GtkGenericPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, n, window, this.oldState, n2));
                this.oldState = n2;
            }
        } else {
            GtkGenericPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, n, window));
        }
    }

    public void updateAlwaysOnTop() {
        this.gtkWindowSetAlwaysOnTop(((Window)this.awtComponent).isAlwaysOnTop());
    }

    protected void postExposeEvent(int n, int n2, int n3, int n4) {
        GtkGenericPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(n + this.insets.left, n2 + this.insets.top, n3, n4)));
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        if (!$assertionsDisabled && component != this.awtComponent && !this.isLightweightDescendant(component)) {
            throw new AssertionError();
        }
        boolean bl3 = false;
        if (this.gtkWindowHasFocus()) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component2 = keyboardFocusManager.getFocusOwner();
            if (component2 == component) {
                bl3 = true;
            } else {
                this.postFocusEvent(1004, bl);
                bl3 = true;
            }
        } else if (bl2) {
            bl3 = this.requestWindowFocus();
        }
        return bl3;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        graphics.translate(-this.insets.left, -this.insets.top);
        return graphics;
    }

    protected void updateComponent(PaintEvent paintEvent) {
        this.paintComponent(paintEvent);
    }

    protected void postMouseEvent(int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        super.postMouseEvent(n, l, n2, n3 + this.insets.left, n4 + this.insets.top, n5, bl);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    static {
        $assertionsDisabled = GtkWindowPeer.class$("gnu.java.awt.peer.gtk.GtkWindowPeer").desiredAssertionStatus() ^ true;
    }
}

