/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMRuntimeMXBeanImpl;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;

public final class RuntimeMXBeanImpl
extends BeanImpl
implements RuntimeMXBean {
    private static final String SUN_BOOT_CLASS_PATH = "sun.boot.class.path";
    private static final String JAVA_BOOT_CLASS_PATH = "java.boot.class.path";
    private long startTime;
    private String bootClassPath;
    private boolean bootClassPathSupported;

    private /* synthetic */ void finit$() {
        this.startTime = -1;
        this.bootClassPath = null;
        this.bootClassPathSupported = true;
    }

    public RuntimeMXBeanImpl() throws NotCompliantMBeanException {
        super(RuntimeMXBeanImpl.class$("java.lang.management.RuntimeMXBean"));
        this.finit$();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getBootClassPath() {
        this.checkMonitorPermissions();
        if (this.isBootClassPathSupported()) {
            return this.bootClassPath;
        }
        throw new UnsupportedOperationException("Retrieving the boot classpath is not supported.");
    }

    public String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public List getInputArguments() {
        this.checkMonitorPermissions();
        return Arrays.asList(VMRuntimeMXBeanImpl.getInputArguments());
    }

    public String getLibraryPath() {
        return System.getProperty("java.library.path");
    }

    public String getManagementSpecVersion() {
        return "1.0";
    }

    public String getName() {
        return VMRuntimeMXBeanImpl.getName();
    }

    public String getSpecName() {
        return System.getProperty("java.vm.specification.name");
    }

    public String getSpecVendor() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public String getSpecVersion() {
        return System.getProperty("java.vm.specification.version");
    }

    public long getStartTime() {
        if (this.startTime == (long)-1) {
            this.startTime = VMRuntimeMXBeanImpl.getStartTime();
        }
        return this.startTime;
    }

    public Map getSystemProperties() {
        HashMap hashMap = new HashMap();
        Properties properties = System.getProperties();
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (!(object instanceof String) || !(object2 instanceof String)) continue;
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    public long getUptime() {
        return new Date().getTime() - this.getStartTime();
    }

    public String getVmName() {
        return System.getProperty("java.vm.name");
    }

    public String getVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getVmVersion() {
        return System.getProperty("java.vm.version");
    }

    public boolean isBootClassPathSupported() {
        if (this.bootClassPath == null) {
            this.bootClassPath = SystemProperties.getProperty(JAVA_BOOT_CLASS_PATH);
            if (this.bootClassPath == null) {
                this.bootClassPath = SystemProperties.getProperty(SUN_BOOT_CLASS_PATH);
            }
            if (this.bootClassPath == null) {
                this.bootClassPathSupported = false;
            }
        }
        return this.bootClassPathSupported;
    }
}

