/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.DomIterator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;

public abstract class DomNode
implements Node,
NodeList,
EventTarget,
DocumentEvent,
Cloneable,
Comparable {
    private static final int NKIDS_DELTA = 8;
    private static final int ANCESTORS_INIT = 20;
    private static final int NOTIFICATIONS_INIT = 10;
    static final boolean reportMutations = true;
    private static final Object lockNode = new Object();
    private static boolean dispatchDataLock;
    private static DomNode[] ancestors;
    private static ListenerRecord[] notificationSet;
    private static boolean eventDataLock;
    private static DomEvent.DomMutationEvent mutationEvent;
    DomDocument owner;
    DomNode parent;
    DomNode previous;
    DomNode next;
    DomNode first;
    DomNode last;
    int index;
    int depth;
    int length;
    final short nodeType;
    boolean readonly;
    private HashSet listeners;
    private int nListeners;
    private HashMap userData;
    private HashMap userDataHandlers;

    public void compact() {
    }

    protected DomNode(short s, DomDocument domDocument) {
        this.nodeType = s;
        if (domDocument == null && s != 9 && s != 10) {
            throw new IllegalArgumentException("no owner!");
        }
        this.owner = domDocument;
        this.listeners = new HashSet();
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public boolean hasChildNodes() {
        return this.length != 0;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        DomNode domNode = this.first;
        while (domNode != null) {
            domNode.makeReadonly();
            domNode = domNode.next;
        }
    }

    void setOwner(DomDocument domDocument) {
        this.owner = domDocument;
        DomNode domNode = this.first;
        while (domNode != null) {
            domNode.setOwner(domDocument);
            domNode = domNode.next;
        }
    }

    private void checkMisc(DomNode domNode) {
        if (this.readonly && !this.owner.building) {
            throw new DomDOMException(7, null, this, 0);
        }
        DomNode domNode2 = this;
        while (domNode2 != null) {
            if (domNode == domNode2) {
                throw new DomDOMException(3, "can't make ancestor into a child", this, 0);
            }
            domNode2 = domNode2.parent;
        }
        domNode2 = this.nodeType == 9 ? (DomDocument)this : this.owner;
        DomDocument domDocument = domNode.owner;
        short s = domNode.nodeType;
        if (domDocument != domNode2 && (s != 10 || domDocument != null)) {
            throw new DomDOMException(4, null, domNode, 0);
        }
        switch (this.nodeType) {
            case 9: {
                switch (s) {
                    case 1: 
                    case 7: 
                    case 8: 
                    case 10: {
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (s) {
                    case 3: 
                    case 5: {
                        return;
                    }
                }
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                switch (s) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
            case 10: {
                if (!((DomDocument)domNode2).building) break;
                switch (s) {
                    case 7: 
                    case 8: {
                        return;
                    }
                }
            }
        }
        if (((DomDocument)domNode2).checkingWellformedness) {
            throw new DomDOMException(3, "can't append " + this.nodeTypeToString(s) + " to node of type " + this.nodeTypeToString(this.nodeType), this, 0);
        }
    }

    private void insertionEvent(DomEvent.DomMutationEvent domMutationEvent, DomNode domNode) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean bl = false;
        if (domMutationEvent == null) {
            domMutationEvent = DomNode.getMutationEvent();
        }
        if (domMutationEvent != null) {
            bl = true;
        } else {
            domMutationEvent = new DomEvent.DomMutationEvent(null);
        }
        domMutationEvent.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
        domNode.dispatchEvent(domMutationEvent);
        if (bl) {
            domMutationEvent.target = null;
            domMutationEvent.relatedNode = null;
            domMutationEvent.currentNode = null;
            eventDataLock = false;
        }
    }

    private void removalEvent(DomEvent.DomMutationEvent domMutationEvent, DomNode domNode) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean bl = false;
        if (domMutationEvent == null) {
            domMutationEvent = DomNode.getMutationEvent();
        }
        if (domMutationEvent != null) {
            bl = true;
        } else {
            domMutationEvent = new DomEvent.DomMutationEvent(null);
        }
        domMutationEvent.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
        domNode.dispatchEvent(domMutationEvent);
        domMutationEvent.target = null;
        domMutationEvent.relatedNode = null;
        domMutationEvent.currentNode = null;
        if (bl) {
            eventDataLock = false;
        }
    }

    private static DomEvent.DomMutationEvent getMutationEvent() {
        Object object = lockNode;
        synchronized (object) {
            DomEvent.DomMutationEvent domMutationEvent;
            try {
                if (eventDataLock) {
                    DomEvent.DomMutationEvent domMutationEvent2 = null;
                    Object var2_3 = null;
                    return domMutationEvent2;
                }
                eventDataLock = true;
                domMutationEvent = mutationEvent;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                throw throwable;
            }
            Object var2_4 = null;
            return domMutationEvent;
        }
    }

    private static void freeMutationEvent() {
        mutationEvent.clear();
        eventDataLock = false;
    }

    void setDepth(int n) {
        this.depth = n;
        DomNode domNode = this.first;
        while (domNode != null) {
            domNode.setDepth(n + 1);
            domNode = domNode.next;
        }
    }

    public Node appendChild(Node node2) {
        try {
            DomNode domNode = (DomNode)node2;
            if (domNode.nodeType == 11) {
                DomNode domNode2 = domNode.first;
                while (domNode2 != null) {
                    this.checkMisc(domNode2);
                    domNode2 = domNode2.next;
                }
                domNode2 = domNode.first;
                while (domNode2 != null) {
                    DomNode domNode3 = domNode2.next;
                    this.appendChild(domNode2);
                    domNode2 = domNode3;
                }
            } else {
                this.checkMisc(domNode);
                if (domNode.parent != null) {
                    domNode.parent.removeChild(domNode);
                }
                domNode.parent = this;
                domNode.index = this.length++;
                domNode.setDepth(this.depth + 1);
                domNode.next = null;
                if (this.last == null) {
                    this.first = domNode;
                    domNode.previous = null;
                } else {
                    this.last.next = domNode;
                    domNode.previous = this.last;
                }
                this.last = domNode;
                this.insertionEvent(null, domNode);
            }
            return domNode;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, node2, 0);
        }
    }

    public Node insertBefore(Node node2, Node node3) {
        if (node3 == null) {
            return this.appendChild(node2);
        }
        try {
            DomNode domNode = (DomNode)node2;
            DomNode domNode2 = (DomNode)node3;
            if (domNode.nodeType == 11) {
                DomNode domNode3 = domNode.first;
                while (domNode3 != null) {
                    this.checkMisc(domNode3);
                    domNode3 = domNode3.next;
                }
                domNode3 = domNode.first;
                while (domNode3 != null) {
                    DomNode domNode4 = domNode3.next;
                    this.insertBefore(domNode3, domNode2);
                    domNode3 = domNode4;
                }
            } else {
                this.checkMisc(domNode);
                if (domNode2 == null || domNode2.parent != this) {
                    throw new DomDOMException(8, null, domNode2, 0);
                }
                if (domNode2 == domNode) {
                    throw new DomDOMException(3, "can't insert node before itself", domNode2, 0);
                }
                if (domNode.parent != null) {
                    domNode.parent.removeChild(domNode);
                }
                domNode.parent = this;
                int n = domNode2.index;
                domNode.setDepth(this.depth + 1);
                domNode.next = domNode2;
                if (domNode2.previous != null) {
                    domNode2.previous.next = domNode;
                }
                domNode.previous = domNode2.previous;
                domNode2.previous = domNode;
                if (this.first == domNode2) {
                    this.first = domNode;
                }
                DomNode domNode5 = domNode;
                while (domNode5 != null) {
                    domNode5.index = n++;
                    domNode5 = domNode5.next;
                }
                this.insertionEvent(null, domNode);
            }
            return domNode;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, node2, 0);
        }
    }

    public Node replaceChild(Node node2, Node node3) {
        try {
            boolean bl;
            DomNode domNode = (DomNode)node2;
            DomNode domNode2 = (DomNode)node3;
            DomEvent.DomMutationEvent domMutationEvent = DomNode.getMutationEvent();
            boolean bl2 = bl = domMutationEvent != null;
            if (domNode.nodeType == 11) {
                DomNode domNode3 = domNode.first;
                while (domNode3 != null) {
                    this.checkMisc(domNode3);
                    domNode3 = domNode3.next;
                }
                if (domNode2 == null || domNode2.parent != this) {
                    throw new DomDOMException(8, null, domNode2, 0);
                }
                this.removalEvent(domMutationEvent, domNode2);
                --this.length;
                this.length += domNode.length;
                if (domNode.length == 0) {
                    if (domNode2.previous != null) {
                        domNode2.previous.next = domNode2.next;
                    }
                    if (domNode2.next != null) {
                        domNode2.next.previous = domNode2.previous;
                    }
                    if (this.first == domNode2) {
                        this.first = domNode2.next;
                    }
                    if (this.last == domNode2) {
                        this.last = domNode2.previous;
                    }
                } else {
                    int n = domNode2.index;
                    DomNode domNode4 = domNode.first;
                    while (domNode4 != null) {
                        domNode4.parent = this;
                        domNode4.index = n++;
                        domNode4.setDepth(domNode2.depth);
                        if (domNode4 == domNode.first) {
                            domNode4.previous = domNode2.previous;
                        }
                        if (domNode4 == domNode.last) {
                            domNode4.next = domNode2.next;
                        }
                        domNode4 = domNode4.next;
                    }
                    if (this.first == domNode2) {
                        this.first = domNode.first;
                    }
                    if (this.last == domNode2) {
                        this.last = domNode.last;
                    }
                }
            } else {
                this.checkMisc(domNode);
                if (domNode2 == null || domNode2.parent != this) {
                    throw new DomDOMException(8, null, domNode2, 0);
                }
                this.removalEvent(domMutationEvent, domNode2);
                if (domNode.parent != null) {
                    domNode.parent.removeChild(domNode);
                }
                domNode.parent = this;
                domNode.index = domNode2.index;
                domNode.setDepth(domNode2.depth);
                if (domNode2.previous != null) {
                    domNode2.previous.next = domNode;
                }
                domNode.previous = domNode2.previous;
                if (domNode2.next != null) {
                    domNode2.next.previous = domNode;
                }
                domNode.next = domNode2.next;
                if (this.first == domNode2) {
                    this.first = domNode;
                }
                if (this.last == domNode2) {
                    this.last = domNode;
                }
                this.insertionEvent(domMutationEvent, domNode);
                if (bl) {
                    DomNode.freeMutationEvent();
                }
            }
            domNode2.parent = null;
            domNode2.index = 0;
            domNode2.setDepth(0);
            domNode2.previous = null;
            domNode2.next = null;
            return domNode2;
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, node2, 0);
        }
    }

    public Node removeChild(Node node2) {
        try {
            DomNode domNode = (DomNode)node2;
            if (domNode == null || domNode.parent != this) {
                throw new DomDOMException(8, null, domNode, 0);
            }
            if (this.readonly && !this.owner.building) {
                throw new DomDOMException(7, null, this, 0);
            }
            DomNode domNode2 = this.first;
            while (domNode2 != null) {
                if (domNode2 == domNode) {
                    this.removalEvent(null, domNode2);
                    --this.length;
                    if (domNode.previous != null) {
                        domNode.previous.next = domNode.next;
                    }
                    if (domNode.next != null) {
                        domNode.next.previous = domNode.previous;
                    }
                    if (this.first == domNode) {
                        this.first = domNode.next;
                    }
                    if (this.last == domNode) {
                        this.last = domNode.previous;
                    }
                    int n = 0;
                    DomNode domNode3 = this.first;
                    while (domNode3 != null) {
                        domNode3.index = n++;
                        domNode3 = domNode3.next;
                    }
                    domNode.parent = null;
                    domNode.setDepth(0);
                    domNode.index = 0;
                    domNode.previous = null;
                    domNode.next = null;
                    return domNode;
                }
                domNode2 = domNode2.next;
            }
            throw new DomDOMException(8, "that's no child of mine", node2, 0);
        }
        catch (ClassCastException classCastException) {
            throw new DomDOMException(4, null, node2, 0);
        }
    }

    public Node item(int n) {
        DomNode domNode = this.first;
        for (int i = 0; domNode != null && i < n; ++i) {
            domNode = domNode.next;
        }
        return domNode;
    }

    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
    }

    public Node getNextSibling() {
        return this.next;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public boolean isSupported(String string, String string2) {
        Document document = this.owner;
        DOMImplementation dOMImplementation = null;
        if (document == null && this.nodeType == 9) {
            document = (Document)((Object)this);
        }
        if (document == null) {
            throw new IllegalStateException("unbound ownerDocument");
        }
        dOMImplementation = document.getImplementation();
        return dOMImplementation.hasFeature(string, string2);
    }

    public final Document getOwnerDocument() {
        return this.owner;
    }

    public void setNodeValue(String string) {
    }

    public String getNodeValue() {
        return null;
    }

    public final short getNodeType() {
        return this.nodeType;
    }

    public abstract String getNodeName();

    public void setPrefix(String string) {
    }

    public String getPrefix() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public Node cloneNode(boolean bl) {
        DomNode domNode = (DomNode)this.clone();
        if (bl) {
            DomDocument domDocument = this.nodeType == 9 ? (DomDocument)domNode : domNode.owner;
            boolean bl2 = domDocument.building;
            domDocument.building = true;
            DomNode domNode2 = this.first;
            while (domNode2 != null) {
                DomNode domNode3 = (DomNode)domNode2.cloneNode(bl);
                domNode3.setOwner(domDocument);
                domNode.appendChild(domNode3);
                domNode2 = domNode2.next;
            }
            domDocument.building = bl2;
        }
        if (this.nodeType == 5) {
            domNode.makeReadonly();
        }
        this.notifyUserDataHandlers((short)1, this, domNode);
        return domNode;
    }

    void notifyUserDataHandlers(short s, Node node2, Node node3) {
        if (this.userDataHandlers != null) {
            Iterator iterator = this.userDataHandlers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                UserDataHandler userDataHandler = (UserDataHandler)entry.getValue();
                Object object = this.userData.get(string);
                userDataHandler.handle(s, string, object, node2, node3);
            }
        }
    }

    public Object clone() {
        try {
            DomNode domNode = (DomNode)super.clone();
            domNode.parent = null;
            domNode.depth = 0;
            domNode.index = 0;
            domNode.length = 0;
            domNode.first = null;
            domNode.last = null;
            domNode.previous = null;
            domNode.next = null;
            domNode.readonly = false;
            domNode.listeners = new HashSet();
            domNode.nListeners = 0;
            return domNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("clone didn't work");
        }
    }

    public NodeList getElementsByTagName(String string) {
        return new ShadowList(this, null, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new ShadowList(this, string, string2);
    }

    public Event createEvent(String string) {
        if ("mutationevents".equals(string = string.toLowerCase())) {
            return new DomEvent.DomMutationEvent(null);
        }
        if ("htmlevents".equals(string) || "events".equals(string) || "user-events".equals(string)) {
            return new DomEvent(null);
        }
        if ("uievents".equals(string)) {
            return new DomEvent.DomUIEvent(null);
        }
        throw new DomDOMException(9, string, null, 0);
    }

    public final void addEventListener(String string, EventListener eventListener, boolean bl) {
        ListenerRecord listenerRecord = new ListenerRecord(string, eventListener, bl);
        this.listeners.add(listenerRecord);
        this.nListeners = this.listeners.size();
    }

    /*
     * Exception decompiling
     */
    public final boolean dispatchEvent(Event var1_1) throws EventException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void notifyNode(DomEvent domEvent, DomNode domNode, boolean bl, ListenerRecord[] listenerRecordArray) {
        int n = 0;
        Iterator iterator = domNode.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerRecord listenerRecord = (ListenerRecord)iterator.next();
            if (listenerRecord.useCapture != bl || !domEvent.type.equals(listenerRecord.type)) continue;
            if (n >= listenerRecordArray.length) {
                int n2 = Math.max(listenerRecordArray.length, 1);
                ListenerRecord[] listenerRecordArray2 = new ListenerRecord[n2 * 2];
                System.arraycopy(listenerRecordArray, 0, listenerRecordArray2, 0, listenerRecordArray.length);
                listenerRecordArray = listenerRecordArray2;
            }
            listenerRecordArray[n++] = listenerRecord;
        }
        iterator = null;
        domEvent.currentNode = domNode;
        for (int i = 0; i < n; ++i) {
            try {
                iterator = domNode.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerRecord listenerRecord = (ListenerRecord)iterator.next();
                    if (!listenerRecord.equals(listenerRecordArray[i])) continue;
                    listenerRecordArray[i].listener.handleEvent(domEvent);
                    break;
                }
                iterator = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            listenerRecordArray[i] = null;
        }
    }

    public final void removeEventListener(String string, EventListener eventListener, boolean bl) {
        this.listeners.remove(new ListenerRecord(string, eventListener, bl));
        this.nListeners = this.listeners.size();
    }

    public final void normalize() {
        boolean bl = this.readonly;
        this.readonly = false;
        DomNode domNode = this.first;
        while (domNode != null) {
            boolean bl2 = domNode.readonly;
            domNode.readonly = false;
            switch (domNode.nodeType) {
                case 3: 
                case 4: {
                    Object object;
                    while (domNode.next != null && (domNode.next.nodeType == 3 || domNode.next.nodeType == 4)) {
                        object = (Text)((Object)domNode);
                        object.appendData(domNode.next.getNodeValue());
                        this.removeChild(domNode.next);
                    }
                    break;
                }
                case 1: {
                    Object object = domNode.getAttributes();
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        DomNode domNode2 = (DomNode)object.item(i);
                        boolean bl3 = domNode2.readonly;
                        domNode2.readonly = false;
                        domNode2.normalize();
                        domNode2.readonly = bl3;
                    }
                }
                case 2: 
                case 5: 
                case 9: 
                case 11: {
                    domNode.normalize();
                }
            }
            domNode.readonly = bl2;
            domNode = domNode.next;
        }
        this.readonly = bl;
    }

    public boolean nameAndTypeEquals(Node node2) {
        if (node2 == this) {
            return true;
        }
        if (this.nodeType != node2.getNodeType()) {
            return false;
        }
        String string = this.getNamespaceURI();
        String string2 = node2.getNamespaceURI();
        if (string != null && string2 != null) {
            return string.equals(string2) && this.equal(this.getLocalName(), node2.getLocalName());
        }
        if (string == null && string2 == null) {
            return this.getNodeName().equals(node2.getNodeName());
        }
        return false;
    }

    public String getBaseURI() {
        if (this.parent != null) {
            return this.parent.getBaseURI();
        }
        return null;
    }

    public short compareDocumentPosition(Node node2) throws DOMException {
        return (short)this.compareTo(node2);
    }

    public final int compareTo(Object object) {
        if (object instanceof DomNode) {
            int n;
            DomNode domNode = this;
            DomNode domNode2 = (DomNode)object;
            if (domNode.owner != domNode2.owner) {
                return 0;
            }
            int n2 = domNode2.depth;
            int n3 = n - n2;
            for (n = domNode.depth; n > n2; --n) {
                domNode = domNode.parent;
            }
            while (n2 > n) {
                domNode2 = domNode2.parent;
                --n2;
            }
            int n4 = this.compareTo2(domNode, domNode2);
            if (n4 != 0) {
                return n4;
            }
            return n3;
        }
        return 0;
    }

    final int compareTo2(DomNode domNode, DomNode domNode2) {
        if (domNode == domNode2 || domNode.depth == 0 || domNode2.depth == 0) {
            return 0;
        }
        int n = this.compareTo2(domNode.parent, domNode2.parent);
        if (n != 0) {
            return n;
        }
        return domNode.index - domNode2.index;
    }

    public final String getTextContent() throws DOMException {
        return this.getTextContent(true);
    }

    final String getTextContent(boolean bl) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                DomNode domNode = this.first;
                while (domNode != null) {
                    String string = domNode.getTextContent(false);
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    domNode = domNode.next;
                }
                return stringBuffer.toString();
            }
            case 3: 
            case 4: {
                if (((Text)((Object)this)).isElementContentWhitespace()) {
                    return "";
                }
                return this.getNodeValue();
            }
            case 2: {
                return this.getNodeValue();
            }
            case 7: 
            case 8: {
                if (bl) {
                    return this.getNodeValue();
                }
                return "";
            }
        }
        return null;
    }

    public void setTextContent(String string) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                Node node2 = this.first;
                while (node2 != null) {
                    DomNode domNode = node2.next;
                    this.removeChild(node2);
                    node2 = domNode;
                }
                if (string == null) break;
                node2 = this.owner.createTextNode(string);
                this.appendChild(node2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.setNodeValue(string);
            }
        }
    }

    public boolean isSameNode(Node node2) {
        return this == node2;
    }

    public String lookupPrefix(String string) {
        if (this.parent == null || this.parent == this.owner) {
            return null;
        }
        return this.parent.lookupPrefix(string);
    }

    public boolean isDefaultNamespace(String string) {
        if (this.parent != null && this.parent != this.owner) {
            return this.parent.isDefaultNamespace(string);
        }
        return false;
    }

    public String lookupNamespaceURI(String string) {
        if (this.parent == null || this.parent == this.owner) {
            return null;
        }
        return this.parent.lookupNamespaceURI(string);
    }

    public boolean isEqualNode(Node node2) {
        Node node3;
        if (this == node2) {
            return true;
        }
        if (node2 == null) {
            return false;
        }
        if (this.nodeType != node2.getNodeType()) {
            return false;
        }
        switch (this.nodeType) {
            case 1: 
            case 2: {
                if (this.equal(this.getLocalName(), node2.getLocalName()) && this.equal(this.getNamespaceURI(), node2.getNamespaceURI())) break;
                return false;
            }
            case 7: {
                if (this.equal(this.getNodeName(), node2.getNodeName()) && this.equal(this.getNodeValue(), node2.getNodeValue())) break;
                return false;
            }
            case 3: 
            case 4: 
            case 8: {
                if (this.equal(this.getNodeValue(), node2.getNodeValue())) break;
                return false;
            }
        }
        this.getFirstChild();
        DomNode domNode = this.first;
        for (node3 = node2.getFirstChild(); domNode != null && node3 != null; node3 = node3.getNextSibling()) {
            if (this.nodeType == 9) {
                while (domNode != null && domNode.nodeType == 3) {
                    domNode = domNode.next;
                }
                while (node3 != null && domNode.getNodeType() == 3) {
                    node3 = node3.getNextSibling();
                }
                if (domNode == null && node3 != null) {
                    return false;
                }
                if (node3 == null && domNode != null) {
                    return false;
                }
            }
            if (!domNode.isEqualNode(node3)) {
                return false;
            }
            domNode = domNode.next;
        }
        return domNode == null && node3 == null;
    }

    boolean equal(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public Object getFeature(String string, String string2) {
        DOMImplementation dOMImplementation;
        DOMImplementation dOMImplementation2 = dOMImplementation = this.nodeType == 9 ? ((Document)((Object)this)).getImplementation() : this.owner.getImplementation();
        if (dOMImplementation.hasFeature(string, string2)) {
            return this;
        }
        return null;
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (userDataHandler != null) {
            if (this.userDataHandlers == null) {
                this.userDataHandlers = new HashMap();
            }
            this.userDataHandlers.put(string, userDataHandler);
        }
        return this.userData.put(string, object);
    }

    public Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(string);
    }

    public String toString() {
        String string = this.getNodeName();
        String string2 = this.getNodeValue();
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        if (string != null) {
            stringBuffer.append(string);
        }
        if (string2 != null) {
            if (string != null) {
                stringBuffer.append('=');
            }
            stringBuffer.append('\'');
            stringBuffer.append(this.encode(string2));
            stringBuffer.append('\'');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    String encode(String string) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("\\r");
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    String nodeTypeToString(short s) {
        switch (s) {
            case 1: {
                return "ELEMENT_NODE";
            }
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
        }
        return "UNKNOWN";
    }

    public void list(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(" ");
        }
        printStream.println(this.toString());
        DomNode domNode = this.first;
        while (domNode != null) {
            domNode.list(printStream, n + 1);
            domNode = domNode.next;
        }
    }

    static {
        ancestors = new DomNode[20];
        notificationSet = new ListenerRecord[10];
        mutationEvent = new DomEvent.DomMutationEvent(null);
    }

    static final class DomEventException
    extends EventException {
        DomEventException() {
            super((short)0, "unspecified event type");
        }
    }

    static final class ListenerRecord {
        String type;
        EventListener listener;
        boolean useCapture;

        ListenerRecord(String string, EventListener eventListener, boolean bl) {
            this.type = string.intern();
            this.listener = eventListener;
            this.useCapture = bl;
        }

        public boolean equals(Object object) {
            ListenerRecord listenerRecord = (ListenerRecord)object;
            return this.listener == listenerRecord.listener && this.useCapture == listenerRecord.useCapture && this.type == listenerRecord.type;
        }

        public int hashCode() {
            return this.listener.hashCode() ^ this.type.hashCode();
        }
    }

    final class LiveNodeList
    implements NodeList,
    EventListener,
    NodeFilter {
        private /* synthetic */ DomNode this$0;
        private final boolean matchAnyURI;
        private final boolean matchAnyName;
        private final String elementURI;
        private final String elementName;
        private DomIterator current;
        private int lastIndex;

        LiveNodeList(DomNode domNode, String string, String string2) {
            this.this$0 = domNode;
            this.elementURI = string;
            this.elementName = string2;
            this.matchAnyURI = "*".equals(string);
            this.matchAnyName = "*".equals(string2);
            domNode.addEventListener("DOMNodeInserted", this, true);
            domNode.addEventListener("DOMNodeRemoved", this, true);
        }

        void detach() {
            if (this.current != null) {
                this.current.detach();
            }
            this.current = null;
            this.this$0.removeEventListener("DOMNodeInserted", this, true);
            this.this$0.removeEventListener("DOMNodeRemoved", this, true);
        }

        public short acceptNode(Node node2) {
            if (node2 == this.this$0) {
                return 3;
            }
            if (this.elementURI != null) {
                if (!this.matchAnyURI && !this.elementURI.equals(node2.getNamespaceURI())) {
                    return 3;
                }
                if (!this.matchAnyName && !this.elementName.equals(node2.getLocalName())) {
                    return 3;
                }
            } else if (!this.matchAnyName && !this.elementName.equals(node2.getNodeName())) {
                return 3;
            }
            return 1;
        }

        private DomIterator createIterator() {
            return new DomIterator(this.this$0, 1, this, true);
        }

        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node2 = mutationEvent.getRelatedNode();
            if (node2.getNodeType() != 1 || node2.getNodeName() != this.elementName || node2.getNamespaceURI() != this.elementURI) {
                return;
            }
            if (this.current != null) {
                this.current.detach();
            }
            this.current = null;
        }

        public Node item(int n) {
            if (this.current == null) {
                this.current = this.createIterator();
                this.lastIndex = -1;
            }
            if (n <= this.lastIndex) {
                while (n != this.lastIndex) {
                    this.current.previousNode();
                    --this.lastIndex;
                }
                Node node2 = this.current.previousNode();
                this.current.detach();
                this.current = null;
                return node2;
            }
            while (++this.lastIndex != n) {
                this.current.nextNode();
            }
            Node node3 = this.current.nextNode();
            this.current.detach();
            this.current = null;
            return node3;
        }

        public int getLength() {
            int n = 0;
            DomIterator domIterator = this.createIterator();
            while (domIterator.nextNode() != null) {
                ++n;
            }
            domIterator.detach();
            return n;
        }
    }

    final class ShadowList
    implements NodeList {
        private /* synthetic */ DomNode this$0;
        private LiveNodeList liveList;

        ShadowList(DomNode domNode, String string, String string2) {
            this.this$0 = domNode;
            this.liveList = new LiveNodeList(domNode, string, string2);
        }

        public void finalize() {
            this.liveList.detach();
            this.liveList = null;
        }

        public Node item(int n) {
            return this.liveList.item(n);
        }

        public int getLength() {
            return this.liveList.getLength();
        }
    }
}

